/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.util.ServiceConfigurationError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public final class ServiceFinder<T>
implements Iterable<T> {
    private static final String prefix = "META-INF/services/";
    private final Class<T> serviceClass;
    @Nullable
    private final ClassLoader classLoader;

    public static <T> ServiceFinder<T> find(@NotNull Class<T> clazz, @Nullable ClassLoader classLoader) {
        return new ServiceFinder<T>(clazz, classLoader);
    }

    public static <T> ServiceFinder<T> find(Class<T> clazz) {
        return ServiceFinder.find(clazz, Thread.currentThread().getContextClassLoader());
    }

    private ServiceFinder(Class<T> clazz, ClassLoader classLoader) {
        this.serviceClass = clazz;
        this.classLoader = classLoader;
    }

    @Override
    public Iterator<T> iterator() {
        return new LazyIterator(this.serviceClass, this.classLoader);
    }

    public T[] toArray() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : this) {
            arrayList.add(t);
        }
        return arrayList.toArray((Object[])Array.newInstance(this.serviceClass, arrayList.size()));
    }

    private static void fail(Class clazz, String string, Throwable throwable) throws ServiceConfigurationError {
        ServiceConfigurationError serviceConfigurationError = new ServiceConfigurationError(clazz.getName() + ": " + string);
        serviceConfigurationError.initCause(throwable);
        throw serviceConfigurationError;
    }

    private static void fail(Class clazz, String string) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(clazz.getName() + ": " + string);
    }

    private static void fail(Class clazz, URL uRL, int n, String string) throws ServiceConfigurationError {
        ServiceFinder.fail(clazz, uRL + ":" + n + ": " + string);
    }

    private static int parseLine(Class clazz, URL uRL, BufferedReader bufferedReader, int n, List<String> list, Set<String> set) throws IOException, ServiceConfigurationError {
        int n2;
        String string = bufferedReader.readLine();
        if (string == null) {
            return -1;
        }
        int n3 = string.indexOf(35);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if ((n2 = (string = string.trim()).length()) != 0) {
            int n4;
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0) {
                ServiceFinder.fail(clazz, uRL, n, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(n4 = string.codePointAt(0))) {
                ServiceFinder.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            for (int i = Character.charCount(n4); i < n2; i += Character.charCount(n4)) {
                n4 = string.codePointAt(i);
                if (Character.isJavaIdentifierPart(n4) || n4 == 46) continue;
                ServiceFinder.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            if (!set.contains(string)) {
                list.add(string);
                set.add(string);
            }
        }
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> parse(Class clazz, URL uRL, Set<String> set) throws ServiceConfigurationError {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            inputStream = uRL.openStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            int n = 1;
            while ((n = ServiceFinder.parseLine(clazz, uRL, bufferedReader, n, arrayList, set)) >= 0) {
            }
        }
        catch (IOException iOException) {
            ServiceFinder.fail(clazz, ": " + iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                ServiceFinder.fail(clazz, ": " + iOException);
            }
        }
        return arrayList.iterator();
    }

    private static class LazyIterator<T>
    implements Iterator<T> {
        Class<T> service;
        @Nullable
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        Set<String> returned = new TreeSet<String>();
        String nextName = null;
        URL currentConfig = null;

        private LazyIterator(Class<T> clazz, ClassLoader classLoader) {
            this.service = clazz;
            this.loader = classLoader;
        }

        @Override
        public boolean hasNext() throws ServiceConfigurationError {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String string = ServiceFinder.prefix + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(string) : this.loader.getResources(string);
                }
                catch (IOException iOException) {
                    ServiceFinder.fail(this.service, ": " + iOException);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.currentConfig = this.configs.nextElement();
                this.pending = ServiceFinder.parse(this.service, this.currentConfig, this.returned);
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public T next() throws ServiceConfigurationError {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.nextName;
            this.nextName = null;
            try {
                return this.service.cast(Class.forName(string, true, this.loader).newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
                ServiceFinder.fail(this.service, "Provider " + string + " is specified in " + this.currentConfig + " but not found");
            }
            catch (Exception exception) {
                ServiceFinder.fail(this.service, "Provider " + string + " is specified in " + this.currentConfig + "but could not be instantiated: " + exception, exception);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

