/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ConstantException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class Constants {
    private final String className;
    private final Map fieldCache = new HashMap();

    public Constants(Class clazz) {
        Assert.notNull(clazz);
        this.className = clazz.getName();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!ReflectionUtils.isPublicStaticFinal(field)) continue;
            String string = field.getName();
            try {
                Object object = field.get(null);
                this.fieldCache.put(string, object);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public final String getClassName() {
        return this.className;
    }

    public final int getSize() {
        return this.fieldCache.size();
    }

    protected final Map getFieldCache() {
        return this.fieldCache;
    }

    public Number asNumber(String string) throws ConstantException {
        Object object = this.asObject(string);
        if (!(object instanceof Number)) {
            throw new ConstantException(this.className, string, "not a Number");
        }
        return (Number)object;
    }

    public String asString(String string) throws ConstantException {
        return this.asObject(string).toString();
    }

    public Object asObject(String string) throws ConstantException {
        Assert.notNull(string, "Code must not be null");
        String string2 = string.toUpperCase(Locale.ENGLISH);
        Object v = this.fieldCache.get(string2);
        if (v == null) {
            throw new ConstantException(this.className, string2, "not found");
        }
        return v;
    }

    public Set getNames(String string) {
        String string2 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.fieldCache.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.startsWith(string2)) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    public Set getNamesForProperty(String string) {
        return this.getNames(this.propertyToConstantNamePrefix(string));
    }

    public Set getNamesForSuffix(String string) {
        String string2 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.fieldCache.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.endsWith(string2)) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    public Set getValues(String string) {
        String string2 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet hashSet = new HashSet();
        Iterator iterator = this.fieldCache.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.startsWith(string2)) continue;
            hashSet.add(this.fieldCache.get(string3));
        }
        return hashSet;
    }

    public Set getValuesForProperty(String string) {
        return this.getValues(this.propertyToConstantNamePrefix(string));
    }

    public Set getValuesForSuffix(String string) {
        String string2 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet hashSet = new HashSet();
        Iterator iterator = this.fieldCache.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.endsWith(string2)) continue;
            hashSet.add(this.fieldCache.get(string3));
        }
        return hashSet;
    }

    public String toCode(Object object, String string) throws ConstantException {
        String string2 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : null;
        Iterator iterator = this.fieldCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string3 = (String)entry.getKey();
            if (!string3.startsWith(string2) || !entry.getValue().equals(object)) continue;
            return string3;
        }
        throw new ConstantException(this.className, string2, object);
    }

    public String toCodeForProperty(Object object, String string) throws ConstantException {
        return this.toCode(object, this.propertyToConstantNamePrefix(string));
    }

    public String toCodeForSuffix(Object object, String string) throws ConstantException {
        String string2 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : null;
        Iterator iterator = this.fieldCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string3 = (String)entry.getKey();
            if (!string3.endsWith(string2) || !entry.getValue().equals(object)) continue;
            return string3;
        }
        throw new ConstantException(this.className, string2, object);
    }

    public String propertyToConstantNamePrefix(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                stringBuffer.append("_");
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(Character.toUpperCase(c));
        }
        return stringBuffer.toString();
    }
}

