/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.beans.factory.support.DisposableBeanAdapter;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractBeanFactory
extends DefaultSingletonBeanRegistry
implements ConfigurableBeanFactory {
    private BeanFactory parentBeanFactory;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean cacheBeanMetadata = true;
    private final Map customEditors = new HashMap();
    private final Set propertyEditorRegistrars = CollectionFactory.createLinkedSetIfPossible((int)16);
    private final List beanPostProcessors = new ArrayList();
    private boolean hasInstantiationAwareBeanPostProcessors;
    private boolean hasDestructionAwareBeanPostProcessors;
    private final Map scopes = new HashMap();
    private final Map aliasMap = CollectionFactory.createConcurrentMapIfPossible((int)16);
    private final Map mergedBeanDefinitions = CollectionFactory.createConcurrentMapIfPossible((int)16);
    private final Set alreadyCreated = Collections.synchronizedSet(new HashSet());
    private final ThreadLocal prototypesCurrentlyInCreation = new ThreadLocal();
    private final Map factoryBeanObjectCache = new HashMap();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;
    static /* synthetic */ Class class$java$lang$Object;

    public AbstractBeanFactory() {
    }

    public AbstractBeanFactory(BeanFactory beanFactory) {
        this.parentBeanFactory = beanFactory;
    }

    public Object getBean(String string) throws BeansException {
        return this.getBean(string, null, null);
    }

    public Object getBean(String string, Class clazz) throws BeansException {
        return this.getBean(string, clazz, null);
    }

    public Object getBean(String string, Object[] objectArray) throws BeansException {
        return this.getBean(string, null, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBean(String string, Class clazz, final Object[] objectArray) throws BeansException {
        final String string2 = this.transformedBeanName(string);
        Object object = null;
        Object object2 = this.getSingleton(string2);
        if (object2 != null) {
            if (this.isSingletonCurrentlyInCreation(string2)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Returning eagerly cached instance of singleton bean '" + string2 + "' that is not fully initialized yet - a consequence of a circular reference"));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning cached instance of singleton bean '" + string2 + "'"));
            }
            if (this.containsBeanDefinition(string2)) {
                RootBeanDefinition rootBeanDefinition = this.getMergedBeanDefinition(string2, false);
                object = this.getObjectForBeanInstance(object2, string, rootBeanDefinition);
            } else {
                object = this.getObjectForBeanInstance(object2, string, null);
            }
        } else {
            if (this.isPrototypeCurrentlyInCreation(string2)) {
                throw new BeanCurrentlyInCreationException(string2);
            }
            BeanFactory beanFactory = this.getParentBeanFactory();
            if (beanFactory != null && !this.containsBeanDefinition(string2)) {
                String string3 = this.originalBeanName(string);
                if (beanFactory instanceof AbstractBeanFactory) {
                    return ((AbstractBeanFactory)beanFactory).getBean(string3, clazz, objectArray);
                }
                if (objectArray == null) {
                    return beanFactory.getBean(string3, clazz);
                }
                throw new NoSuchBeanDefinitionException(string2, "Cannot delegate to parent BeanFactory because it does not supported passed-in arguments");
            }
            this.alreadyCreated.add(string2);
            final RootBeanDefinition rootBeanDefinition = this.getMergedBeanDefinition(string2, false);
            this.checkMergedBeanDefinition(rootBeanDefinition, string2, objectArray);
            if (rootBeanDefinition.isSingleton()) {
                object2 = this.getSingleton(string2, new ObjectFactory(){

                    public Object getObject() throws BeansException {
                        try {
                            return AbstractBeanFactory.this.createBean(string2, rootBeanDefinition, objectArray);
                        }
                        catch (BeansException beansException) {
                            AbstractBeanFactory.this.destroySingleton(string2);
                            throw beansException;
                        }
                    }
                });
                object = this.getObjectForBeanInstance(object2, string, rootBeanDefinition);
            } else if (rootBeanDefinition.isPrototype()) {
                Object object3 = null;
                try {
                    this.beforePrototypeCreation(string2);
                    object3 = this.createBean(string2, rootBeanDefinition, objectArray);
                }
                finally {
                    this.afterPrototypeCreation(string2);
                }
                object = this.getObjectForBeanInstance(object3, string, rootBeanDefinition);
            } else {
                String string4 = rootBeanDefinition.getScope();
                final Scope scope = (Scope)this.scopes.get(string4);
                if (scope == null) {
                    throw new IllegalStateException("No Scope registered for scope '" + string4 + "'");
                }
                try {
                    Object object4 = scope.get(string2, new ObjectFactory(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object getObject() throws BeansException {
                            AbstractBeanFactory.this.beforePrototypeCreation(string2);
                            try {
                                Object object = AbstractBeanFactory.this.createBean(string2, rootBeanDefinition, objectArray);
                                if (AbstractBeanFactory.this.requiresDestruction(object, rootBeanDefinition)) {
                                    scope.registerDestructionCallback(string2, new DisposableBeanAdapter(object, string2, rootBeanDefinition, AbstractBeanFactory.this.getBeanPostProcessors()));
                                }
                                Object object2 = object;
                                return object2;
                            }
                            finally {
                                AbstractBeanFactory.this.afterPrototypeCreation(string2);
                            }
                        }
                    });
                    object = this.getObjectForBeanInstance(object4, string, rootBeanDefinition);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new BeanCreationException(string2, "Scope '" + string4 + "' is not active for the current thread; " + "consider defining a scoped proxy for this bean if you intend to refer to it from a singleton", illegalStateException);
                }
            }
        }
        if (clazz != null && !clazz.isAssignableFrom(object.getClass())) {
            throw new BeanNotOfRequiredTypeException(string, clazz, object.getClass());
        }
        return object;
    }

    public boolean containsBean(String string) {
        String string2 = this.transformedBeanName(string);
        if (this.containsSingleton(string2) || this.containsBeanDefinition(string2)) {
            return !BeanFactoryUtils.isFactoryDereference(string) || this.isFactoryBean(string);
        }
        BeanFactory beanFactory = this.getParentBeanFactory();
        return beanFactory != null && beanFactory.containsBean(this.originalBeanName(string));
    }

    public boolean isSingleton(String string) throws NoSuchBeanDefinitionException {
        String string2 = this.transformedBeanName(string);
        Object object = this.getSingleton(string2);
        if (object != null) {
            if (object instanceof FactoryBean) {
                return BeanFactoryUtils.isFactoryDereference(string) || ((FactoryBean)object).isSingleton();
            }
            return !BeanFactoryUtils.isFactoryDereference(string);
        }
        BeanFactory beanFactory = this.getParentBeanFactory();
        if (beanFactory != null && !this.containsBeanDefinition(string2)) {
            return beanFactory.isSingleton(this.originalBeanName(string));
        }
        RootBeanDefinition rootBeanDefinition = this.getMergedBeanDefinition(string2, false);
        if (rootBeanDefinition.isSingleton()) {
            if (this.isBeanClassMatch(string2, rootBeanDefinition, class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean)) {
                if (BeanFactoryUtils.isFactoryDereference(string)) {
                    return true;
                }
                FactoryBean factoryBean = (FactoryBean)this.getBean("&" + string2);
                return factoryBean.isSingleton();
            }
            return !BeanFactoryUtils.isFactoryDereference(string);
        }
        return false;
    }

    public boolean isPrototype(String string) throws NoSuchBeanDefinitionException {
        String string2 = this.transformedBeanName(string);
        BeanFactory beanFactory = this.getParentBeanFactory();
        if (beanFactory != null && !this.containsBeanDefinition(string2)) {
            return beanFactory.isPrototype(this.originalBeanName(string));
        }
        RootBeanDefinition rootBeanDefinition = this.getMergedBeanDefinition(string2, false);
        if (rootBeanDefinition.isPrototype()) {
            return !BeanFactoryUtils.isFactoryDereference(string) || this.isBeanClassMatch(string2, rootBeanDefinition, class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean);
        }
        if (!BeanFactoryUtils.isFactoryDereference(string) && this.isBeanClassMatch(string2, rootBeanDefinition, class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean)) {
            FactoryBean factoryBean = (FactoryBean)this.getBean("&" + string2);
            return factoryBean instanceof SmartFactoryBean && ((SmartFactoryBean)factoryBean).isPrototype() || !factoryBean.isSingleton();
        }
        return false;
    }

    public boolean isTypeMatch(String string, Class clazz) throws NoSuchBeanDefinitionException {
        String string2 = this.transformedBeanName(string);
        Class clazz2 = clazz != null ? clazz : (class$java$lang$Object == null ? (class$java$lang$Object = AbstractBeanFactory.class$("java.lang.Object")) : class$java$lang$Object);
        Object object = this.getSingleton(string2);
        if (object != null) {
            if (object instanceof FactoryBean) {
                if (!BeanFactoryUtils.isFactoryDereference(string)) {
                    Class clazz3 = this.getTypeForFactoryBean((FactoryBean)object);
                    return clazz3 != null && clazz2.isAssignableFrom(clazz3);
                }
                return clazz2.isAssignableFrom(object.getClass());
            }
            return !BeanFactoryUtils.isFactoryDereference(string) && clazz2.isAssignableFrom(object.getClass());
        }
        BeanFactory beanFactory = this.getParentBeanFactory();
        if (beanFactory != null && !this.containsBeanDefinition(string2)) {
            return beanFactory.isTypeMatch(this.originalBeanName(string), clazz);
        }
        RootBeanDefinition rootBeanDefinition = this.getMergedBeanDefinition(string2, false);
        Class clazz4 = this.predictBeanType(string2, rootBeanDefinition);
        if (clazz4 == null) {
            return false;
        }
        if ((class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(clazz4)) {
            if (!BeanFactoryUtils.isFactoryDereference(string)) {
                Class clazz5 = this.getTypeForFactoryBean(string2, rootBeanDefinition);
                return clazz5 != null && clazz2.isAssignableFrom(clazz5);
            }
            return clazz2.isAssignableFrom(clazz4);
        }
        return !BeanFactoryUtils.isFactoryDereference(string) && clazz2.isAssignableFrom(clazz4);
    }

    public Class getType(String string) throws NoSuchBeanDefinitionException {
        String string2 = this.transformedBeanName(string);
        Object object = this.getSingleton(string2);
        if (object != null) {
            if (object instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(string)) {
                return this.getTypeForFactoryBean((FactoryBean)object);
            }
            return object.getClass();
        }
        BeanFactory beanFactory = this.getParentBeanFactory();
        if (beanFactory != null && !this.containsBeanDefinition(string2)) {
            return beanFactory.getType(this.originalBeanName(string));
        }
        RootBeanDefinition rootBeanDefinition = this.getMergedBeanDefinition(string2, false);
        Class clazz = this.predictBeanType(string2, rootBeanDefinition);
        if (clazz != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(clazz)) {
            if (!BeanFactoryUtils.isFactoryDereference(string)) {
                return this.getTypeForFactoryBean(string2, rootBeanDefinition);
            }
            return clazz;
        }
        return !BeanFactoryUtils.isFactoryDereference(string) ? clazz : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliases(String string) {
        String string2 = this.transformedBeanName(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = string.startsWith("&");
        String string3 = string2;
        if (bl) {
            string3 = "&" + string2;
        }
        if (!string3.equals(string)) {
            arrayList.add(string3);
        }
        Object object = this.aliasMap;
        synchronized (object) {
            Iterator iterator = this.aliasMap.entrySet().iterator();
            while (iterator.hasNext()) {
                String string4;
                Map.Entry entry = iterator.next();
                if (!entry.getValue().equals(string2) || (string4 = (bl ? "&" : "") + entry.getKey()).equals(string)) continue;
                arrayList.add(string4);
            }
        }
        if (!this.containsSingleton(string2) && !this.containsBeanDefinition(string2) && (object = this.getParentBeanFactory()) != null) {
            arrayList.addAll(Arrays.asList(object.getAliases(string3)));
        }
        return StringUtils.toStringArray(arrayList);
    }

    public BeanFactory getParentBeanFactory() {
        return this.parentBeanFactory;
    }

    public boolean containsLocalBean(String string) {
        String string2 = this.transformedBeanName(string);
        return !(!this.containsSingleton(string2) && !this.containsBeanDefinition(string2) || BeanFactoryUtils.isFactoryDereference(string) && !this.isFactoryBean(string2));
    }

    public void setParentBeanFactory(BeanFactory beanFactory) {
        if (this.parentBeanFactory != null && this.parentBeanFactory != beanFactory) {
            throw new IllegalStateException("Already associated with parent BeanFactory: " + this.parentBeanFactory);
        }
        this.parentBeanFactory = beanFactory;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setCacheBeanMetadata(boolean bl) {
        this.cacheBeanMetadata = bl;
    }

    public boolean isCacheBeanMetadata() {
        return this.cacheBeanMetadata;
    }

    public void addPropertyEditorRegistrar(PropertyEditorRegistrar propertyEditorRegistrar) {
        Assert.notNull((Object)propertyEditorRegistrar, (String)"PropertyEditorRegistrar must not be null");
        this.propertyEditorRegistrars.add(propertyEditorRegistrar);
    }

    public Set getPropertyEditorRegistrars() {
        return this.propertyEditorRegistrars;
    }

    public void registerCustomEditor(Class clazz, PropertyEditor propertyEditor) {
        Assert.notNull((Object)clazz, (String)"Required type must not be null");
        Assert.notNull((Object)propertyEditor, (String)"PropertyEditor must not be null");
        this.customEditors.put(clazz, propertyEditor);
    }

    public Map getCustomEditors() {
        return this.customEditors;
    }

    public TypeConverter getTypeConverter() {
        SimpleTypeConverter simpleTypeConverter = new SimpleTypeConverter();
        this.registerCustomEditors(simpleTypeConverter);
        return simpleTypeConverter;
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        Assert.notNull((Object)beanPostProcessor, (String)"BeanPostProcessor must not be null");
        this.beanPostProcessors.add(beanPostProcessor);
        if (beanPostProcessor instanceof InstantiationAwareBeanPostProcessor) {
            this.hasInstantiationAwareBeanPostProcessors = true;
        }
        if (beanPostProcessor instanceof DestructionAwareBeanPostProcessor) {
            this.hasDestructionAwareBeanPostProcessors = true;
        }
    }

    public int getBeanPostProcessorCount() {
        return this.beanPostProcessors.size();
    }

    public List getBeanPostProcessors() {
        return this.beanPostProcessors;
    }

    protected boolean hasInstantiationAwareBeanPostProcessors() {
        return this.hasInstantiationAwareBeanPostProcessors;
    }

    protected boolean hasDestructionAwareBeanPostProcessors() {
        return this.hasDestructionAwareBeanPostProcessors;
    }

    public void registerScope(String string, Scope scope) {
        Assert.notNull((Object)string, (String)"Scope identifier must not be null");
        Assert.notNull((Object)scope, (String)"Scope must not be null");
        if ("singleton".equals(string) || "prototype".equals(string)) {
            throw new IllegalArgumentException("Cannot replace existing scopes 'singleton' and 'prototype'");
        }
        this.scopes.put(string, scope);
    }

    public String[] getRegisteredScopeNames() {
        return StringUtils.toStringArray(this.scopes.keySet());
    }

    public Scope getRegisteredScope(String string) {
        Assert.notNull((Object)string, (String)"Scope identifier must not be null");
        return (Scope)this.scopes.get(string);
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory configurableBeanFactory) {
        Assert.notNull((Object)configurableBeanFactory, (String)"BeanFactory must not be null");
        this.setBeanClassLoader(configurableBeanFactory.getBeanClassLoader());
        this.setCacheBeanMetadata(configurableBeanFactory.isCacheBeanMetadata());
        if (configurableBeanFactory instanceof AbstractBeanFactory) {
            AbstractBeanFactory abstractBeanFactory = (AbstractBeanFactory)configurableBeanFactory;
            this.customEditors.putAll(abstractBeanFactory.customEditors);
            this.propertyEditorRegistrars.addAll(abstractBeanFactory.propertyEditorRegistrars);
            this.beanPostProcessors.addAll(abstractBeanFactory.beanPostProcessors);
            this.hasInstantiationAwareBeanPostProcessors = this.hasInstantiationAwareBeanPostProcessors || abstractBeanFactory.hasInstantiationAwareBeanPostProcessors;
            this.hasDestructionAwareBeanPostProcessors = this.hasDestructionAwareBeanPostProcessors || abstractBeanFactory.hasDestructionAwareBeanPostProcessors;
            this.scopes.putAll(abstractBeanFactory.scopes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAlias(String string, String string2) throws BeanDefinitionStoreException {
        Assert.hasText((String)string, (String)"'beanName' must not be empty");
        Assert.hasText((String)string2, (String)"'alias' must not be empty");
        if (!string2.equals(string)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering alias '" + string2 + "' for bean with name '" + string + "'"));
            }
            Map map = this.aliasMap;
            synchronized (map) {
                Object v = this.aliasMap.get(string2);
                if (v != null && !v.equals(string)) {
                    throw new BeanDefinitionStoreException("Cannot register alias '" + string2 + "' for bean name '" + string + "': It's already registered for bean name '" + v + "'.");
                }
                this.aliasMap.put(string2, string);
            }
        }
    }

    protected void beforePrototypeCreation(String string) {
        Object t = this.prototypesCurrentlyInCreation.get();
        if (t == null) {
            this.prototypesCurrentlyInCreation.set(string);
        } else if (t instanceof String) {
            HashSet<Object> hashSet = new HashSet<Object>(2);
            hashSet.add(t);
            hashSet.add(string);
            this.prototypesCurrentlyInCreation.set(hashSet);
        } else {
            Set set = (Set)t;
            set.add(string);
        }
    }

    protected void afterPrototypeCreation(String string) {
        Object t = this.prototypesCurrentlyInCreation.get();
        if (t instanceof String) {
            this.prototypesCurrentlyInCreation.set(null);
        } else if (t instanceof Set) {
            Set set = (Set)t;
            set.remove(string);
            if (set.isEmpty()) {
                this.prototypesCurrentlyInCreation.set(null);
            }
        }
    }

    protected final boolean isPrototypeCurrentlyInCreation(String string) {
        Object t = this.prototypesCurrentlyInCreation.get();
        return t != null && (t.equals(string) || t instanceof Set && ((Set)t).contains(string));
    }

    public boolean isCurrentlyInCreation(String string) {
        return this.isSingletonCurrentlyInCreation(string) || this.isPrototypeCurrentlyInCreation(string);
    }

    public void destroyBean(String string, Object object) {
        this.destroyBean(string, object, this.getMergedBeanDefinition(string));
    }

    protected void destroyBean(String string, Object object, RootBeanDefinition rootBeanDefinition) {
        new DisposableBeanAdapter(object, string, rootBeanDefinition, this.getBeanPostProcessors()).destroy();
    }

    public void destroyScopedBean(String string) {
        RootBeanDefinition rootBeanDefinition = this.getMergedBeanDefinition(string);
        if (rootBeanDefinition.isSingleton() || rootBeanDefinition.isPrototype()) {
            throw new IllegalArgumentException("Bean name '" + string + "' does not correspond to an object in a Scope");
        }
        String string2 = rootBeanDefinition.getScope();
        Scope scope = (Scope)this.scopes.get(string2);
        if (scope == null) {
            throw new IllegalStateException("No Scope registered for scope '" + string2 + "'");
        }
        Object object = scope.remove(string);
        if (object != null) {
            this.destroyBean(string, object, rootBeanDefinition);
        }
    }

    protected String transformedBeanName(String string) {
        String string2 = BeanFactoryUtils.transformedBeanName(string);
        String string3 = null;
        do {
            if ((string3 = (String)this.aliasMap.get(string2)) == null) continue;
            string2 = string3;
        } while (string3 != null);
        return string2;
    }

    protected String originalBeanName(String string) {
        String string2 = this.transformedBeanName(string);
        if (string.startsWith("&")) {
            string2 = "&" + string2;
        }
        return string2;
    }

    protected boolean isAlias(String string) {
        return this.aliasMap.containsKey(string);
    }

    protected void initBeanWrapper(BeanWrapper beanWrapper) {
        this.registerCustomEditors(beanWrapper);
    }

    protected void registerCustomEditors(PropertyEditorRegistry propertyEditorRegistry) {
        Object object;
        PropertyEditorRegistrySupport propertyEditorRegistrySupport;
        PropertyEditorRegistrySupport propertyEditorRegistrySupport2 = propertyEditorRegistrySupport = propertyEditorRegistry instanceof PropertyEditorRegistrySupport ? (PropertyEditorRegistrySupport)propertyEditorRegistry : null;
        if (propertyEditorRegistrySupport != null) {
            propertyEditorRegistrySupport.useConfigValueEditors();
        }
        Iterator<Object> iterator = this.propertyEditorRegistrars.iterator();
        while (iterator.hasNext()) {
            object = (PropertyEditorRegistrar)iterator.next();
            object.registerCustomEditors(propertyEditorRegistry);
        }
        iterator = this.customEditors.entrySet().iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            Class clazz = (Class)object.getKey();
            PropertyEditor propertyEditor = (PropertyEditor)object.getValue();
            if (propertyEditorRegistrySupport != null) {
                propertyEditorRegistrySupport.registerSharedEditor(clazz, propertyEditor);
                continue;
            }
            propertyEditorRegistry.registerCustomEditor(clazz, propertyEditor);
        }
    }

    public RootBeanDefinition getMergedBeanDefinition(String string) throws BeansException {
        return this.getMergedBeanDefinition(string, false);
    }

    protected RootBeanDefinition getMergedBeanDefinition(String string, boolean bl) throws BeansException {
        if (bl && !this.containsBeanDefinition(string) && this.getParentBeanFactory() instanceof AbstractBeanFactory) {
            return ((AbstractBeanFactory)this.getParentBeanFactory()).getMergedBeanDefinition(string, true);
        }
        return this.getMergedBeanDefinition(string, this.getBeanDefinition(string));
    }

    protected RootBeanDefinition getMergedBeanDefinition(String string, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        return this.getMergedBeanDefinition(string, beanDefinition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RootBeanDefinition getMergedBeanDefinition(String string, BeanDefinition beanDefinition, BeanDefinition beanDefinition2) throws BeanDefinitionStoreException {
        RootBeanDefinition rootBeanDefinition = null;
        if (beanDefinition2 == null) {
            rootBeanDefinition = (RootBeanDefinition)this.mergedBeanDefinitions.get(string);
        }
        if (rootBeanDefinition == null) {
            Map map = this.mergedBeanDefinitions;
            synchronized (map) {
                if (beanDefinition2 == null) {
                    rootBeanDefinition = (RootBeanDefinition)this.mergedBeanDefinitions.get(string);
                }
                if (rootBeanDefinition == null) {
                    if (beanDefinition instanceof RootBeanDefinition) {
                        rootBeanDefinition = new RootBeanDefinition((RootBeanDefinition)beanDefinition);
                    } else if (beanDefinition instanceof ChildBeanDefinition) {
                        RootBeanDefinition rootBeanDefinition2;
                        ChildBeanDefinition childBeanDefinition;
                        block17: {
                            childBeanDefinition = (ChildBeanDefinition)beanDefinition;
                            rootBeanDefinition2 = null;
                            try {
                                String string2 = this.transformedBeanName(childBeanDefinition.getParentName());
                                if (!string.equals(string2)) {
                                    rootBeanDefinition2 = this.getMergedBeanDefinition(string2, true);
                                    break block17;
                                }
                                if (this.getParentBeanFactory() instanceof AbstractBeanFactory) {
                                    AbstractBeanFactory abstractBeanFactory = (AbstractBeanFactory)this.getParentBeanFactory();
                                    rootBeanDefinition2 = abstractBeanFactory.getMergedBeanDefinition(string2, true);
                                    break block17;
                                }
                                throw new NoSuchBeanDefinitionException(childBeanDefinition.getParentName(), "Parent name '" + childBeanDefinition.getParentName() + "' is equal to bean name '" + string + "': cannot be resolved without an AbstractBeanFactory parent");
                            }
                            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                                throw new BeanDefinitionStoreException(childBeanDefinition.getResourceDescription(), string, "Could not resolve parent bean definition '" + childBeanDefinition.getParentName() + "'", (Throwable)((Object)noSuchBeanDefinitionException));
                            }
                        }
                        rootBeanDefinition = new RootBeanDefinition(rootBeanDefinition2);
                        rootBeanDefinition.overrideFrom(childBeanDefinition);
                    } else {
                        throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), string, "Definition is neither a RootBeanDefinition nor a ChildBeanDefinition: " + beanDefinition);
                    }
                    if (beanDefinition2 != null && !beanDefinition2.isSingleton() && rootBeanDefinition.isSingleton()) {
                        rootBeanDefinition.setSingleton(false);
                    }
                    if (beanDefinition2 == null && this.isCacheBeanMetadata() && this.alreadyCreated.contains(string)) {
                        this.mergedBeanDefinitions.put(string, rootBeanDefinition);
                    }
                }
            }
        }
        return rootBeanDefinition;
    }

    protected void checkMergedBeanDefinition(RootBeanDefinition rootBeanDefinition, String string, Object[] objectArray) throws BeanDefinitionStoreException {
        if (rootBeanDefinition.isAbstract()) {
            throw new BeanIsAbstractException(string);
        }
        if (objectArray != null) {
            if (rootBeanDefinition.isSingleton()) {
                throw new BeanDefinitionStoreException("Cannot specify arguments in the getBean() method when referring to a singleton bean definition");
            }
            if (rootBeanDefinition.getFactoryMethodName() == null) {
                throw new BeanDefinitionStoreException("Can only specify arguments in the getBean() method in conjunction with a factory method");
            }
        }
    }

    protected Class resolveBeanClass(RootBeanDefinition rootBeanDefinition, String string) throws CannotLoadBeanClassException {
        if (rootBeanDefinition.hasBeanClass()) {
            return rootBeanDefinition.getBeanClass();
        }
        try {
            return rootBeanDefinition.resolveBeanClass(this.getBeanClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CannotLoadBeanClassException(rootBeanDefinition.getResourceDescription(), string, rootBeanDefinition.getBeanClassName(), classNotFoundException);
        }
        catch (LinkageError linkageError) {
            throw new CannotLoadBeanClassException(rootBeanDefinition.getResourceDescription(), string, rootBeanDefinition.getBeanClassName(), linkageError);
        }
    }

    protected boolean isBeanClassMatch(String string, RootBeanDefinition rootBeanDefinition, Class clazz) throws CannotLoadBeanClassException {
        Class clazz2 = this.resolveBeanClass(rootBeanDefinition, string);
        return clazz2 != null && clazz.isAssignableFrom(clazz2);
    }

    protected Class predictBeanType(String string, RootBeanDefinition rootBeanDefinition) {
        if (rootBeanDefinition.getFactoryMethodName() != null) {
            return null;
        }
        return this.resolveBeanClass(rootBeanDefinition, string);
    }

    protected Class getTypeForFactoryBean(String string, RootBeanDefinition rootBeanDefinition) {
        if (!rootBeanDefinition.isSingleton()) {
            return null;
        }
        try {
            FactoryBean factoryBean = (FactoryBean)this.getBean("&" + string);
            return this.getTypeForFactoryBean(factoryBean);
        }
        catch (BeanCreationException beanCreationException) {
            this.logger.debug((Object)"Ignoring bean creation exception on FactoryBean type check", (Throwable)((Object)beanCreationException));
            return null;
        }
    }

    protected Class getTypeForFactoryBean(FactoryBean factoryBean) {
        try {
            return factoryBean.getObjectType();
        }
        catch (Throwable throwable) {
            this.logger.warn((Object)"FactoryBean threw exception from getObjectType, despite the contract saying that it should return null if the type of its object cannot be determined yet", throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectForBeanInstance(Object object, String string, RootBeanDefinition rootBeanDefinition) {
        if (BeanFactoryUtils.isFactoryDereference(string) && !(object instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(this.transformedBeanName(string), object.getClass());
        }
        boolean bl = rootBeanDefinition == null || rootBeanDefinition.isSingleton();
        Object object2 = object;
        if (object instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(string)) {
            FactoryBean factoryBean = (FactoryBean)object;
            String string2 = this.transformedBeanName(string);
            if (bl && factoryBean.isSingleton()) {
                Object object3 = this.getSingletonMutex();
                synchronized (object3) {
                    object2 = this.factoryBeanObjectCache.get(string2);
                    if (object2 == null) {
                        object2 = this.getObjectFromFactoryBean(factoryBean, string2, rootBeanDefinition);
                        this.factoryBeanObjectCache.put(string2, object2);
                    }
                }
            } else {
                object2 = this.getObjectFromFactoryBean(factoryBean, string2, rootBeanDefinition);
            }
        }
        return object2;
    }

    private Object getObjectFromFactoryBean(FactoryBean factoryBean, String string, RootBeanDefinition rootBeanDefinition) throws BeanCreationException {
        Object object;
        try {
            object = factoryBean.getObject();
        }
        catch (FactoryBeanNotInitializedException factoryBeanNotInitializedException) {
            throw new BeanCurrentlyInCreationException(string, factoryBeanNotInitializedException.toString());
        }
        catch (Throwable throwable) {
            throw new BeanCreationException(string, "FactoryBean threw exception on object creation", throwable);
        }
        if (object == null && this.isSingletonCurrentlyInCreation(string)) {
            throw new BeanCurrentlyInCreationException(string, "FactoryBean which is currently in creation returned null from getObject");
        }
        if (!(object == null || rootBeanDefinition != null && rootBeanDefinition.isSynthetic())) {
            try {
                object = this.postProcessObjectFromFactoryBean(object, string);
            }
            catch (Throwable throwable) {
                throw new BeanCreationException(rootBeanDefinition.getResourceDescription(), string, "Post-processing of the FactoryBean's object failed", throwable);
            }
        }
        return object;
    }

    protected Object postProcessObjectFromFactoryBean(Object object, String string) throws BeansException {
        return object;
    }

    public boolean isFactoryBean(String string) throws NoSuchBeanDefinitionException {
        String string2 = this.transformedBeanName(string);
        Object object = this.getSingleton(string2);
        if (object != null) {
            return object instanceof FactoryBean;
        }
        if (!this.containsBeanDefinition(string2) && this.getParentBeanFactory() instanceof AbstractBeanFactory) {
            return ((AbstractBeanFactory)this.getParentBeanFactory()).isFactoryBean(string);
        }
        RootBeanDefinition rootBeanDefinition = this.getMergedBeanDefinition(string2, false);
        return this.isBeanClassMatch(string2, rootBeanDefinition, class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean);
    }

    protected boolean isBeanNameInUse(String string) {
        return this.containsLocalBean(string) || this.hasDependentBean(string);
    }

    protected boolean requiresDestruction(Object object, RootBeanDefinition rootBeanDefinition) {
        return object instanceof DisposableBean || rootBeanDefinition.getDestroyMethodName() != null || this.hasDestructionAwareBeanPostProcessors();
    }

    protected void registerDisposableBeanIfNecessary(String string, Object object, RootBeanDefinition rootBeanDefinition) {
        if (rootBeanDefinition.isSingleton() && this.requiresDestruction(object, rootBeanDefinition)) {
            this.registerDisposableBean(string, new DisposableBeanAdapter(object, string, rootBeanDefinition, this.getBeanPostProcessors()));
            String[] stringArray = rootBeanDefinition.getDependsOn();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.registerDependentBean(stringArray[i], string);
                }
            }
        }
    }

    protected void removeSingleton(String string) {
        super.removeSingleton(string);
        this.factoryBeanObjectCache.remove(string);
    }

    protected abstract boolean containsBeanDefinition(String var1);

    protected abstract BeanDefinition getBeanDefinition(String var1) throws BeansException;

    protected abstract Object createBean(String var1, RootBeanDefinition var2, Object[] var3) throws BeanCreationException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

