/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.client.ContentNegotiation;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.MimeCodec;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.encoding.xml.XMLCodec;
import com.sun.xml.internal.ws.encoding.xml.XMLMessage;
import com.sun.xml.internal.ws.resources.StreamingMessages;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.channels.WritableByteChannel;
import java.util.StringTokenizer;
import javax.activation.DataSource;
import javax.xml.ws.WebServiceException;

public final class XMLHTTPBindingCodec
extends MimeCodec {
    private static final String BASE_ACCEPT_VALUE = "*";
    private static final String APPLICATION_FAST_INFOSET_MIME_TYPE = "application/fastinfoset";
    private boolean useFastInfosetForEncoding;
    private final Codec xmlCodec;
    private final Codec fiCodec;
    private static final String xmlAccept = null;
    private static final String fiXmlAccept = "application/fastinfoset, *";
    private AcceptContentType _adaptingContentType = new AcceptContentType();

    public XMLHTTPBindingCodec(WSBinding wSBinding) {
        super(SOAPVersion.SOAP_11, wSBinding);
        this.xmlCodec = new XMLCodec(wSBinding);
        this.fiCodec = XMLHTTPBindingCodec.getFICodec();
    }

    @Override
    public String getMimeType() {
        return null;
    }

    @Override
    public ContentType getStaticContentType(Packet packet) {
        XMLMessage.MessageDataSource messageDataSource;
        this.setRootCodec(packet);
        ContentType contentType = null;
        if (packet.getMessage() instanceof XMLMessage.MessageDataSource && (messageDataSource = (XMLMessage.MessageDataSource)((Object)packet.getMessage())).hasUnconsumedDataSource()) {
            contentType = this.getStaticContentType(messageDataSource);
            return contentType != null ? this._adaptingContentType.set(packet, contentType) : null;
        }
        contentType = super.getStaticContentType(packet);
        return contentType != null ? this._adaptingContentType.set(packet, contentType) : null;
    }

    @Override
    public ContentType encode(Packet packet, OutputStream outputStream) throws IOException {
        XMLMessage.MessageDataSource messageDataSource;
        this.setRootCodec(packet);
        if (packet.getMessage() instanceof XMLMessage.MessageDataSource && (messageDataSource = (XMLMessage.MessageDataSource)((Object)packet.getMessage())).hasUnconsumedDataSource()) {
            return this._adaptingContentType.set(packet, this.encode(messageDataSource, outputStream));
        }
        return this._adaptingContentType.set(packet, super.encode(packet, outputStream));
    }

    @Override
    public ContentType encode(Packet packet, WritableByteChannel writableByteChannel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        if (packet.contentNegotiation == null) {
            this.useFastInfosetForEncoding = false;
        }
        if (string == null) {
            this.xmlCodec.decode(inputStream, string, packet);
        } else if (this.isMultipartRelated(string)) {
            packet.setMessage(new XMLMessage.XMLMultiPart(string, inputStream, this.binding));
        } else if (this.isFastInfoset(string)) {
            if (this.fiCodec == null) {
                throw new RuntimeException(StreamingMessages.FASTINFOSET_NO_IMPLEMENTATION());
            }
            this.useFastInfosetForEncoding = true;
            this.fiCodec.decode(inputStream, string, packet);
        } else if (this.isXml(string)) {
            this.xmlCodec.decode(inputStream, string, packet);
        } else {
            packet.setMessage(new XMLMessage.UnknownContent(string, inputStream));
        }
        if (!this.useFastInfosetForEncoding) {
            this.useFastInfosetForEncoding = this.isFastInfosetAcceptable(packet.acceptableMimeTypes);
        }
    }

    @Override
    protected void decode(MimeMultipartParser mimeMultipartParser, Packet packet) throws IOException {
    }

    @Override
    public MimeCodec copy() {
        return new XMLHTTPBindingCodec(this.binding);
    }

    private boolean isMultipartRelated(String string) {
        return this.compareStrings(string, "multipart/related");
    }

    private boolean isApplicationXopXml(String string) {
        return this.compareStrings(string, "application/xop+xml");
    }

    private boolean isXml(String string) {
        return this.compareStrings(string, "application/xml") || this.compareStrings(string, "text/xml") || this.compareStrings(string, "application/") && string.toLowerCase().indexOf("+xml") != -1;
    }

    private boolean isFastInfoset(String string) {
        return this.compareStrings(string, APPLICATION_FAST_INFOSET_MIME_TYPE);
    }

    private boolean compareStrings(String string, String string2) {
        return string.length() >= string2.length() && string2.equalsIgnoreCase(string.substring(0, string2.length()));
    }

    private boolean isFastInfosetAcceptable(String string) {
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!string2.equalsIgnoreCase(APPLICATION_FAST_INFOSET_MIME_TYPE)) continue;
            return true;
        }
        return false;
    }

    private ContentType getStaticContentType(XMLMessage.MessageDataSource messageDataSource) {
        String string = messageDataSource.getDataSource().getContentType();
        boolean bl = XMLMessage.isFastInfoset(string);
        if (!XMLHTTPBindingCodec.requiresTransformationOfDataSource(bl, this.useFastInfosetForEncoding)) {
            return new ContentTypeImpl(string);
        }
        return null;
    }

    private ContentType encode(XMLMessage.MessageDataSource messageDataSource, OutputStream outputStream) {
        try {
            int n;
            boolean bl = XMLMessage.isFastInfoset(messageDataSource.getDataSource().getContentType());
            DataSource dataSource = XMLHTTPBindingCodec.transformDataSource(messageDataSource.getDataSource(), bl, this.useFastInfosetForEncoding, this.binding);
            InputStream inputStream = dataSource.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            return new ContentTypeImpl(dataSource.getContentType());
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
    }

    private void setRootCodec(Packet packet) {
        if (packet.contentNegotiation == ContentNegotiation.none) {
            this.useFastInfosetForEncoding = false;
        } else if (packet.contentNegotiation == ContentNegotiation.optimistic) {
            this.useFastInfosetForEncoding = true;
        }
        this.rootCodec = this.useFastInfosetForEncoding && this.fiCodec != null ? this.fiCodec : this.xmlCodec;
    }

    public static boolean requiresTransformationOfDataSource(boolean bl, boolean bl2) {
        return bl && !bl2 || !bl && bl2;
    }

    public static DataSource transformDataSource(DataSource dataSource, boolean bl, boolean bl2, WSBinding wSBinding) {
        try {
            if (bl && !bl2) {
                XMLHTTPBindingCodec xMLHTTPBindingCodec = new XMLHTTPBindingCodec(wSBinding);
                Packet packet = new Packet();
                xMLHTTPBindingCodec.decode(dataSource.getInputStream(), dataSource.getContentType(), packet);
                packet.getMessage().getAttachments();
                xMLHTTPBindingCodec.getStaticContentType(packet);
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                ContentType contentType = xMLHTTPBindingCodec.encode(packet, (OutputStream)byteArrayBuffer);
                return XMLMessage.createDataSource(contentType.getContentType(), byteArrayBuffer.newInputStream());
            }
            if (!bl && bl2) {
                XMLHTTPBindingCodec xMLHTTPBindingCodec = new XMLHTTPBindingCodec(wSBinding);
                Packet packet = new Packet();
                xMLHTTPBindingCodec.decode(dataSource.getInputStream(), dataSource.getContentType(), packet);
                packet.contentNegotiation = ContentNegotiation.optimistic;
                packet.getMessage().getAttachments();
                xMLHTTPBindingCodec.getStaticContentType(packet);
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                ContentType contentType = xMLHTTPBindingCodec.encode(packet, (OutputStream)byteArrayBuffer);
                return XMLMessage.createDataSource(contentType.getContentType(), byteArrayBuffer.newInputStream());
            }
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        return dataSource;
    }

    private static Codec getFICodec() {
        try {
            Class<?> clazz = Class.forName("com.sun.xml.internal.ws.encoding.fastinfoset.FastInfosetCodec");
            Method method = clazz.getMethod("create", new Class[0]);
            return (Codec)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class AcceptContentType
    implements ContentType {
        private ContentType _c;
        private String _accept;

        private AcceptContentType() {
        }

        public AcceptContentType set(Packet packet, ContentType contentType) {
            this._accept = packet.contentNegotiation == ContentNegotiation.optimistic || packet.contentNegotiation == ContentNegotiation.pessimistic ? XMLHTTPBindingCodec.fiXmlAccept : xmlAccept;
            this._c = contentType;
            return this;
        }

        @Override
        public String getContentType() {
            return this._c.getContentType();
        }

        @Override
        public String getSOAPActionHeader() {
            return this._c.getSOAPActionHeader();
        }

        @Override
        public String getAcceptHeader() {
            return this._accept;
        }
    }
}

