/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadCoilsResponse;
import net.wimpi.modbus.procimg.DigitalOut;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;

public final class ReadCoilsRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_BitCount;

    public ReadCoilsRequest() {
        this.setFunctionCode(1);
        this.setDataLength(4);
    }

    public ReadCoilsRequest(int ref, int count) {
        this.setFunctionCode(1);
        this.setDataLength(4);
        this.setReference(ref);
        this.setBitCount(count);
    }

    @Override
    public ModbusResponse createResponse() {
        ReadCoilsResponse response = null;
        DigitalOut[] douts = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            douts = procimg.getDigitalOutRange(this.getReference(), this.getBitCount());
        }
        catch (IllegalAddressException iaex) {
            return this.createExceptionResponse(2);
        }
        response = new ReadCoilsResponse(douts.length);
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        int i = 0;
        while (i < douts.length) {
            response.setCoilStatus(i, douts[i].isSet());
            ++i;
        }
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setBitCount(int count) {
        if (count > 2000) {
            throw new IllegalArgumentException("Maximum bitcount exceeded.");
        }
        this.m_BitCount = count;
    }

    public int getBitCount() {
        return this.m_BitCount;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        dout.writeShort(this.m_BitCount);
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        this.m_BitCount = din.readUnsignedShort();
    }
}

