/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public abstract class CachingMapDecorator
implements Map,
Serializable {
    private static Object NULL_VALUE = new Object();
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$util$CachingMapDecorator == null ? (class$org$springframework$util$CachingMapDecorator = CachingMapDecorator.class$("org.springframework.util.CachingMapDecorator")) : class$org$springframework$util$CachingMapDecorator));
    private final Map targetMap;
    static /* synthetic */ Class class$org$springframework$util$CachingMapDecorator;

    public CachingMapDecorator() {
        this(false);
    }

    public CachingMapDecorator(boolean bl) {
        AbstractMap abstractMap = bl ? new WeakHashMap() : new HashMap();
        this.targetMap = Collections.synchronizedMap(abstractMap);
    }

    public CachingMapDecorator(boolean bl, int n) {
        AbstractMap abstractMap = bl ? new WeakHashMap(n) : new HashMap(n);
        this.targetMap = Collections.synchronizedMap(abstractMap);
    }

    public CachingMapDecorator(Map map) {
        Assert.notNull(map, "Target Map is required");
        this.targetMap = map;
    }

    public int size() {
        return this.targetMap.size();
    }

    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.targetMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.targetMap.containsValue(object);
    }

    public Object put(Object object, Object object2) {
        return this.targetMap.put(object, object2);
    }

    public Object remove(Object object) {
        return this.targetMap.remove(object);
    }

    public void putAll(Map map) {
        this.targetMap.putAll(map);
    }

    public void clear() {
        this.targetMap.clear();
    }

    public Set keySet() {
        return this.targetMap.keySet();
    }

    public Collection values() {
        return this.targetMap.values();
    }

    public Set entrySet() {
        return this.targetMap.entrySet();
    }

    public Object get(Object object) {
        Object object2 = this.targetMap.get(object);
        if (object2 == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating new expensive value for key '" + object + "'"));
            }
            if ((object2 = this.create(object)) == null) {
                object2 = NULL_VALUE;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Caching expensive value: " + object2));
            }
            this.put(object, object2);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("For key '" + object + "', returning cached value: " + object2));
        }
        return object2 == NULL_VALUE ? null : object2;
    }

    protected abstract Object create(Object var1);

    public String toString() {
        return "CachingMapDecorator [" + this.getClass().getName() + "]:" + this.targetMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

