/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.CommandParameterMap;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.ControlRelation;
import cn.com.voltronic.solar.data.bean.EnableSpinnerItem;
import cn.com.voltronic.solar.data.bean.EnableSpinnerParameter;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.HistoryFaultDataColumns;
import cn.com.voltronic.solar.data.bean.MoreInfo;
import cn.com.voltronic.solar.data.bean.ProductInfo;
import cn.com.voltronic.solar.data.bean.PurchaseInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RatingInfo;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class P17
implements IProtocol {
    public Logger logger = Logger.getLogger(P17.class);
    protected static final int THIRTYK = 30000;
    protected static final int TENK = 10000;
    protected static final int FIVEK = 5000;
    protected static final int FOURK = 4000;
    protected static final int THREEK = 3000;
    public static final String VERSION_170711 = "170711123000";
    private static int GRIDTIE_BASIC = 100;
    private static int OFFGRID_BASIC = 150;
    private static int HOMESOLAR_BASIC = 200;
    protected int mpptTrackNumber = 1;
    private String dspversion = "";
    private String mcuversion = "";
    private String modelName = "";
    protected String modelType = "10";
    protected String deviceModel = "100";
    protected String serialNo = "";
    private boolean supportModelSetting = true;
    private CommandParameterMap map = new CommandParameterMap();
    private List<ControlRelation> relalist = new ArrayList<ControlRelation>();

    @Override
    public String getProtocolID() {
        return "P17";
    }

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            IComUSBHandler _handler = (IComUSBHandler)handler;
            String dataStr = _handler.excuteSimpleCommand("PI");
            if (!StringUtils.isEmpty((String)dataStr) && dataStr.startsWith("17")) {
                block16: {
                    block15: {
                        String[] qmds;
                        block14: {
                            String qmdStr;
                            block13: {
                                qmdStr = _handler.excuteCommand("MD", true);
                                if (!StringUtils.isEmpty((String)qmdStr)) break block13;
                                return false;
                            }
                            qmds = qmdStr.split(",");
                            if (qmds.length >= 2) break block14;
                            return false;
                        }
                        int outputRateVA = VolUtil.parseInt(qmds[1]);
                        if (outputRateVA == 10000) break block15;
                        return false;
                    }
                    this.mpptTrackNumber = _handler.getMpptTrackNumber();
                    this.modelType = _handler.getModeType();
                    this.deviceModel = _handler.getDeviceModel();
                    String serialNoStr = _handler.getSerialNo();
                    if (!StringUtils.isEmpty((String)serialNoStr)) {
                        this.serialNo = serialNoStr;
                        break block16;
                    }
                    return false;
                }
                try {
                    dataStr = "";
                    int i = 0;
                    while (i < 5 && (StringUtils.isEmpty((String)dataStr) || dataStr.startsWith("(NAK") || dataStr.indexOf("MCU:") < 0 || dataStr.indexOf("DSP:") < 0)) {
                        dataStr = _handler.excuteSimpleCommand("VFWT");
                        String[] index = dataStr.split(",");
                        if (index.length > 0) {
                            this.dspversion = index[0];
                            this.mcuversion = index[1];
                        } else {
                            dataStr = "";
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
                return true;
            }
            return false;
        }
        if (!(handler instanceof ModbusHandler)) {
            boolean cfr_ignored_0 = handler instanceof SNMPHandler;
        }
        return false;
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.pvInputVoltage1[:]", "{workInfo.getPvInputVoltage1}", "V"));
        item.add(new AutoLabelItem("message.pvInputVoltage2[:]", "{workInfo.getPvInputVoltage2}", "V"));
        item.add(new AutoLabelItem("message.gridVoltager[:]", "{workInfo.getRGridVoltage}", "V"));
        item.add(new AutoLabelItem("message.gridVoltages[:]", "{workInfo.getSGridVoltage}", "V"));
        item.add(new AutoLabelItem("message.gridVoltaget[:]:", "{workInfo.getTGridVoltage}", "V"));
        item.add(new AutoLabelItem("message.gridFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null) {
            IComUSBHandler _handler = (IComUSBHandler)((Object)processor.getHandler());
            this.modelType = _handler.getModeType();
        }
        if (!this.modelType.equals("00")) {
            ConfigData configData;
            item.add(new AutoLabelItem("message.outputLoadPercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
            item.add(new AutoLabelItem("message.chargeCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
            item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getPBatteryVoltage}", "V"));
            item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
            if (processor != null && (configData = (ConfigData)processor.getBeanBag().getBean("configdata")).getBatTptCompensate() > 0.0) {
                item.add(new AutoLabelItem("message.externalBatteryTemperature[:]", "{workInfo.getExternalBatteryTemperature}", "\u2103"));
            }
            item.add(new AutoLabelItem("message.acOutputActivePowerR[:]", "{workInfo.getAcOutputActivePowerR}", "W"));
            item.add(new AutoLabelItem("message.acOutputActivePowerS[:]", "{workInfo.getAcOutputActivePowerS}", "W"));
            item.add(new AutoLabelItem("message.acOutputActivePowerT[:]", "{workInfo.getAcOutputActivePowerT}", "W"));
            item.add(new AutoLabelItem("message.totalAcOutputActivePower[:]", "{workInfo.getWholeGridOutputPower}", "W"));
            item.add(new AutoLabelItem("message.acOutputApperentPowerR[:]", "{workInfo.getAcOutputApperentPowerR}", "VA"));
            item.add(new AutoLabelItem("message.acOutputApperentPowerS[:]", "{workInfo.getAcOutputApperentPowerS}", "VA"));
            item.add(new AutoLabelItem("message.acOutputApperentPowerT[:]", "{workInfo.getAcOutputApperentPowerT}", "VA"));
            item.add(new AutoLabelItem("message.totalAcOutputApperentPower[:]", "{workInfo.getWholeGridOutputApperentPower}", "VA"));
        }
        item.add(new AutoLabelItem("message.innerTemperature[:]", "{workInfo.getInnerTemperature}", "\u2103"));
        item.add(new AutoLabelItem("message.maxComponentTemperature[:]", "{workInfo.getMaxTemperature}", "\u2103"));
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public MoreInfo getMoreInfo() {
        return null;
    }

    @Override
    public ProductInfo getProductInfo() {
        ProductInfo productInfo = new ProductInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.machinetype[:]", "{machineInfo.getMachineType}", ""));
        infos.add(new AutoLabelItem("message.topology[:]", "{machineInfo.getTopology}", ""));
        infos.add(new AutoLabelItem("message.mainfirewareversion[:]", "{machineInfo.getMainFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.slavefirewareversion[:]", "{machineInfo.getSlaveFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.iophase[:]", "{machineInfo.getIoPhase}", ""));
        infos.add(new AutoLabelItem("message.nominalInputVoltage[:]", "{machineInfo.getNominalInputVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominalOutputVoltage[:]", "{machineInfo.getNominalOutputVoltage}", "V"));
        if (!this.modelType.equals("00")) {
            infos.add(new AutoLabelItem("message.batteryPieceNumber[:]", "{machineInfo.getBatteryPieceNumber}", ""));
            infos.add(new AutoLabelItem("message.batteryStandVoltage[:]", "{machineInfo.getBatteryStandVoltage}", "V"));
        }
        productInfo.setInfos(infos);
        return productInfo;
    }

    @Override
    public PurchaseInfo getPurchaseInfo() {
        return null;
    }

    @Override
    public RatingInfo getRatingInfo() {
        RatingInfo ratingInfo = new RatingInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.outputRateVA[:]", "{machineInfo.getOutputRateVA}", "W"));
        if (!this.modelType.equals("00")) {
            infos.add(new AutoLabelItem("message.acVoltageL[:]", "{machineInfo.getMinACInputLowV}", "V"));
            infos.add(new AutoLabelItem("message.acVoltageH[:]", "{machineInfo.getMaxACInputHighV}", "V"));
            infos.add(new AutoLabelItem("message.acFrequencyL[:]", "{machineInfo.getMinACInputLowF}", "Hz"));
            infos.add(new AutoLabelItem("message.acfrequencyH[:]", "{machineInfo.getMaxACInputHighF}", "Hz"));
        }
        if (!this.modelType.equals("01")) {
            infos.add(new AutoLabelItem("message.acRatingVoltage[:]", "{machineInfo.getGridRatingVoltage}", "V"));
            infos.add(new AutoLabelItem("message.acRatingFrequency[:]", "{machineInfo.getGridRatingFrequency}", "Hz"));
            infos.add(new AutoLabelItem("message.gridRatingCurrent[:]", "{machineInfo.getGridRatingCurrent}", "A"));
        }
        infos.add(new AutoLabelItem("message.MPPTRatingCurrent[:]", "{machineInfo.getPerMPPTRatingCurrent}", "A"));
        if (!this.modelType.equals("00")) {
            infos.add(new AutoLabelItem("message.batteryRatingVoltage[:]", "{machineInfo.getBatteryRatingVoltage}", "V"));
        }
        ratingInfo.setInfos(infos);
        return ratingInfo;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        if (this.modelType.equals("00") || this.modelType.equals("10")) {
            infos.add(new AutoLabelItem("message.setGOLV[:]", "{defaultData.getLowGridV}", "V"));
            infos.add(new AutoLabelItem("message.setGOHV[:]", "{defaultData.getHighGridV}", "V"));
            infos.add(new AutoLabelItem("message.setGOLF[:]", "{defaultData.getLowGridF}", "Hz"));
            infos.add(new AutoLabelItem("message.setGOHF[:]", "{defaultData.getHighGridF}", "Hz"));
        } else {
            infos.add(new AutoLabelItem("message.acVoltageL[:]", "{defaultData.getLowGridV}", "V"));
            infos.add(new AutoLabelItem("message.acVoltageH[:]", "{defaultData.getHighGridV}", "V"));
            infos.add(new AutoLabelItem("message.acFrequencyL[:]", "{defaultData.getLowGridF}", "Hz"));
            infos.add(new AutoLabelItem("message.acfrequencyH[:]", "{defaultData.getHighGridF}", "Hz"));
        }
        if (!this.modelType.equals("01") && (this.deviceModel.equals("100") || this.deviceModel.equals("108") || this.deviceModel.equals("050") || this.deviceModel.equals("058"))) {
            infos.add(new AutoLabelItem("message.setGILTHV[:]", "{defaultData.getGridAvgHighV}", "V"));
        }
        infos.add(new AutoLabelItem("message.setPVIPLV[:]", "{defaultData.getPvInputLowV}", "V"));
        infos.add(new AutoLabelItem("message.setPVIPHV[:]", "{defaultData.getPvInputHighV}", "V"));
        infos.add(new AutoLabelItem("message.setMPPTLV[:]", "{defaultData.getMppLowV}", "V"));
        infos.add(new AutoLabelItem("message.setMPPTHV[:]", "{defaultData.getMppHighV}", "V"));
        infos.add(new AutoLabelItem("message.setBTNUM[:]", "{configData.getBatteryNumber}", ""));
        if (!this.modelType.equals("00")) {
            infos.add(new AutoLabelItem("message.maxChargingCurrent[:]", "{defaultData.getMaxChargingCurrent}", "A"));
            infos.add(new AutoLabelItem("message.maxFloatingVoltage[:]", "{defaultData.getFloatingVoltage}", "V"));
            infos.add(new AutoLabelItem("message.maxChargingVoltage[:]", "{defaultData.getMaxChargingVoltage}", "V"));
        }
        if (!this.modelType.equals("00")) {
            infos.add(new AutoLabelItem("message.cutoffVolGridOn[:]", "{defaultData.getBatteryWeakVoltage}", "V"));
            infos.add(new AutoLabelItem("message.recoverVolGridOn[:]", "{defaultData.getBatteryWeakBackVoltage}", "V"));
            infos.add(new AutoLabelItem("message.cutoffVolGridLoss[:]", "{defaultData.getBatteryUnderVoltage}", "V"));
            infos.add(new AutoLabelItem("message.recoverVolGridLoss[:]", "{defaultData.getBatteryUnderBackVoltage}", "V"));
        }
        infos.add(new AutoLabelItem("message.setLCD[:]", "{defaultData.getLcdSleepTime}", "S"));
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        list.add(new AutoRadioItem("message.pepdP[:]", "message.enable", "message.disable", "{cappbility.isCapableB}", "CapableB", false));
        if (!this.modelType.equals("01") && this.getMCUVersion().compareTo(VERSION_170711) >= 0 && (this.deviceModel.equals("064") || this.deviceModel.equals("114") || this.deviceModel.equals("065") || this.deviceModel.equals("115") || this.deviceModel.equals("066") || this.deviceModel.equals("116") || this.deviceModel.equals("067") || this.deviceModel.equals("117") || this.deviceModel.equals("068") || this.deviceModel.equals("118") || this.deviceModel.equals("069") || this.deviceModel.equals("119"))) {
            list.add(new AutoRadioItem("message.OverFrequencyDerating[:]", "message.enable", "message.disable", "{cappbility.isCapableG}", "CapableG", false));
            list.add(new AutoRadioItem("message.OverVoltageDerating[:]", "message.enable", "message.disable", "{cappbility.isCapableH}", "CapableH", false));
            list.add(new AutoRadioItem("message.rPControl[:]", "message.enable", "message.disable", "{cappbility.getCheck_reactivePowerAutoControl}", "ENFH", false));
        }
        if (!this.modelType.equals("00")) {
            list.add(new AutoRadioItem("message.pepdB[:]", "message.enable", "message.disable", "{cappbility.isCapableC}", "CapableC", false));
            list.add(new AutoRadioItem("message.BatteryTypeLiFe[:]", "message.yes", "message.no", "{configData.isLiFeBattery}", "LBF", false));
            list.add(new AutoRadioItem("message.GNTM[:]", "message.enable", "message.disable", "{cappbility.isCapableD}", "CapableD", false));
            list.add(new AutoRadioItem("message.wideAcInputRange[:]", "message.enable", "message.disable", "{cappbility.isCapableE}", "CapableE", false));
            list.add(new AutoRadioItem("message.parallelforoutput[:]", "message.enable", "message.disable", "{cappbility.isParallelOutput}", "ParallelFO", false));
        }
        list.add(new AutoRadioItem("message.pepdF[:]", "message.enable", "message.disable", "{cappbility.isCapableF}", "CapableF", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        list.add(new AutoSpinnerItem("message.setPVIPLV[:]", "{configData.getMinPvInputLowV}", "{configData.getMaxPvInputLowV}", "1", "{configData.getPvInputLowV}", "V", "setPVIPLV", 0, false));
        list.add(new AutoSpinnerItem("message.setPVIPHV[:]", "{configData.getMinPvInputHighV}", "{configData.getMaxPvInputHighV}", "1", "{configData.getPvInputHighV}", "V", "setPVIPHV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTLV[:]", "{configData.getMinMpptLowV}", "{configData.getMaxMpptLowV}", "1", "{configData.getMpptLowV}", "V", "setMPPTLV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTHV[:]", "{configData.getMinMpptHighV}", "{configData.getMaxMpptHighV}", "1", "{configData.getMpptHighV}", "V", "setMPPTHV", 0, false));
        list.add(new AutoSpinnerItem("message.setBTNUM[:]", "{configData.getMinBatteryNumber}", "{configData.getMaxBatteryNumber}", "1", "{configData.getBatteryNumber}", "", "setBTNUM", 0, false));
        if (!this.modelType.equals("00")) {
            list.add(new AutoSpinnerItem("message.maxChargingCurrent[:]", "{configData.getMinMaxChargingCurrent}", "{configData.getMaxMaxChargingCurrent}", "0.1", "{configData.getMaxChargingCurrent}", "A", "setMaxChargingCurrent", 0, false));
            list.add(new AutoSpinnerItem("message.maxACchargingCurrent[:]", "{configData.getMinMaxChargingCurrent}", "{configData.getMaxMaxChargingCurrent}", "0.1", "{configData.getMaxAcChargingCurrent}", "A", "setMaxAcChargingCurrent", 0, false));
            list.add(new AutoSpinnerItem("message.maxChargingVoltage[:]", "{configData.getMinMaxChargingVoltage}", "{configData.getMaxMaxChargingVoltage}", "0.1", "{configData.getMaxChargingVoltage}", "V", "setMCHGV", 1, false));
            list.add(new AutoSpinnerItem("message.maxFloatingVoltage[:]", "{configData.getMinFloatingVoltage}", "{configData.getMaxFloatingVoltage}", "0.1", "{configData.getFloatingVoltage}", "V", "setMCHGV", 0, false));
            list.add(new AutoSpinnerItem("message.cutoffVolGridOn[:]", "{configData.getMinCutoffVoltage}", "{configData.getMaxCutoffVoltage}", "0.1", "{configData.getCutoffVoltage}", "V", "setBatDischargeVol", 2, false));
            list.add(new AutoSpinnerItem("message.recoverVolGridOn[:]", "{configData.getMinRecoverVoltage}", "{configData.getMaxRecoverVoltage}", "0.1", "{configData.getRecoverVoltage}", "V", "setBatDischargeVol", 3, false));
            list.add(new AutoSpinnerItem("message.cutoffVolGridLoss[:]", "{configData.getMinCutoffVoltageGridLoss}", "{configData.getMaxCutoffVoltageGridLoss}", "0.1", "{configData.getCutoffVoltageGridLoss}", "V", "setBatDischargeVol", 0, false));
            list.add(new AutoSpinnerItem("message.recoverVolGridLoss[:]", "{configData.getMinRecoverVoltageGridLoss}", "{configData.getMaxRecoverVoltageGridLoss}", "0.1", "{configData.getRecoverVoltageGridLoss}", "V", "setBatDischargeVol", 1, false));
            list.add(new AutoSpinnerItem("message.batTprCompensation[:]", "{configData.getMinBatTptCompensate}", "{configData.getMaxBatTptCompensate}", "0.1", "{configData.getBatTptCompensate}", "mV", "setBatTptCompensate", 0, false));
            list.add(new AutoSpinnerItem("message.batDischargeMaxCurrentInHybridMode[:]", "{configData.getMinBatDischargeMaxCurrentInHybridMode}", "{configData.getMaxBatDischargeMaxCurrentInHybridMode}", "1", "{configData.getBatDischargeMaxCurrentInHybridMode}", "A", "setBatDischargeMaxCurrentInHybridMode", 0, false));
            list.add(new AutoSpinnerItem("message.feedingGridPowerCalibrationR[:]", "{configData.getMinFeedingGridCalibrationPowerR}", "{configData.getMaxFeedingGridCalibrationPowerR}", "1", "{configData.getFeedingGridCalibrationPowerR}", "W", "setFeedingGridCalibrationPowerR", 0, false));
            list.add(new AutoSpinnerItem("message.feedingGridPowerCalibrationS[:]", "{configData.getMinFeedingGridCalibrationPowerS}", "{configData.getMaxFeedingGridCalibrationPowerS}", "1", "{configData.getFeedingGridCalibrationPowerS}", "W", "setFeedingGridCalibrationPowerS", 0, false));
            list.add(new AutoSpinnerItem("message.feedingGridPowerCalibrationT[:]", "{configData.getMinFeedingGridCalibrationPowerT}", "{configData.getMaxFeedingGridCalibrationPowerT}", "1", "{configData.getFeedingGridCalibrationPowerT}", "W", "setFeedingGridCalibrationPowerT", 0, false));
        }
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", true, true));
        list.add(new HistoryData("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", true, true));
        list.add(new HistoryData("message.pvInputPower1", "{workInfo.getPvInputPower1}", true, true));
        list.add(new HistoryData("message.pvInputPower2", "{workInfo.getPvInputPower2}", true, true));
        list.add(new HistoryData("message.gridVoltager", "{workInfo.getRGridVoltage}", true, true));
        list.add(new HistoryData("message.gridVoltages", "{workInfo.getSGridVoltage}", true, true));
        list.add(new HistoryData("message.gridVoltaget", "{workInfo.getTGridVoltage}", true, true));
        list.add(new HistoryData("message.gridFrequency", "{workInfo.getGridFrequency}", true, true));
        if (!this.modelType.equals("00")) {
            list.add(new HistoryData("message.outputLoadPercent", "{workInfo.getOutputLoadPercent}", true, true));
            list.add(new HistoryData("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", true, true));
            list.add(new HistoryData("message.batteryCapacity", "{workInfo.getBatteryCapacity}", true, true));
            list.add(new HistoryData("message.chargeCurrent", "{workInfo.getChargingCurrent}", true, true));
            list.add(new HistoryData("message.acOutputActivePowerR", "{workInfo.getAcOutputActivePowerR}", false, true));
            list.add(new HistoryData("message.acOutputActivePowerS", "{workInfo.getAcOutputActivePowerS}", false, true));
            list.add(new HistoryData("message.acOutputActivePowerT", "{workInfo.getAcOutputActivePowerT}", false, true));
            list.add(new HistoryData("message.totalAcOutputActivePower", "{workInfo.getWholeGridOutputPower}", false, true));
            list.add(new HistoryData("message.acOutputApperentPowerR", "{workInfo.getAcOutputApperentPowerR}", false, true));
            list.add(new HistoryData("message.acOutputApperentPowerS", "{workInfo.getAcOutputApperentPowerS}", false, true));
            list.add(new HistoryData("message.acOutputApperentPowerT", "{workInfo.getAcOutputApperentPowerT}", false, true));
            list.add(new HistoryData("message.totalAcOutputApperentPower", "{workInfo.getWholeGridOutputApperentPower}", false, true));
        }
        list.add(new HistoryData("message.innerTemperature", "{workInfo.getInnerTemperature}", true, true));
        list.add(new HistoryData("message.temperature", "{workInfo.getMaxTemperature}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", 1000.0, "V", true));
        list.add(new HistoryChart("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", 1000.0, "V", true));
        list.add(new HistoryChart("message.pvInputPower1", "{workInfo.getPvInputPower1}", 15000.0, "W", true));
        list.add(new HistoryChart("message.pvInputPower2", "{workInfo.getPvInputPower2}", 15000.0, "W", true));
        list.add(new HistoryChart("message.gridVoltager", "{workInfo.getRGridVoltage}", 300.0, "V", true));
        list.add(new HistoryChart("message.gridVoltages", "{workInfo.getSGridVoltage}", 300.0, "V", true));
        list.add(new HistoryChart("message.gridVoltaget", "{workInfo.getTGridVoltage}", 300.0, "V", true));
        list.add(new HistoryChart("message.gridFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        if (!this.modelType.equals("00")) {
            list.add(new HistoryChart("message.outputLoadPercent", "{workInfo.getOutputLoadPercent}", 100.0, "%", true));
            list.add(new HistoryChart("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", 500.0, "V", true));
            list.add(new HistoryChart("message.batteryCapacity", "{workInfo.getBatteryCapacity}", 100.0, "%", true));
            list.add(new HistoryChart("message.chargeCurrent", "{workInfo.getChargingCurrent}", 100.0, "A", true));
            list.add(new HistoryChart("message.acOutputActivePowerR", "{workInfo.getAcOutputActivePowerR}", 10000.0, "W", true));
            list.add(new HistoryChart("message.acOutputActivePowerS", "{workInfo.getAcOutputActivePowerS}", 10000.0, "W", true));
            list.add(new HistoryChart("message.acOutputActivePowerT", "{workInfo.getAcOutputActivePowerT}", 10000.0, "W", true));
            list.add(new HistoryChart("message.totalAcOutputActivePower", "{workInfo.getWholeGridOutputPower}", 30000.0, "W", true));
            list.add(new HistoryChart("message.acOutputApperentPowerR", "{workInfo.getAcOutputApperentPowerR}", 10000.0, "VA", true));
            list.add(new HistoryChart("message.acOutputApperentPowerS", "{workInfo.getAcOutputApperentPowerS}", 10000.0, "VA", true));
            list.add(new HistoryChart("message.acOutputApperentPowerT", "{workInfo.getAcOutputApperentPowerT}", 10000.0, "VA", true));
            list.add(new HistoryChart("message.totalAcOutputApperentPower", "{workInfo.getWholeGridOutputApperentPower}", 30000.0, "VA", true));
        }
        list.add(new HistoryChart("message.innerTemperature", "{workInfo.getInnerTemperature}", 180.0, "\u2103", true));
        list.add(new HistoryChart("message.temperature", "{workInfo.getMaxTemperature}", 180.0, "\u2103", true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryFaultDataColumns getHistoryFaultColumns() {
        HistoryFaultDataColumns columns = new HistoryFaultDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.trandate", "{faultData.getTrandate}", true, true));
        list.add(new HistoryData("message.faultString", "{faultData.getFaultString}", true, true));
        list.add(new HistoryData("message.pvInputVoltage1", "{faultData.getPvinputvoltage1}", true, true));
        list.add(new HistoryData("message.pvInputVoltage2", "{faultData.getPvinputvoltage2}", true, true));
        list.add(new HistoryData("message.gridVoltager", "{faultData.getAcinputvoltager}", true, true));
        list.add(new HistoryData("message.gridVoltages", "{faultData.getAcinputvoltages}", true, true));
        list.add(new HistoryData("message.gridVoltaget", "{faultData.getAcinputvoltaget}", true, true));
        list.add(new HistoryData("message.gridFrequency", "{faultData.getGridFrequency}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{faultData.getBatteryVoltage}", true, true));
        list.add(new HistoryData("message.chargeCurrent", "{faultData.getBatteryCurrent}", true, true));
        list.add(new HistoryData("message.gridOutputVoltageR", "{faultData.getAcoutputvoltager}", true, true));
        list.add(new HistoryData("message.gridOutputVoltageS", "{faultData.getAcoutputvoltages}", true, true));
        list.add(new HistoryData("message.gridOutputVoltageT", "{faultData.getAcoutputvoltaget}", true, true));
        list.add(new HistoryData("message.acOutputFrequency", "{faultData.getOutputLoadFrequency}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public int getMpptTrackNumber() {
        return this.mpptTrackNumber;
    }

    @Override
    public void setMpptTrackNumber(int mpptTrackNumber) {
        this.mpptTrackNumber = mpptTrackNumber;
    }

    @Override
    public String getSerialNo() {
        return this.serialNo;
    }

    @Override
    public String getModelType() {
        return this.modelType;
    }

    @Override
    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    @Override
    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.baseSet", 101, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.passwordSet", 102, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.smsinfoSet", 104, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.emailSet", 105, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electricEventSet", 106, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.setcom", 107, ""), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.modelchange", 200, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.parametersSetting", 201, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.factoryReset", 202, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.synchroEnergyData", 203, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.realTimeCtrl", 204, ""), null));
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryPower", 301, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryData", 302, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryFaultData", 303, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryEvent", 304, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.monitorPointInfo", 305, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.powerNumber", 306, ""), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("English", 401, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("French", 402, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("German", 403, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Italian", 404, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Polish", 405, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Portuguese", 406, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Russian", 407, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Spanish", 408, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Ukrainian", 409, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Turkish", 410, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", 411, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", 412, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Japanese", 413, "radio"), null));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.about", 501, ""), null));
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.onlineHelp", 502, ""), null));
        menus.add(new AutoMenuOne("[" + GlobalVariables.customerConfig.getCustomerName() + "]" + "message.pvConfig", 1, items1));
        menus.add(new AutoMenuOne("message.pvControl", 2, items2));
        menus.add(new AutoMenuOne("message.pvView", 3, items3));
        menus.add(new AutoMenuOne("message.language", 4, items4));
        menus.add(new AutoMenuOne("message.help", 5, items5));
        menuList.setMenuList(menus);
        return menuList;
    }

    @Override
    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
        try {
            int modeid = Integer.parseInt(deviceModel);
            this.modelType = modeid >= HOMESOLAR_BASIC ? "11" : (modeid >= OFFGRID_BASIC ? "01" : (modeid >= GRIDTIE_BASIC ? "00" : "10"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Override
    public CommandParameterMap getCommandMap() {
        return this.map;
    }

    @Override
    public void initCommandMap() {
        this.map.clear();
        this.map.AddCommand("setPVIPLV", 1);
        this.map.AddCommand("setPVIPHV", 1);
        this.map.AddCommand("setMPPTLV", 1);
        this.map.AddCommand("setMPPTHV", 1);
        this.map.AddCommand("setGOLV", 1);
        this.map.AddCommand("setGOHV", 1);
        this.map.AddCommand("setGOLF", 1);
        this.map.AddCommand("setGOHF", 1);
        this.map.AddCommand("setGridWaittime", 1);
        this.map.AddCommand("setGILTHV", 1);
        this.map.AddCommand("setMaxChargingCurrent", 1);
        this.map.AddCommand("setMaxAcChargingCurrent", 1);
        this.map.AddCommand("setMaxPowerFeedingGrid", 1);
        this.map.AddCommand("setMCHGV", 2);
        this.map.AddCommand("setBatTptCompensate", 1);
        this.map.AddCommand("setBatDischargeVol", 4);
        this.map.AddCommand("setLiBatterySetting", 3);
        this.map.AddCommand("setGridPowerDeviation", 1);
        this.map.AddCommand("setBatDischargeMaxCurrentInHybridMode", 1);
        this.map.AddCommand("setFeedinPowerFactor", 1);
        this.map.AddCommand("setFeedingGridCalibrationPowerR", 1);
        this.map.AddCommand("setFeedingGridCalibrationPowerS", 1);
        this.map.AddCommand("setFeedingGridCalibrationPowerT", 1);
        this.map.AddCommand("setFeefInReactivePower", 1);
        this.map.AddCommand("setBTNUM", 1);
        this.relalist.clear();
        this.relalist.add(new ControlRelation("setMCHGV", 1, "setMCHGV", 0, ControlRelation.RELATION_MAX));
        this.relalist.add(new ControlRelation("setMCHGV", 0, "setMCHGV", 1, ControlRelation.RELATION_MIN));
        this.relalist.add(new ControlRelation("setMCHGV", 0, "setBatDischargeVol", 1, ControlRelation.RELATION_MAX));
        this.relalist.add(new ControlRelation("setMCHGV", 0, "setBatDischargeVol", 3, ControlRelation.RELATION_MAX));
        this.relalist.add(new ControlRelation("setMCHGV", 0, "setLiBatterySetting", 1, ControlRelation.RELATION_MAX));
        this.relalist.add(new ControlRelation("setBatDischargeVol", 1, "setMCHGV", 0, ControlRelation.RELATION_MIN));
        this.relalist.add(new ControlRelation("setBatDischargeVol", 3, "setMCHGV", 0, ControlRelation.RELATION_MIN));
        this.relalist.add(new ControlRelation("setLiBatterySetting", 1, "setMCHGV", 0, ControlRelation.RELATION_MIN));
        this.relalist.add(new ControlRelation("setMaxChargingCurrent", 0, "setLiBatterySetting", 0, ControlRelation.RELATION_MAX));
        this.relalist.add(new ControlRelation("setLiBatterySetting", 0, "setMaxChargingCurrent", 0, ControlRelation.RELATION_MIN));
        this.relalist.add(new ControlRelation("setBatDischargeVol", 0, "setBatDischargeVol", 1, ControlRelation.RELATION_MIN));
        this.relalist.add(new ControlRelation("setBatDischargeVol", 2, "setBatDischargeVol", 3, ControlRelation.RELATION_MIN));
        this.relalist.add(new ControlRelation("setBatDischargeVol", 1, "setBatDischargeVol", 0, ControlRelation.RELATION_MAX));
        this.relalist.add(new ControlRelation("setBatDischargeVol", 3, "setBatDischargeVol", 2, ControlRelation.RELATION_MAX));
    }

    @Override
    public List<ControlRelation> getRelationList() {
        return this.relalist;
    }

    @Override
    public boolean isSupportModelSetting() {
        return this.supportModelSetting;
    }

    public void setSupportModelSetting(boolean supportModelSetting) {
        this.supportModelSetting = supportModelSetting;
    }

    @Override
    public String getDSPVersion() {
        return this.dspversion;
    }

    @Override
    public String getMCUVersion() {
        return this.mcuversion;
    }

    @Override
    public SpinnerParameter getFactoryParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        if (this.modelType.equals("00")) {
            list.add(new AutoSpinnerItem("message.setGOLV[:]", "{configData.getMinGridoutputlowV}", "{configData.getMaxGridoutputlowV}", "0.1", "{configData.getGridoutputlowV}", "V", "setGOLV", 0, false));
            list.add(new AutoSpinnerItem("message.setGOHV[:]", "{configData.getMinGridoutputhighV}", "{configData.getMaxGridoutputhighV}", "0.1", "{configData.getGridoutputhighV}", "V", "setGOHV", 0, false));
            list.add(new AutoSpinnerItem("message.setGOLF[:]", "{configData.getMinGridoutputlowF}", "{configData.getMaxGridoutputlowF}", "0.1", "{configData.getGridoutputlowF}", "Hz", "setGOLF", 0, false));
            list.add(new AutoSpinnerItem("message.setGOHF[:]", "{configData.getMinGridoutputhighF}", "{configData.getMaxGridoutputhighF}", "0.1", "{configData.getGridoutputhighF}", "Hz", "setGOHF", 0, false));
            list.add(new AutoSpinnerItem("message.setGridwaittime[:]", "{configData.getMinGridWaittime}", "{configData.getMaxGridWaittime}", "1", "{configData.getGridwaittime}", "message.seconds", "setGridWaittime", 0, false));
            if (this.getMCUVersion().compareTo(VERSION_170711) >= 0) {
                list.add(new AutoSpinnerItem("message.feef-inReactivePower[:]", "{configData.getMinfeefInReactivePower}", "{configData.getMaxInReactivePower}", "1", "{configData.getFeefInReactivePower}", "Var", "setGOHF", 0, false));
            }
        } else if (this.modelType.equals("10") || this.modelType.equals("11")) {
            list.add(new AutoSpinnerItem("message.setGOLV[:]", "{configData.getMinGridInputLowV}", "{configData.getMaxGridInputLowV}", "0.1", "{configData.getGridInputLowV}", "V", "setGOLV", 0, false));
            list.add(new AutoSpinnerItem("message.setGOHV[:]", "{configData.getMinGridInputHighV}", "{configData.getMaxGridInputHighV}", "0.1", "{configData.getGridInputHighV}", "V", "setGOHV", 0, false));
            list.add(new AutoSpinnerItem("message.setGOLF[:]", "{configData.getMinGridInputLowF}", "{configData.getMaxGridInputLowF}", "0.1", "{configData.getGridInputLowF}", "Hz", "setGOLF", 0, false));
            list.add(new AutoSpinnerItem("message.setGOHF[:]", "{configData.getMinGridInputHighF}", "{configData.getMaxGridInputHighF}", "0.1", "{configData.getGridInputHighF}", "Hz", "setGOHF", 0, false));
            list.add(new AutoSpinnerItem("message.setGridwaittime[:]", "{configData.getMinGridWaittime}", "{configData.getMaxGridWaittime}", "1", "{configData.getGridwaittime}", "message.seconds", "setGridWaittime", 0, false));
            if (this.getMCUVersion().compareTo(VERSION_170711) >= 0) {
                list.add(new AutoSpinnerItem("message.feef-inReactivePower[:]", "{configData.getMinfeefInReactivePower}", "{configData.getMaxfeefInReactivePower}", "1", "{configData.getFeefInReactivePower}", "Var", "setFeefInReactivePower", 0, false));
            }
        }
        if (!this.modelType.equals("01")) {
            if (this.deviceModel.equals("100") || this.deviceModel.equals("108") || this.deviceModel.equals("050") || this.deviceModel.equals("058")) {
                list.add(new AutoSpinnerItem("message.setGILTHV[:]", "{configData.getMinGridAvgHighV}", "{configData.getMaxGridAvgHighV}", "1", "{configData.getGridAvgHighV}", "V", "setGILTHV", 0, false));
            } else if (this.deviceModel.equals("061") || this.deviceModel.equals("111")) {
                list.add(new AutoSpinnerItem("message.setGILTHV[:]", "{configData.getMinGridAvgHighV}", "{configData.getMaxGridAvgHighV}", "1", "{configData.getGridAvgHighV}", "V", "setGILTHV", 0, false));
            }
            if (this.getMCUVersion().compareTo(VERSION_170711) >= 0 && (this.deviceModel.equals("065") || this.deviceModel.equals("115") || this.deviceModel.equals("064") || this.deviceModel.equals("114") || this.deviceModel.equals("066") || this.deviceModel.equals("116") || this.deviceModel.equals("067") || this.deviceModel.equals("117") || this.deviceModel.equals("068") || this.deviceModel.equals("118") || this.deviceModel.equals("069") || this.deviceModel.equals("119"))) {
                list.add(new AutoSpinnerItem("message.setGILTHV[:]", "{configData.getMinGridAvgHighV}", "{configData.getMaxGridAvgHighV}", "1", "{configData.getGridAvgHighV}", "V", "setGILTHV", 0, false));
            }
        }
        if (!this.modelType.equals("01")) {
            list.add(new AutoSpinnerItem("message.maxPowerFeedingGrid[:]", "{configData.getMinPowerFeedGrid}", "{configData.getMaxPowerFeedGrid}", "10", "{configData.getPowerfeedGrid}", "W", "setMaxPowerFeedingGrid", 0, false));
            list.add(new AutoSpinnerItem("message.feedinPowerFactor[:]", "{configData.getMinFeedinPowerFactor}", "{configData.getMaxFeedinPowerFactor}", "0.01", "{configData.getFeedinPowerFactor}", "", "setFeedinPowerFactor", 0, false));
        }
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public List<String> spinnerValueRelate() {
        return null;
    }

    @Override
    public EnableSpinnerParameter getEnableSpinnerParameter() {
        EnableSpinnerParameter params = new EnableSpinnerParameter();
        ArrayList<EnableSpinnerItem> list = new ArrayList<EnableSpinnerItem>();
        if (this.deviceModel.equals("058") || this.deviceModel.equals("108") || this.deviceModel.equals("051") || this.deviceModel.equals("101")) {
            EnableSpinnerItem itemAAPF = new EnableSpinnerItem("message.AutoAdjustPFWithPower", "{configData.isEnabledAAPF}", "setAAPF");
            itemAAPF.setSpinnerCaptionA("message.StartPowerPercentage");
            itemAAPF.setSpinnerUnitA("%");
            itemAAPF.setSpinnerMinValueA("{configData.getMinStartPowerPercentage}");
            itemAAPF.setSpinnerMaxValueA("{configData.getMaxStartPowerPercentage}");
            itemAAPF.setSpinnerValueA("{configData.getStartPowerPercentage}");
            itemAAPF.setSpinnerStepA(1);
            itemAAPF.setSpinnerCaptionB("message.MinmumPFValue");
            itemAAPF.setSpinnerUnitB("");
            itemAAPF.setSpinnerMinValueB("{configData.getMinMinmumPFValue}");
            itemAAPF.setSpinnerMaxValueB("{configData.getMaxMinmumPFValue}");
            itemAAPF.setSpinnerValueB("{configData.getMinmumPFValue}");
            itemAAPF.setSpinnerStepB(0.01);
            list.add(itemAAPF);
        }
        params.setParameters(list);
        return params;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        return null;
    }

    @Override
    public int getOutputMode() {
        return 0;
    }

    @Override
    public void setOutputMode(int outputmode) {
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }
}

