/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.packaging.mime.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class QPEncoderStream
extends FilterOutputStream {
    private int count = 0;
    private int bytesPerLine;
    private boolean gotSpace = false;
    private boolean gotCR = false;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public QPEncoderStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.bytesPerLine = n - 1;
    }

    public QPEncoderStream(OutputStream outputStream) {
        this(outputStream, 76);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) throws IOException {
        n &= 0xFF;
        if (this.gotSpace) {
            if (n == 13 || n == 10) {
                this.output(32, true);
            } else {
                this.output(32, false);
            }
            this.gotSpace = false;
        }
        if (n == 13) {
            this.gotCR = true;
            this.outputCRLF();
        } else {
            if (n == 10) {
                if (!this.gotCR) {
                    this.outputCRLF();
                }
            } else if (n == 32) {
                this.gotSpace = true;
            } else if (n < 32 || n >= 127 || n == 61) {
                this.output(n, true);
            } else {
                this.output(n, false);
            }
            this.gotCR = false;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    private void outputCRLF() throws IOException {
        this.out.write(13);
        this.out.write(10);
        this.count = 0;
    }

    protected void output(int n, boolean bl) throws IOException {
        if (bl) {
            if ((this.count += 3) > this.bytesPerLine) {
                this.out.write(61);
                this.out.write(13);
                this.out.write(10);
                this.count = 3;
            }
            this.out.write(61);
            this.out.write(hex[n >> 4]);
            this.out.write(hex[n & 0xF]);
        } else {
            if (++this.count > this.bytesPerLine) {
                this.out.write(61);
                this.out.write(13);
                this.out.write(10);
                this.count = 1;
            }
            this.out.write(n);
        }
    }
}

