/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.dao.DeviceDao;
import cn.com.voltronic.solar.data.bean.DeviceBean;
import cn.com.voltronic.solar.data.bean.EnergyBean;
import cn.com.voltronic.solar.data.bean.Merge;
import cn.com.voltronic.solar.data.bean.MonthEnergy;
import cn.com.voltronic.solar.data.bean.YearEnergy;
import cn.com.voltronic.solar.debug.Debug;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.ExcelFileFilter;
import cn.com.voltronic.solar.view.ExcelxFileFilter;
import cn.com.voltronic.solar.view.HistoryEnergyChart;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.PDFFileFilter;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AACheckBox;
import cn.com.voltronic.solar.view.component.AAComboBox;
import cn.com.voltronic.solar.view.component.AADefaultTableModel;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.AATabbedPane;
import cn.com.voltronic.solar.view.component.ComponentFactory;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.GridBagTable;
import cn.com.voltronic.solar.view.component.I18NListener;
import cn.com.voltronic.solar.view.component.MyCalendarPanel;
import cn.com.voltronic.solar.webservice.WebServices;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.commons.lang.StringUtils;

public class HistoryEnergyDialog
extends AADialog {
    private static final long serialVersionUID = 7150098148061598284L;
    private HistoryEnergyChart chartPanel;
    private JPanel dataPanel;
    private AAButton jButton1;
    private AAButton jButton2;
    private AAButton jButton3;
    private AACheckBox excelCheckBox;
    private AAButton jButton8;
    private JComboBox jComboBox1;
    private AAComboBox jComboBox3;
    private AAComboBox jComboBox4;
    private AAComboBox jComboBox5;
    private AALabel jLabel1;
    private AALabel jLabel2;
    private AALabel jLabel3;
    private AALabel jLabel4;
    private AALabel jLabel5;
    private AALabel hourLabel;
    private AALabel jLabel8;
    private AALabel totalQuantityV;
    private AALabel totalQuantityU;
    private AALabel totalAmountLabel;
    private AALabel totalAmountV;
    private AALabel totalQuantityLabel;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JSpinner yearSpinner1;
    private JSpinner yearSpinner2;
    private JSpinner hourSpinner1;
    private JSpinner hourSpinner2;
    private GridBagTable jTable1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private AATabbedPane mainTabbedPane;
    private WebServices energyComputer = null;
    private DeviceDao deviceDao = null;
    private JFileChooser fDialog;
    private AADefaultTableModel tableModel = null;
    private List<YearEnergy> yearEnergyList = null;
    private List<MonthEnergy> monthEnergyList = null;
    private List<EnergyBean> dayEnergyList = null;
    private List<EnergyBean> hourEnergyList = null;
    private List<EnergyBean> energyBean = null;
    private final int MAX_SIZE = 27;
    private int MAX_COLUMN = 2;
    private String[] yearTitle = new String[]{"message.year", "message.datePeriod", "message.quantity", "message.electrovalence", "message.amount", "message.quantitieList", "message.amountList"};
    private String[] yearWithoutPriceTitle = new String[]{"message.year", "message.quantity"};
    private String[] monthTitle = new String[]{"message.month", "message.datePeriod", "message.quantity", "message.electrovalence", "message.amount", "message.quantitieList", "message.amountList"};
    private String[] monthWithoutPriceTitle = new String[]{"message.month", "message.quantity"};
    private String[] dayTitle = new String[]{"message.date", "message.quantity", "message.electrovalence", "message.amount"};
    private String[] dayWithoutPriceTitle = new String[]{"message.date", "message.quantity"};
    private String[] hourTitle = new String[]{"message.date", "message.hour", "message.quantity", "message.electrovalence", "message.amount"};
    private String[] hourWithoutPriceTitle = new String[]{"message.date", "message.hour", "message.quantity"};

    public HistoryEnergyDialog(Frame parent, boolean modal) {
        super(parent, modal);
        String serialno;
        this.deviceDao = new DeviceDao();
        this.energyBean = new ArrayList<EnergyBean>();
        this.yearEnergyList = new ArrayList<YearEnergy>();
        this.monthEnergyList = new ArrayList<MonthEnergy>();
        this.dayEnergyList = new ArrayList<EnergyBean>();
        this.hourEnergyList = new ArrayList<EnergyBean>();
        this.energyComputer = new WebServices();
        this.initComponents();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null && !StringUtils.isEmpty((String)(serialno = processor.getProtocol().getSerialNo().trim()))) {
            this.jComboBox1.setSelectedItem(serialno);
            this.setCycleModel(serialno);
        }
        this.setTitle("message.queryPower");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void setCycleModel(String serialno) {
        DeviceBean bean = this.deviceDao.queryDevicebySerialno(serialno);
        if (bean.getProdid().equals("P18") || bean.getProdid().equals("P1834K") || bean.getProdid().equals("P1812K")) {
            this.jComboBox3.setModel(new String[]{"message.year", "message.month", "message.day"});
            this.jComboBox3.setSelectedIndex(0);
            this.setPeriod1();
        } else {
            this.jComboBox3.setModel(new String[]{"message.year", "message.month", "message.day", "message.hour"});
            this.jComboBox3.setSelectedIndex(0);
            this.setPeriod1();
        }
    }

    private void initComponents() {
        this.mainTabbedPane = new AATabbedPane();
        this.dataPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new AALabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new AALabel();
        this.jLabel8 = new AALabel();
        this.totalQuantityV = new AALabel();
        this.totalQuantityU = new AALabel();
        this.totalAmountLabel = new AALabel();
        this.totalAmountV = new AALabel();
        this.totalQuantityLabel = new AALabel();
        this.jTextField1 = new JTextField();
        this.jLabel3 = new AALabel();
        this.jLabel4 = new AALabel();
        this.jLabel5 = new AALabel();
        this.hourLabel = new AALabel();
        this.jButton3 = new AAButton();
        this.excelCheckBox = new AACheckBox();
        this.jTextField2 = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.jButton1 = new AAButton();
        this.jButton2 = new AAButton();
        this.jButton8 = new AAButton();
        this.chartPanel = new HistoryEnergyChart();
        this.jComboBox3 = new AAComboBox();
        this.jComboBox4 = new AAComboBox();
        this.jComboBox5 = new AAComboBox();
        this.yearSpinner1 = ComponentFactory.createNumberSpinner(2010, DateUtils.getCurrentYear() + 200, 1, DateUtils.getCurrentYear());
        this.yearSpinner2 = ComponentFactory.createNumberSpinner(2010, DateUtils.getCurrentYear() + 200, 1, DateUtils.getCurrentYear());
        this.hourSpinner1 = ComponentFactory.createNumberSpinner(0, 23, 1, DateUtils.getCurrentHour());
        this.hourSpinner2 = ComponentFactory.createNumberSpinner(0, 23, 1, DateUtils.getCurrentHour());
        this.setDefaultCloseOperation(2);
        this.dataPanel.setLayout(new BorderLayout());
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("message.device[:]");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(this.queryDevices()));
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String serialno = HistoryEnergyDialog.this.jComboBox1.getSelectedItem().toString().trim();
                if (!StringUtils.isEmpty((String)serialno)) {
                    HistoryEnergyDialog.this.setCycleModel(serialno);
                }
            }
        });
        this.jComboBox3.setModel(new String[]{"message.year", "message.month", "message.day", "message.hour"});
        this.jComboBox3.setSelectedIndex(0);
        this.jComboBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryEnergyDialog.this.setPeriod1();
            }
        });
        this.jLabel2.setText("message.cycle[:]");
        this.jLabel8.setText(":");
        String[] monthArr = new String[]{"message.january", "message.february", "message.march", "message.april", "message.may", "message.june", "message.july", "message.august", "message.september", "message.october", "message.november", "message.december"};
        this.jComboBox4.setModel(monthArr);
        this.jComboBox5.setModel(monthArr);
        this.hourLabel.setText("message.hour");
        this.jLabel3.setIcon(new ImageIcon(Constants.DATE));
        this.jLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEnergyDialog.this.jTextField1);
                calendarPanel.setBounds(HistoryEnergyDialog.this.getX() + HistoryEnergyDialog.this.jLabel3.getX() + 30, HistoryEnergyDialog.this.getY() + HistoryEnergyDialog.this.jLabel3.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jTextField1.setEditable(false);
        this.jTextField1.setBackground(I18NListener.bgColor);
        this.jTextField1.setText(DateUtils.getNowDate());
        this.jTextField1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEnergyDialog.this.jTextField1);
                calendarPanel.setBounds(HistoryEnergyDialog.this.getX() + HistoryEnergyDialog.this.jLabel3.getX() + 30, HistoryEnergyDialog.this.getY() + HistoryEnergyDialog.this.jLabel3.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jLabel4.setText("--");
        this.jLabel5.setIcon(new ImageIcon(Constants.DATE));
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEnergyDialog.this.jTextField2);
                calendarPanel.setBounds(HistoryEnergyDialog.this.getX() + HistoryEnergyDialog.this.jLabel5.getX() + 30, HistoryEnergyDialog.this.getY() + HistoryEnergyDialog.this.jLabel5.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jTextField2.setEditable(false);
        this.jTextField2.setBackground(I18NListener.bgColor);
        this.jTextField2.setText(DateUtils.getNowDate());
        this.jTextField2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEnergyDialog.this.jTextField2);
                calendarPanel.setBounds(HistoryEnergyDialog.this.getX() + HistoryEnergyDialog.this.jLabel5.getX() + 30, HistoryEnergyDialog.this.getY() + HistoryEnergyDialog.this.jLabel5.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jButton3.setText("message.view");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryEnergyDialog.this.queryHistoryEnergy();
            }
        });
        this.excelCheckBox.setText("message.saveasexcel");
        this.totalQuantityLabel.setText("message.totalQuantity[:]");
        this.totalQuantityV.setText("0.0");
        this.totalQuantityU.setText("kWh");
        this.totalAmountLabel.setText("message.totalAmount[:]");
        this.totalAmountV.setText("0.0");
        String serialno = null;
        int startyear = 2011;
        int endyear = 2011;
        try {
            if (this.jComboBox3.getSelectedItem() != null) {
                serialno = this.jComboBox1.getSelectedItem().toString().trim();
            }
            startyear = VolUtil.parseInt(this.yearSpinner1.getValue().toString());
            endyear = VolUtil.parseInt(this.yearSpinner2.getValue().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.queryYearEnergy(serialno, serialno, startyear, endyear);
        }
        catch (Exception ex) {
            System.err.println("query year error");
        }
        this.setPeriod1();
        this.dataPanel.add((Component)this.jPanel3, "Center");
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jButton1.setText("message.del");
        this.jButton1.setVisible(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                HistoryEnergyDialog.this.deleteEnergys();
            }
        });
        this.jButton2.setText("message.close");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryEnergyDialog.this.dispose();
            }
        });
        this.jButton8.setText("message.saveas");
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                HistoryEnergyDialog.this.saveAs();
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.totalQuantityLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.totalQuantityV).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.totalQuantityU).addGap(18, 18, 18).addComponent(this.totalAmountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.totalAmountV).addContainerGap(300, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 320, Short.MAX_VALUE).addComponent(this.jButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addGap(12, 12, 12)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton1).addComponent(this.jButton8).addComponent(this.totalQuantityLabel).addComponent(this.totalQuantityV).addComponent(this.totalQuantityU).addComponent(this.totalAmountLabel).addComponent(this.totalAmountV)).addContainerGap()));
        this.dataPanel.add((Component)this.jPanel4, "Last");
        this.mainTabbedPane.addTab("message.dataview", this.dataPanel);
        this.chartPanel.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryEnergyDialog.this.dispose();
            }
        });
        this.mainTabbedPane.addTab("message.digram", this.chartPanel);
        this.getContentPane().add((Component)this.mainTabbedPane, "Center");
        this.pack();
    }

    private void setTotalValues() {
        this.totalAmountLabel.setVisible(false);
        this.totalAmountV.setVisible(false);
        double quantity = 0.0;
        if (this.energyBean != null) {
            int i = 0;
            while (i < this.energyBean.size()) {
                quantity += this.energyBean.get(i).getQuantity();
                ++i;
            }
        }
        this.totalQuantityV.setText(String.valueOf(NumberFormat.getInstance().format(VolUtil.round(quantity, 3))));
    }

    private void setYearTotalValues() {
        this.totalAmountLabel.setVisible(true);
        this.totalAmountV.setVisible(true);
        double quantity = 0.0;
        double amount = 0.0;
        if (this.yearEnergyList != null) {
            int i = 0;
            while (i < this.yearEnergyList.size()) {
                quantity += this.yearEnergyList.get(i).getQuantity();
                amount += this.yearEnergyList.get(i).getAmount();
                ++i;
            }
        }
        this.totalQuantityV.setText(String.valueOf(NumberFormat.getInstance().format(VolUtil.round(quantity, 3))));
        this.totalAmountV.setText(String.valueOf(NumberFormat.getInstance().format(VolUtil.round(amount, 3))));
    }

    private void setMonthTotalValues() {
        this.totalAmountLabel.setVisible(true);
        this.totalAmountV.setVisible(true);
        double quantity = 0.0;
        double amount = 0.0;
        if (this.monthEnergyList != null) {
            int i = 0;
            while (i < this.monthEnergyList.size()) {
                quantity += this.monthEnergyList.get(i).getQuantity();
                amount += this.monthEnergyList.get(i).getAmount();
                ++i;
            }
        }
        this.totalQuantityV.setText(String.valueOf(NumberFormat.getInstance().format(VolUtil.round(quantity, 3))));
        this.totalAmountV.setText(String.valueOf(NumberFormat.getInstance().format(VolUtil.round(amount, 3))));
    }

    private void setDayTotalValues() {
        this.totalAmountLabel.setVisible(true);
        this.totalAmountV.setVisible(true);
        double quantity = 0.0;
        double amount = 0.0;
        if (this.dayEnergyList != null) {
            int i = 0;
            while (i < this.dayEnergyList.size()) {
                quantity += this.dayEnergyList.get(i).getQuantity();
                amount += this.dayEnergyList.get(i).getAmount();
                ++i;
            }
        }
        this.totalQuantityV.setText(String.valueOf(NumberFormat.getInstance().format(VolUtil.round(quantity, 3))));
        this.totalAmountV.setText(String.valueOf(NumberFormat.getInstance().format(VolUtil.round(amount, 3))));
    }

    private void setHourTotalValues() {
        this.totalAmountLabel.setVisible(true);
        this.totalAmountV.setVisible(true);
        double quantity = 0.0;
        double amount = 0.0;
        if (this.hourEnergyList != null) {
            int i = 0;
            while (i < this.hourEnergyList.size()) {
                quantity += this.hourEnergyList.get(i).getQuantity();
                amount += this.hourEnergyList.get(i).getAmount();
                ++i;
            }
        }
        this.totalQuantityV.setText(String.valueOf(NumberFormat.getInstance().format(VolUtil.round(quantity, 3))));
        this.totalAmountV.setText(String.valueOf(NumberFormat.getInstance().format(VolUtil.round(amount, 3))));
    }

    private void queryYearEnergy(String processorKey, String serialno, int startyear, int endyear) throws Exception {
        if (this.jTable1 != null) {
            this.jTable1.removeAll();
            this.jScrollPane1.remove(this.jTable1);
        }
        this.MAX_COLUMN = 2;
        this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.yearWithoutPriceTitle){
            private static final long serialVersionUID = -4444769250474742659L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTable1 = new GridBagTable(this.tableModel){
            private static final long serialVersionUID = 8435740443994560845L;

            @Override
            public boolean isCellSelected(int row, int column) {
                if (row >= HistoryEnergyDialog.this.yearEnergyList.size()) {
                    return false;
                }
                return super.isCellSelected(row, column);
            }
        };
        if (!"".equals(serialno) && serialno != null) {
            DeviceBean bean = this.deviceDao.queryDevicebySerialno(serialno);
            String prodid = bean.getProdid();
            if (prodid.equals("P15") || prodid.equals("P20")) {
                try {
                    this.yearEnergyList = this.energyComputer.queryYearwithPriceView(processorKey, serialno, startyear, endyear);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.jTable1 != null) {
                    this.jTable1.removeAll();
                }
                this.MAX_COLUMN = 7;
                this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.yearTitle){
                    private static final long serialVersionUID = -5941593256117750312L;

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                this.jTable1 = new GridBagTable(this.tableModel){
                    private static final long serialVersionUID = 8235740443994560845L;

                    @Override
                    public boolean isCellSelected(int row, int column) {
                        if (row >= HistoryEnergyDialog.this.yearEnergyList.size()) {
                            return false;
                        }
                        return super.isCellSelected(row, column);
                    }
                };
                this.tableModel.setColumnIdentifiers(this.yearTitle);
                int size = this.yearEnergyList.size();
                if (size < 27) {
                    size = 27;
                }
                Object[][] obj = new Object[size][this.MAX_COLUMN];
                int oldyear = 0;
                int start = 0;
                int end = 0;
                ArrayList<Merge> list = new ArrayList<Merge>();
                int i = 0;
                while (i < this.yearEnergyList.size()) {
                    int year = this.yearEnergyList.get(i).getYear();
                    if (year == oldyear) {
                        end = i;
                        list.add(new Merge(start, end));
                    } else {
                        start = i;
                        oldyear = year;
                    }
                    obj[i][0] = this.yearEnergyList.get(i).getYear();
                    obj[i][1] = this.yearEnergyList.get(i).getDateperiod();
                    obj[i][2] = NumberFormat.getInstance().format(this.yearEnergyList.get(i).getQuantity());
                    obj[i][3] = NumberFormat.getInstance().format(this.yearEnergyList.get(i).getPrice());
                    obj[i][4] = NumberFormat.getInstance().format(this.yearEnergyList.get(i).getAmount());
                    double totalQuan = this.yearEnergyList.get(i).getTotalQuantity();
                    String totalQuanStr = "0.0";
                    if (totalQuan > 0.0) {
                        totalQuanStr = String.valueOf(NumberFormat.getInstance().format(VolUtil.round(totalQuan, 3)));
                    }
                    obj[i][5] = totalQuanStr;
                    double totalAmont = this.yearEnergyList.get(i).getTotalAmount();
                    String totalAmontStr = "0.0";
                    if (totalAmont > 0.0) {
                        totalAmontStr = String.valueOf(NumberFormat.getInstance().format(VolUtil.round(totalAmont, 3)));
                    }
                    obj[i][6] = totalAmontStr;
                    ++i;
                }
                int k = 0;
                while (k < list.size()) {
                    this.jTable1.mergeCells(((Merge)list.get(k)).getStart(), ((Merge)list.get(k)).getEnd(), 0, 0);
                    this.jTable1.mergeCells(((Merge)list.get(k)).getStart(), ((Merge)list.get(k)).getEnd(), 5, 5);
                    this.jTable1.mergeCells(((Merge)list.get(k)).getStart(), ((Merge)list.get(k)).getEnd(), 6, 6);
                    ++k;
                }
                if (this.yearEnergyList.size() < 27) {
                    i = this.yearEnergyList.size();
                    while (i < 27) {
                        int j = 0;
                        while (j < this.MAX_COLUMN) {
                            obj[i][j] = null;
                            ++j;
                        }
                        ++i;
                    }
                }
                this.tableModel.setDataVector(obj, this.yearTitle);
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn t0 = this.jTable1.getColumnModel().getColumn(0);
                t0.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn t1 = this.jTable1.getColumnModel().getColumn(1);
                t1.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t2 = this.jTable1.getColumnModel().getColumn(2);
                t2.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t3 = this.jTable1.getColumnModel().getColumn(3);
                t3.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t4 = this.jTable1.getColumnModel().getColumn(4);
                t4.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t5 = this.jTable1.getColumnModel().getColumn(5);
                t5.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t6 = this.jTable1.getColumnModel().getColumn(6);
                t6.setCellRenderer(renderer);
                this.setYearTotalValues();
            } else {
                this.energyBean = prodid.equals("P1730K") ? this.energyComputer.queryYearwithoutPriceForP1730K(processorKey, serialno, startyear, endyear, true) : this.energyComputer.queryYearwithoutPrice(processorKey, serialno, startyear, endyear, true);
                if (this.jTable1 != null) {
                    this.jTable1.removeAll();
                }
                this.MAX_COLUMN = 2;
                this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.yearWithoutPriceTitle){
                    private static final long serialVersionUID = 2394034720139767988L;

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                this.jTable1 = new GridBagTable(this.tableModel){
                    private static final long serialVersionUID = 8435740443994560845L;

                    @Override
                    public boolean isCellSelected(int row, int column) {
                        if (row >= HistoryEnergyDialog.this.energyBean.size()) {
                            return false;
                        }
                        return super.isCellSelected(row, column);
                    }
                };
                this.tableModel.setColumnIdentifiers(this.yearWithoutPriceTitle);
                int size = this.energyBean.size();
                if (size < 27) {
                    size = 27;
                }
                Object[][] obj = new Object[size][this.MAX_COLUMN];
                int i = 0;
                while (i < this.energyBean.size()) {
                    obj[i][0] = this.energyBean.get(i).getYear();
                    obj[i][1] = NumberFormat.getInstance().format(this.energyBean.get(i).getQuantity());
                    ++i;
                }
                if (this.energyBean.size() < 27) {
                    i = this.energyBean.size();
                    while (i < 27) {
                        int j = 0;
                        while (j < this.MAX_COLUMN) {
                            obj[i][j] = null;
                            ++j;
                        }
                        ++i;
                    }
                }
                this.tableModel.setDataVector(obj, this.yearWithoutPriceTitle);
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn tc0 = this.jTable1.getColumnModel().getColumn(0);
                tc0.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn tc1 = this.jTable1.getColumnModel().getColumn(1);
                tc1.setCellRenderer(renderer);
                this.setTotalValues();
            }
        }
        this.jScrollPane1.setViewportView(this.jTable1);
    }

    private void queryMonthEnergy(String processorKey, String serialno, int startyear, int startmonth, int endyear, int endmonth) throws Exception {
        if (this.jTable1 != null) {
            this.jTable1.removeAll();
            this.jScrollPane1.remove(this.jTable1);
        }
        this.MAX_COLUMN = 2;
        this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.monthWithoutPriceTitle){
            private static final long serialVersionUID = -3552663590977608178L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTable1 = new GridBagTable(this.tableModel){
            private static final long serialVersionUID = 6113931257711952392L;

            @Override
            public boolean isCellSelected(int row, int column) {
                if (row >= HistoryEnergyDialog.this.monthEnergyList.size()) {
                    return false;
                }
                return super.isCellSelected(row, column);
            }
        };
        if (!"".equals(serialno) && serialno != null) {
            DeviceBean bean = this.deviceDao.queryDevicebySerialno(serialno);
            String prodid = bean.getProdid();
            if (prodid.equals("P15") || prodid.equals("P20")) {
                if (this.jTable1 != null) {
                    this.jTable1.removeAll();
                    this.jScrollPane1.remove(this.jTable1);
                }
                this.MAX_COLUMN = 7;
                this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.monthTitle){
                    private static final long serialVersionUID = -5941593256113750362L;

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                this.jTable1 = new GridBagTable(this.tableModel){
                    private static final long serialVersionUID = -3082938225283163277L;

                    @Override
                    public boolean isCellSelected(int row, int column) {
                        if (row >= HistoryEnergyDialog.this.monthEnergyList.size()) {
                            return false;
                        }
                        return super.isCellSelected(row, column);
                    }
                };
                this.tableModel.setColumnIdentifiers(this.monthTitle);
                this.monthEnergyList = this.energyComputer.queryMonthwithPriceView(processorKey, serialno, startyear, startmonth, endyear, endmonth);
                int size = this.monthEnergyList.size();
                if (size < 27) {
                    size = 27;
                }
                Object[][] obj = new Object[size][this.MAX_COLUMN];
                String oldyearmonth = "";
                int start = 0;
                int end = 0;
                ArrayList<Merge> list = new ArrayList<Merge>();
                int i = 0;
                while (i < this.monthEnergyList.size()) {
                    String yearmonth = this.monthEnergyList.get(i).getYearmonth();
                    if (oldyearmonth.equals(yearmonth)) {
                        end = i;
                        list.add(new Merge(start, end));
                    } else {
                        start = i;
                        oldyearmonth = yearmonth;
                    }
                    obj[i][0] = this.monthEnergyList.get(i).getYearmonth();
                    obj[i][1] = this.monthEnergyList.get(i).getDateperiod();
                    obj[i][2] = NumberFormat.getInstance().format(this.monthEnergyList.get(i).getQuantity());
                    obj[i][3] = NumberFormat.getInstance().format(this.monthEnergyList.get(i).getPrice());
                    obj[i][4] = NumberFormat.getInstance().format(this.monthEnergyList.get(i).getAmount());
                    double totalQuan = this.monthEnergyList.get(i).getTotalQuantity();
                    String totalQuanStr = "0.0";
                    if (totalQuan > 0.0) {
                        totalQuanStr = String.valueOf(NumberFormat.getInstance().format(VolUtil.round(totalQuan, 3)));
                    }
                    obj[i][5] = totalQuanStr;
                    double totalAmont = this.monthEnergyList.get(i).getTotalAmount();
                    String totalAmontStr = "0.0";
                    if (totalAmont > 0.0) {
                        totalAmontStr = String.valueOf(NumberFormat.getInstance().format(VolUtil.round(totalAmont, 3)));
                    }
                    obj[i][6] = totalAmontStr;
                    ++i;
                }
                int k = 0;
                while (k < list.size()) {
                    this.jTable1.mergeCells(((Merge)list.get(k)).getStart(), ((Merge)list.get(k)).getEnd(), 0, 0);
                    this.jTable1.mergeCells(((Merge)list.get(k)).getStart(), ((Merge)list.get(k)).getEnd(), 5, 5);
                    this.jTable1.mergeCells(((Merge)list.get(k)).getStart(), ((Merge)list.get(k)).getEnd(), 6, 6);
                    ++k;
                }
                if (this.monthEnergyList.size() < 27) {
                    i = this.monthEnergyList.size();
                    while (i < 27) {
                        int j = 0;
                        while (j < this.MAX_COLUMN) {
                            obj[i][j] = null;
                            ++j;
                        }
                        ++i;
                    }
                }
                this.tableModel.setDataVector(obj, this.monthTitle);
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn t0 = this.jTable1.getColumnModel().getColumn(0);
                t0.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn t1 = this.jTable1.getColumnModel().getColumn(1);
                t1.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t2 = this.jTable1.getColumnModel().getColumn(2);
                t2.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t3 = this.jTable1.getColumnModel().getColumn(3);
                t3.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t4 = this.jTable1.getColumnModel().getColumn(4);
                t4.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t5 = this.jTable1.getColumnModel().getColumn(5);
                t5.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t6 = this.jTable1.getColumnModel().getColumn(6);
                t6.setCellRenderer(renderer);
                this.setMonthTotalValues();
            } else {
                if (this.jTable1 != null) {
                    this.jTable1.removeAll();
                    this.jScrollPane1.remove(this.jTable1);
                }
                this.MAX_COLUMN = 2;
                this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.monthWithoutPriceTitle){
                    private static final long serialVersionUID = -5941593276117750362L;

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                this.jTable1 = new GridBagTable(this.tableModel){
                    private static final long serialVersionUID = -3082818225183165277L;

                    @Override
                    public boolean isCellSelected(int row, int column) {
                        if (row >= HistoryEnergyDialog.this.energyBean.size()) {
                            return false;
                        }
                        return super.isCellSelected(row, column);
                    }
                };
                this.tableModel.setColumnIdentifiers(this.monthWithoutPriceTitle);
                this.energyBean = prodid.equals("P1730K") ? this.energyComputer.queryMonthwithoutPriceForP1730K(processorKey, serialno, startyear, startmonth, endyear, endmonth, true) : this.energyComputer.queryMonthwithoutPrice(processorKey, serialno, startyear, startmonth, endyear, endmonth, true);
                int size = this.energyBean.size();
                if (size < 27) {
                    size = 27;
                }
                Object[][] obj = new Object[size][this.MAX_COLUMN];
                int i = 0;
                while (i < this.energyBean.size()) {
                    obj[i][0] = this.energyBean.get(i).getYearmonth();
                    obj[i][1] = NumberFormat.getInstance().format(this.energyBean.get(i).getQuantity());
                    ++i;
                }
                if (this.energyBean.size() < 27) {
                    i = this.energyBean.size();
                    while (i < 27) {
                        int j = 0;
                        while (j < this.MAX_COLUMN) {
                            obj[i][j] = null;
                            ++j;
                        }
                        ++i;
                    }
                }
                this.tableModel.setDataVector(obj, this.monthWithoutPriceTitle);
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn tc0 = this.jTable1.getColumnModel().getColumn(0);
                tc0.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn tc1 = this.jTable1.getColumnModel().getColumn(1);
                tc1.setCellRenderer(renderer);
                this.setTotalValues();
            }
            this.jScrollPane1.setViewportView(this.jTable1);
        }
    }

    private void queryDayEnergy(String processorKey, String serialno, Calendar startdate, Calendar enddate) throws Exception {
        if (this.jTable1 != null) {
            this.jTable1.removeAll();
            this.jScrollPane1.remove(this.jTable1);
        }
        this.MAX_COLUMN = 2;
        this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.dayWithoutPriceTitle){
            private static final long serialVersionUID = -4711121114560655760L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTable1 = new GridBagTable(this.tableModel){
            private static final long serialVersionUID = -3082938225183163277L;

            @Override
            public boolean isCellSelected(int row, int column) {
                if (row >= HistoryEnergyDialog.this.dayEnergyList.size()) {
                    return false;
                }
                return super.isCellSelected(row, column);
            }
        };
        if (!"".equals(serialno) && serialno != null) {
            DeviceBean bean = this.deviceDao.queryDevicebySerialno(serialno);
            String prodid = bean.getProdid();
            if (prodid.equals("P15") || prodid.equals("P20")) {
                if (this.jTable1 != null) {
                    this.jTable1.removeAll();
                    this.jScrollPane1.remove(this.jTable1);
                }
                this.MAX_COLUMN = 4;
                this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.dayTitle){
                    private static final long serialVersionUID = -5941593256117750362L;

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                this.jTable1 = new GridBagTable(this.tableModel){
                    private static final long serialVersionUID = -3082938225183163277L;

                    @Override
                    public boolean isCellSelected(int row, int column) {
                        if (row >= HistoryEnergyDialog.this.dayEnergyList.size()) {
                            return false;
                        }
                        return super.isCellSelected(row, column);
                    }
                };
                this.tableModel.setColumnIdentifiers(this.dayTitle);
                this.dayEnergyList = this.energyComputer.queryDaywithPrice(processorKey, serialno, startdate, enddate);
                int size = this.dayEnergyList.size();
                if (size < 27) {
                    size = 27;
                }
                Object[][] obj = new Object[size][this.MAX_COLUMN];
                int i = 0;
                while (i < this.dayEnergyList.size()) {
                    obj[i][0] = DateUtils.getFormatDate(this.dayEnergyList.get(i).getTrandate().getTime());
                    obj[i][1] = NumberFormat.getInstance().format(this.dayEnergyList.get(i).getQuantity());
                    obj[i][2] = NumberFormat.getInstance().format(this.dayEnergyList.get(i).getPrice());
                    obj[i][3] = NumberFormat.getInstance().format(this.dayEnergyList.get(i).getAmount());
                    ++i;
                }
                if (this.dayEnergyList.size() < 27) {
                    i = this.dayEnergyList.size();
                    while (i < 27) {
                        int j = 0;
                        while (j < this.MAX_COLUMN) {
                            obj[i][j] = null;
                            ++j;
                        }
                        ++i;
                    }
                }
                this.tableModel.setDataVector(obj, this.dayTitle);
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn t0 = this.jTable1.getColumnModel().getColumn(0);
                t0.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t1 = this.jTable1.getColumnModel().getColumn(1);
                t1.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t2 = this.jTable1.getColumnModel().getColumn(2);
                t2.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t3 = this.jTable1.getColumnModel().getColumn(3);
                t3.setCellRenderer(renderer);
                this.setDayTotalValues();
            } else {
                if (this.jTable1 != null) {
                    this.jTable1.removeAll();
                    this.jScrollPane1.remove(this.jTable1);
                }
                this.MAX_COLUMN = 2;
                this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.dayWithoutPriceTitle){
                    private static final long serialVersionUID = -5941593256117750362L;

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                this.jTable1 = new GridBagTable(this.tableModel){
                    private static final long serialVersionUID = -3082938225183163277L;

                    @Override
                    public boolean isCellSelected(int row, int column) {
                        if (row >= HistoryEnergyDialog.this.energyBean.size()) {
                            return false;
                        }
                        return super.isCellSelected(row, column);
                    }
                };
                this.tableModel.setColumnIdentifiers(this.dayWithoutPriceTitle);
                this.energyBean = prodid.equals("P1730K") ? this.energyComputer.queryDaywithoutPriceForP1730K(processorKey, serialno, startdate, enddate, true) : this.energyComputer.queryDaywithoutPrice(processorKey, serialno, startdate, enddate, true);
                int size = this.energyBean.size();
                if (size < 27) {
                    size = 27;
                }
                Object[][] obj = new Object[size][this.MAX_COLUMN];
                int i = 0;
                while (i < this.energyBean.size()) {
                    obj[i][0] = DateUtils.getFormatDate(this.energyBean.get(i).getTrandate().getTime());
                    obj[i][1] = NumberFormat.getInstance().format(this.energyBean.get(i).getQuantity());
                    ++i;
                }
                if (this.energyBean.size() < 27) {
                    i = this.energyBean.size();
                    while (i < 27) {
                        int j = 0;
                        while (j < this.MAX_COLUMN) {
                            obj[i][j] = null;
                            ++j;
                        }
                        ++i;
                    }
                }
                this.tableModel.setDataVector(obj, this.dayWithoutPriceTitle);
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn tc0 = this.jTable1.getColumnModel().getColumn(0);
                tc0.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn tc1 = this.jTable1.getColumnModel().getColumn(1);
                tc1.setCellRenderer(renderer);
                this.setTotalValues();
            }
        }
        this.jScrollPane1.setViewportView(this.jTable1);
    }

    private void queryHourEnergy(String processorKey, String serialno, Calendar startdate, int starthour, Calendar enddate, int endhour) throws Exception {
        if (this.jTable1 != null) {
            this.jTable1.removeAll();
            this.jScrollPane1.remove(this.jTable1);
        }
        this.MAX_COLUMN = 3;
        this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.hourWithoutPriceTitle){
            private static final long serialVersionUID = -7623517732859696766L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTable1 = new GridBagTable(this.tableModel){
            private static final long serialVersionUID = -8169861173234420041L;

            @Override
            public boolean isCellSelected(int row, int column) {
                if (row >= HistoryEnergyDialog.this.hourEnergyList.size()) {
                    return false;
                }
                return super.isCellSelected(row, column);
            }
        };
        if (!"".equals(serialno) && serialno != null) {
            DeviceBean bean = this.deviceDao.queryDevicebySerialno(serialno);
            String prodid = bean.getProdid();
            if (prodid.equals("P16") || prodid.equals("P17") || prodid.equals("P175K") || prodid.equals("P17P1S1") || prodid.equals("P1730K")) {
                if (this.jTable1 != null) {
                    this.jTable1.removeAll();
                    this.jScrollPane1.remove(this.jTable1);
                }
                this.MAX_COLUMN = 3;
                this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.hourWithoutPriceTitle){
                    private static final long serialVersionUID = -110569132212046870L;

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                this.jTable1 = new GridBagTable(this.tableModel){
                    private static final long serialVersionUID = -3723154360216690419L;

                    @Override
                    public boolean isCellSelected(int row, int column) {
                        if (row >= HistoryEnergyDialog.this.energyBean.size()) {
                            return false;
                        }
                        return super.isCellSelected(row, column);
                    }
                };
                this.tableModel.setColumnIdentifiers(this.hourWithoutPriceTitle);
                this.energyBean = this.energyComputer.queryHourwithoutPrice(processorKey, serialno, startdate, starthour, enddate, endhour, true);
                int size = this.energyBean.size();
                if (size < 27) {
                    size = 27;
                }
                Object[][] obj = new Object[size][this.MAX_COLUMN];
                int i = 0;
                while (i < this.energyBean.size()) {
                    obj[i][0] = DateUtils.getFormatDate(this.energyBean.get(i).getTrandate().getTime());
                    obj[i][1] = this.energyBean.get(i).getHour();
                    obj[i][2] = NumberFormat.getInstance().format(this.energyBean.get(i).getQuantity());
                    ++i;
                }
                if (this.energyBean.size() < 27) {
                    i = this.energyBean.size();
                    while (i < 27) {
                        int j = 0;
                        while (j < this.MAX_COLUMN) {
                            obj[i][j] = null;
                            ++j;
                        }
                        ++i;
                    }
                }
                this.tableModel.setDataVector(obj, this.hourWithoutPriceTitle);
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn tc0 = this.jTable1.getColumnModel().getColumn(0);
                tc0.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn tc1 = this.jTable1.getColumnModel().getColumn(1);
                tc1.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn tc2 = this.jTable1.getColumnModel().getColumn(2);
                tc2.setCellRenderer(renderer);
                this.setTotalValues();
            } else if (prodid.equals("P15") || prodid.equals("P20")) {
                if (this.jTable1 != null) {
                    this.jTable1.removeAll();
                    this.jScrollPane1.remove(this.jTable1);
                }
                this.MAX_COLUMN = 5;
                this.tableModel = new AADefaultTableModel(new Object[27][this.MAX_COLUMN], this.hourTitle){
                    private static final long serialVersionUID = -110569132412046870L;

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                this.jTable1 = new GridBagTable(this.tableModel){
                    private static final long serialVersionUID = -3723234360216690419L;

                    @Override
                    public boolean isCellSelected(int row, int column) {
                        if (row >= HistoryEnergyDialog.this.hourEnergyList.size()) {
                            return false;
                        }
                        return super.isCellSelected(row, column);
                    }
                };
                this.tableModel.setColumnIdentifiers(this.hourTitle);
                this.hourEnergyList = this.energyComputer.queryHourwithPrice(processorKey, serialno, startdate, starthour, enddate, endhour);
                int size = this.hourEnergyList.size();
                if (size < 27) {
                    size = 27;
                }
                Object[][] obj = new Object[size][this.MAX_COLUMN];
                int i = 0;
                while (i < this.hourEnergyList.size()) {
                    obj[i][0] = DateUtils.getFormatDate(this.hourEnergyList.get(i).getTrandate().getTime());
                    obj[i][1] = this.hourEnergyList.get(i).getHour();
                    obj[i][2] = NumberFormat.getInstance().format(this.hourEnergyList.get(i).getQuantity());
                    obj[i][3] = NumberFormat.getInstance().format(this.hourEnergyList.get(i).getPrice());
                    obj[i][4] = NumberFormat.getInstance().format(this.hourEnergyList.get(i).getAmount());
                    ++i;
                }
                if (this.hourEnergyList.size() < 27) {
                    i = this.hourEnergyList.size();
                    while (i < 27) {
                        int j = 0;
                        while (j < this.MAX_COLUMN) {
                            obj[i][j] = null;
                            ++j;
                        }
                        ++i;
                    }
                }
                this.tableModel.setDataVector(obj, this.hourTitle);
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn t0 = this.jTable1.getColumnModel().getColumn(0);
                t0.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(0);
                TableColumn t1 = this.jTable1.getColumnModel().getColumn(1);
                t1.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t2 = this.jTable1.getColumnModel().getColumn(2);
                t2.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t3 = this.jTable1.getColumnModel().getColumn(3);
                t3.setCellRenderer(renderer);
                renderer = new DefaultTableCellRenderer();
                renderer.setHorizontalAlignment(4);
                TableColumn t4 = this.jTable1.getColumnModel().getColumn(4);
                t4.setCellRenderer(renderer);
                this.setHourTotalValues();
            }
        }
        this.jScrollPane1.setViewportView(this.jTable1);
    }

    public void queryHistoryEnergy() {
        if (this.jComboBox1.getSelectedItem() != null) {
            String serialno = this.jComboBox1.getSelectedItem().toString().trim();
            int startyear = VolUtil.parseInt(this.yearSpinner1.getValue().toString());
            int endyear = VolUtil.parseInt(this.yearSpinner2.getValue().toString());
            int starthour = VolUtil.parseInt(this.hourSpinner1.getValue().toString());
            int endhour = VolUtil.parseInt(this.hourSpinner2.getValue().toString());
            String startDate = this.jTextField1.getText().trim();
            String endDate = this.jTextField2.getText().trim();
            int startmonth = this.jComboBox4.getSelectedIndex() + 1;
            int endmonth = this.jComboBox5.getSelectedIndex() + 1;
            SimpleDateFormat format = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
            Date fromDate = new Date();
            Date toDate = new Date();
            try {
                fromDate = format.parse(startDate);
                toDate = format.parse(endDate);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Calendar startdate = Calendar.getInstance();
            startdate.setTime(fromDate);
            Calendar enddate = Calendar.getInstance();
            enddate.setTime(toDate);
            this.jTable1.clearMergence();
            this.totalQuantityV.setText("0.0");
            this.totalAmountV.setText("0.0");
            try {
                if (this.jComboBox3.getSelectedIndex() == 0) {
                    this.queryYearEnergy(serialno, serialno, startyear, endyear);
                } else if (this.jComboBox3.getSelectedIndex() == 1) {
                    this.queryMonthEnergy(serialno, serialno, startyear, startmonth, startyear, endmonth);
                } else if (this.jComboBox3.getSelectedIndex() == 2) {
                    this.queryDayEnergy(serialno, serialno, startdate, enddate);
                } else if (this.jComboBox3.getSelectedIndex() == 3) {
                    this.queryHourEnergy(serialno, serialno, startdate, starthour, (Calendar)startdate.clone(), endhour);
                }
            }
            catch (Exception ex) {
                System.err.println("query error");
            }
        }
    }

    public void setTableFormate() {
        TableColumnModel tcm = this.jTable1.getColumnModel();
        TableColumn tc0 = tcm.getColumn(0);
        TableColumn tc1 = tcm.getColumn(1);
        TableColumn tc2 = tcm.getColumn(2);
        TableColumn tc3 = tcm.getColumn(3);
        tc0.setPreferredWidth(30);
        tc1.setPreferredWidth(30);
        tc2.setPreferredWidth(100);
        tc3.setPreferredWidth(250);
    }

    public String[] queryDevices() {
        List<String> devicelist = this.deviceDao.querySerialnoAll();
        String[] devices = new String[devicelist.size()];
        int i = 0;
        while (i < devicelist.size()) {
            devices[i] = devicelist.get(i);
            ++i;
        }
        return devices;
    }

    public void deleteEnergys() {
        block32: {
            if (this.jComboBox1.getSelectedItem() == null) break block32;
            String serialno = this.jComboBox1.getSelectedItem().toString().trim();
            int re = DisplayMessage.showConfirmDialog("message.deleteConfirm", "message.info");
            if (re == 0) {
                WebServices webService = new WebServices();
                if (this.jComboBox3.getSelectedIndex() == 0) {
                    boolean result = false;
                    if (result) {
                        this.queryHistoryEnergy();
                    } else {
                        DisplayMessage.showErrorDialog("message.operationfailure");
                    }
                } else if (this.jComboBox3.getSelectedIndex() == 1) {
                    boolean result = false;
                    int row = this.jTable1.getSelectedRow();
                    int column = this.jTable1.getSelectedColumn();
                    Object obj = null;
                    try {
                        obj = this.tableModel.getValueAt(row, column);
                    }
                    catch (Exception ex) {
                        obj = null;
                        row = -1;
                    }
                    if (obj == null) {
                        row = -1;
                    }
                    if (row == -1) {
                        DisplayMessage.showErrorDialog("message.pleaseselect");
                        return;
                    }
                    int[] rows = this.jTable1.getSelectedRows();
                    int k = 0;
                    while (k < rows.length) {
                        Object yearmonth = this.tableModel.getValueAt(rows[k], 0);
                        MonthEnergy monthEnergy = new MonthEnergy();
                        monthEnergy.setYearmonth(yearmonth.toString());
                        result = webService.deleteMonth("", serialno, monthEnergy);
                        if (!result) {
                            DisplayMessage.showErrorDialog("message.operationfailure");
                            break;
                        }
                        this.queryHistoryEnergy();
                        ++k;
                    }
                } else if (this.jComboBox3.getSelectedIndex() == 2) {
                    boolean result = false;
                    int row = this.jTable1.getSelectedRow();
                    int column = this.jTable1.getSelectedColumn();
                    Object obj = null;
                    try {
                        obj = this.tableModel.getValueAt(row, column);
                    }
                    catch (Exception ex) {
                        obj = null;
                        row = -1;
                    }
                    if (obj == null) {
                        row = -1;
                    }
                    if (row == -1) {
                        DisplayMessage.showErrorDialog("message.pleaseselect");
                        return;
                    }
                    int[] rows = this.jTable1.getSelectedRows();
                    int k = 0;
                    while (k < rows.length) {
                        block33: {
                            String source = this.tableModel.getValueAt(rows[k], 0).toString();
                            SimpleDateFormat sdf = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
                            Date trandate = new Date();
                            try {
                                trandate = sdf.parse(source);
                                Calendar calendar = Calendar.getInstance();
                                calendar.setTime(trandate);
                                EnergyBean bean = new EnergyBean();
                                bean.setTrandate(calendar);
                                result = webService.deleteDay("", serialno, bean);
                                if (result) {
                                    this.queryHistoryEnergy();
                                    break block33;
                                }
                                DisplayMessage.showErrorDialog("message.operationfailure");
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                DisplayMessage.showErrorDialog("message.operationfailure");
                            }
                            break;
                        }
                        ++k;
                    }
                } else if (this.jComboBox3.getSelectedIndex() == 3) {
                    boolean result = false;
                    int row = this.jTable1.getSelectedRow();
                    int column = this.jTable1.getSelectedColumn();
                    Object obj = null;
                    try {
                        obj = this.tableModel.getValueAt(row, column);
                    }
                    catch (Exception ex) {
                        obj = null;
                        row = -1;
                    }
                    if (obj == null) {
                        row = -1;
                    }
                    if (row == -1) {
                        DisplayMessage.showErrorDialog("message.pleaseselect");
                        return;
                    }
                    int[] rows = this.jTable1.getSelectedRows();
                    int k = 0;
                    while (k < rows.length) {
                        block34: {
                            String source = this.tableModel.getValueAt(rows[k], 0).toString();
                            int hour = Integer.parseInt(this.tableModel.getValueAt(rows[k], 1).toString());
                            SimpleDateFormat sdf = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
                            Date trandate = new Date();
                            try {
                                trandate = sdf.parse(source);
                                Calendar calendar = Calendar.getInstance();
                                calendar.setTime(trandate);
                                EnergyBean bean = new EnergyBean();
                                bean.setTrandate(calendar);
                                bean.setHour(hour);
                                result = webService.deleteHour("", serialno, bean);
                                if (result) {
                                    this.queryHistoryEnergy();
                                    break block34;
                                }
                                DisplayMessage.showErrorDialog("message.operationfailure");
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                DisplayMessage.showErrorDialog("message.operationfailure");
                            }
                            break;
                        }
                        ++k;
                    }
                }
            }
        }
    }

    public int getSaveDialog() {
        Date date = new Date();
        String saveFileName = DateUtils.getFormatDate(date, "yyyyMMddHHmmss");
        this.fDialog = new JFileChooser();
        if (this.excelCheckBox.isSelected()) {
            saveFileName = String.valueOf(saveFileName) + ".xls";
            ExcelFileFilter xls = new ExcelFileFilter();
            this.fDialog.addChoosableFileFilter(xls);
            ExcelxFileFilter xlsx = new ExcelxFileFilter();
            this.fDialog.setFileFilter(xlsx);
        } else {
            saveFileName = String.valueOf(saveFileName) + ".pdf";
            PDFFileFilter txtFilter = new PDFFileFilter();
            this.fDialog.addChoosableFileFilter(txtFilter);
            this.fDialog.setFileFilter(txtFilter);
        }
        this.fDialog.setAcceptAllFileFilterUsed(true);
        this.fDialog.setSelectedFile(new File(saveFileName));
        return this.fDialog.showSaveDialog(this);
    }

    public void saveAs() {
        int result = this.getSaveDialog();
        if (result == 0) {
            String filepathStr = this.fDialog.getSelectedFile().getPath();
            File newFile = new File(filepathStr);
            if (newFile.exists()) {
                int re = DisplayMessage.showConfirmDialog("message.confirmoverwrite", "message.info");
                if (re == 0) {
                    if (this.excelCheckBox.isSelected()) {
                        this.createExcel(newFile);
                    } else {
                        this.createPdf(filepathStr);
                    }
                } else {
                    this.saveAs();
                }
            } else {
                try {
                    newFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.excelCheckBox.isSelected()) {
                    this.createExcel(newFile);
                } else {
                    this.createPdf(filepathStr);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createPdf(String path) {
        if (this.jComboBox1.getSelectedItem() == null) {
            return;
        }
        String serialno = this.jComboBox1.getSelectedItem().toString().trim();
        DeviceBean bean = this.deviceDao.queryDevicebySerialno(serialno);
        String prodid = bean.getProdid();
        if (Debug.DEBUG_JIAYI) {
            prodid = "P16";
        }
        if (prodid.equals("P16") || prodid.equals("P17") || prodid.equals("P1730K") || prodid.equals("P175K") || prodid.equals("P17P1S1") || prodid.equals("P18") || prodid.equals("P1834K") || prodid.equals("P1812K")) {
            Document pdf = new Document(PageSize.A4);
            try {
                try {
                    PdfWriter.getInstance((Document)pdf, (OutputStream)new FileOutputStream(path));
                    pdf.addTitle("History energy datas");
                    pdf.addAuthor(GlobalVariables.customerConfig.getCustomerName());
                    pdf.open();
                    BaseFont bf = BaseFont.createFont((String)(String.valueOf(Constants.PDF_STYLE_PATH) + "simsun.ttc,1"), (String)"Identity-H", (boolean)false);
                    Font datafont = new Font(bf, 12.0f, 0, BaseColor.BLACK);
                    String[] titles = this.yearWithoutPriceTitle;
                    if (this.jComboBox3.getSelectedIndex() == 0) {
                        titles = this.yearWithoutPriceTitle;
                    } else if (this.jComboBox3.getSelectedIndex() == 1) {
                        titles = this.monthWithoutPriceTitle;
                    } else if (this.jComboBox3.getSelectedIndex() == 2) {
                        titles = this.dayWithoutPriceTitle;
                    } else if (this.jComboBox3.getSelectedIndex() == 3) {
                        titles = this.hourWithoutPriceTitle;
                    }
                    PdfPTable table = new PdfPTable(titles.length);
                    int i = 0;
                    while (i < titles.length) {
                        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(bd.getString(titles[i]), datafont));
                        cell.setHorizontalAlignment(1);
                        table.addCell(cell);
                        ++i;
                    }
                    if (this.jComboBox3.getSelectedIndex() == 0) {
                        i = 0;
                        while (i < this.energyBean.size()) {
                            table.addCell((Phrase)new Paragraph(String.valueOf(this.energyBean.get(i).getYear()), datafont));
                            table.addCell((Phrase)new Paragraph(String.valueOf(this.energyBean.get(i).getQuantity()), datafont));
                            ++i;
                        }
                    } else if (this.jComboBox3.getSelectedIndex() == 1) {
                        i = 0;
                        while (i < this.energyBean.size()) {
                            table.addCell((Phrase)new Paragraph(String.valueOf(this.energyBean.get(i).getYearmonth()), datafont));
                            table.addCell((Phrase)new Paragraph(String.valueOf(this.energyBean.get(i).getQuantity()), datafont));
                            ++i;
                        }
                    } else if (this.jComboBox3.getSelectedIndex() == 2) {
                        i = 0;
                        while (i < this.energyBean.size()) {
                            table.addCell((Phrase)new Paragraph(String.valueOf(DateUtils.getFormatDate(this.energyBean.get(i).getTrandate().getTime())), datafont));
                            table.addCell((Phrase)new Paragraph(String.valueOf(this.energyBean.get(i).getQuantity()), datafont));
                            ++i;
                        }
                    } else if (this.jComboBox3.getSelectedIndex() == 3) {
                        i = 0;
                        while (i < this.energyBean.size()) {
                            table.addCell((Phrase)new Paragraph(String.valueOf(DateUtils.getFormatDate(this.energyBean.get(i).getTrandate().getTime())), datafont));
                            table.addCell((Phrase)new Paragraph(String.valueOf(this.energyBean.get(i).getHour()), datafont));
                            table.addCell((Phrase)new Paragraph(String.valueOf(this.energyBean.get(i).getQuantity()), datafont));
                            ++i;
                        }
                    }
                    table.setWidthPercentage(100.0f);
                    pdf.add((Element)table);
                    Thread.sleep(1500L);
                    return;
                }
                catch (Exception ie) {
                    DisplayMessage.showErrorDialog("message.saveerror");
                    try {
                        if (pdf == null) return;
                        pdf.close();
                        return;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return;
            }
            finally {
                try {
                    if (pdf != null) {
                        pdf.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        Document pdf = new Document(PageSize.A4);
        try {
            try {
                PdfWriter.getInstance((Document)pdf, (OutputStream)new FileOutputStream(path));
                pdf.addTitle("History energy datas");
                pdf.addAuthor(GlobalVariables.customerConfig.getCustomerName());
                pdf.open();
                BaseFont bf = BaseFont.createFont((String)(String.valueOf(Constants.PDF_STYLE_PATH) + "simsun.ttc,1"), (String)"Identity-H", (boolean)false);
                Font datafont = new Font(bf, 12.0f, 0, BaseColor.BLACK);
                String[] titles = this.yearTitle;
                if (this.jComboBox3.getSelectedIndex() == 0) {
                    titles = this.yearTitle;
                } else if (this.jComboBox3.getSelectedIndex() == 1) {
                    titles = this.monthTitle;
                } else if (this.jComboBox3.getSelectedIndex() == 2) {
                    titles = this.dayTitle;
                } else if (this.jComboBox3.getSelectedIndex() == 3) {
                    titles = this.hourTitle;
                }
                PdfPTable table = new PdfPTable(titles.length);
                int i = 0;
                while (i < titles.length) {
                    PdfPCell cell = new PdfPCell((Phrase)new Paragraph(bd.getString(titles[i]), datafont));
                    cell.setHorizontalAlignment(1);
                    table.addCell(cell);
                    ++i;
                }
                if (this.jComboBox3.getSelectedIndex() == 0) {
                    i = 0;
                    while (i < this.yearEnergyList.size()) {
                        double totalQuan = this.yearEnergyList.get(i).getTotalQuantity();
                        String totalQuanStr = "0.0";
                        if (totalQuan > 0.0) {
                            totalQuanStr = String.valueOf(VolUtil.round(totalQuan, 3));
                        }
                        double totalAmont = this.yearEnergyList.get(i).getTotalAmount();
                        String totalAmontStr = "0.0";
                        if (totalAmont > 0.0) {
                            totalAmontStr = String.valueOf(VolUtil.round(totalAmont, 3));
                        }
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.yearEnergyList.get(i).getYear()), datafont));
                        table.addCell((Phrase)new Paragraph(this.yearEnergyList.get(i).getDateperiod(), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.yearEnergyList.get(i).getQuantity()), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.yearEnergyList.get(i).getPrice()), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.yearEnergyList.get(i).getAmount()), datafont));
                        table.addCell((Phrase)new Paragraph(totalQuanStr, datafont));
                        table.addCell((Phrase)new Paragraph(totalAmontStr, datafont));
                        ++i;
                    }
                } else if (this.jComboBox3.getSelectedIndex() == 1) {
                    i = 0;
                    while (i < this.monthEnergyList.size()) {
                        double totalQuan = this.monthEnergyList.get(i).getTotalQuantity();
                        String totalQuanStr = "0.0";
                        if (totalQuan > 0.0) {
                            totalQuanStr = String.valueOf(VolUtil.round(totalQuan, 3));
                        }
                        double totalAmont = this.monthEnergyList.get(i).getTotalAmount();
                        String totalAmontStr = "0.0";
                        if (totalAmont > 0.0) {
                            totalAmontStr = String.valueOf(VolUtil.round(totalAmont, 3));
                        }
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.monthEnergyList.get(i).getYearmonth()), datafont));
                        table.addCell((Phrase)new Paragraph(this.monthEnergyList.get(i).getDateperiod(), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.monthEnergyList.get(i).getQuantity()), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.monthEnergyList.get(i).getPrice()), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.monthEnergyList.get(i).getAmount()), datafont));
                        table.addCell((Phrase)new Paragraph(totalQuanStr, datafont));
                        table.addCell((Phrase)new Paragraph(totalAmontStr, datafont));
                        ++i;
                    }
                } else if (this.jComboBox3.getSelectedIndex() == 2) {
                    i = 0;
                    while (i < this.dayEnergyList.size()) {
                        table.addCell((Phrase)new Paragraph(String.valueOf(DateUtils.getFormatDate(this.dayEnergyList.get(i).getTrandate().getTime())), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.dayEnergyList.get(i).getQuantity()), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.dayEnergyList.get(i).getPrice()), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.dayEnergyList.get(i).getAmount()), datafont));
                        ++i;
                    }
                } else if (this.jComboBox3.getSelectedIndex() == 3) {
                    i = 0;
                    while (i < this.hourEnergyList.size()) {
                        table.addCell((Phrase)new Paragraph(String.valueOf(DateUtils.getFormatDate(this.hourEnergyList.get(i).getTrandate().getTime())), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.hourEnergyList.get(i).getHour()), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.hourEnergyList.get(i).getQuantity()), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.hourEnergyList.get(i).getPrice()), datafont));
                        table.addCell((Phrase)new Paragraph(String.valueOf(this.hourEnergyList.get(i).getAmount()), datafont));
                        ++i;
                    }
                }
                table.setWidthPercentage(100.0f);
                pdf.add((Element)table);
                Thread.sleep(1500L);
                DisplayMessage.showInfoDialog("message.savesuccess");
                return;
            }
            catch (Exception ie) {
                DisplayMessage.showErrorDialog("message.saveerror");
                try {
                    if (pdf == null) return;
                    pdf.close();
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return;
        }
        finally {
            try {
                if (pdf != null) {
                    pdf.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createExcel(File newFile) {
        if (this.jComboBox1.getSelectedItem() == null) {
            return;
        }
        String serialno = this.jComboBox1.getSelectedItem().toString().trim();
        DeviceBean bean = this.deviceDao.queryDevicebySerialno(serialno);
        String prodid = bean.getProdid();
        if (prodid.equals("P16") || prodid.equals("P17") || prodid.equals("P175K") || prodid.equals("P17P1S1") || prodid.equals("P18") || prodid.equals("P1834K") || prodid.equals("P1812K") || prodid.equals("P1730K")) {
            WritableWorkbook wwb = null;
            try {
                try {
                    wwb = Workbook.createWorkbook((File)newFile);
                    WritableSheet ws = wwb.createSheet("History energy datas", 0);
                    WritableCellFormat cellFormat = new WritableCellFormat();
                    cellFormat.setAlignment(Alignment.CENTRE);
                    String[] titles = this.yearWithoutPriceTitle;
                    if (this.jComboBox3.getSelectedIndex() == 0) {
                        titles = this.yearWithoutPriceTitle;
                    } else if (this.jComboBox3.getSelectedIndex() == 1) {
                        titles = this.monthWithoutPriceTitle;
                    } else if (this.jComboBox3.getSelectedIndex() == 2) {
                        titles = this.dayWithoutPriceTitle;
                    } else if (this.jComboBox3.getSelectedIndex() == 3) {
                        titles = this.hourWithoutPriceTitle;
                    }
                    int i = 0;
                    while (i < titles.length) {
                        Label labelC = new Label(i, 0, bd.getString(titles[i]));
                        labelC.setCellFormat((CellFormat)cellFormat);
                        ws.addCell((WritableCell)labelC);
                        int length = bd.getString(titles[i]).length();
                        if (length >= 20) {
                            ws.setColumnView(i, length + 2);
                        } else {
                            ws.setColumnView(i, 22);
                        }
                        ++i;
                    }
                    if (this.jComboBox3.getSelectedIndex() == 0) {
                        i = 0;
                        while (i < this.energyBean.size()) {
                            ws.addCell((WritableCell)new Label(0, i + 1, String.valueOf(this.energyBean.get(i).getYear())));
                            ws.addCell((WritableCell)new Label(1, i + 1, String.valueOf(this.energyBean.get(i).getQuantity())));
                            ++i;
                        }
                    } else if (this.jComboBox3.getSelectedIndex() == 1) {
                        i = 0;
                        while (i < this.energyBean.size()) {
                            ws.addCell((WritableCell)new Label(0, i + 1, String.valueOf(this.energyBean.get(i).getYearmonth())));
                            ws.addCell((WritableCell)new Label(1, i + 1, String.valueOf(this.energyBean.get(i).getQuantity())));
                            ++i;
                        }
                    } else if (this.jComboBox3.getSelectedIndex() == 2) {
                        i = 0;
                        while (i < this.energyBean.size()) {
                            ws.addCell((WritableCell)new Label(0, i + 1, String.valueOf(DateUtils.getFormatDate(this.energyBean.get(i).getTrandate().getTime()))));
                            ws.addCell((WritableCell)new Label(1, i + 1, String.valueOf(this.energyBean.get(i).getQuantity())));
                            ++i;
                        }
                    } else if (this.jComboBox3.getSelectedIndex() == 3) {
                        i = 0;
                        while (i < this.energyBean.size()) {
                            ws.addCell((WritableCell)new Label(0, i + 1, String.valueOf(DateUtils.getFormatDate(this.energyBean.get(i).getTrandate().getTime()))));
                            ws.addCell((WritableCell)new Label(1, i + 1, String.valueOf(this.energyBean.get(i).getHour())));
                            ws.addCell((WritableCell)new Label(2, i + 1, String.valueOf(this.energyBean.get(i).getQuantity())));
                            ++i;
                        }
                    }
                    wwb.write();
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (wwb == null) return;
                    try {
                        wwb.close();
                        return;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                return;
            }
            finally {
                if (wwb != null) {
                    try {
                        wwb.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        WritableWorkbook wwb = null;
        try {
            wwb = Workbook.createWorkbook((File)newFile);
            WritableSheet ws = wwb.createSheet("History energy datas", 0);
            WritableCellFormat cellFormat = new WritableCellFormat();
            cellFormat.setAlignment(Alignment.CENTRE);
            String[] titles = this.yearTitle;
            if (this.jComboBox3.getSelectedIndex() == 0) {
                titles = this.yearTitle;
            } else if (this.jComboBox3.getSelectedIndex() == 1) {
                titles = this.monthTitle;
            } else if (this.jComboBox3.getSelectedIndex() == 2) {
                titles = this.dayTitle;
            } else if (this.jComboBox3.getSelectedIndex() == 3) {
                titles = this.hourTitle;
            }
            int i = 0;
            while (i < titles.length) {
                Label labelC = new Label(i, 0, bd.getString(titles[i]));
                labelC.setCellFormat((CellFormat)cellFormat);
                ws.addCell((WritableCell)labelC);
                int length = bd.getString(titles[i]).length();
                if (length >= 20) {
                    ws.setColumnView(i, length + 2);
                } else {
                    ws.setColumnView(i, 22);
                }
                ++i;
            }
            if (this.jComboBox3.getSelectedIndex() == 0) {
                i = 0;
                while (i < this.yearEnergyList.size()) {
                    double totalQuan = this.yearEnergyList.get(i).getTotalQuantity();
                    String totalQuanStr = "0.0";
                    if (totalQuan > 0.0) {
                        totalQuanStr = String.valueOf(VolUtil.round(totalQuan, 3));
                    }
                    double totalAmont = this.yearEnergyList.get(i).getTotalAmount();
                    String totalAmontStr = "0.0";
                    if (totalAmont > 0.0) {
                        totalAmontStr = String.valueOf(VolUtil.round(totalAmont, 3));
                    }
                    ws.addCell((WritableCell)new Label(0, i + 1, String.valueOf(this.yearEnergyList.get(i).getYear())));
                    ws.addCell((WritableCell)new Label(1, i + 1, this.yearEnergyList.get(i).getDateperiod()));
                    ws.addCell((WritableCell)new Label(2, i + 1, String.valueOf(this.yearEnergyList.get(i).getQuantity())));
                    ws.addCell((WritableCell)new Label(3, i + 1, String.valueOf(this.yearEnergyList.get(i).getPrice())));
                    ws.addCell((WritableCell)new Label(4, i + 1, String.valueOf(this.yearEnergyList.get(i).getAmount())));
                    ws.addCell((WritableCell)new Label(5, i + 1, totalQuanStr));
                    ws.addCell((WritableCell)new Label(6, i + 1, totalAmontStr));
                    ++i;
                }
            } else if (this.jComboBox3.getSelectedIndex() == 1) {
                i = 0;
                while (i < this.monthEnergyList.size()) {
                    double totalQuan = this.monthEnergyList.get(i).getTotalQuantity();
                    String totalQuanStr = "0.0";
                    if (totalQuan > 0.0) {
                        totalQuanStr = String.valueOf(VolUtil.round(totalQuan, 3));
                    }
                    double totalAmont = this.monthEnergyList.get(i).getTotalAmount();
                    String totalAmontStr = "0.0";
                    if (totalAmont > 0.0) {
                        totalAmontStr = String.valueOf(VolUtil.round(totalAmont, 3));
                    }
                    ws.addCell((WritableCell)new Label(0, i + 1, String.valueOf(this.monthEnergyList.get(i).getYearmonth())));
                    ws.addCell((WritableCell)new Label(1, i + 1, this.monthEnergyList.get(i).getDateperiod()));
                    ws.addCell((WritableCell)new Label(2, i + 1, String.valueOf(this.monthEnergyList.get(i).getQuantity())));
                    ws.addCell((WritableCell)new Label(3, i + 1, String.valueOf(this.monthEnergyList.get(i).getPrice())));
                    ws.addCell((WritableCell)new Label(4, i + 1, String.valueOf(this.monthEnergyList.get(i).getAmount())));
                    ws.addCell((WritableCell)new Label(5, i + 1, totalQuanStr));
                    ws.addCell((WritableCell)new Label(6, i + 1, totalAmontStr));
                    ++i;
                }
            } else if (this.jComboBox3.getSelectedIndex() == 2) {
                i = 0;
                while (i < this.dayEnergyList.size()) {
                    ws.addCell((WritableCell)new Label(0, i + 1, String.valueOf(DateUtils.getFormatDate(this.dayEnergyList.get(i).getTrandate().getTime()))));
                    ws.addCell((WritableCell)new Label(1, i + 1, String.valueOf(this.dayEnergyList.get(i).getQuantity())));
                    ws.addCell((WritableCell)new Label(2, i + 1, String.valueOf(this.dayEnergyList.get(i).getPrice())));
                    ws.addCell((WritableCell)new Label(3, i + 1, String.valueOf(this.dayEnergyList.get(i).getAmount())));
                    ++i;
                }
            } else if (this.jComboBox3.getSelectedIndex() == 3) {
                i = 0;
                while (i < this.hourEnergyList.size()) {
                    ws.addCell((WritableCell)new Label(0, i + 1, String.valueOf(DateUtils.getFormatDate(this.hourEnergyList.get(i).getTrandate().getTime()))));
                    ws.addCell((WritableCell)new Label(1, i + 1, String.valueOf(this.hourEnergyList.get(i).getHour())));
                    ws.addCell((WritableCell)new Label(2, i + 1, String.valueOf(this.hourEnergyList.get(i).getQuantity())));
                    ws.addCell((WritableCell)new Label(3, i + 1, String.valueOf(this.hourEnergyList.get(i).getPrice())));
                    ws.addCell((WritableCell)new Label(4, i + 1, String.valueOf(this.hourEnergyList.get(i).getAmount())));
                    ++i;
                }
            }
            wwb.write();
            Thread.sleep(1500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (wwb == null) return;
        try {
            wwb.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPeriod1() {
        if (this.jComboBox3.getSelectedIndex() == 0) {
            this.jButton1.setVisible(false);
            this.yearSpinner1.setVisible(true);
            this.yearSpinner2.setVisible(true);
            this.jComboBox4.setVisible(false);
            this.jComboBox5.setVisible(false);
            this.jTextField1.setVisible(false);
            this.jTextField2.setVisible(false);
            this.jLabel3.setVisible(false);
            this.jLabel5.setVisible(false);
            this.hourSpinner1.setVisible(false);
            this.hourSpinner2.setVisible(false);
            this.hourLabel.setVisible(false);
            GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
            this.jPanel3.setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 950, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearSpinner1, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearSpinner2, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.excelCheckBox))).addContainerGap()));
            jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.excelCheckBox).addComponent(this.jButton3, -2, -1, -2).addComponent(this.yearSpinner2).addComponent(this.jLabel4, -2, -1, -2).addComponent(this.yearSpinner1).addComponent(this.jLabel8, -2, -1, -2).addComponent(this.jComboBox3).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jComboBox1).addComponent(this.jLabel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 447, Short.MAX_VALUE).addContainerGap()));
        } else if (this.jComboBox3.getSelectedIndex() == 1) {
            this.jButton1.setVisible(true);
            this.yearSpinner1.setVisible(true);
            this.yearSpinner2.setVisible(false);
            this.jComboBox4.setVisible(true);
            this.jComboBox5.setVisible(true);
            this.jTextField1.setVisible(false);
            this.jTextField2.setVisible(false);
            this.jLabel3.setVisible(false);
            this.jLabel5.setVisible(false);
            this.hourSpinner1.setVisible(false);
            this.hourSpinner2.setVisible(false);
            this.hourLabel.setVisible(false);
            GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
            this.jPanel3.setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 950, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearSpinner1, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox4, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox5, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.excelCheckBox))).addContainerGap()));
            jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.excelCheckBox).addComponent(this.jButton3).addComponent(this.jComboBox5, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jComboBox4, -2, -1, -2).addComponent(this.yearSpinner1, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 447, Short.MAX_VALUE).addContainerGap()));
        } else if (this.jComboBox3.getSelectedIndex() == 2) {
            this.jButton1.setVisible(true);
            this.yearSpinner1.setVisible(false);
            this.yearSpinner2.setVisible(false);
            this.jComboBox4.setVisible(false);
            this.jComboBox5.setVisible(false);
            this.jTextField1.setVisible(true);
            this.jTextField2.setVisible(true);
            this.jLabel3.setVisible(true);
            this.jLabel5.setVisible(true);
            this.hourSpinner1.setVisible(false);
            this.hourSpinner2.setVisible(false);
            this.hourLabel.setVisible(false);
            GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
            this.jPanel3.setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 950, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.excelCheckBox))).addContainerGap()));
            jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.excelCheckBox).addComponent(this.jButton3).addComponent(this.jLabel4).addComponent(this.jLabel8).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 447, Short.MAX_VALUE).addContainerGap()));
        } else if (this.jComboBox3.getSelectedIndex() == 3) {
            this.jButton1.setVisible(true);
            this.yearSpinner1.setVisible(false);
            this.yearSpinner2.setVisible(false);
            this.jComboBox4.setVisible(false);
            this.jComboBox5.setVisible(false);
            this.jTextField1.setVisible(true);
            this.jTextField2.setVisible(false);
            this.jLabel3.setVisible(true);
            this.jLabel5.setVisible(false);
            this.hourSpinner1.setVisible(true);
            this.hourSpinner2.setVisible(true);
            this.hourLabel.setVisible(true);
            GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
            this.jPanel3.setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 950, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hourSpinner1, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hourSpinner2, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hourLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.excelCheckBox))).addContainerGap()));
            jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.excelCheckBox).addComponent(this.jButton3).addComponent(this.hourLabel).addComponent(this.hourSpinner2, -2, -1, -2).addComponent(this.hourSpinner1, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jLabel2).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 448, Short.MAX_VALUE).addContainerGap()));
        }
    }
}

