/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.console.linux;

import cn.com.voltronic.solar.beanbag.P15BeanBag;
import cn.com.voltronic.solar.beanbag.P16BeanBag;
import cn.com.voltronic.solar.beanbag.P17BeanBag;
import cn.com.voltronic.solar.beanbag.P18BeanBag;
import cn.com.voltronic.solar.communicate.SECSerialHandler;
import cn.com.voltronic.solar.communicate.SECUSBHandler;
import cn.com.voltronic.solar.communicate.SerialHandler;
import cn.com.voltronic.solar.communicate.SerialHandlerSolaris;
import cn.com.voltronic.solar.communicate.USBHandler;
import cn.com.voltronic.solar.comusbprocessor.P15ComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.P16ComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.P176TO30KComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.P17ComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.P181TO2KComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.P18ComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.P20ComUSBProcessor;
import cn.com.voltronic.solar.configure.SystemEnv;
import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.console.linux.LinuxConsoleTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.dao.P15Dao;
import cn.com.voltronic.solar.dao.P16Dao;
import cn.com.voltronic.solar.dao.P17Dao;
import cn.com.voltronic.solar.dao.P18Dao;
import cn.com.voltronic.solar.dao.WorkDataDao;
import cn.com.voltronic.solar.protocol.P15;
import cn.com.voltronic.solar.protocol.P16;
import cn.com.voltronic.solar.protocol.P17;
import cn.com.voltronic.solar.protocol.P1730K;
import cn.com.voltronic.solar.protocol.P175K;
import cn.com.voltronic.solar.protocol.P17P1S1;
import cn.com.voltronic.solar.protocol.P18;
import cn.com.voltronic.solar.protocol.P181TO2K;
import cn.com.voltronic.solar.protocol.P183TO4K;
import cn.com.voltronic.solar.protocol.P18VII6k;
import cn.com.voltronic.solar.protocol.P20;
import cn.com.voltronic.solar.socket.DatagramServer;
import cn.com.voltronic.solar.socket.SystemTrayUDPServer;
import cn.com.voltronic.solar.socket.UdpClient;
import cn.com.voltronic.solar.system.DaoManager;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.system.ProcessorCategories;
import cn.com.voltronic.solar.thread.AutoDetect;
import cn.com.voltronic.solar.thread.EventThread;
import cn.com.voltronic.solar.thread.PageThread;
import cn.com.voltronic.solar.upgrade.StartUpgrade;
import cn.com.voltronic.solar.view.EventInfoDialog;
import cn.com.voltronic.solar.view.MainJFrame;
import cn.com.voltronic.solar.work.PollProcessorStatus;
import cn.com.voltronic.solar.work.RecordWorkinfo;
import cn.com.voltronic.solar.work.SearchDevice;
import cn.com.voltronic.solar.work.SynchroEnergyScheduler;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class SolarPower
extends Thread {
    private static final String LOG_PATH = String.valueOf(System.getProperty("user.dir")) + File.separator + "config" + File.separator + "log4j.properties";
    private static final Logger LOGGER = Logger.getLogger(SolarPower.class);
    private DatagramServer udpServerSocket;
    public EventInfoDialog dialog;
    private static SolarPowerTray consoleTray = null;
    public TrayIcon trayIcon;
    public volatile List<String> infoList;
    private volatile boolean hasInfo;
    public volatile boolean isopen;
    public volatile int pvCounter;

    public static SolarPowerTray getConsoleTray() {
        return consoleTray;
    }

    public SolarPower() {
        block11: {
            this.udpServerSocket = null;
            this.dialog = null;
            this.trayIcon = null;
            this.hasInfo = false;
            this.isopen = false;
            this.pvCounter = 0;
            try {
                PropertyConfigurator.configure((String)LOG_PATH);
                this.udpServerSocket = SystemTrayUDPServer.getServer();
                try {
                    this.inint();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff01");
                    if (this.udpServerSocket != null) {
                        this.udpServerSocket.close();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u6258\u76d8\u5df2\u7ecf\u6253\u5f00\uff01");
                String port = "38694";
                UdpClient client = null;
                try {
                    try {
                        port = GlobalVariables.globalConfig.getUdpPort();
                        client = new UdpClient("localhost", port);
                        client.send("OPENPAGE");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (client != null) {
                            client.disconnect();
                        }
                    }
                }
                finally {
                    if (client == null) break block11;
                    client.disconnect();
                }
            }
        }
    }

    public void inint() {
        GlobalVariables.initConfig(Constants.CONFIG_PATH);
        this.initMonitorProcess();
        consoleTray = new LinuxConsoleTray();
        EventThread event = new EventThread();
        event.start();
        PageThread thread = new PageThread();
        thread.start();
        this.initDaoManager();
        SearchDevice searchdevice = new SearchDevice();
        searchdevice.start();
        RecordWorkinfo record = new RecordWorkinfo();
        record.start();
        SynchroEnergyScheduler scheduler = new SynchroEnergyScheduler();
        scheduler.start();
        PollProcessorStatus pollstatus = new PollProcessorStatus();
        pollstatus.setPriority(10);
        pollstatus.start();
        this.trayIcon = SolarPowerTray.trayIcon;
        boolean useautoDetect = GlobalVariables.upgradeConfig.isAutoUpgrade();
        if (useautoDetect) {
            AutoDetect autoDetect = new AutoDetect();
            autoDetect.setDaemon(true);
            autoDetect.start();
        }
        this.infoList = new ArrayList<String>();
        this.responseAction();
        EventListener eventListener = new EventListener();
        eventListener.start();
    }

    public static void main(String[] args) {
        SolarPower linuxConsole = new SolarPower();
        linuxConsole.start();
    }

    private void initDaoManager() {
        DaoManager.registerDAO(P15BeanBag.class, P15Dao.class);
        DaoManager.registerDAO(P15BeanBag.class, WorkDataDao.class);
        DaoManager.registerDAO(P16BeanBag.class, P16Dao.class);
        DaoManager.registerDAO(P16BeanBag.class, WorkDataDao.class);
        DaoManager.registerDAO(P17BeanBag.class, P17Dao.class);
        DaoManager.registerDAO(P17BeanBag.class, WorkDataDao.class);
        DaoManager.registerDAO(P18BeanBag.class, P18Dao.class);
        DaoManager.registerDAO(P18BeanBag.class, WorkDataDao.class);
    }

    private void initMonitorProcess() {
        ProcessorCategories.registerProcessor(P15.class, SerialHandler.class, P15ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P15.class, SerialHandlerSolaris.class, P15ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P15.class, USBHandler.class, P15ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P16.class, SerialHandler.class, P16ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P16.class, SerialHandlerSolaris.class, P16ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P16.class, USBHandler.class, P16ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P20.class, SerialHandler.class, P20ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P20.class, SerialHandlerSolaris.class, P20ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P20.class, USBHandler.class, P20ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P17.class, SECUSBHandler.class, P17ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P17.class, SECSerialHandler.class, P17ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P175K.class, SECUSBHandler.class, P17ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P175K.class, SECSerialHandler.class, P17ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P17P1S1.class, SECUSBHandler.class, P17ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P17P1S1.class, SECSerialHandler.class, P17ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P1730K.class, SECUSBHandler.class, P176TO30KComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P1730K.class, SECSerialHandler.class, P176TO30KComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P18.class, SECUSBHandler.class, P18ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P18.class, SECSerialHandler.class, P18ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P18VII6k.class, SECUSBHandler.class, P18ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P18VII6k.class, SECSerialHandler.class, P18ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P183TO4K.class, SECUSBHandler.class, P18ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P183TO4K.class, SECSerialHandler.class, P18ComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P181TO2K.class, SECUSBHandler.class, P181TO2KComUSBProcessor.class);
        ProcessorCategories.registerProcessor(P181TO2K.class, SECSerialHandler.class, P181TO2KComUSBProcessor.class);
    }

    public void responseAction() {
        MouseAdapter openItemAction = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isMetaDown()) {
                    if (SolarPower.this.hasInfo) {
                        SolarPower.this.dialog = EventInfoDialog.getInstance();
                        SolarPower.this.isopen = true;
                        SolarPower.this.trayIcon.setPopupMenu(LinuxConsoleTray.popup);
                        SolarPower.this.dialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                (this).SolarPower.this.isopen = false;
                                (this).SolarPower.this.infoList.clear();
                                (this).SolarPower.this.dialog.dispose();
                            }
                        });
                        SolarPower.this.dialog.jButton1.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                (this).SolarPower.this.isopen = false;
                                (this).SolarPower.this.infoList.clear();
                                (this).SolarPower.this.dialog.dispose();
                            }
                        });
                        SolarPower.this.dialog.setVisible(true);
                        StringBuffer sb = new StringBuffer();
                        if (SolarPower.this.infoList.size() > 20) {
                            int i = SolarPower.this.infoList.size() - 20;
                            while (i < SolarPower.this.infoList.size()) {
                                sb.append(SolarPower.this.infoList.get(i));
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < SolarPower.this.infoList.size()) {
                                sb.append(SolarPower.this.infoList.get(i));
                                ++i;
                            }
                        }
                        SolarPower.this.dialog.getEventTextPanel().setText(sb.toString());
                        SolarPower.this.dialog.getEventTextPanel().setCaretPosition(sb.toString().length());
                        if (SolarPower.this.pvCounter > 0) {
                            SolarPower.this.trayIcon.setImage(Constants.CONNECTEDIMG_DEVICE);
                        } else {
                            SolarPower.this.trayIcon.setImage(Constants.CONNECTEDIMG);
                        }
                        SolarPower.this.hasInfo = false;
                    }
                } else if (e.getClickCount() == 2 && !e.isMetaDown() && !SolarPower.this.hasInfo) {
                    MainJFrame.getNewInstance().setVisible(true);
                    MainJFrame.getNewInstance().setState(0);
                }
            }
        };
        this.trayIcon.addMouseListener(openItemAction);
    }

    class EventListener
    extends Thread {
        EventListener() {
        }

        @Override
        public void run() {
            boolean isUpgrade = false;
            block6: while (true) {
                try {
                    while (true) {
                        String rec;
                        if ((rec = SolarPower.this.udpServerSocket.receive().trim()).startsWith("(Event:")) {
                            String event = rec.substring(7, rec.lastIndexOf("13"));
                            String eventaddn = String.valueOf(event) + "\n";
                            String startEvent = eventaddn.substring(0, eventaddn.lastIndexOf("]") + 1);
                            String endEvent = eventaddn.substring(eventaddn.lastIndexOf("]") + 2);
                            SolarPower.this.infoList.add(String.valueOf(startEvent) + "\n" + "     " + endEvent);
                            if (SolarPower.this.isopen) {
                                StringBuffer sb = new StringBuffer();
                                int i = 0;
                                while (i < SolarPower.this.infoList.size()) {
                                    sb.append(SolarPower.this.infoList.get(i));
                                    ++i;
                                }
                                SolarPower.this.dialog.getEventTextPanel().setText(sb.toString());
                                SolarPower.this.dialog.getEventTextPanel().setCaretPosition(SolarPower.this.dialog.getEventTextPanel().getText().length());
                                continue;
                            }
                            if (SolarPower.this.pvCounter > 0) {
                                SolarPower.this.trayIcon.setImage(Constants.HASEVENT_DEVICE);
                            } else {
                                SolarPower.this.trayIcon.setImage(Constants.HASEVENT);
                            }
                            SolarPower.this.hasInfo = true;
                            SolarPower.this.trayIcon.setPopupMenu(null);
                            continue;
                        }
                        if (rec.startsWith("(PVCount:")) {
                            try {
                                String count = rec.substring(9);
                                SolarPower.this.pvCounter = Integer.parseInt(count);
                                if (SolarPower.this.pvCounter > 0) {
                                    if (SolarPower.this.hasInfo && !SolarPower.this.isopen) {
                                        SolarPower.this.trayIcon.setImage(Constants.HASEVENT_DEVICE);
                                        continue;
                                    }
                                    SolarPower.this.trayIcon.setImage(Constants.CONNECTEDIMG_DEVICE);
                                    continue;
                                }
                                if (SolarPower.this.hasInfo && !SolarPower.this.isopen) {
                                    SolarPower.this.trayIcon.setImage(Constants.HASEVENT);
                                    continue;
                                }
                                SolarPower.this.trayIcon.setImage(Constants.CONNECTEDIMG);
                            }
                            catch (Exception count) {}
                            continue;
                        }
                        if (rec.startsWith("(exit:myself")) {
                            SystemEnv.stoped = 0;
                            SystemEnv.stopping = true;
                            break block6;
                        }
                        if (rec.startsWith("(exit:upgrade")) {
                            isUpgrade = true;
                            SystemEnv.stoped = 0;
                            SystemEnv.stopping = true;
                            break block6;
                        }
                        if (!rec.equals("OPENPAGE")) continue;
                        MainJFrame.getNewInstance().setVisible(true);
                        MainJFrame.getNewInstance().setState(0);
                    }
                }
                catch (Exception rec) {
                    continue;
                }
                break;
            }
            if (SolarPower.this.udpServerSocket != null) {
                SolarPower.this.udpServerSocket.close();
            }
            int iexit = 0;
            while (SystemEnv.stoped < 3) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (++iexit > 20) break;
            }
            LOGGER.error((Object)"stopped ok");
            if (isUpgrade) {
                StartUpgrade.runUpgrade();
            }
            System.exit(0);
        }
    }
}

