/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.tool.component;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.JLabel;

public class LinkLabel
extends JLabel {
    private static final long serialVersionUID = 6154377678777257460L;
    private String text;
    private String url;
    private boolean isSupported;

    public LinkLabel(String text, String url) {
        this.text = text;
        this.url = url;
        try {
            this.isSupported = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
        }
        catch (Exception e) {
            this.isSupported = false;
        }
        this.setText(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkLabel.this.setText(LinkLabel.this.isSupported);
                if (LinkLabel.this.isSupported) {
                    LinkLabel.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkLabel.this.setText(false);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(LinkLabel.this.url));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void setText(boolean b) {
        if (!b) {
            this.setText("<html><font color=blue><u>" + this.text);
        } else {
            this.setText("<html><font color=red><u>" + this.text);
        }
    }
}

