/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.MethodReplacer;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.SimpleInstantiationStrategy;

public class CglibSubclassingInstantiationStrategy
extends SimpleInstantiationStrategy {
    private static final int PASSTHROUGH = 0;
    private static final int LOOKUP_OVERRIDE = 1;
    private static final int METHOD_REPLACER = 2;
    static /* synthetic */ Class class$org$springframework$beans$factory$support$CglibSubclassingInstantiationStrategy$CglibSubclassCreator;

    protected Object instantiateWithMethodInjection(RootBeanDefinition rootBeanDefinition, String string, BeanFactory beanFactory) {
        return new CglibSubclassCreator(rootBeanDefinition, beanFactory).instantiate(null, null);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition rootBeanDefinition, String string, BeanFactory beanFactory, Constructor constructor, Object[] objectArray) {
        return new CglibSubclassCreator(rootBeanDefinition, beanFactory).instantiate(constructor, objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CglibSubclassCreator {
        private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$support$CglibSubclassingInstantiationStrategy$CglibSubclassCreator == null ? (class$org$springframework$beans$factory$support$CglibSubclassingInstantiationStrategy$CglibSubclassCreator = CglibSubclassingInstantiationStrategy.class$("org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy$CglibSubclassCreator")) : class$org$springframework$beans$factory$support$CglibSubclassingInstantiationStrategy$CglibSubclassCreator));
        private final RootBeanDefinition beanDefinition;
        private final BeanFactory owner;

        public CglibSubclassCreator(RootBeanDefinition rootBeanDefinition, BeanFactory beanFactory) {
            this.beanDefinition = rootBeanDefinition;
            this.owner = beanFactory;
        }

        public Object instantiate(Constructor constructor, Object[] objectArray) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(this.beanDefinition.getBeanClass());
            enhancer.setCallbackFilter((CallbackFilter)new CallbackFilterImpl());
            enhancer.setCallbacks(new Callback[]{NoOp.INSTANCE, new LookupOverrideMethodInterceptor(), new ReplaceOverrideMethodInterceptor()});
            return constructor == null ? enhancer.create() : enhancer.create((Class[])constructor.getParameterTypes(), objectArray);
        }

        private class CallbackFilterImpl
        extends CglibIdentitySupport
        implements CallbackFilter {
            private CallbackFilterImpl() {
            }

            public int accept(Method method) {
                MethodOverride methodOverride = CglibSubclassCreator.this.beanDefinition.getMethodOverrides().getOverride(method);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Override for '" + method.getName() + "' is [" + methodOverride + "]"));
                }
                if (methodOverride == null) {
                    return 0;
                }
                if (methodOverride instanceof LookupOverride) {
                    return 1;
                }
                if (methodOverride instanceof ReplaceOverride) {
                    return 2;
                }
                throw new UnsupportedOperationException("Unexpected MethodOverride subclass: " + methodOverride.getClass().getName());
            }
        }

        private class CglibIdentitySupport {
            private CglibIdentitySupport() {
            }

            protected RootBeanDefinition getBeanDefinition() {
                return CglibSubclassCreator.this.beanDefinition;
            }

            public int hashCode() {
                return CglibSubclassCreator.this.beanDefinition.hashCode();
            }

            public boolean equals(Object object) {
                return object.getClass() == this.getClass() && ((CglibIdentitySupport)object).getBeanDefinition() == CglibSubclassCreator.this.beanDefinition;
            }
        }

        private class LookupOverrideMethodInterceptor
        extends CglibIdentitySupport
        implements MethodInterceptor {
            private LookupOverrideMethodInterceptor() {
            }

            public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) throws Throwable {
                LookupOverride lookupOverride = (LookupOverride)CglibSubclassCreator.this.beanDefinition.getMethodOverrides().getOverride(method);
                return CglibSubclassCreator.this.owner.getBean(lookupOverride.getBeanName());
            }
        }

        private class ReplaceOverrideMethodInterceptor
        extends CglibIdentitySupport
        implements MethodInterceptor {
            private ReplaceOverrideMethodInterceptor() {
            }

            public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) throws Throwable {
                ReplaceOverride replaceOverride = (ReplaceOverride)CglibSubclassCreator.this.beanDefinition.getMethodOverrides().getOverride(method);
                MethodReplacer methodReplacer = (MethodReplacer)CglibSubclassCreator.this.owner.getBean(replaceOverride.getMethodReplacerBeanName());
                return methodReplacer.reimplement(object, method, objectArray);
            }
        }
    }
}

