/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;

public class URIEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;

    public URIEditor() {
        this.classLoader = ClassUtils.getDefaultClassLoader();
    }

    public URIEditor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            this.setValue(null);
        } else {
            if (string.startsWith("classpath:")) {
                ClassPathResource classPathResource = new ClassPathResource(string.substring("classpath:".length()), this.classLoader);
                try {
                    this.setValue(new URI(classPathResource.getURL().toString()));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Could not retrieve URI for " + classPathResource + ": " + iOException.getMessage());
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException("Invalid URI syntax: " + uRISyntaxException);
                }
            }
            try {
                this.setValue(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Invalid URI syntax: " + uRISyntaxException);
            }
        }
    }

    public String getAsText() {
        URI uRI = (URI)this.getValue();
        return uRI != null ? uRI.toString() : "";
    }
}

