/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.ui.ApplicationIconGenerator;
import com.sun.javaws.ui.SplashScreen;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public class CacheUtil {
    public static void remove(boolean bl) {
        File[] fileArray;
        ArrayList arrayList = Cache.getJnlpCacheEntries((boolean)Environment.isSystemCacheMode());
        ArrayList arrayList2 = bl ? new ArrayList() : CacheUtil.getExcludedCacheEntries(arrayList.iterator());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            fileArray = (File[])iterator.next();
            LaunchDesc launchDesc = null;
            try {
                launchDesc = LaunchDescFactory.buildDescriptor((File)fileArray, null, null, null);
            }
            catch (Exception exception) {
                Trace.println((String)"Cached jnlp file has no codebase", (TraceLevel)TraceLevel.CACHE);
                try {
                    launchDesc = LaunchDescFactory.buildDescriptor((File)fileArray);
                }
                catch (Exception exception2) {
                    Trace.ignoredException((Exception)exception);
                }
            }
            if (launchDesc == null) continue;
            CacheUtil.remove((File)fileArray, launchDesc, arrayList2);
        }
        if (Globals.isShortcutMode()) {
            return;
        }
        fileArray = Cache.getCacheEntries((boolean)Environment.isSystemCacheMode());
        for (int i = 0; i < fileArray.length; ++i) {
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile((File)fileArray[i]);
            if (cacheEntry != null) {
                if (arrayList2.contains(cacheEntry.getIndexFile())) continue;
                Cache.removeCacheEntry((CacheEntry)cacheEntry);
                continue;
            }
            fileArray[i].delete();
        }
        if (bl) {
            try {
                Cache.removeAllMuffins();
                Cache.removeAllLapFiles();
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
    }

    public static ArrayList getInstalledResources(boolean bl) {
        return CacheUtil.getExcludedCacheEntries(Cache.getJnlpCacheEntries((boolean)bl).iterator());
    }

    public static ArrayList getExcludedCacheEntries(Iterator iterator) {
        ArrayList arrayList = new ArrayList(){

            public boolean add(Object object) {
                if (!this.contains(object)) {
                    super.add(object);
                }
                return true;
            }
        };
        while (iterator.hasNext()) {
            CacheEntry cacheEntry;
            File file = (File)iterator.next();
            File file2 = new File(file.getPath() + ".idx");
            LaunchDesc launchDesc = null;
            if (!file2.exists()) continue;
            try {
                launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, null);
            }
            catch (BadFieldException badFieldException) {
                try {
                    cacheEntry = Cache.getCacheEntryFromFile((File)file2);
                    launchDesc = LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile(), URLUtil.getBase((URL)new URL(cacheEntry.getURL())), null, new URL(cacheEntry.getURL()));
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
            CacheEntry cacheEntry2 = Cache.getCacheEntryFromFile((File)file2);
            if (launchDesc == null || cacheEntry2 == null || (cacheEntry = Cache.getLocalApplicationProperties((CacheEntry)cacheEntry2)) == null || !cacheEntry.isJnlpInstalled()) continue;
            CacheUtil.markResourcesInstalled(file2, launchDesc, cacheEntry2, arrayList);
        }
        return arrayList;
    }

    private static void markResourcesInstalled(File file, LaunchDesc launchDesc, CacheEntry cacheEntry, ArrayList arrayList) {
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        Object object4;
        arrayList.add(file);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            object4 = resourcesDesc.getLocalJarDescs();
            if (object4 != null) {
                for (int i = ((JARDesc[])object4).length - 1; i >= 0; --i) {
                    URL uRL = ((JARDesc)object4[i]).getLocation();
                    object2 = Cache.getCacheEntry((URL)uRL, (String)(object3 = ((JARDesc)object4[i]).getVersion()));
                    if (object2 == null) continue;
                    arrayList.add(object2.getIndexFile());
                }
            }
            if ((objectArray = resourcesDesc.getExtensionDescs()) != null) {
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    object3 = objectArray[i];
                    object2 = Cache.getCacheEntry((URL)((ExtensionDesc)object3).getLocation(), (String)((ExtensionDesc)object3).getVersion());
                    if (object2 == null) continue;
                    try {
                        object = LaunchDescFactory.buildDescriptor(object2.getDataFile(), null, null, null);
                        if (object == null) continue;
                        CacheUtil.markResourcesInstalled(object2.getIndexFile(), (LaunchDesc)object, object2, arrayList);
                        continue;
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                    }
                }
            }
        }
        if ((object4 = launchDesc.getInformation()) != null) {
            RContentDesc[] rContentDescArray;
            objectArray = ((InformationDesc)object4).getIcons();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    object3 = ((IconDesc)objectArray[i]).getLocation();
                    if (object3 == null || (object = Cache.getCacheEntry((URL)object3, (String)(object2 = ((IconDesc)objectArray[i]).getVersion()))) == null) continue;
                    arrayList.add(object.getIndexFile());
                }
            }
            if ((rContentDescArray = ((InformationDesc)object4).getRelatedContent()) != null) {
                for (int i = 0; i < rContentDescArray.length; ++i) {
                    object2 = rContentDescArray[i].getIcon();
                    if (object2 == null || (object = Cache.getCacheEntry((URL)object2, null)) == null) continue;
                    arrayList.add(object.getIndexFile());
                }
            }
        }
    }

    public static void remove(CacheEntry cacheEntry) {
        try {
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile(), null, null, null);
            CacheUtil.remove(cacheEntry, launchDesc);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
    }

    public static void remove(File file, LaunchDesc launchDesc, ArrayList arrayList) {
        File file2 = new File(file.getPath() + ".idx");
        if (file2.exists()) {
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile((File)file2);
            if (cacheEntry != null) {
                if (!arrayList.contains(file2)) {
                    CacheUtil.remove(cacheEntry, launchDesc);
                }
            } else {
                file2.delete();
                file.delete();
            }
        } else if (file.exists() && ResourceProvider.get().getCacheDir().equals(file.getParentFile())) {
            file.delete();
        } else {
            CacheEntry cacheEntry = Cache.getCacheEntry((URL)launchDesc.getCanonicalHome(), null);
            if (cacheEntry != null && !arrayList.contains(cacheEntry.getIndexFile())) {
                CacheUtil.remove(cacheEntry, launchDesc);
            }
        }
    }

    public static void remove(CacheEntry cacheEntry, LaunchDesc launchDesc) {
        Object object;
        Object object2;
        Object object3;
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((CacheEntry)cacheEntry);
        InformationDesc informationDesc = launchDesc.getInformation();
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        if (localInstallHandler != null && launchDesc.isApplicationDescriptor()) {
            localInstallHandler.uninstall(launchDesc, localApplicationProperties, true);
        }
        if (Globals.isShortcutMode()) {
            return;
        }
        if (launchDesc.isApplicationDescriptor() && launchDesc.getLocation() != null) {
            Cache.saveRemovedApp((URL)launchDesc.getLocation(), (String)informationDesc.getTitle());
        }
        localApplicationProperties.refresh();
        if (localApplicationProperties.isExtensionInstalled() && launchDesc.isInstaller()) {
            object3 = new ArrayList();
            ((ArrayList)object3).add(cacheEntry.getDataFile());
            try {
                object2 = localApplicationProperties.getInstallDirectory();
                JnlpxArgs.executeUninstallers((ArrayList)object3);
                JREInfo.removeJREsIn((String)object2);
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }
        SplashScreen.removeCustomSplash(launchDesc);
        ApplicationIconGenerator.removeCustomIcon(launchDesc);
        if (informationDesc != null) {
            object3 = informationDesc.getIcons();
            if (object3 != null) {
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    URL uRL = ((IconDesc)object3[i]).getLocation();
                    object = ((IconDesc)object3[i]).getVersion();
                    CacheUtil.removeEntries(uRL, (String)object);
                }
            }
            if ((object2 = informationDesc.getRelatedContent()) != null) {
                for (int i = 0; i < ((Object[])object2).length; ++i) {
                    object = ((RContentDesc)object2[i]).getIcon();
                    if (object == null) continue;
                    CacheUtil.removeEntries((URL)object, null);
                }
            }
        }
        if ((object3 = launchDesc.getResources()) != null) {
            ExtensionDesc[] extensionDescArray;
            Object object4;
            object2 = ((ResourcesDesc)object3).getLocalJarDescs();
            if (object2 != null) {
                for (int i = ((Object[])object2).length - 1; i >= 0; --i) {
                    object = ((JARDesc)object2[i]).getLocation();
                    object4 = ((JARDesc)object2[i]).getVersion();
                    CacheUtil.removeEntries((URL)object, (String)object4);
                }
            }
            if ((extensionDescArray = ((ResourcesDesc)object3).getExtensionDescs()) != null) {
                for (int i = extensionDescArray.length - 1; i >= 0; --i) {
                    object4 = extensionDescArray[i];
                    CacheEntry cacheEntry2 = Cache.getCacheEntry((URL)((ExtensionDesc)object4).getLocation(), (String)((ExtensionDesc)object4).getVersion());
                    if (cacheEntry2 == null) continue;
                    try {
                        LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(cacheEntry2.getDataFile(), null, null, null);
                        if (launchDesc2 == null || !launchDesc2.isInstaller()) continue;
                        CacheUtil.remove(cacheEntry2, launchDesc2);
                        continue;
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                    }
                }
            }
        }
        object2 = cacheEntry.getURL();
        String string = cacheEntry.getVersion();
        try {
            URL uRL = new URL((String)object2);
            if (uRL != null) {
                CacheUtil.removeEntries(uRL, string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignored((Throwable)malformedURLException);
        }
        Cache.removeLoadedProperties((String)object2);
    }

    private static void removeEntries(URL uRL, String string) {
        if (uRL != null) {
            CacheEntry cacheEntry = Cache.getCacheEntry((URL)uRL, (String)string);
            Cache.removeAllCacheEntries((CacheEntry)cacheEntry);
        }
    }

    static File getCachedFileNative(URL uRL) {
        if (uRL.getProtocol().equals("jar")) {
            String string = uRL.getPath();
            int n = string.indexOf("!/");
            if (n > 0) {
                try {
                    String string2 = string.substring(n + 2);
                    URL uRL2 = new URL(string.substring(0, n));
                    String string3 = ResourceProvider.get().getLibraryDirForJar(string2, uRL2, null);
                    if (string3 != null) {
                        return new File(string3, string2);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignored((Throwable)malformedURLException);
                }
                catch (IOException iOException) {
                    Trace.ignored((Throwable)iOException);
                }
            }
            return null;
        }
        Resource resource = ResourceProvider.get().getCachedResource(uRL, null);
        return resource != null ? resource.getDataFile() : null;
    }
}

