/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.animation.TickCalculation;
import com.sun.javafx.collections.TrackableObservableList;
import java.util.Arrays;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.util.Duration;

public final class SequentialTransition
extends Transition {
    private static final Animation[] EMPTY_ANIMATION_ARRAY = new Animation[0];
    private static final int BEFORE = -1;
    private static final double EPSILON = 1.0E-12;
    private Animation[] cachedChildren = EMPTY_ANIMATION_ARRAY;
    private long[] startTimes;
    private long[] durations;
    private long[] delays;
    private double[] rates;
    private boolean[] forceChildSync;
    private int end;
    private int curIndex;
    private long oldTicks = -1L;
    private long offsetTicks;
    private boolean childrenChanged = true;
    private final InvalidationListener childrenListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            SequentialTransition.this.childrenChanged = true;
            if (SequentialTransition.this.getStatus() == Animation.Status.STOPPED) {
                SequentialTransition.this.setCycleDuration(SequentialTransition.this.computeCycleDuration());
            }
        }
    };
    private ObjectProperty<Node> node;
    private static final Node DEFAULT_NODE = null;
    private final ObservableList<Animation> children = new TrackableObservableList<Animation>(){

        @Override
        protected void onChanged(ListChangeListener.Change<Animation> change) {
            while (change.next()) {
                for (Animation animation : change.getRemoved()) {
                    if (animation instanceof Transition) {
                        Transition transition = (Transition)animation;
                        if (transition.parent == SequentialTransition.this) {
                            transition.parent = null;
                        }
                    }
                    animation.rateProperty().removeListener(SequentialTransition.this.childrenListener);
                    animation.totalDurationProperty().removeListener(SequentialTransition.this.childrenListener);
                    animation.delayProperty().removeListener(SequentialTransition.this.childrenListener);
                }
                for (Animation animation : change.getAddedSubList()) {
                    if (animation instanceof Transition) {
                        ((Transition)animation).parent = SequentialTransition.this;
                    }
                    animation.rateProperty().addListener(SequentialTransition.this.childrenListener);
                    animation.totalDurationProperty().addListener(SequentialTransition.this.childrenListener);
                    animation.delayProperty().addListener(SequentialTransition.this.childrenListener);
                }
            }
            SequentialTransition.this.childrenListener.invalidated(SequentialTransition.this.children);
        }
    };

    public final void setNode(Node node) {
        if (this.node != null || node != null) {
            this.nodeProperty().set(node);
        }
    }

    public final Node getNode() {
        return this.node == null ? DEFAULT_NODE : (Node)this.node.get();
    }

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty<Node>(this, "node", DEFAULT_NODE);
        }
        return this.node;
    }

    public final ObservableList<Animation> getChildren() {
        return this.children;
    }

    public SequentialTransition(Node node, Animation ... animationArray) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
        this.getChildren().setAll((Animation[])animationArray);
    }

    public SequentialTransition(Animation ... animationArray) {
        this((Node)null, animationArray);
    }

    public SequentialTransition(Node node) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
    }

    public SequentialTransition() {
        this((Node)null);
    }

    @Override
    protected Node getParentTargetNode() {
        Node node = this.getNode();
        return node != null ? node : (this.parent != null ? this.parent.getParentTargetNode() : null);
    }

    private Duration computeCycleDuration() {
        Duration duration = Duration.ZERO;
        for (Animation animation : this.getChildren()) {
            duration = duration.add(animation.getDelay());
            double d = Math.abs(animation.getRate());
            if (!(duration = duration.add(d < 1.0E-12 ? animation.getTotalDuration() : animation.getTotalDuration().divide(d))).isIndefinite()) continue;
            break;
        }
        return duration;
    }

    private double calculateFraction(long l, long l2) {
        double d = (double)l / (double)l2;
        return d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
    }

    private int findNewIndex(long l) {
        int n;
        if (this.curIndex != -1 && this.curIndex != this.end && this.startTimes[this.curIndex] <= l && l <= this.startTimes[this.curIndex + 1]) {
            return this.curIndex;
        }
        boolean bl = this.curIndex == -1 || this.curIndex == this.end;
        int n2 = bl || l < this.oldTicks ? 0 : this.curIndex + 1;
        int n3 = Arrays.binarySearch(this.startTimes, n2, n = bl || this.oldTicks < l ? this.end : this.curIndex, l);
        return n3 < 0 ? -n3 - 2 : (n3 > 0 ? n3 - 1 : 0);
    }

    @Override
    void impl_sync(boolean bl) {
        super.impl_sync(bl);
        if (bl && this.childrenChanged || this.startTimes == null) {
            this.cachedChildren = this.getChildren().toArray(EMPTY_ANIMATION_ARRAY);
            this.end = this.cachedChildren.length;
            this.startTimes = new long[this.end + 1];
            this.durations = new long[this.end];
            this.delays = new long[this.end];
            this.rates = new double[this.end];
            this.forceChildSync = new boolean[this.end];
            long l = 0L;
            int n = 0;
            for (Animation animation : this.cachedChildren) {
                this.startTimes[n] = l;
                this.rates[n] = animation.getRate();
                if (this.rates[n] < 1.0E-12) {
                    this.rates[n] = 1.0;
                }
                this.durations[n] = TickCalculation.fromDuration(animation.getTotalDuration(), this.rates[n]);
                this.delays[n] = TickCalculation.fromDuration(animation.getDelay());
                l = this.durations[n] == Long.MAX_VALUE || this.delays[n] == Long.MAX_VALUE || l == Long.MAX_VALUE ? Long.MAX_VALUE : TickCalculation.add(l, TickCalculation.add(this.durations[n], this.delays[n]));
                this.forceChildSync[n] = true;
                ++n;
            }
            this.startTimes[this.end] = l;
            this.childrenChanged = false;
        } else if (bl) {
            int n = this.forceChildSync.length;
            for (int i = 0; i < n; ++i) {
                this.forceChildSync[i] = true;
            }
        }
    }

    @Override
    void impl_start(boolean bl) {
        super.impl_start(bl);
        this.curIndex = this.getCurrentRate() > 0.0 ? -1 : this.end;
        this.offsetTicks = 0L;
    }

    @Override
    void impl_pause() {
        Animation animation;
        super.impl_pause();
        if (this.curIndex != -1 && this.curIndex != this.end && (animation = this.cachedChildren[this.curIndex]).getStatus() == Animation.Status.RUNNING) {
            animation.impl_pause();
        }
    }

    @Override
    void impl_resume() {
        Animation animation;
        super.impl_resume();
        if (this.curIndex != -1 && this.curIndex != this.end && (animation = this.cachedChildren[this.curIndex]).getStatus() == Animation.Status.PAUSED) {
            animation.impl_resume();
        }
    }

    @Override
    void impl_stop() {
        Animation animation;
        super.impl_stop();
        if (this.curIndex != -1 && this.curIndex != this.end && (animation = this.cachedChildren[this.curIndex]).getStatus() != Animation.Status.STOPPED) {
            animation.impl_stop();
        }
        if (this.childrenChanged) {
            this.setCycleDuration(this.computeCycleDuration());
        }
    }

    private boolean startChild(Animation animation, int n) {
        boolean bl = this.forceChildSync[n];
        if (animation.impl_startable(bl)) {
            animation.setRate(this.rates[n] * Math.signum(this.getCurrentRate()));
            animation.impl_start(bl);
            this.forceChildSync[n] = false;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void impl_playTo(long l, long l2) {
        Animation animation;
        this.impl_setCurrentTicks(l);
        double d = this.calculateFraction(l, l2);
        long l3 = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, l2, d), l2));
        int n = this.findNewIndex(l3);
        Animation animation2 = animation = this.curIndex == -1 || this.curIndex == this.end ? null : this.cachedChildren[this.curIndex];
        if (this.curIndex == n) {
            if (this.getCurrentRate() > 0.0) {
                long l4 = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (l3 >= l4) {
                    if (this.oldTicks <= l4 || animation.getStatus() == Animation.Status.STOPPED) {
                        boolean bl;
                        boolean bl2 = bl = this.oldTicks <= l4;
                        if (bl) {
                            animation.jumpTo(Duration.ZERO);
                        }
                        if (!this.startChild(animation, this.curIndex)) {
                            EventHandler<ActionEvent> eventHandler;
                            if (bl && (eventHandler = animation.getOnFinished()) != null) {
                                eventHandler.handle(new ActionEvent(this, null));
                            }
                            this.oldTicks = l3;
                            return;
                        }
                    }
                    long l5 = TickCalculation.sub(l3, l4);
                    if (l3 >= this.startTimes[this.curIndex + 1]) {
                        animation.impl_timePulse(Long.MAX_VALUE);
                        if (l3 == l2) {
                            this.curIndex = this.end;
                        }
                    } else {
                        animation.impl_timePulse(this.calcTimePulse(l5));
                    }
                }
            } else {
                long l6 = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (this.oldTicks >= this.startTimes[this.curIndex + 1] || this.oldTicks >= l6 && animation.getStatus() == Animation.Status.STOPPED) {
                    boolean bl;
                    boolean bl3 = bl = this.oldTicks >= this.startTimes[this.curIndex + 1];
                    if (bl) {
                        animation.jumpTo("end");
                    }
                    if (!this.startChild(animation, this.curIndex)) {
                        EventHandler<ActionEvent> eventHandler;
                        if (bl && (eventHandler = animation.getOnFinished()) != null) {
                            eventHandler.handle(new ActionEvent(this, null));
                        }
                        this.oldTicks = l3;
                        return;
                    }
                }
                if (l3 <= l6) {
                    animation.impl_timePulse(Long.MAX_VALUE);
                    if (l3 == 0L) {
                        this.curIndex = -1;
                    }
                } else {
                    long l7 = TickCalculation.sub(this.startTimes[this.curIndex + 1], l3);
                    animation.impl_timePulse(this.calcTimePulse(l7));
                }
            }
        } else if (this.curIndex < n) {
            EventHandler<ActionEvent> eventHandler;
            if (animation != null) {
                long l8 = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (this.oldTicks <= l8 || animation.getStatus() == Animation.Status.STOPPED && this.oldTicks != this.startTimes[this.curIndex + 1]) {
                    EventHandler<ActionEvent> eventHandler2;
                    boolean bl;
                    boolean bl4 = bl = this.oldTicks <= l8;
                    if (bl) {
                        animation.jumpTo(Duration.ZERO);
                    }
                    if (!this.startChild(animation, this.curIndex) && bl && (eventHandler2 = animation.getOnFinished()) != null) {
                        eventHandler2.handle(new ActionEvent(this, null));
                    }
                }
                if (animation.getStatus() == Animation.Status.RUNNING) {
                    animation.impl_timePulse(Long.MAX_VALUE);
                }
                this.oldTicks = this.startTimes[this.curIndex + 1];
            }
            this.offsetTicks = 0L;
            ++this.curIndex;
            while (this.curIndex < n) {
                Animation animation3 = this.cachedChildren[this.curIndex];
                animation3.jumpTo(Duration.ZERO);
                if (this.startChild(animation3, this.curIndex)) {
                    animation3.impl_timePulse(Long.MAX_VALUE);
                } else {
                    eventHandler = animation3.getOnFinished();
                    if (eventHandler != null) {
                        eventHandler.handle(new ActionEvent(this, null));
                    }
                }
                this.oldTicks = this.startTimes[this.curIndex + 1];
                ++this.curIndex;
            }
            Animation animation4 = this.cachedChildren[this.curIndex];
            animation4.jumpTo(Duration.ZERO);
            if (this.startChild(animation4, this.curIndex)) {
                if (l3 >= this.startTimes[this.curIndex + 1]) {
                    animation4.impl_timePulse(Long.MAX_VALUE);
                    if (l3 == l2) {
                        this.curIndex = this.end;
                    }
                } else {
                    long l9 = TickCalculation.sub(l3, TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]));
                    animation4.impl_timePulse(this.calcTimePulse(l9));
                }
            } else {
                eventHandler = animation4.getOnFinished();
                if (eventHandler != null) {
                    eventHandler.handle(new ActionEvent(this, null));
                }
            }
        } else {
            EventHandler<ActionEvent> eventHandler;
            if (animation != null) {
                long l10 = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (this.oldTicks >= this.startTimes[this.curIndex + 1] || this.oldTicks > l10 && animation.getStatus() == Animation.Status.STOPPED) {
                    EventHandler<ActionEvent> eventHandler3;
                    boolean bl;
                    boolean bl5 = bl = this.oldTicks >= this.startTimes[this.curIndex + 1];
                    if (bl) {
                        animation.jumpTo("end");
                    }
                    if (!this.startChild(animation, this.curIndex) && bl && (eventHandler3 = animation.getOnFinished()) != null) {
                        eventHandler3.handle(new ActionEvent(this, null));
                    }
                }
                if (animation.getStatus() == Animation.Status.RUNNING) {
                    animation.impl_timePulse(Long.MAX_VALUE);
                }
                this.oldTicks = this.startTimes[this.curIndex];
            }
            this.offsetTicks = 0L;
            --this.curIndex;
            while (this.curIndex > n) {
                Animation animation5 = this.cachedChildren[this.curIndex];
                animation5.jumpTo(TickCalculation.toDuration(this.durations[this.curIndex], this.rates[this.curIndex]));
                if (this.startChild(animation5, this.curIndex)) {
                    animation5.impl_timePulse(Long.MAX_VALUE);
                } else {
                    eventHandler = animation5.getOnFinished();
                    if (eventHandler != null) {
                        eventHandler.handle(new ActionEvent(this, null));
                    }
                }
                this.oldTicks = this.startTimes[this.curIndex];
                --this.curIndex;
            }
            Animation animation6 = this.cachedChildren[this.curIndex];
            animation6.jumpTo("end");
            if (this.startChild(animation6, this.curIndex)) {
                if (l3 <= TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex])) {
                    animation6.impl_timePulse(Long.MAX_VALUE);
                    if (l3 == 0L) {
                        this.curIndex = -1;
                    }
                } else {
                    long l11 = TickCalculation.sub(this.startTimes[this.curIndex + 1], l3);
                    animation6.impl_timePulse(this.calcTimePulse(l11));
                }
            } else {
                eventHandler = animation6.getOnFinished();
                if (eventHandler != null) {
                    eventHandler.handle(new ActionEvent(this, null));
                }
            }
        }
        this.oldTicks = l3;
    }

    @Override
    @Deprecated
    public void impl_jumpTo(long l, long l2) {
        this.impl_sync(false);
        Animation.Status status = this.getStatus();
        double d = this.calculateFraction(l, l2);
        long l3 = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, l2, d), l2));
        int n = this.curIndex;
        this.curIndex = this.findNewIndex(l3);
        Animation animation = this.cachedChildren[this.curIndex];
        if (this.curIndex != n && status != Animation.Status.STOPPED) {
            Animation animation2;
            if (n != -1 && n != this.end && (animation2 = this.cachedChildren[n]).getStatus() != Animation.Status.STOPPED) {
                this.cachedChildren[n].impl_stop();
            }
            this.startChild(animation, this.curIndex);
            if (status == Animation.Status.PAUSED) {
                animation.impl_pause();
            }
        }
        this.offsetTicks = this.getCurrentRate() < 0.0 ? TickCalculation.sub(this.startTimes[this.curIndex + 1], l3) : TickCalculation.sub(l3, TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]));
        animation.jumpTo(TickCalculation.toDuration(TickCalculation.sub(l3, TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex])), this.rates[this.curIndex]));
        this.oldTicks = l3;
    }

    @Override
    protected void interpolate(double d) {
    }

    private long calcTimePulse(long l) {
        return TickCalculation.sub(Math.round((double)l * Math.abs(this.rates[this.curIndex])), this.offsetTicks);
    }
}

