/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.value.ObservableValue;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class ProgressBarTableCell<S>
extends TableCell<S, Double> {
    private final ProgressBar progressBar;
    private ObservableValue observable;

    public static <S> Callback<TableColumn<S, Double>, TableCell<S, Double>> forTableColumn() {
        return new Callback<TableColumn<S, Double>, TableCell<S, Double>>(){

            @Override
            public TableCell<S, Double> call(TableColumn<S, Double> tableColumn) {
                return new ProgressBarTableCell();
            }
        };
    }

    public ProgressBarTableCell() {
        this.getStyleClass().add("progress-bar-table-cell");
        this.progressBar = new ProgressBar();
        this.setGraphic(this.progressBar);
    }

    @Override
    public void updateItem(Double d, boolean bl) {
        super.updateItem(d, bl);
        if (bl) {
            this.setGraphic(null);
        } else {
            this.progressBar.progressProperty().unbind();
            this.observable = this.getTableColumn().getCellObservableValue(this.getIndex());
            if (this.observable != null) {
                this.progressBar.progressProperty().bind(this.observable);
            } else {
                this.progressBar.setProgress(d);
            }
            this.setGraphic(this.progressBar);
        }
    }
}

