/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ObjectUtils;

public class BeanDefinitionBuilder {
    private AbstractBeanDefinition beanDefinition;
    private int constructorArgIndex;

    public static BeanDefinitionBuilder rootBeanDefinition(Class clazz) {
        return BeanDefinitionBuilder.rootBeanDefinition(clazz, null);
    }

    public static BeanDefinitionBuilder rootBeanDefinition(Class clazz, String string) {
        BeanDefinitionBuilder beanDefinitionBuilder = new BeanDefinitionBuilder();
        beanDefinitionBuilder.beanDefinition = new RootBeanDefinition();
        beanDefinitionBuilder.beanDefinition.setBeanClass(clazz);
        beanDefinitionBuilder.beanDefinition.setFactoryMethodName(string);
        return beanDefinitionBuilder;
    }

    public static BeanDefinitionBuilder rootBeanDefinition(String string) {
        return BeanDefinitionBuilder.rootBeanDefinition(string, null);
    }

    public static BeanDefinitionBuilder rootBeanDefinition(String string, String string2) {
        BeanDefinitionBuilder beanDefinitionBuilder = new BeanDefinitionBuilder();
        beanDefinitionBuilder.beanDefinition = new RootBeanDefinition();
        beanDefinitionBuilder.beanDefinition.setBeanClassName(string);
        beanDefinitionBuilder.beanDefinition.setFactoryMethodName(string2);
        return beanDefinitionBuilder;
    }

    public static BeanDefinitionBuilder childBeanDefinition(String string) {
        BeanDefinitionBuilder beanDefinitionBuilder = new BeanDefinitionBuilder();
        beanDefinitionBuilder.beanDefinition = new ChildBeanDefinition(string);
        return beanDefinitionBuilder;
    }

    private BeanDefinitionBuilder() {
    }

    public AbstractBeanDefinition getRawBeanDefinition() {
        return this.beanDefinition;
    }

    public AbstractBeanDefinition getBeanDefinition() {
        this.beanDefinition.validate();
        return this.beanDefinition;
    }

    public BeanDefinitionBuilder addPropertyValue(String string, Object object) {
        this.beanDefinition.getPropertyValues().addPropertyValue(new PropertyValue(string, object));
        return this;
    }

    public BeanDefinitionBuilder addPropertyReference(String string, String string2) {
        return this.addPropertyValue(string, new RuntimeBeanReference(string2));
    }

    public BeanDefinitionBuilder addConstructorArg(Object object) {
        this.beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(this.constructorArgIndex++, object);
        return this;
    }

    public BeanDefinitionBuilder addConstructorArgReference(String string) {
        return this.addConstructorArg(new RuntimeBeanReference(string));
    }

    public BeanDefinitionBuilder setFactoryMethod(String string) {
        this.beanDefinition.setFactoryMethodName(string);
        return this;
    }

    public BeanDefinitionBuilder setFactoryBean(String string, String string2) {
        this.beanDefinition.setFactoryBeanName(string);
        this.beanDefinition.setFactoryMethodName(string2);
        return this;
    }

    public BeanDefinitionBuilder setScope(String string) {
        this.beanDefinition.setScope(string);
        return this;
    }

    public BeanDefinitionBuilder setSingleton(boolean bl) {
        this.beanDefinition.setSingleton(bl);
        return this;
    }

    public BeanDefinitionBuilder setAbstract(boolean bl) {
        this.beanDefinition.setAbstract(bl);
        return this;
    }

    public BeanDefinitionBuilder setLazyInit(boolean bl) {
        this.beanDefinition.setLazyInit(bl);
        return this;
    }

    public BeanDefinitionBuilder setAutowireMode(int n) {
        this.beanDefinition.setAutowireMode(n);
        return this;
    }

    public BeanDefinitionBuilder setDependencyCheck(int n) {
        this.beanDefinition.setDependencyCheck(n);
        return this;
    }

    public BeanDefinitionBuilder setDestroyMethodName(String string) {
        this.beanDefinition.setDestroyMethodName(string);
        return this;
    }

    public BeanDefinitionBuilder setInitMethodName(String string) {
        this.beanDefinition.setInitMethodName(string);
        return this;
    }

    public BeanDefinitionBuilder setResourceDescription(String string) {
        this.beanDefinition.setResourceDescription(string);
        return this;
    }

    public BeanDefinitionBuilder addDependsOn(String string) {
        if (this.beanDefinition.getDependsOn() == null) {
            this.beanDefinition.setDependsOn(new String[]{string});
        } else {
            String[] stringArray = (String[])ObjectUtils.addObjectToArray((Object[])this.beanDefinition.getDependsOn(), (Object)string);
            this.beanDefinition.setDependsOn(stringArray);
        }
        return this;
    }

    public BeanDefinitionBuilder setSource(Object object) {
        this.beanDefinition.setSource(object);
        return this;
    }

    public BeanDefinitionBuilder setRole(int n) {
        this.beanDefinition.setRole(n);
        return this;
    }
}

