/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.factory.support.MethodOverride;

public class MethodOverrides {
    private final Set overrides = new HashSet();

    public MethodOverrides() {
    }

    public MethodOverrides(MethodOverrides methodOverrides) {
        this.addOverrides(methodOverrides);
    }

    public void addOverrides(MethodOverrides methodOverrides) {
        if (methodOverrides != null) {
            this.overrides.addAll(methodOverrides.getOverrides());
        }
    }

    public void addOverride(MethodOverride methodOverride) {
        this.overrides.add(methodOverride);
    }

    public Set getOverrides() {
        return this.overrides;
    }

    public boolean isEmpty() {
        return this.overrides.isEmpty();
    }

    public MethodOverride getOverride(Method method) {
        Iterator iterator = this.overrides.iterator();
        while (iterator.hasNext()) {
            MethodOverride methodOverride = (MethodOverride)iterator.next();
            if (!methodOverride.matches(method)) continue;
            return methodOverride;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MethodOverrides methodOverrides = (MethodOverrides)object;
        return ((Object)this.overrides).equals(methodOverrides.overrides);
    }

    public int hashCode() {
        return ((Object)this.overrides).hashCode();
    }
}

