/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.communicate;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.communicate.ISECProtocolHandler;
import cn.com.voltronic.solar.communicate.SECFormat;
import cn.com.voltronic.solar.debug.Debug;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.util.VolUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import usb.IUSBComm;

public class SECUSBHandler
implements IComUSBHandler,
ICommunicateDevice,
ISECProtocolHandler {
    private static final Logger LOGGER = Logger.getLogger(SECUSBHandler.class);
    private String usbId;
    private IUSBComm usbComm;
    protected AbstractProcessor notifyProcesser;
    private int _errorcount = 0;
    private boolean isUseCRC = false;

    public SECUSBHandler(IUSBComm usbComm, String usbId) {
        this.usbComm = usbComm;
        this.usbId = usbId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String excuteSimpleCommand(String command) {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            String returnValue;
            block12: {
                boolean result = true;
                returnValue = "";
                try {
                    try {
                        int time = 0;
                        while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 3) {
                            Thread.sleep(500L);
                            if (this.isUseCRC()) {
                                this.usbComm.setUseCRC(1);
                            } else {
                                this.usbComm.setUseCRC(0);
                            }
                            String returnData = "";
                            returnData = this.isUseCRC() ? this.usbComm.sendCommand(this.usbId, String.valueOf(SECFormat.addPollHeader(command, 2)) + "\r") : this.usbComm.sendCommand(this.usbId, String.valueOf(SECFormat.addPollHeader(command)) + "\r");
                            LOGGER.debug((Object)(String.valueOf(command) + " : " + returnData));
                            returnValue = SECFormat.getNodeData(returnData);
                            LOGGER.debug((Object)("getNodeData : " + returnValue));
                            ++time;
                        }
                        if (StringUtils.isEmpty((String)returnValue)) {
                            result = false;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.debug((Object)ex.getMessage());
                        result = false;
                        this.countErrorandNotifyProcesser(result);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.countErrorandNotifyProcesser(result);
                    throw throwable;
                }
                this.countErrorandNotifyProcesser(result);
            }
            Debug.debug(command, returnValue);
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String excuteCommand(String command, boolean isResponse) {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            String returnValue;
            block17: {
                boolean result;
                block15: {
                    block16: {
                        if (this.isUseCRC()) {
                            this.usbComm.setUseCRC(1);
                        } else {
                            this.usbComm.setUseCRC(0);
                        }
                        result = true;
                        returnValue = "";
                        boolean isTimeOut = false;
                        if (!isResponse) break block15;
                        int time = 0;
                        while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 3) {
                            if (time > 0) {
                                Thread.sleep(500L);
                            }
                            String returnData = "";
                            returnData = this.isUseCRC() ? this.usbComm.sendCommand(this.usbId, String.valueOf(SECFormat.addPollHeader(command, 2)) + "\r") : this.usbComm.sendCommand(this.usbId, String.valueOf(SECFormat.addPollHeader(command)) + "\r");
                            LOGGER.debug((Object)(String.valueOf(command) + " : " + returnData));
                            if (returnData.equals("Receive timed out")) {
                                isTimeOut = true;
                                break;
                            }
                            returnValue = SECFormat.getNodeData(returnData);
                            ++time;
                        }
                        if (!isTimeOut) break block16;
                        if (SystemUtils.IS_OS_MAC_OSX) {
                            this.usbComm.exitMacServ();
                        }
                        this.countErrorandNotifyProcesser(result);
                        return "";
                    }
                    try {
                        try {
                            if (StringUtils.isEmpty((String)returnValue)) {
                                result = false;
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.debug((Object)ex.getMessage());
                            result = false;
                            this.countErrorandNotifyProcesser(result);
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        this.countErrorandNotifyProcesser(result);
                        throw throwable;
                    }
                }
                this.countErrorandNotifyProcesser(result);
            }
            Debug.debug(command, returnValue);
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String excuteSetCommand(String command, boolean isResponse) {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            String returnValue;
            block13: {
                if (this.isUseCRC()) {
                    this.usbComm.setUseCRC(1);
                } else {
                    this.usbComm.setUseCRC(0);
                }
                boolean result = true;
                returnValue = "";
                try {
                    try {
                        if (isResponse) {
                            int time = 0;
                            while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 2) {
                                returnValue = this.isUseCRC() ? SECFormat.getNodeData(this.usbComm.sendCommand(this.usbId, String.valueOf(SECFormat.addSetHeader(command, 2)) + "\r")) : SECFormat.getNodeData(this.usbComm.sendCommand(this.usbId, String.valueOf(SECFormat.addSetHeader(command)) + "\r"));
                                ++time;
                            }
                            if (StringUtils.isEmpty((String)returnValue)) {
                                result = false;
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.debug((Object)ex.getMessage());
                        result = false;
                        this.countErrorandNotifyProcesser(result);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    this.countErrorandNotifyProcesser(result);
                    throw throwable;
                }
                this.countErrorandNotifyProcesser(result);
            }
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            if (this.usbComm != null) {
                try {
                    this.usbComm.closeUSBPort(this.usbId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getDeviceName() {
        return "USB" + this.usbId;
    }

    @Override
    public void setNotifyProcess(AbstractProcessor process) {
        this.notifyProcesser = process;
    }

    private void countErrorandNotifyProcesser(boolean success) {
        this._errorcount = success ? 0 : ++this._errorcount;
        if (this._errorcount >= 3 && this.notifyProcesser != null) {
            LOGGER.debug((Object)("---------communication exception---------" + this._errorcount));
            this.notifyProcesser.close();
        }
    }

    @Override
    public int getMpptTrackNumber() {
        int mpptTrackNumber = 2;
        String qpigsStr = this.excuteCommand("GS", true);
        if (!"".equals(qpigsStr) && !qpigsStr.equals("(NAK")) {
            String[] qpigsArr = qpigsStr.split(",");
            mpptTrackNumber = VolUtil.parseInt(qpigsArr[7]);
        }
        return mpptTrackNumber;
    }

    @Override
    public String getSerialNo() {
        String serialno = "";
        String serialnoStr = "";
        try {
            int i = 0;
            while (i < 3) {
                serialnoStr = this.excuteCommand("ID", true);
                if (!(StringUtils.isEmpty((String)serialnoStr) || serialnoStr.equalsIgnoreCase("(NAK") || serialnoStr.equalsIgnoreCase("(ACK"))) {
                    String validLen = serialnoStr.substring(0, 2);
                    serialno = serialnoStr.substring(2, 2 + Integer.valueOf(validLen));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serialno;
    }

    @Override
    public String getModeType() {
        String machineTypeStr = "";
        try {
            String qpiriStr = this.excuteCommand("PIRI", true);
            if (!StringUtils.isEmpty((String)qpiriStr) && !qpiriStr.equals("(NAK")) {
                String[] ratingInfo = qpiriStr.split(",");
                machineTypeStr = ratingInfo[8];
                return machineTypeStr;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return machineTypeStr;
    }

    @Override
    public String getDeviceModel() {
        String _deviceModel = "";
        try {
            String qdmStr = this.excuteCommand("DM", true);
            if (!StringUtils.isEmpty((String)qdmStr) && !qdmStr.equals("(NAK")) {
                _deviceModel = qdmStr;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return _deviceModel;
    }

    @Override
    public void setCrcCheck(boolean isCrcCheck) {
    }

    @Override
    public boolean isUseCRC() {
        return this.isUseCRC;
    }

    @Override
    public void setUseCRC(boolean isUseCRC) {
        this.isUseCRC = isUseCRC;
    }

    @Override
    public String getModelName() {
        return null;
    }
}

