/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.modbusprocessor;

import cn.com.voltronic.solar.beanbag.P15BeanBag;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.control.P15ModbusControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProtocolInfo;
import cn.com.voltronic.solar.data.bean.SelfTestResult;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.exception.FaultHandler;
import cn.com.voltronic.solar.modbusprocessor.AbstractModbusProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.Calendar;
import java.util.Date;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleRegister;
import net.wimpi.modbus.util.BitVector;

public class P15ModbusProcessor
extends AbstractModbusProcessor {
    private static final double DOUBLE_TEN = 10.0;
    private String oldFaultStr = "";
    private String oldFaultDate = "";
    private BitVector oldWarnings = null;
    private Object query_hour = new Integer(0);
    private Object query_day = new Integer(1);
    private Object query_month = new Integer(2);
    private Object query_year = new Integer(3);
    private static final int WAIT_TIME = 600;

    public P15ModbusProcessor(ModbusHandler handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    protected void initBeanBag() {
        this._beanbag = new P15BeanBag();
    }

    @Override
    protected void initControlModule() {
        this._control = new P15ModbusControlModule(this.getHandler(), (ConfigData)this._beanbag.getBean("configdata"), (Capability)this._beanbag.getBean("capability"));
    }

    @Override
    public void initProtocol() {
        ProtocolInfo info = (ProtocolInfo)this.getBeanBag().getBean("protocolinfo");
        info.setProdid(this._protocol.getProtocolID());
        info.setBaseInfo(this._protocol.getBaseInfo());
        info.setProductInfo(this._protocol.getProductInfo());
        info.setRatingInfo(this._protocol.getRatingInfo());
        try {
            info.setSerialno(this._protocol.getSerialNo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        info.setMoreInfo(this._protocol.getMoreInfo());
        info.setMpptTrackNumber(this._protocol.getMpptTrackNumber());
    }

    @Override
    public boolean pollQueryStatus() {
        if (!super.pollQueryStatus()) {
            ++this.reconnectTimes;
            return false;
        }
        boolean result = true;
        ModbusHandler handler = this.getHandler();
        if (handler == null) {
            return false;
        }
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            workinfo.setProdid("P15");
            workinfo.setSerialno(this.getProtocol().getSerialNo());
            if (this.currenttime != null) {
                workinfo.setCurrentTime(this.getCurrentTime().getTime());
            }
            if (this.isStartQuerySelfTestResult()) {
                this.querySelfTestResult();
            }
            Register[] queryQPIWS = handler.readMultipleRegisters(3, 2);
            BitVector warnStatus = new BitVector(16);
            warnStatus.setBytes(queryQPIWS[0].toBytes(), 16);
            warnStatus.toggleAccess(true);
            BitVector newWarnStatus = new BitVector(12);
            int item = 0;
            while (item < 8) {
                newWarnStatus.setBit(item, warnStatus.getBit(item + 8));
                ++item;
            }
            warnStatus = new BitVector(16);
            warnStatus.setBytes(queryQPIWS[1].toBytes(), 16);
            warnStatus.toggleAccess(true);
            item = 0;
            while (item < 6) {
                newWarnStatus.setBit(item + 8, warnStatus.getBit(item));
                ++item;
            }
            workinfo.clearWarning();
            Calendar machineTime = Calendar.getInstance();
            machineTime.setTime(workinfo.getCurrentTime());
            Calendar serverTime = Calendar.getInstance();
            serverTime.setTime(new Date());
            if (Math.abs(machineTime.getTimeInMillis() - serverTime.getTimeInMillis()) > (long)(GlobalVariables.globalConfig.getShowWarningForDatetime() * 60 * 1000)) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "3003");
                workinfo.addWarning("3003");
            }
            this.setWarningStatus(newWarnStatus, workinfo);
            if (newWarnStatus.getBit(11) || newWarnStatus.getBit(10) || newWarnStatus.getBit(9) || newWarnStatus.getBit(8) || newWarnStatus.getBit(7)) {
                workinfo.setLineLoss(true);
            } else {
                workinfo.setLineLoss(false);
            }
            if (newWarnStatus.getBit(0)) {
                Register[] queryQPIFS = handler.readMultipleRegisters(605, 27);
                String faultstr = new String(queryQPIFS[0].toBytes()).trim();
                System.out.println("------------faultstr:" + faultstr);
                int tempFault = 0;
                try {
                    tempFault = Integer.parseInt(faultstr);
                }
                catch (Exception e) {
                    tempFault = 0;
                }
                if (tempFault > 0 && tempFault <= 19) {
                    DataBeforeFault data = new DataBeforeFault();
                    String timeStr = "";
                    int item2 = 1;
                    while (item2 <= 7) {
                        timeStr = String.valueOf(timeStr) + new String(queryQPIFS[item2].toBytes()).trim();
                        ++item2;
                    }
                    if (!this.oldFaultStr.equals(faultstr) || !this.oldFaultDate.equals(timeStr)) {
                        data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                        data.setProdid("P15");
                        data.setSerialno(this.getProtocol().getSerialNo());
                        data.setPvinputvoltage1((double)queryQPIFS[8].getValue() / 10.0);
                        data.setPvinputcurrent1((double)queryQPIFS[9].getValue() / 10.0);
                        data.setPvinputvoltage2((double)queryQPIFS[10].getValue() / 10.0);
                        data.setPvinputcurrent2((double)queryQPIFS[11].getValue() / 10.0);
                        data.setPvinputvoltage3((double)queryQPIFS[12].getValue() / 10.0);
                        data.setPvinputcurrent3((double)queryQPIFS[13].getValue() / 10.0);
                        data.setInverterVoltage((double)queryQPIFS[14].getValue() / 10.0);
                        data.setInverterCurrent((double)queryQPIFS[15].getValue() / 10.0);
                        data.setGridVoltage((double)queryQPIFS[16].getValue() / 10.0);
                        data.setGridFrequency((double)queryQPIFS[17].getValue() / 10.0);
                        data.setGridCurrent((double)P15ModbusProcessor.convert2Regiters(queryQPIFS[18], queryQPIFS[19]) / 10.0);
                        data.setOutputLoadPercent(queryQPIFS[20].getValue());
                        data.setOutputLoadCurrent((double)queryQPIFS[21].getValue() / 10.0);
                        data.setOutputLoadVoltage((double)queryQPIFS[22].getValue() / 10.0);
                        data.setOutputLoadFrequency((double)queryQPIFS[23].getValue() / 10.0);
                        data.setBatteryVoltage((double)queryQPIFS[24].getValue() / 10.0);
                        data.setMaxTemperature((double)queryQPIFS[25].getValue() / 10.0);
                        String runStatus = new String(queryQPIFS[26].toBytes());
                        data.setRunStatus(runStatus);
                        FaultHandler.doFaultEvent(faultstr, workinfo.getProdid(), workinfo.getSerialno(), data);
                        this.oldFaultStr = faultstr;
                        this.oldFaultDate = timeStr;
                    }
                    workinfo.setFaultInfo(faultstr);
                }
            } else {
                FaultHandler.removeFaultEvent(workinfo.getProdid(), workinfo.getSerialno());
                workinfo.setFaultInfo(null);
            }
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            workinfo.clear();
            ++this.reconnectTimes;
        }
        return result;
    }

    private boolean isSameMachine() throws Exception {
        String serialno = "";
        ModbusHandler handler = this.getHandler();
        Register[] qid = handler.readMultipleRegisters(1003, 7);
        int item = 0;
        while (item < qid.length) {
            serialno = String.valueOf(serialno) + new String(qid[item].toBytes()).trim();
            ++item;
        }
        return serialno.equalsIgnoreCase(this.getProtocol().getSerialNo());
    }

    @Override
    public boolean pollQuery() {
        WorkInfo workinfo;
        ModbusHandler handler;
        boolean result;
        block13: {
            if (!super.pollQuery()) {
                ++this.reconnectTimes;
                return false;
            }
            result = true;
            handler = this.getHandler();
            if (handler == null) {
                return false;
            }
            workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
            if (this.isSameMachine()) break block13;
            this.close();
            return false;
        }
        try {
            workinfo.setProdid("P15");
            workinfo.setSerialno(this.getProtocol().getSerialNo());
            if (this.currenttime != null) {
                workinfo.setCurrentTime(this.currenttime.getTime());
            }
            Register[] queryLong = handler.readMultipleRegisters(208, 31);
            String modestr = new String(queryLong[0].toBytes());
            if ("Power On".equals(modestr = modestr.trim())) {
                workinfo.setWorkMode("Power On");
            } else if ("Standby".equals(modestr)) {
                workinfo.setWorkMode("Standby");
            } else if ("Fault".equals(modestr)) {
                workinfo.setWorkMode("Fault");
            } else if ("Grid".equals(modestr)) {
                workinfo.setWorkMode("Grid");
            }
            double gridVoltageR = (double)queryLong[1].getValue() / 10.0;
            workinfo.setGridVoltageR(gridVoltageR);
            double gridPowerR = P15ModbusProcessor.convert3Regiters(queryLong[2], queryLong[3], queryLong[4]);
            workinfo.setGridPowerR(gridPowerR);
            double gridFrequency = (double)queryLong[5].getValue() / 10.0;
            workinfo.setGridFrequency(gridFrequency);
            double gridCurrentR = (double)P15ModbusProcessor.convert2Regiters(queryLong[6], queryLong[7]) / 10.0;
            workinfo.setGridCurrentR(gridCurrentR);
            workinfo.setOutputLoadPercent(queryLong[13].getValue());
            double pBUSVoltage = (double)queryLong[14].getValue() / 10.0;
            workinfo.setPBUSVoltage(pBUSVoltage);
            double sBUSVoltage = (double)queryLong[15].getValue() / 10.0;
            workinfo.setSBUSVoltage(sBUSVoltage);
            int pvInputPower1 = (int)P15ModbusProcessor.convert2Regiters(queryLong[20], queryLong[21]);
            int pvInputPower2 = (int)P15ModbusProcessor.convert2Regiters(queryLong[22], queryLong[23]);
            int pvInputPower3 = (int)P15ModbusProcessor.convert2Regiters(queryLong[24], queryLong[25]);
            workinfo.setPvInputPower1(pvInputPower1);
            workinfo.setPvInputPower2(pvInputPower2);
            workinfo.setPvInputPower3(pvInputPower3);
            double pvInputVoltage1 = (double)queryLong[26].getValue() / 10.0;
            double pvInputVoltage2 = (double)queryLong[27].getValue() / 10.0;
            double pvInputVoltage3 = (double)queryLong[28].getValue() / 10.0;
            workinfo.setPvInputVoltage1(pvInputVoltage1);
            workinfo.setPvInputVoltage2(pvInputVoltage2);
            workinfo.setPvInputVoltage3(pvInputVoltage3);
            double temperature = (double)queryLong[29].getValue() / 10.0;
            workinfo.setMaxTemperature(temperature);
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            workinfo.clear();
            ++this.reconnectTimes;
        }
        return result;
    }

    @Override
    public boolean queryMachineInfo() {
        boolean result = true;
        ModbusHandler handler = this.getHandler();
        if (handler == null) {
            return false;
        }
        MachineInfo machineinfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        try {
            Register[] queryLong = handler.readMultipleRegisters(993, 30);
            String qvfwstr = "";
            int item = 0;
            while (item < 10) {
                qvfwstr = String.valueOf(qvfwstr) + new String(queryLong[item].toBytes()).trim();
                ++item;
            }
            machineinfo.setMainFirmwareVersion(qvfwstr);
            String serialno = "";
            int item2 = 10;
            while (item2 < 17) {
                serialno = String.valueOf(serialno) + new String(queryLong[item2].toBytes()).trim();
                ++item2;
            }
            machineinfo.setSerialno(serialno);
            int outputPhase = queryLong[20].getValue();
            machineinfo.setIoPhase("" + outputPhase);
            double nominalInputVoltage = queryLong[21].getValue();
            machineinfo.setNominalInputVoltage(nominalInputVoltage);
            double nominalOutputVoltage = queryLong[22].getValue();
            machineinfo.setNominalOutputVoltage(nominalOutputVoltage);
            double outputPowerFactor = queryLong[23].getValue();
            machineinfo.setOutputPowerFactor(VolUtil.round(outputPowerFactor * 0.01, 2));
            double outputRateVA = P15ModbusProcessor.convert2Regiters(queryLong[24], queryLong[25]);
            machineinfo.setOutputRateVA(outputRateVA);
            Register[] queryLong2 = handler.readMultipleRegisters(1167, 41);
            double gridRatingVoltage = (double)queryLong2[0].getValue() / 10.0;
            machineinfo.setGridRatingVoltage(gridRatingVoltage);
            double gridRatingFrequency = (double)queryLong2[1].getValue() / 10.0;
            machineinfo.setGridRatingFrequency(gridRatingFrequency);
            double gridRatingCurrent = (double)queryLong2[2].getValue() / 10.0;
            machineinfo.setGridRatingCurrent(gridRatingCurrent);
            double perMPPTRatingCurrent = (double)queryLong2[8].getValue() / 10.0;
            machineinfo.setPerMPPTRatingCurrent(perMPPTRatingCurrent);
            int mpptTrackNumber = queryLong2[10].getValue();
            machineinfo.setMpptTrackNumber(mpptTrackNumber);
            String machinetype = new String(queryLong2[11].toBytes()).trim();
            String gridtype = new String(queryLong2[12].toBytes()).trim();
            machineinfo.setTopology(gridtype.equals("0") ? "transformerless" : "transformer");
            String qsvfw = "";
            int item3 = 13;
            while (item3 < 17) {
                qsvfw = String.valueOf(qsvfw) + new String(queryLong2[item3].toBytes()).trim();
                ++item3;
            }
            machineinfo.setSlaveFirmwareVersion(qsvfw);
            String timeStr = "";
            int item4 = 36;
            while (item4 < 41) {
                timeStr = String.valueOf(timeStr) + new String(queryLong2[item4].toBytes());
                ++item4;
            }
            Date date = DateUtils.parseDate(timeStr, "yyyyMMddHH");
            if (date != null) {
                this.enerystarttime = Calendar.getInstance();
                this.enerystarttime.setTime(date);
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean queryCapability() {
        boolean result = true;
        ModbusHandler handler = this.getHandler();
        if (handler == null) {
            return false;
        }
        Capability capability = (Capability)this.getBeanBag().getBean("capability");
        try {
            BitVector bits = new BitVector(16);
            Register[] reg = handler.readMultipleRegisters(14, 1);
            bits.setBytes(reg[0].toBytes(), 16);
            bits.toggleAccess(true);
            capability.setCapableA(bits.getBit(0));
            capability.setCapableP(bits.getBit(13));
        }
        catch (Exception e) {
            result = false;
            System.err.println(e.getMessage());
        }
        return result;
    }

    public void setWarningStatus(BitVector warnStatus, WorkInfo workinfo) {
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 1, "2001", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 2, "2002", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 3, "2003", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 4, "2004", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 5, "2005", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 6, "2006", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 7, "2007", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 8, "2008", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 9, "2009", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 10, "2010", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 11, "2011", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 12, "2012", workinfo);
        this.refreshWarningStatus(warnStatus, this.oldWarnings, 13, "2013", workinfo);
        this.oldWarnings = warnStatus;
    }

    @Override
    public Calendar queryCurrentTime() {
        String timeStr;
        Calendar ca;
        block6: {
            ModbusHandler handler = this.getHandler();
            if (handler == null) {
                return null;
            }
            try {
                ca = null;
                Register[] queryTime = handler.readMultipleRegisters(275, 7);
                timeStr = "";
                int item = 0;
                while (item < queryTime.length) {
                    timeStr = String.valueOf(timeStr) + new String(queryTime[item].toBytes());
                    ++item;
                }
                if (timeStr.trim().length() == 14) break block6;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Date date = DateUtils.parseDate(timeStr, "yyyyMMddHHmmss");
        if (date != null) {
            ca = Calendar.getInstance();
            ca.setTime(date);
        }
        return ca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyDay(Calendar trandate) throws Exception {
        Object object = this.query_day;
        synchronized (object) {
            double returnValue = 0.0;
            ModbusHandler handler = this.getHandler();
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String value = DateUtils.getFormatDate(trandate.getTime(), "yyyyMMdd");
            byte[] bytes1 = value.substring(0, 2).getBytes();
            byte[] bytes2 = value.substring(2, 4).getBytes();
            byte[] bytes3 = value.substring(4, 6).getBytes();
            byte[] bytes4 = value.substring(6).getBytes();
            Register[] regs = new Register[]{new SimpleRegister(bytes1[0], bytes1[1]), new SimpleRegister(bytes2[0], bytes2[1]), new SimpleRegister(bytes3[0], bytes3[1]), new SimpleRegister(bytes4[0], bytes4[1])};
            boolean querysuccess = false;
            int sendtimes = 0;
            while (!querysuccess) {
                if (++sendtimes >= 3) {
                    throw new Exception(" Query energy failure: " + value);
                }
                handler.writeMultipleRegisters(453, regs);
                boolean querycompleted = false;
                int try_i = 0;
                while (!querycompleted && try_i < 3) {
                    Thread.sleep(600L);
                    Register[] queryD = handler.readMultipleRegisters(411, 2);
                    returnValue = P15ModbusProcessor.convert2Regiters(queryD[0], queryD[1]);
                    querycompleted = this.energyqueryCompleted(returnValue);
                    ++try_i;
                }
                querysuccess = this.energyquerySuccess(returnValue);
            }
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyHour(Calendar trandate, int hour) throws Exception {
        Object object = this.query_hour;
        synchronized (object) {
            double returnValue = 0.0;
            ModbusHandler handler = this.getHandler();
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String hourStr = String.valueOf(hour).length() < 2 ? "0" + hour : String.valueOf(hour);
            String value = String.valueOf(DateUtils.getFormatDate(trandate.getTime(), "yyyyMMdd")) + hourStr;
            byte[] bytes1 = value.substring(0, 2).getBytes();
            byte[] bytes2 = value.substring(2, 4).getBytes();
            byte[] bytes3 = value.substring(4, 6).getBytes();
            byte[] bytes4 = value.substring(6, 8).getBytes();
            byte[] bytes5 = value.substring(8).getBytes();
            Register[] regs = new Register[]{new SimpleRegister(bytes1[0], bytes1[1]), new SimpleRegister(bytes2[0], bytes2[1]), new SimpleRegister(bytes3[0], bytes3[1]), new SimpleRegister(bytes4[0], bytes4[1]), new SimpleRegister(bytes5[0], bytes5[1])};
            boolean querysuccess = false;
            int sendtimes = 0;
            while (!querysuccess) {
                if (++sendtimes >= 3) {
                    throw new Exception(" Query energy failure: " + value);
                }
                handler.writeMultipleRegisters(448, regs);
                boolean querycompleted = false;
                int try_i = 0;
                while (!querycompleted && try_i < 3) {
                    Thread.sleep(600L);
                    Register[] queryH = handler.readMultipleRegisters(409, 2);
                    returnValue = P15ModbusProcessor.convert2Regiters(queryH[0], queryH[1]);
                    querycompleted = this.energyqueryCompleted(returnValue);
                    ++try_i;
                }
                querysuccess = this.energyquerySuccess(returnValue);
            }
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyMonth(int year, int month) throws Exception {
        Object object = this.query_month;
        synchronized (object) {
            double returnValue = 0.0;
            ModbusHandler handler = this.getHandler();
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String monthStr = String.valueOf(month).length() < 2 ? "0" + month : String.valueOf(month);
            String value = year + monthStr;
            byte[] bytes1 = value.substring(0, 2).getBytes();
            byte[] bytes2 = value.substring(2, 4).getBytes();
            byte[] bytes3 = value.substring(4).getBytes();
            Register[] regs = new Register[]{new SimpleRegister(bytes1[0], bytes1[1]), new SimpleRegister(bytes2[0], bytes2[1]), new SimpleRegister(bytes3[0], bytes3[1])};
            boolean querysuccess = false;
            int sendtimes = 0;
            while (!querysuccess) {
                if (++sendtimes >= 3) {
                    throw new Exception(" Query energy failure: " + value);
                }
                handler.writeMultipleRegisters(457, regs);
                boolean querycompleted = false;
                int try_i = 0;
                while (!querycompleted && try_i < 3) {
                    Thread.sleep(600L);
                    Register[] queryM = handler.readMultipleRegisters(413, 2);
                    returnValue = P15ModbusProcessor.convert2Regiters(queryM[0], queryM[1]);
                    querycompleted = this.energyqueryCompleted(returnValue);
                    ++try_i;
                }
                querysuccess = this.energyquerySuccess(returnValue);
            }
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyYear(int year) throws Exception {
        Object object = this.query_year;
        synchronized (object) {
            double returnValue = 0.0;
            ModbusHandler handler = this.getHandler();
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String value = "" + year;
            byte[] bytes1 = value.substring(0, 2).getBytes();
            byte[] bytes2 = value.substring(2).getBytes();
            Register[] regs = new Register[]{new SimpleRegister(bytes1[0], bytes1[1]), new SimpleRegister(bytes2[0], bytes2[1])};
            boolean querysuccess = false;
            int sendtimes = 0;
            while (!querysuccess) {
                if (++sendtimes >= 3) {
                    throw new Exception(" Query energy failure: " + value);
                }
                handler.writeMultipleRegisters(460, regs);
                boolean querycompleted = false;
                int try_i = 0;
                while (!querycompleted && try_i < 3) {
                    Thread.sleep(600L);
                    Register[] queryY = handler.readMultipleRegisters(415, 2);
                    returnValue = P15ModbusProcessor.convert2Regiters(queryY[0], queryY[1]);
                    querycompleted = this.energyqueryCompleted(returnValue);
                    ++try_i;
                }
                querysuccess = this.energyquerySuccess(returnValue);
            }
            return returnValue;
        }
    }

    @Override
    public boolean queryConfigData() {
        boolean result = true;
        try {
            ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
            ModbusHandler handler = this.getHandler();
            if (handler == null) {
                throw new Exception("handler is null");
            }
            Register[] queryFrequency = handler.readMultipleRegisters(1168, 1);
            double frequency = (double)queryFrequency[0].getValue() / 10.0;
            if (frequency == 50.0) {
                configdata.setMinGridoutputlowF(45.0);
                configdata.setMaxGridoutputlowF(49.8);
                configdata.setMinGridoutputhighF(50.2);
                configdata.setMaxGridoutputhighF(54.8);
            } else if (frequency == 60.0) {
                configdata.setMinGridoutputlowF(55.0);
                configdata.setMaxGridoutputlowF(59.8);
                configdata.setMinGridoutputhighF(60.2);
                configdata.setMaxGridoutputhighF(64.8);
            }
            Register[] queryFV = handler.readMultipleRegisters(850, 8);
            configdata.setGridoutputhighV(queryFV[0].getValue());
            configdata.setGridoutputlowV(queryFV[1].getValue());
            configdata.setGridoutputhighF((double)queryFV[2].getValue() / 10.0);
            configdata.setGridoutputlowF((double)queryFV[3].getValue() / 10.0);
            String gridwaittimeStr = String.valueOf(new String(queryFV[6].toBytes())) + new String(queryFV[7].toBytes());
            int gridwait = 0;
            try {
                gridwait = Integer.parseInt(gridwaittimeStr.trim());
            }
            catch (Exception e) {
                gridwait = 5;
                e.printStackTrace();
            }
            configdata.setGridwaittime(gridwait);
            configdata.setMinGridWaittime(5);
            configdata.setMaxGridWaittime(999);
            configdata.setMinGridoutputlowV(176.0);
            configdata.setMaxGridoutputlowV(220.0);
            configdata.setMinGridoutputhighV(240.0);
            configdata.setMaxGridoutputhighV(276.0);
            Register[] queryModel = handler.readMultipleRegisters(1017, 2);
            configdata.setMinMaxoutputPower(0);
            configdata.setMaxMaxoutputPower((int)P15ModbusProcessor.convert2Regiters(queryModel[0], queryModel[1]));
            Register[] query = handler.readMultipleRegisters(1037, 5);
            configdata.setMaxoutputPower((int)P15ModbusProcessor.convert2Regiters(query[0], query[1]));
            configdata.setPvInputLowV(query[2].getValue());
            configdata.setPvInputHighV(query[3].getValue());
            configdata.setLcdSleepTime(new String(query[4].toBytes()));
            configdata.setMinPvInputHighV(configdata.getPvInputLowV() + 10);
            configdata.setMaxPvInputHighV(510);
            configdata.setMinPvInputLowV(90);
            configdata.setMaxPvInputLowV(configdata.getPvInputHighV() - 10);
            configdata.setMaxGridAvgHighV(264);
            configdata.setMinGridAvgHighV(253);
            Register[] query2 = handler.readMultipleRegisters(1484, 3);
            configdata.setGridAvgHighV(query2[0].getValue());
            configdata.setMpptHighV(query2[1].getValue());
            configdata.setMpptLowV(query2[2].getValue());
            configdata.setMinMpptHighV(configdata.getMpptLowV() + 10);
            configdata.setMaxMpptHighV(450);
            configdata.setMinMpptLowV(110);
            configdata.setMaxMpptLowV(configdata.getMpptHighV() - 10);
            Register[] queryPVN = handler.readMultipleRegisters(1177, 1);
            configdata.setPvnNumber(queryPVN[0].getValue());
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void queryEnergyBeginDate() {
        ModbusHandler handler = this.getHandler();
        if (handler == null) {
            return;
        }
        try {
            Date date;
            Register[] queryTime = handler.readMultipleRegisters(1203, 5);
            String timeStr = "";
            int item = 0;
            while (item < queryTime.length) {
                timeStr = String.valueOf(timeStr) + new String(queryTime[item].toBytes()).trim();
                ++item;
            }
            if (timeStr.trim().length() == 10 && (date = DateUtils.parseDate(timeStr, "yyyyMMddHH")) != null) {
                this.enerystarttime = Calendar.getInstance();
                this.enerystarttime.setTime(date);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println(Integer.parseInt("030"));
    }

    @Override
    public void querySelfTestResult() {
        ModbusHandler handler = this.getHandler();
        if (handler == null) {
            return;
        }
        try {
            Register[] query = handler.readMultipleRegisters(596, 9);
            int resultValue = query[0].getValue();
            if (resultValue != 0) {
                SelfTestResult result = (SelfTestResult)this.getBeanBag().getBean("selftestresult");
                if (resultValue == 1) {
                    result.setResult("PASS");
                } else {
                    result.setResult("FAIL");
                }
                MachineInfo machineinfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                result.setModelName("Solar inverter");
                result.setFwVersion(String.valueOf(machineinfo.getMainFirmwareVersion()) + "/" + machineinfo.getSlaveFirmwareVersion());
                result.setHighVoltage((double)query[1].getValue() / 10.0);
                result.setLowVoltage((double)query[2].getValue() / 10.0);
                result.setHighFrequency((double)query[3].getValue() / 10.0);
                result.setLowFrequency((double)query[4].getValue() / 10.0);
                result.setHighVoltageT(query[5].getValue());
                result.setLowVoltageT(query[6].getValue());
                result.setHighFrequencyT(query[7].getValue());
                result.setLowFrequencyT(query[8].getValue());
                result.setDateStr(DateUtils.getFormatDate(this.getCurrentTime().getTime(), DateUtils.getDateFormat(true)));
                result.setTimeStr(DateUtils.getFormatDate(this.getCurrentTime().getTime(), "HH:mm"));
                EventsHandler.handleEvent(this.getProtocol().getProtocolID(), this.getProtocol().getSerialNo(), this.getCurrentTime().getTime(), "3009");
                this.setStartQuerySelfTestResult(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean queryDefaultData() {
        ModbusHandler handler = this.getHandler();
        if (handler == null) {
            return false;
        }
        boolean result = true;
        return result;
    }

    @Override
    public boolean supportSelfTest() {
        boolean result = false;
        ModbusHandler handler = this.getHandler();
        if (handler == null) {
            return result;
        }
        try {
            Register[] query = handler.readMultipleRegisters(1473, 1);
            result = query[0].getValue() == 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public float getFWVersion() {
        return 0.0f;
    }

    @Override
    public float queryFWVersion() {
        return 0.0f;
    }

    @Override
    public String getDeviceMode() {
        return null;
    }

    @Override
    public boolean queryDeviceModel() {
        return false;
    }

    @Override
    public double queryEnergyTotal() {
        return 0.0;
    }
}

