/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class InstallCert {
    public static void main(String[] args) {
        try {
            InstallCert.insertCert("voltronic.com.tw");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void insertCert(String address) throws Exception {
        File dir;
        String[] c = address.split(":");
        String host = c[0];
        int port = c.length == 1 ? 443 : Integer.parseInt(c[1]);
        String p = "changeit";
        char[] passphrase = p.toCharArray();
        char SEP = File.separatorChar;
        String path = String.valueOf(System.getProperty("java.home")) + SEP + "lib" + SEP + "security";
        File file = new File(String.valueOf(path) + SEP + "jssecacerts");
        if (!file.isFile() && !(file = new File(dir = new File(path), "jssecacerts")).isFile()) {
            file = new File(dir, "cacerts");
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(file);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(in, passphrase);
            ((InputStream)in).close();
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
            socket.setSoTimeout(10000);
            try {
                socket.startHandshake();
                socket.close();
            }
            catch (SSLException e) {
                e.printStackTrace();
            }
            X509Certificate[] chain = tm.chain;
            if (chain == null) {
                return;
            }
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                int i = 0;
                while (i < chain.length) {
                    X509Certificate cert = chain[i];
                    sha1.update(cert.getEncoded());
                    md5.update(cert.getEncoded());
                    ++i;
                }
                X509Certificate cert = chain[0];
                String alias = String.valueOf(host) + "-" + 1;
                ks.setCertificateEntry(alias, cert);
                out = new FileOutputStream(String.valueOf(path) + SEP + "jssecacerts");
                ks.store(out, passphrase);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

