/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.dao.DeviceDao;
import cn.com.voltronic.solar.data.bean.DeviceBean;
import cn.com.voltronic.solar.data.bean.EnergyBean;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AAComboBox;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.AAPanel;
import cn.com.voltronic.solar.view.component.ComponentFactory;
import cn.com.voltronic.solar.view.component.I18NListener;
import cn.com.voltronic.solar.view.component.MyCalendarPanel;
import cn.com.voltronic.solar.webservice.WebServices;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.TextAnchor;

public class HistoryEnergyChart
extends AAPanel {
    private static final long serialVersionUID = 5760694448382544782L;
    public AAButton closeButton;
    private AAButton jButton3;
    private JComboBox jComboBox1;
    private AAComboBox jComboBox3;
    private AAComboBox jComboBox4;
    private AAComboBox jComboBox5;
    private AALabel jLabel1;
    private AALabel jLabel2;
    private AALabel jLabel3;
    private AALabel jLabel4;
    private AALabel jLabel5;
    private AALabel hourLabel;
    private AALabel jLabel8;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JSpinner yearSpinner1;
    private JSpinner yearSpinner2;
    private JSpinner hourSpinner1;
    private JSpinner hourSpinner2;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private WebServices energyComputer = null;
    private DefaultCategoryDataset dataset = null;
    private JFreeChart chart = null;
    private CategoryPlot categoryPlot = null;
    private ValueAxis rangeAxis = null;
    private DeviceDao dao = new DeviceDao();

    public HistoryEnergyChart() {
        String serialno;
        this.energyComputer = new WebServices();
        this.initComponents();
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null && !StringUtils.isEmpty((String)(serialno = processor.getProtocol().getSerialNo().trim()))) {
            this.jComboBox1.setSelectedItem(serialno);
            this.setCycleModel(serialno);
        }
    }

    private void setCycleModel(String serialno) {
        DeviceBean bean = this.dao.queryDevicebySerialno(serialno);
        if (bean.getProdid().equals("P18") || bean.getProdid().equals("P1834K") || bean.getProdid().equals("P1812K")) {
            this.jComboBox3.setModel(new String[]{"message.year", "message.month", "message.day"});
            this.jComboBox3.setSelectedIndex(0);
            this.setPeriod();
        } else {
            this.jComboBox3.setModel(new String[]{"message.year", "message.month", "message.day", "message.hour"});
            this.jComboBox3.setSelectedIndex(0);
            this.setPeriod();
        }
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jLabel1 = new AALabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new AALabel();
        this.jLabel8 = new AALabel();
        this.jTextField1 = new JTextField();
        this.jLabel3 = new AALabel();
        this.jLabel4 = new AALabel();
        this.jLabel5 = new AALabel();
        this.hourLabel = new AALabel();
        this.jButton3 = new AAButton();
        this.jTextField2 = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.closeButton = new AAButton();
        this.jComboBox3 = new AAComboBox();
        this.jComboBox4 = new AAComboBox();
        this.jComboBox5 = new AAComboBox();
        this.yearSpinner1 = ComponentFactory.createNumberSpinner(2010, DateUtils.getCurrentYear() + 200, 1, DateUtils.getCurrentYear());
        this.yearSpinner2 = ComponentFactory.createNumberSpinner(2010, DateUtils.getCurrentYear() + 200, 1, DateUtils.getCurrentYear());
        this.hourSpinner1 = ComponentFactory.createNumberSpinner(0, 23, 1, DateUtils.getCurrentHour());
        this.hourSpinner2 = ComponentFactory.createNumberSpinner(0, 23, 1, DateUtils.getCurrentHour());
        this.setLayout(new BorderLayout());
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("message.device[:]");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(this.queryDevices()));
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String serialno = HistoryEnergyChart.this.jComboBox1.getSelectedItem().toString().trim();
                if (!StringUtils.isEmpty((String)serialno)) {
                    HistoryEnergyChart.this.setCycleModel(serialno);
                }
            }
        });
        this.jComboBox3.setModel(new String[]{"message.year", "message.month", "message.day", "message.hour"});
        this.jComboBox3.setSelectedIndex(0);
        this.jComboBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryEnergyChart.this.setPeriod();
            }
        });
        this.jLabel2.setText("message.cycle[:]");
        this.jLabel8.setText(":");
        String[] monthArr = new String[]{"message.january", "message.february", "message.march", "message.april", "message.may", "message.june", "message.july", "message.august", "message.september", "message.october", "message.november", "message.december"};
        this.jComboBox4.setModel(monthArr);
        this.jComboBox5.setModel(monthArr);
        this.hourLabel.setText("message.hour");
        this.jLabel3.setIcon(new ImageIcon(Constants.DATE));
        this.jLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEnergyChart.this.jTextField1);
                calendarPanel.setBounds(HistoryEnergyChart.this.getX() + HistoryEnergyChart.this.jLabel3.getX() + 30, HistoryEnergyChart.this.getY() + HistoryEnergyChart.this.jLabel3.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jTextField1.setEditable(false);
        this.jTextField1.setBackground(I18NListener.bgColor);
        this.jTextField1.setText(DateUtils.getNowDate());
        this.jTextField1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEnergyChart.this.jTextField1);
                calendarPanel.setBounds(HistoryEnergyChart.this.getX() + HistoryEnergyChart.this.jLabel3.getX() + 30, HistoryEnergyChart.this.getY() + HistoryEnergyChart.this.jLabel3.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jLabel4.setText("--");
        this.jLabel5.setIcon(new ImageIcon(Constants.DATE));
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEnergyChart.this.jTextField2);
                calendarPanel.setBounds(HistoryEnergyChart.this.getX() + HistoryEnergyChart.this.jLabel5.getX() + 30, HistoryEnergyChart.this.getY() + HistoryEnergyChart.this.jLabel5.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jTextField2.setEditable(false);
        this.jTextField2.setBackground(I18NListener.bgColor);
        this.jTextField2.setText(DateUtils.getNowDate());
        this.jTextField2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(HistoryEnergyChart.this.jTextField2);
                calendarPanel.setBounds(HistoryEnergyChart.this.getX() + HistoryEnergyChart.this.jLabel5.getX() + 30, HistoryEnergyChart.this.getY() + HistoryEnergyChart.this.jLabel5.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jButton3.setText("message.view");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryEnergyChart.this.viewAction();
            }
        });
        try {
            this.dataset = new DefaultCategoryDataset();
            this.chart = ChartFactory.createBarChart((String)"", (String)"", (String)"kWh", (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            this.chart.setBackgroundPaint((Paint)Constants.BG_COLOR);
            this.categoryPlot = this.chart.getCategoryPlot();
            this.categoryPlot.setBackgroundPaint((Paint)Constants.BG_COLOR);
            this.categoryPlot.setDomainGridlinePaint((Paint)Constants.BG_COLOR);
            this.categoryPlot.setDomainGridlinesVisible(true);
            this.categoryPlot.setRangeGridlinePaint((Paint)Color.white);
            CategoryAxis categoryAxis = this.categoryPlot.getDomainAxis();
            categoryAxis.setLabelPaint((Paint)Color.white);
            categoryAxis.setTickLabelPaint((Paint)Color.white);
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
            this.rangeAxis = this.categoryPlot.getRangeAxis();
            this.rangeAxis.setUpperMargin(0.1);
            this.rangeAxis.setLabelPaint((Paint)Color.white);
            this.rangeAxis.setTickLabelPaint((Paint)Color.white);
            BarRenderer barRenderer = (BarRenderer)this.categoryPlot.getRenderer();
            barRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
            barRenderer.setBaseItemLabelsVisible(true);
            barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER));
            barRenderer.setItemLabelsVisible(true);
            barRenderer.setPaint((Paint)new Color(232, 107, 30));
            barRenderer.setMinimumBarLength(0.02);
            barRenderer.setMaxBarWidth(0.07);
            barRenderer.setItemLabelPaint((Paint)Color.white);
            ChartPanel chartPane = new ChartPanel(this.chart);
            this.jScrollPane1.setViewportView((Component)chartPane);
        }
        catch (Exception ex) {
            System.err.println("history energy chart error");
        }
        this.setPeriod();
        this.add((Component)this.jPanel3, "Center");
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.closeButton.setText("message.close");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(734, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addGap(12, 12, 12)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton)).addContainerGap()));
        this.add((Component)this.jPanel4, "Last");
    }

    private void setPeriod() {
        if (this.jComboBox3.getSelectedIndex() == 0) {
            this.yearSpinner1.setVisible(true);
            this.yearSpinner2.setVisible(true);
            this.jComboBox4.setVisible(false);
            this.jComboBox5.setVisible(false);
            this.jTextField1.setVisible(false);
            this.jTextField2.setVisible(false);
            this.jLabel3.setVisible(false);
            this.jLabel5.setVisible(false);
            this.hourSpinner1.setVisible(false);
            this.hourSpinner2.setVisible(false);
            this.hourLabel.setVisible(false);
            GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
            this.jPanel3.setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 950, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearSpinner1, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearSpinner2, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3))).addContainerGap()));
            jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButton3).addComponent(this.yearSpinner2, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.yearSpinner1, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 447, Short.MAX_VALUE).addContainerGap()));
        } else if (this.jComboBox3.getSelectedIndex() == 1) {
            this.yearSpinner1.setVisible(true);
            this.yearSpinner2.setVisible(false);
            this.jComboBox4.setVisible(true);
            this.jComboBox5.setVisible(true);
            this.jTextField1.setVisible(false);
            this.jTextField2.setVisible(false);
            this.jLabel3.setVisible(false);
            this.jLabel5.setVisible(false);
            this.hourSpinner1.setVisible(false);
            this.hourSpinner2.setVisible(false);
            this.hourLabel.setVisible(false);
            GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
            this.jPanel3.setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 950, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearSpinner1, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox4, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox5, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3))).addContainerGap()));
            jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButton3).addComponent(this.jComboBox5, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jComboBox4, -2, -1, -2).addComponent(this.yearSpinner1, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 447, Short.MAX_VALUE).addContainerGap()));
        } else if (this.jComboBox3.getSelectedIndex() == 2) {
            this.yearSpinner1.setVisible(false);
            this.yearSpinner2.setVisible(false);
            this.jComboBox4.setVisible(false);
            this.jComboBox5.setVisible(false);
            this.jTextField1.setVisible(true);
            this.jTextField2.setVisible(true);
            this.jLabel3.setVisible(true);
            this.jLabel5.setVisible(true);
            this.hourSpinner1.setVisible(false);
            this.hourSpinner2.setVisible(false);
            this.hourLabel.setVisible(false);
            GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
            this.jPanel3.setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 950, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3))).addContainerGap()));
            jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.jButton3).addComponent(this.jLabel4).addComponent(this.jLabel8).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 447, Short.MAX_VALUE).addContainerGap()));
        } else if (this.jComboBox3.getSelectedIndex() == 3) {
            this.yearSpinner1.setVisible(false);
            this.yearSpinner2.setVisible(false);
            this.jComboBox4.setVisible(false);
            this.jComboBox5.setVisible(false);
            this.jTextField1.setVisible(true);
            this.jTextField2.setVisible(false);
            this.jLabel3.setVisible(true);
            this.jLabel5.setVisible(false);
            this.hourSpinner1.setVisible(true);
            this.hourSpinner2.setVisible(true);
            this.hourLabel.setVisible(true);
            GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
            this.jPanel3.setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 950, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hourSpinner1, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hourSpinner2, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hourLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3))).addContainerGap()));
            jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.hourLabel).addComponent(this.hourSpinner2, -2, -1, -2).addComponent(this.hourSpinner1, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jLabel2).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 448, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.CENTER, jPanel3Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jButton3).addGap(463, 463, 463)));
        }
    }

    public void viewAction() {
        if (this.jComboBox1.getSelectedItem() != null) {
            String serialno = this.jComboBox1.getSelectedItem().toString().trim();
            this.dataset.clear();
            if (this.jComboBox3.getSelectedIndex() == 0) {
                String processorKey = "";
                int startyear = VolUtil.parseInt(this.yearSpinner1.getValue().toString());
                int endyear = VolUtil.parseInt(this.yearSpinner2.getValue().toString());
                boolean queryHistory = true;
                double maxValue = 0.0;
                List<EnergyBean> energyList = this.energyComputer.queryYearwithoutPrice(processorKey, serialno, startyear, endyear, queryHistory);
                int i = 0;
                while (i < energyList.size()) {
                    double quantity = energyList.get(i).getQuantity();
                    if (maxValue < quantity) {
                        maxValue = quantity;
                    }
                    this.dataset.addValue(quantity, (Comparable)((Object)bd.getString("message.year")), (Comparable)((Object)String.valueOf(energyList.get(i).getYear())));
                    ++i;
                }
                if (maxValue <= 0.0) {
                    maxValue = 100.0;
                }
                this.rangeAxis.setRange(0.0, maxValue + maxValue * 0.35);
            } else if (this.jComboBox3.getSelectedIndex() == 1) {
                String processorKey = "";
                int startyear = VolUtil.parseInt(this.yearSpinner1.getValue().toString());
                int endyear = VolUtil.parseInt(this.yearSpinner2.getValue().toString());
                int startmonth = this.jComboBox4.getSelectedIndex() + 1;
                int endmonth = this.jComboBox5.getSelectedIndex() + 1;
                boolean queryHistory = true;
                double maxValue = 0.0;
                List<EnergyBean> energyList = this.energyComputer.queryMonthwithoutPrice(processorKey, serialno, startyear, startmonth, endyear, endmonth, queryHistory);
                int i = 0;
                while (i < energyList.size()) {
                    double quantity = energyList.get(i).getQuantity();
                    if (maxValue < quantity) {
                        maxValue = quantity;
                    }
                    this.dataset.addValue(quantity, (Comparable)((Object)bd.getString("message.month")), (Comparable)((Object)String.valueOf(energyList.get(i).getYearmonth())));
                    ++i;
                }
                if (maxValue <= 0.0) {
                    maxValue = 100.0;
                }
                this.rangeAxis.setRange(0.0, maxValue + maxValue * 0.35);
            } else if (this.jComboBox3.getSelectedIndex() == 2) {
                String processorKey = "";
                String startDate = this.jTextField1.getText().trim();
                String endDate = this.jTextField2.getText().trim();
                SimpleDateFormat format = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
                Date fromDate = new Date();
                Date toDate = new Date();
                try {
                    fromDate = format.parse(startDate);
                    toDate = format.parse(endDate);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Calendar startdate = Calendar.getInstance();
                startdate.setTime(fromDate);
                Calendar enddate = Calendar.getInstance();
                enddate.setTime(toDate);
                boolean queryHistory = true;
                double maxValue = 0.0;
                List<EnergyBean> energyList = this.energyComputer.queryDaywithoutPrice(processorKey, serialno, startdate, enddate, queryHistory);
                int i = 0;
                while (i < energyList.size()) {
                    double quantity = energyList.get(i).getQuantity();
                    if (maxValue < quantity) {
                        maxValue = quantity;
                    }
                    this.dataset.addValue(quantity, (Comparable)((Object)bd.getString("message.day")), (Comparable)((Object)DateUtils.getFormatDate(energyList.get(i).getTrandate().getTime())));
                    ++i;
                }
                if (maxValue <= 0.0) {
                    maxValue = 100.0;
                }
                this.rangeAxis.setRange(0.0, maxValue + maxValue * 0.35);
            } else if (this.jComboBox3.getSelectedIndex() == 3) {
                String processorKey = "";
                String startDate = this.jTextField1.getText().trim();
                SimpleDateFormat format = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
                Date fromDate = new Date();
                Date toDate = new Date();
                try {
                    fromDate = format.parse(startDate);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Calendar startdate = Calendar.getInstance();
                startdate.setTime(fromDate);
                Calendar enddate = Calendar.getInstance();
                enddate.setTime(toDate);
                int starthour = VolUtil.parseInt(this.hourSpinner1.getValue().toString());
                int endhour = VolUtil.parseInt(this.hourSpinner2.getValue().toString());
                boolean queryHistory = true;
                double maxValue = 0.0;
                List<EnergyBean> energyList = this.energyComputer.queryHourwithoutPrice(processorKey, serialno, startdate, starthour, (Calendar)startdate.clone(), endhour, queryHistory);
                int i = 0;
                while (i < energyList.size()) {
                    double quantity = energyList.get(i).getQuantity();
                    if (maxValue < quantity) {
                        maxValue = quantity;
                    }
                    this.dataset.addValue(quantity, (Comparable)((Object)bd.getString("message.hour")), (Comparable)((Object)String.valueOf(energyList.get(i).getHour())));
                    ++i;
                }
                if (maxValue <= 0.0) {
                    maxValue = 100.0;
                }
                this.rangeAxis.setRange(0.0, maxValue + maxValue * 0.35);
            }
        }
    }

    public String[] queryDevices() {
        List<String> devicelist = this.dao.querySerialnoAll("P18", "P1834K", "P1812K");
        String[] devices = new String[devicelist.size()];
        int i = 0;
        while (i < devicelist.size()) {
            devices[i] = devicelist.get(i);
            ++i;
        }
        return devices;
    }
}

