/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.configure.ConfigureTools;
import cn.com.voltronic.solar.configure.CustomerConfig;
import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.EnergyData;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P16;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.Clock;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.AboutJDialog;
import cn.com.voltronic.solar.view.BasicJDialog;
import cn.com.voltronic.solar.view.COMSetJDialog;
import cn.com.voltronic.solar.view.EmailSetting;
import cn.com.voltronic.solar.view.EventActionDialog;
import cn.com.voltronic.solar.view.HistoryDataJDialog;
import cn.com.voltronic.solar.view.HistoryEnergyDialog;
import cn.com.voltronic.solar.view.HistoryEventDialog;
import cn.com.voltronic.solar.view.HistoryFaultDataDialog;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.ModelChangeP16;
import cn.com.voltronic.solar.view.ModelChangeP17;
import cn.com.voltronic.solar.view.MonitoredInfoJDialog;
import cn.com.voltronic.solar.view.ParameterJDialog;
import cn.com.voltronic.solar.view.ParameterJDialogP18;
import cn.com.voltronic.solar.view.PasswordJDialog;
import cn.com.voltronic.solar.view.PowerInfoJFrame;
import cn.com.voltronic.solar.view.PriceJDialog;
import cn.com.voltronic.solar.view.RealControlJDialog15;
import cn.com.voltronic.solar.view.RealControlJDialog16;
import cn.com.voltronic.solar.view.RealControlJDialog17;
import cn.com.voltronic.solar.view.RealControlJDialog18;
import cn.com.voltronic.solar.view.RestoreJDialog;
import cn.com.voltronic.solar.view.SMSSetting;
import cn.com.voltronic.solar.view.SynchronizeDataJDialog;
import cn.com.voltronic.solar.view.component.AAButtonTip;
import cn.com.voltronic.solar.view.component.AAJMenu;
import cn.com.voltronic.solar.view.component.AAJMenuItem;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.I18NBundle;
import cn.com.voltronic.solar.view.component.VPTree;
import cn.com.voltronic.solar.view.panel.BasePanel;
import cn.com.voltronic.solar.view.panel.StatusPanel;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;

public class MainJFrame
extends JFrame {
    private static final long serialVersionUID = -3494660164922508506L;
    private static MainJFrame mainFrame = null;
    private Clock clock = null;
    private AbstractProcessor currProcesser = null;
    private JMenuBar menuBar = null;
    private JPanel centerPanel;
    private JPanel changePanel;
    private AAButtonTip statusButton;
    private AAButtonTip parameterButton;
    private AAButtonTip powerButton;
    private AAButtonTip dataButton;
    private AAButtonTip eventButton;
    private AAButtonTip faultButton;
    public static AAButtonTip loginButton;
    public static AALabel loginLabel;
    private AALabel monitoredLabelC;
    private AALabel monitoredLabelV;
    private AALabel deviceTimeLabelC;
    private AALabel deviceTimeLabelV;
    private AALabel temperatureLabelC;
    private AALabel temperatureLabelV;
    private AALabel temperatureLabelU;
    private JSplitPane jSplitPane;
    private static VPTree deviceTree;
    private JScrollPane leftScrollPane;
    private JScrollPane treeScrollPane;
    private JPanel treePanel;
    private JLabel logoLabel;
    private JPanel mainPanel;
    private JPanel northPanel;
    private StatusPanel statusPanel;
    private static Integer lock;
    private static Integer menuLock;
    public IProtocol protocol = null;
    private String oldModelName = "";
    private int oldMpptTrackNumber = 2;
    private IProtocol oldProtocol = new P16();

    static {
        lock = 1;
        menuLock = 2;
        try {
            Properties props = new Properties();
            props.put("foregroundColor", "255 255 255");
            props.put("frameColor", "130 130 130");
            props.put("gridColor", "210 210 210");
            props.put("logoString", "");
            props.put("tooltipBackgroundColor", "102 102 102");
            props.put("tooltipForegroundColor", "255 255 255");
            props.put("selectionBackgroundColor", "230 230 230");
            props.put("menuSelectionForegroundColor", "0 0 0");
            props.put("menuSelectionBackgroundColor", "230 230 230");
            props.put("menuSelectionBackgroundColorLight", "255 255 255");
            props.put("menuSelectionBackgroundColorDark", "230 230 230");
            props.put("menuBackgroundColor", "90 90 90");
            props.put("menuColorLight", "69 69 69");
            props.put("menuColorDark", "102 102 102");
            props.put("menuForegroundColor", "255 255 255");
            props.put("controlColor", "102 102 102");
            props.put("controlColorLight", "102 102 102");
            props.put("controlColorDark", "69 69 69");
            props.put("buttonForegroundColor", "255 255 255");
            props.put("buttonColor", "102 102 102");
            props.put("buttonBackgroundColor", "102 102 102");
            props.put("buttonColorLight", "230 230 230");
            props.put("buttonColorDark", "102 102 102");
            props.put("rolloverColor", "102 102 102");
            props.put("rolloverColorLight", "102 102 102");
            props.put("rolloverColorDark", "69 69 69");
            props.put("windowTitleForegroundColor", "0 0 0");
            props.put("windowTitleBackgroundColor", "69 69 69");
            props.put("windowTitleColorLight", "197 197 197");
            props.put("windowTitleColorDark", "69 69 69");
            props.put("windowBorderColor", "10 10 10");
            props.put("tabAreaBackgroundColor", "102 102 102");
            props.put("inputForegroundColor", "255 255 255");
            props.put("inputBackgroundColor", "102 102 102");
            props.put("focusColor", "255 255 255");
            props.put("focusCellColor", "255 255 255");
            props.put("backgroundColor", "102 102 102");
            props.put("backgroundColorLight", "255 255 255");
            props.put("backgroundColorDark", "102 102 102");
            SmartLookAndFeel.setCurrentTheme((Properties)props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.smart.SmartLookAndFeel");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MainJFrame() {
        this.menuBar = new JMenuBar();
        this.initMenu();
        this.setJMenuBar(this.menuBar);
        this.initComponents();
        Dimension ds = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 1280;
        int height = 800;
        if (ds.getWidth() < (double)width) {
            width = (int)ds.getWidth();
        }
        if (ds.getHeight() < (double)height) {
            height = (int)ds.getHeight();
        }
        this.setSize(width - 20, height - 45);
        this.setTitle(GlobalVariables.customerConfig.getCustomerName());
        this.setIconImage(Constants.CONNECTEDIMG);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainJFrame getNewInstance() {
        Integer n = lock;
        synchronized (n) {
            if (mainFrame == null) {
                mainFrame = new MainJFrame();
                mainFrame.setVisible(true);
            }
            return mainFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMenu() {
        Integer n = menuLock;
        synchronized (n) {
            if (this.menuBar != null) {
                this.menuBar.removeAll();
                this.protocol = new P16();
                this.currProcesser = GlobalProcessors.getCurrentProcessor();
                if (this.currProcesser != null) {
                    this.protocol = this.currProcesser.getProtocol();
                }
                if (this.protocol == null) {
                    this.protocol = new P16();
                }
                AutoMenuList autoMenuList = this.protocol.getMenuList();
                List<AutoMenuOne> autoMenuOneList = autoMenuList.getMenuList();
                int i = 0;
                while (i < autoMenuOneList.size()) {
                    List<AutoMenuTwo> autoMenuTwoList = autoMenuOneList.get(i).getItems();
                    String label = autoMenuOneList.get(i).getLabel();
                    AAJMenu autoMenuOne = new AAJMenu();
                    autoMenuOne.setText(label);
                    int j = 0;
                    while (j < autoMenuTwoList.size()) {
                        Object autoMenuItem;
                        List<AutoMenuItem> items = autoMenuTwoList.get(j).getItems();
                        if (items == null) {
                            autoMenuItem = autoMenuTwoList.get(j).getItem();
                            AAJMenuItem menuItemTwo = new AAJMenuItem();
                            menuItemTwo.setText(((AutoMenuItem)autoMenuItem).getLabel());
                            final int data = ((AutoMenuItem)autoMenuItem).getData();
                            menuItemTwo.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MainJFrame.this.menuItemAction(data, MainJFrame.this.protocol);
                                }
                            });
                            autoMenuOne.add(menuItemTwo);
                        } else {
                            autoMenuItem = new AAJMenu();
                            ((AAJMenu)autoMenuItem).setText(autoMenuTwoList.get(j).getItem().getLabel());
                            int k = 0;
                            while (k < items.size()) {
                                AAJMenuItem menuItemThree = new AAJMenuItem();
                                menuItemThree.setText(items.get(k).getLabel());
                                final int data = items.get(k).getData();
                                menuItemThree.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        MainJFrame.this.menuItemAction(data, MainJFrame.this.protocol);
                                    }
                                });
                                ((JMenu)autoMenuItem).add(menuItemThree);
                                ++k;
                            }
                            autoMenuOne.add((JMenuItem)autoMenuItem);
                        }
                        ++j;
                    }
                    this.menuBar.add(autoMenuOne);
                    ++i;
                }
            }
        }
    }

    private void menuItemAction(int data, IProtocol protocol) {
        String prodid = protocol.getProtocolID();
        switch (data) {
            case 101: {
                new BasicJDialog((Frame)mainFrame, true);
                break;
            }
            case 102: {
                new PasswordJDialog((Frame)mainFrame, true);
                break;
            }
            case 103: {
                new PriceJDialog((Frame)mainFrame, true);
                break;
            }
            case 104: {
                new SMSSetting((Frame)mainFrame, true);
                break;
            }
            case 105: {
                new EmailSetting((Frame)mainFrame, true);
                break;
            }
            case 106: {
                new EventActionDialog((Frame)mainFrame, true);
                break;
            }
            case 107: {
                new COMSetJDialog((Frame)mainFrame, true);
                break;
            }
            case 200: {
                if (protocol.getProtocolID().equals("P17") || protocol.getProtocolID().equals("P175K") || protocol.getProtocolID().equals("P17P1S1") || protocol.getProtocolID().equals("P1730K")) {
                    new ModelChangeP17((Frame)mainFrame, true);
                    break;
                }
                new ModelChangeP16((Frame)mainFrame, true);
                break;
            }
            case 201: {
                if (protocol.getProtocolID().equals("P18") || protocol.getProtocolID().equals("P1834K") || protocol.getProtocolID().equals("P1812K")) {
                    new ParameterJDialogP18((Frame)mainFrame, true);
                    break;
                }
                new ParameterJDialog((Frame)mainFrame, true);
                break;
            }
            case 202: {
                new RestoreJDialog((Frame)mainFrame, true);
                break;
            }
            case 203: {
                new SynchronizeDataJDialog((Frame)mainFrame, true);
                break;
            }
            case 204: {
                if (protocol.getProtocolID().equals("P15")) {
                    new RealControlJDialog15((Frame)mainFrame, true);
                    break;
                }
                if (protocol.getProtocolID().equals("P16")) {
                    new RealControlJDialog16((Frame)mainFrame, true);
                    break;
                }
                if (protocol.getProtocolID().equals("P17") || protocol.getProtocolID().equals("P175K") || protocol.getProtocolID().equals("P17P1S1") || protocol.getProtocolID().equals("P1730K")) {
                    new RealControlJDialog17((Frame)mainFrame, true);
                    break;
                }
                if (protocol.getProtocolID().equals("P18") || protocol.getProtocolID().equals("P1834K") || protocol.getProtocolID().equals("P1812K")) {
                    new RealControlJDialog18((Frame)mainFrame, true);
                    break;
                }
                new RealControlJDialog16((Frame)mainFrame, true);
                break;
            }
            case 301: {
                new HistoryEnergyDialog((Frame)mainFrame, true);
                break;
            }
            case 302: {
                new HistoryDataJDialog((Frame)mainFrame, true);
                break;
            }
            case 303: {
                new HistoryFaultDataDialog((Frame)mainFrame, true);
                break;
            }
            case 304: {
                new HistoryEventDialog((Frame)mainFrame, true);
                break;
            }
            case 305: {
                new MonitoredInfoJDialog((Frame)mainFrame, true);
                break;
            }
            case 306: {
                PowerInfoJFrame powerInfoJFrame = PowerInfoJFrame.getInstance();
                if (powerInfoJFrame == null) {
                    powerInfoJFrame = new PowerInfoJFrame(mainFrame);
                    PowerInfoJFrame.setInstance(powerInfoJFrame);
                }
                powerInfoJFrame.setVisible(true);
                powerInfoJFrame.scheduleAction();
                break;
            }
            case 401: {
                I18NBundle.changeUS();
                this.updateLanguage("en_US");
                break;
            }
            case 402: {
                I18NBundle.changeFR();
                this.updateLanguage("fr_FR");
                break;
            }
            case 403: {
                I18NBundle.changeDE();
                this.updateLanguage("de_DE");
                break;
            }
            case 404: {
                I18NBundle.changeIT();
                this.updateLanguage("it_IT");
                break;
            }
            case 405: {
                I18NBundle.changePL();
                this.updateLanguage("pl_PL");
                break;
            }
            case 406: {
                I18NBundle.changePT();
                this.updateLanguage("pt_PT");
                break;
            }
            case 407: {
                I18NBundle.changeRUS();
                this.updateLanguage("ru_RU");
                break;
            }
            case 408: {
                I18NBundle.changeSP();
                this.updateLanguage("es_ES");
                break;
            }
            case 409: {
                I18NBundle.changeUKR();
                this.updateLanguage("uk_UA");
                break;
            }
            case 410: {
                I18NBundle.changeTUR();
                this.updateLanguage("tr_TR");
                break;
            }
            case 411: {
                I18NBundle.changeCN();
                this.updateLanguage("zh_CN");
                break;
            }
            case 412: {
                I18NBundle.changeTW();
                this.updateLanguage("zh_TW");
                break;
            }
            case 413: {
                I18NBundle.changeJP();
                this.updateLanguage("ja_JP");
                break;
            }
            case 501: {
                new AboutJDialog((Frame)mainFrame, true);
                break;
            }
            case 502: {
                CustomerConfig custormerConfig = GlobalVariables.customerConfig;
                if (custormerConfig.isEnglish()) {
                    if (prodid.equals("P15") || prodid.equals("P20")) {
                        this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P15");
                        break;
                    }
                    if (prodid.equals("P16")) {
                        this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                        break;
                    }
                    if (prodid.equals("P17") || prodid.equals("P1730K")) {
                        this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17");
                        break;
                    }
                    if (prodid.equals("P175K") || prodid.equals("P17P1S1")) {
                        this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17COMM");
                        break;
                    }
                    if (prodid.equals("P18") || prodid.equals("P1834K") || prodid.equals("P1812K")) {
                        this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P18");
                        break;
                    }
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                    break;
                }
                if (custormerConfig.isTurkish()) {
                    if (prodid.equals("P15") || prodid.equals("P20")) {
                        this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P15");
                        break;
                    }
                    if (prodid.equals("P16")) {
                        this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                        break;
                    }
                    if (prodid.equals("P17") || prodid.equals("P1730K")) {
                        this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17");
                        break;
                    }
                    if (prodid.equals("P175K") || prodid.equals("P17P1S1")) {
                        this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17COMM");
                        break;
                    }
                    if (prodid.equals("P18") || prodid.equals("P1834K") || prodid.equals("P1812K")) {
                        this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P18");
                        break;
                    }
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                    break;
                }
                if (!custormerConfig.isRussian()) break;
                if (prodid.equals("P15") || prodid.equals("P20")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P15");
                    break;
                }
                if (prodid.equals("P16")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                    break;
                }
                if (prodid.equals("P17") || prodid.equals("P1730K")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17");
                    break;
                }
                if (prodid.equals("P175K") || prodid.equals("P17P1S1")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17COMM");
                    break;
                }
                if (prodid.equals("P18") || prodid.equals("P1834K") || prodid.equals("P1812K")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P18");
                    break;
                }
                this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                break;
            }
            case 5021: {
                if (prodid.equals("P15") || prodid.equals("P20")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P15");
                    break;
                }
                if (prodid.equals("P16")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                    break;
                }
                if (prodid.equals("P17") || prodid.equals("P1730K")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17");
                    break;
                }
                if (prodid.equals("P175K") || prodid.equals("P17P1S1")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17COMM");
                    break;
                }
                if (prodid.equals("P18") || prodid.equals("P1834K") || prodid.equals("P1812K")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P18");
                    break;
                }
                this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                break;
            }
            case 5022: {
                if (prodid.equals("P15") || prodid.equals("P20")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P15");
                    break;
                }
                if (prodid.equals("P16")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                    break;
                }
                if (prodid.equals("P17") || prodid.equals("P1730K")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17");
                    break;
                }
                if (prodid.equals("P175K") || prodid.equals("P17P1S1")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17COMM");
                    break;
                }
                if (prodid.equals("P18") || prodid.equals("P1834K") || prodid.equals("P1812K")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P18");
                    break;
                }
                this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                break;
            }
            case 5023: {
                if (prodid.equals("P15") || prodid.equals("P20")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P15");
                    break;
                }
                if (prodid.equals("P16")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                    break;
                }
                if (prodid.equals("P17") || prodid.equals("P1730K")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17");
                    break;
                }
                if (prodid.equals("P175K") || prodid.equals("P17P1S1")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P17COMM");
                    break;
                }
                if (prodid.equals("P18") || prodid.equals("P1834K") || prodid.equals("P1812K")) {
                    this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P18");
                    break;
                }
                this.openURL(String.valueOf(System.getProperty("user.dir")) + File.separator + "help" + File.separator + "P16");
                break;
            }
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.northPanel = new JPanel();
        this.statusButton = new AAButtonTip();
        this.parameterButton = new AAButtonTip();
        this.powerButton = new AAButtonTip();
        this.dataButton = new AAButtonTip();
        this.eventButton = new AAButtonTip();
        this.faultButton = new AAButtonTip();
        loginButton = new AAButtonTip();
        loginLabel = new AALabel();
        this.monitoredLabelC = new AALabel();
        this.monitoredLabelV = new AALabel();
        this.deviceTimeLabelC = new AALabel();
        this.deviceTimeLabelV = new AALabel();
        this.temperatureLabelC = new AALabel();
        this.temperatureLabelV = new AALabel();
        this.temperatureLabelU = new AALabel();
        this.centerPanel = new JPanel();
        this.jSplitPane = new JSplitPane();
        this.leftScrollPane = new JScrollPane();
        this.treeScrollPane = new JScrollPane();
        this.treePanel = new JPanel();
        this.logoLabel = new JLabel();
        this.changePanel = new JPanel();
        this.statusPanel = new StatusPanel();
        deviceTree = new VPTree();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                mainFrame.setVisible(false);
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        this.statusButton.setIcon(new ImageIcon(Constants.STATUSIMG));
        this.statusButton.setToolTipText("message.monitorPointInfo");
        this.statusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new MonitoredInfoJDialog((Frame)mainFrame, true);
            }
        });
        this.parameterButton.setIcon(new ImageIcon(Constants.PARAMETERIMG));
        this.parameterButton.setToolTipText("message.parametersSetting");
        this.parameterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String prodid = MainJFrame.this.protocol.getProtocolID();
                if (prodid.equals("P18") || prodid.equals("P1834K") || prodid.equals("P1812K")) {
                    new ParameterJDialogP18((Frame)mainFrame, true);
                } else {
                    new ParameterJDialog((Frame)mainFrame, true);
                }
            }
        });
        this.powerButton.setIcon(new ImageIcon(Constants.POWERIMG));
        this.powerButton.setToolTipText("message.queryPower");
        this.powerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HistoryEnergyDialog((Frame)mainFrame, true);
            }
        });
        this.dataButton.setIcon(new ImageIcon(Constants.DATAIMG));
        this.dataButton.setToolTipText("message.queryData");
        this.dataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HistoryDataJDialog((Frame)mainFrame, true);
            }
        });
        this.eventButton.setIcon(new ImageIcon(Constants.EVENTIMG));
        this.eventButton.setToolTipText("message.queryEvent");
        this.eventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HistoryEventDialog((Frame)mainFrame, true);
            }
        });
        this.faultButton.setIcon(new ImageIcon(Constants.FAULTIMG));
        this.faultButton.setToolTipText("message.queryFaultData");
        this.faultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HistoryFaultDataDialog((Frame)mainFrame, true);
            }
        });
        if (SolarPowerTray.isLogin) {
            loginButton.setIcon(new ImageIcon(Constants.LOGOUTIMG));
            loginButton.setToolTipText("message.logout");
            loginLabel.setText("message.localManager");
        } else {
            loginButton.setIcon(new ImageIcon(Constants.LOGINIMG));
            loginButton.setToolTipText("message.login");
            loginLabel.setText("message.observer");
        }
        loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog((Frame)mainFrame, true);
                } else {
                    int result = DisplayMessage.showConfirmDialog("message.asklogout", "message.logout");
                    if (result == 0) {
                        SolarPowerTray.isLogin = false;
                        loginButton.setIcon(new ImageIcon(Constants.LOGINIMG));
                        loginButton.setToolTipText("message.login");
                        loginLabel.setText("message.observer");
                    }
                }
            }
        });
        this.monitoredLabelC.setText("message.currentMonitor[:]");
        this.monitoredLabelV.setText("---");
        this.deviceTimeLabelC.setText("message.machineTime[:]");
        this.runClock();
        this.temperatureLabelC.setText("message.temperature[:]");
        this.temperatureLabelV.setText("---");
        this.temperatureLabelU.setText("\u2103");
        this.northPanel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout northPanelLayout = new GroupLayout(this.northPanel);
        this.northPanel.setLayout(northPanelLayout);
        northPanelLayout.setHorizontalGroup(northPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(northPanelLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.statusButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parameterButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.powerButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.eventButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.faultButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(loginButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(loginLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.monitoredLabelC).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.monitoredLabelV).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.deviceTimeLabelC).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deviceTimeLabelV).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.temperatureLabelC).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.temperatureLabelV).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.temperatureLabelU).addContainerGap(56, Short.MAX_VALUE)));
        northPanelLayout.setVerticalGroup(northPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusButton).addComponent(this.parameterButton).addComponent(this.powerButton).addComponent(this.dataButton).addComponent(this.eventButton).addComponent(this.faultButton).addComponent(loginButton).addGroup(northPanelLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(northPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(loginLabel).addComponent(this.monitoredLabelC).addComponent(this.monitoredLabelV).addComponent(this.deviceTimeLabelC).addComponent(this.deviceTimeLabelV).addComponent(this.temperatureLabelC).addComponent(this.temperatureLabelV).addComponent(this.temperatureLabelU))));
        this.mainPanel.add((Component)this.northPanel, "North");
        this.centerPanel.setLayout(new BorderLayout());
        deviceTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        DefaultMutableTreeNode selectionNode = (DefaultMutableTreeNode)deviceTree.getLastSelectedPathComponent();
                        if (!selectionNode.isRoot()) {
                            Object selectionObj = selectionNode.getUserObject();
                            String itemString = selectionObj.toString();
                            GlobalProcessors.setCurrentProcesserIfExist(itemString);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.treePanel.setLayout(new BorderLayout());
        this.treeScrollPane.setViewportView(deviceTree);
        this.treePanel.add((Component)this.treeScrollPane, "Center");
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Constants.CUSTOMERIMAGES_PATH) + GlobalVariables.customerConfig.getCustomerLogo()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (icon != null) {
            this.logoLabel.setIcon(icon);
        }
        this.treePanel.add((Component)this.logoLabel, "South");
        this.leftScrollPane.setViewportView(this.treePanel);
        this.jSplitPane.setLeftComponent(this.leftScrollPane);
        this.changePanel.setLayout(new BorderLayout());
        this.changePanel.add((Component)this.statusPanel, "Center");
        this.jSplitPane.setRightComponent(this.changePanel);
        this.jSplitPane.setDividerLocation(250);
        this.centerPanel.add((Component)this.jSplitPane, "Center");
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void openURL(String url) {
        try {
            File file1 = new File(String.valueOf(url) + ".swf");
            File file2 = new File(String.valueOf(url) + ".pdf");
            File file3 = new File(String.valueOf(url) + ".doc");
            if (file1.exists()) {
                if (Constants.IS_OS_WINDOWS) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + file1);
                } else {
                    Runtime.getRuntime().exec(file1.getAbsolutePath());
                }
            } else if (file2.exists()) {
                if (Constants.IS_OS_WINDOWS) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + file2);
                } else if (Constants.IS_OS_LINUX) {
                    Runtime.getRuntime().exec("chmod 777 " + url + ".pdf");
                    Runtime.getRuntime().exec("evince " + url + ".pdf");
                } else if (Constants.IS_OS_SOLARIS) {
                    Runtime.getRuntime().exec("chmod 777 " + url + ".pdf");
                    Runtime.getRuntime().exec("gpdf " + url + ".pdf");
                } else if (Constants.IS_OS_MAC || Constants.IS_OS_MAC_OSX) {
                    Runtime.getRuntime().exec("chmod 777 " + url + ".pdf");
                    Runtime.getRuntime().exec("open " + url + ".pdf");
                } else {
                    Runtime.getRuntime().exec(file2.getAbsolutePath());
                }
            } else if (file3.exists()) {
                if (Constants.IS_OS_WINDOWS) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + file3);
                } else {
                    Runtime.getRuntime().exec(file3.getAbsolutePath());
                }
            } else {
                DisplayMessage.showErrorDialog("File is missing!");
            }
        }
        catch (Exception ex) {
            DisplayMessage.showErrorDialog("Please install the PDF reader.");
        }
    }

    public void refreshClock() {
        block10: {
            if (this.currProcesser != null) {
                try {
                    Date date = this.currProcesser.getCurrentTime().getTime();
                    if (date != null) {
                        String source = this.deviceTimeLabelV.getText().trim();
                        if (!source.equals("---")) {
                            long textTime;
                            SimpleDateFormat dateFormat = new SimpleDateFormat(String.valueOf(GlobalVariables.globalConfig.getDateFormat()) + " HH:mm:ss");
                            Date textDate = dateFormat.parse(source);
                            long dateTime = date.getTime();
                            if (dateTime - (textTime = textDate.getTime()) > 20000L || textTime - dateTime > 20000L) {
                                if (this.clock != null) {
                                    this.clock.setGo(false);
                                }
                                this.clock = new Clock(date, this.deviceTimeLabelV);
                                this.clock.setGo(true);
                                this.clock.start();
                            }
                        } else {
                            if (this.clock != null) {
                                this.clock.setGo(false);
                            }
                            this.clock = new Clock(date, this.deviceTimeLabelV);
                            this.clock.setGo(true);
                            this.clock.start();
                        }
                        break block10;
                    }
                    this.deviceTimeLabelV.setText("---");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this.deviceTimeLabelV.setText("---");
            }
        }
    }

    private void runClock() {
        block12: {
            if (this.currProcesser != null) {
                try {
                    Calendar ca = this.currProcesser.getCurrentTime();
                    if (ca != null) {
                        Date date = ca.getTime();
                        if (date != null) {
                            String source = this.deviceTimeLabelV.getText().trim();
                            if (!source.equals("---")) {
                                long textTime;
                                SimpleDateFormat dateFormat = new SimpleDateFormat(String.valueOf(GlobalVariables.globalConfig.getDateFormat()) + " HH:mm:ss");
                                Date textDate = dateFormat.parse(source);
                                long dateTime = date.getTime();
                                if (dateTime - (textTime = textDate.getTime()) > 20000L || textTime - dateTime > 20000L) {
                                    if (this.clock != null) {
                                        this.clock.setGo(false);
                                    }
                                    this.clock = new Clock(date, this.deviceTimeLabelV);
                                    this.clock.setGo(true);
                                    this.clock.start();
                                }
                            } else {
                                if (this.clock != null) {
                                    this.clock.setGo(false);
                                }
                                this.clock = new Clock(date, this.deviceTimeLabelV);
                                this.clock.setGo(true);
                                this.clock.start();
                            }
                        } else {
                            this.deviceTimeLabelV.setText("---");
                        }
                        break block12;
                    }
                    this.deviceTimeLabelV.setText("---");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this.deviceTimeLabelV.setText("---");
            }
        }
    }

    private void updateLanguage(String language) {
        try {
            GlobalVariables.properties.setProperty("GLOBAL_CONFIG", "Language", language);
            GlobalVariables.properties.store();
            ConfigureTools.wrapProperties(GlobalVariables.globalConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshDeviceTree() {
        List<String> devices = GlobalProcessors.getSolarList();
        deviceTree.refreshTree(devices);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                deviceTree.updateUI();
            }
        });
    }

    public void refreshWorkInfo() {
        AbstractProcessor processer = GlobalProcessors.getCurrentProcessor();
        if (processer == null) {
            return;
        }
        WorkInfo workInfo = null;
        EnergyData energydata = null;
        if (processer != null) {
            workInfo = (WorkInfo)processer.getBeanBag().getBean("workinfo");
            energydata = (EnergyData)processer.getBeanBag().getBean("energydata");
        }
        if (workInfo == null) {
            workInfo = new WorkInfo();
        }
        if (energydata == null) {
            energydata = new EnergyData();
        }
        this.refreshWorkInfo(workInfo);
        this.refreshReal(workInfo);
        this.refreshEnergyData(energydata);
        this.refreshEnergyChart(energydata, workInfo);
    }

    public void refreshWorkInfo(WorkInfo workInfo) {
        this.currProcesser = GlobalProcessors.getCurrentProcessor();
        if (this.currProcesser != null) {
            BasePanel basePanel;
            IProtocol protocol = this.currProcesser.getProtocol();
            int mpptTrackNumber = this.currProcesser.getProtocol().getMpptTrackNumber();
            String modelName = this.currProcesser.getProtocol().getModelName();
            if (!this.oldProtocol.getProtocolID().equals(protocol.getProtocolID()) || this.oldMpptTrackNumber != mpptTrackNumber || !this.oldModelName.equals(modelName)) {
                if (this.statusPanel.basePanel != null) {
                    this.statusPanel.baseJSPanel.remove(this.statusPanel.basePanel);
                    this.statusPanel.basePanel = null;
                }
                this.statusPanel.basePanel = basePanel = new BasePanel();
                this.statusPanel.baseJSPanel.setViewportView(this.statusPanel.basePanel);
                this.oldMpptTrackNumber = mpptTrackNumber;
                if (!this.oldProtocol.getProtocolID().equals(protocol.getProtocolID()) || this.oldProtocol.isSupportModelSetting() != protocol.isSupportModelSetting() || !this.oldModelName.equals(modelName)) {
                    this.initMenu();
                    this.oldProtocol = protocol;
                }
                this.oldModelName = modelName;
            }
            if (this.statusPanel.basePanel != null) {
                this.statusPanel.basePanel.refreshWorkInfo(workInfo);
                if (workInfo.isNeedToReresh()) {
                    this.statusPanel.baseJSPanel.remove(this.statusPanel.basePanel);
                    this.statusPanel.basePanel = null;
                    this.statusPanel.basePanel = basePanel = new BasePanel();
                    this.statusPanel.baseJSPanel.setViewportView(this.statusPanel.basePanel);
                    workInfo.setNeedToReresh(false);
                }
            }
        }
        this.runClock();
        if (this.currProcesser != null) {
            String deviceName = this.currProcesser.getDeviceName();
            String serailNo = this.currProcesser.getSerialNo();
            if (deviceName != null && !"".equals(deviceName) && serailNo != null && !"".equals(serailNo)) {
                this.monitoredLabelV.setText(String.valueOf(deviceName) + "_" + serailNo);
            }
            this.temperatureLabelV.setText(VolUtil.getTemperature(String.valueOf(workInfo.getMaxTemperature())));
        } else {
            this.monitoredLabelV.setText("---");
            this.temperatureLabelV.setText("---");
        }
        this.temperatureLabelU.setText(VolUtil.getTempUnit());
    }

    public void refreshEnergyData(EnergyData energydata) {
        this.statusPanel.powerChartsPanel.refreshWork(energydata);
    }

    public void refreshEnergyChart(EnergyData energydata, WorkInfo workInfo) {
        this.statusPanel.powerPanel.refreshWork(energydata, workInfo);
    }

    public void refreshReal(WorkInfo workInfo) {
        this.statusPanel.realPanel.refreshWork(workInfo);
    }

    public void setDefaultValues() {
        BasePanel basePanel;
        this.oldProtocol = new P16();
        this.oldMpptTrackNumber = 2;
        this.initMenu();
        this.statusPanel.baseJSPanel.remove(this.statusPanel.basePanel);
        this.statusPanel.basePanel = null;
        this.statusPanel.basePanel = basePanel = new BasePanel();
        this.statusPanel.baseJSPanel.setViewportView(this.statusPanel.basePanel);
        this.monitoredLabelV.setText("---");
        if (this.clock != null) {
            this.clock.setGo(false);
        }
        this.deviceTimeLabelV.setText("---");
        this.temperatureLabelV.setText("---");
        this.temperatureLabelU.setText("\u2103");
        this.statusPanel.realPanel.setDefaultValues();
        this.statusPanel.basePanel.setDefaultValues();
        this.statusPanel.powerPanel.setDefaultValues();
        this.statusPanel.powerChartsPanel.removeAll();
        this.statusPanel.powerChartsPanel.initComponents();
    }
}

