/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.RuleBasedCollator;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.CollatorSQLClob;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;

public class SQLClob
extends SQLVarchar {
    public String getTypeName() {
        return "CLOB";
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLClob(this.getString());
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLClob();
    }

    public StringDataValue getValue(RuleBasedCollator ruleBasedCollator) {
        if (ruleBasedCollator == null) {
            return this;
        }
        CollatorSQLClob collatorSQLClob = new CollatorSQLClob(ruleBasedCollator);
        collatorSQLClob.copyState(this);
        return collatorSQLClob;
    }

    public int getTypeFormatId() {
        return 447;
    }

    public SQLClob() {
    }

    public SQLClob(String string) {
        super(string);
    }

    public int typePrecedence() {
        return 14;
    }

    public Object getObject() throws StandardException {
        throw this.dataTypeConversion("java.lang.Object");
    }

    public boolean getBoolean() throws StandardException {
        throw this.dataTypeConversion("boolean");
    }

    public byte getByte() throws StandardException {
        throw this.dataTypeConversion("byte");
    }

    public short getShort() throws StandardException {
        throw this.dataTypeConversion("short");
    }

    public int getInt() throws StandardException {
        throw this.dataTypeConversion("int");
    }

    public long getLong() throws StandardException {
        throw this.dataTypeConversion("long");
    }

    public float getFloat() throws StandardException {
        throw this.dataTypeConversion("float");
    }

    public double getDouble() throws StandardException {
        throw this.dataTypeConversion("double");
    }

    public int typeToBigDecimal() throws StandardException {
        throw this.dataTypeConversion("java.math.BigDecimal");
    }

    public byte[] getBytes() throws StandardException {
        throw this.dataTypeConversion("byte[]");
    }

    public Date getDate(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Date");
    }

    public Time getTime(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Time");
    }

    public Timestamp getTimestamp(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Timestamp");
    }

    public final String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.getStream() != null) {
            return this.getTypeName() + "(" + this.getStream().toString() + ")";
        }
        return this.getTypeName() + "(" + this.getLength() + ")";
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof SQLClob) {
            SQLClob sQLClob = (SQLClob)dataValueDescriptor;
            if (sQLClob.stream != null) {
                this.copyState(sQLClob);
                return;
            }
        }
        super.normalize(dataTypeDescriptor, dataValueDescriptor);
    }

    public void setValue(Time time, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Time");
    }

    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Timestamp");
    }

    public void setValue(Date date, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Date");
    }

    public void setBigDecimal(Number number) throws StandardException {
        this.throwLangSetMismatch("java.math.BigDecimal");
    }

    public void setValue(int n) throws StandardException {
        this.throwLangSetMismatch("int");
    }

    public void setValue(double d) throws StandardException {
        this.throwLangSetMismatch("double");
    }

    public void setValue(float f) throws StandardException {
        this.throwLangSetMismatch("float");
    }

    public void setValue(short s) throws StandardException {
        this.throwLangSetMismatch("short");
    }

    public void setValue(long l) throws StandardException {
        this.throwLangSetMismatch("long");
    }

    public void setValue(byte by) throws StandardException {
        this.throwLangSetMismatch("byte");
    }

    public void setValue(boolean bl) throws StandardException {
        this.throwLangSetMismatch("boolean");
    }

    public void setValue(byte[] byArray) throws StandardException {
        this.throwLangSetMismatch("byte[]");
    }

    final void setObject(Object object) throws StandardException {
        Clob clob = (Clob)object;
        try {
            long l = clob.length();
            if (l < 0L || l > Integer.MAX_VALUE) {
                throw this.outOfRange();
            }
            this.setValue(new ReaderToUTF8Stream(clob.getCharacterStream(), (int)l, 0, "CLOB"), (int)l);
        }
        catch (SQLException sQLException) {
            throw this.dataTypeConversion("DAN-438-tmp");
        }
    }
}

