/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.ReplicateScaleFilter;
import sun.awt.image.SurfaceManager;

public abstract class Image {
    private static ImageCapabilities defaultImageCaps = new ImageCapabilities(false);
    protected float accelerationPriority = 0.5f;
    public static final Object UndefinedProperty = new Object();
    public static final int SCALE_DEFAULT = 1;
    public static final int SCALE_FAST = 2;
    public static final int SCALE_SMOOTH = 4;
    public static final int SCALE_REPLICATE = 8;
    public static final int SCALE_AREA_AVERAGING = 16;
    SurfaceManager surfaceManager;

    public abstract int getWidth(ImageObserver var1);

    public abstract int getHeight(ImageObserver var1);

    public abstract ImageProducer getSource();

    public abstract Graphics getGraphics();

    public abstract Object getProperty(String var1, ImageObserver var2);

    public Image getScaledInstance(int n, int n2, int n3) {
        ReplicateScaleFilter replicateScaleFilter = (n3 & 0x14) != 0 ? new AreaAveragingScaleFilter(n, n2) : new ReplicateScaleFilter(n, n2);
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.getSource(), replicateScaleFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public void flush() {
        if (this.surfaceManager != null) {
            this.surfaceManager.flush();
        }
    }

    public ImageCapabilities getCapabilities(GraphicsConfiguration graphicsConfiguration) {
        if (this.surfaceManager != null) {
            return this.surfaceManager.getCapabilities(graphicsConfiguration);
        }
        return defaultImageCaps;
    }

    public void setAccelerationPriority(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Priority must be a value between 0 and 1, inclusive");
        }
        this.accelerationPriority = f;
        if (this.surfaceManager != null) {
            this.surfaceManager.setAccelerationPriority(this.accelerationPriority);
        }
    }

    public float getAccelerationPriority() {
        return this.accelerationPriority;
    }

    static {
        SurfaceManager.setImageAccessor(new SurfaceManager.ImageAccessor(){

            @Override
            public SurfaceManager getSurfaceManager(Image image) {
                return image.surfaceManager;
            }

            @Override
            public void setSurfaceManager(Image image, SurfaceManager surfaceManager) {
                image.surfaceManager = surfaceManager;
            }
        });
    }
}

