/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.CORBA;

import com.sun.corba.se.impl.javax.rmi.CORBA.StubDelegateImpl;
import com.sun.corba.se.impl.orbutil.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.util.Properties;
import javax.rmi.CORBA.GetORBPropertiesFileAction;
import javax.rmi.CORBA.StubDelegate;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CORBA_2_3.portable.ObjectImpl;

public abstract class Stub
extends ObjectImpl
implements Serializable {
    private static final long serialVersionUID = 1087775603798577179L;
    private transient StubDelegate stubDelegate = null;
    private static Class stubDelegateClass = null;
    private static final String StubClassKey = "javax.rmi.CORBA.StubClass";

    @Override
    public int hashCode() {
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null) {
            return this.stubDelegate.hashCode(this);
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null) {
            return this.stubDelegate.equals(this, object);
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null) {
            String string = this.stubDelegate.toString(this);
            if (string == null) {
                return super.toString();
            }
            return string;
        }
        return super.toString();
    }

    public void connect(ORB oRB) throws RemoteException {
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null) {
            this.stubDelegate.connect(this, oRB);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null) {
            this.stubDelegate.readObject(this, objectInputStream);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null) {
            this.stubDelegate.writeObject(this, objectOutputStream);
        }
    }

    private void setDefaultDelegate() {
        if (stubDelegateClass != null) {
            try {
                this.stubDelegate = (StubDelegate)stubDelegateClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Object createDelegate(String string) {
        Properties properties;
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction(string));
        if (string2 == null && (properties = Stub.getORBPropertiesFile()) != null) {
            string2 = properties.getProperty(string);
        }
        if (string2 == null) {
            return new StubDelegateImpl();
        }
        try {
            return Stub.loadDelegateClass(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            INITIALIZE iNITIALIZE = new INITIALIZE("Cannot instantiate " + string2);
            iNITIALIZE.initCause(classNotFoundException);
            throw iNITIALIZE;
        }
        catch (Exception exception) {
            INITIALIZE iNITIALIZE = new INITIALIZE("Error while instantiating" + string2);
            iNITIALIZE.initCause(exception);
            throw iNITIALIZE;
        }
    }

    private static Class loadDelegateClass(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return RMIClassLoader.loadClass(string);
            }
            catch (MalformedURLException malformedURLException) {
                String string2 = "Could not load " + string + ": " + malformedURLException.toString();
                ClassNotFoundException classNotFoundException2 = new ClassNotFoundException(string2);
                throw classNotFoundException2;
            }
        }
    }

    private static Properties getORBPropertiesFile() {
        return (Properties)AccessController.doPrivileged(new GetORBPropertiesFileAction());
    }

    static {
        Object object = Stub.createDelegate(StubClassKey);
        if (object != null) {
            stubDelegateClass = object.getClass();
        }
    }
}

