/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.softeupgrade;

import cn.com.voltronic.gui.I18NBundle;
import cn.com.voltronic.softeupgrade.DisplayMessage;
import cn.com.voltronic.softeupgrade.GenerateCheckSum;
import cn.com.voltronic.softeupgrade.InstallDialog;
import cn.com.voltronic.softeupgrade.InstallDialog15;
import cn.com.voltronic.softeupgrade.InstallDialog16;
import cn.com.voltronic.softeutil.Config;
import cn.com.voltronic.softeutil.GZip;
import cn.com.voltronic.softeutil.PropertiesIni;
import cn.com.voltronic.softeutil.ReadDatFile;
import cn.com.voltronic.softeutil.ReadTempDatFile;
import cn.com.voltronic.softeutil.UpgradeConstants;
import cn.com.voltronic.softeutil.ZipToFile;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class InstallUpgrade
extends Thread {
    protected static Logger logger = Logger.getLogger(InstallUpgrade.class);
    private String fromFile;
    private String fileName;
    private InstallDialog dialog = null;
    private volatile boolean isOver;
    private volatile int stauts = 0;

    public InstallUpgrade(String fromFile, String fileName) {
        this.initFace();
        this.fromFile = fromFile;
        this.fileName = fileName;
        String currentLanguage = "en_US";
        try {
            String path = String.valueOf(System.getProperty("user.dir")) + File.separator + "config" + File.separator + "config.properties";
            Properties pro = new Properties();
            pro.load(new FileInputStream(path));
            currentLanguage = pro.getProperty("Language");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.changeLanguage(currentLanguage);
    }

    public void colseTip() {
        if (this.stauts == 0) {
            DisplayMessage.showErrorDialog("message.cannotOption0", "message.tiptitle");
        } else if (this.stauts == 1) {
            DisplayMessage.showErrorDialog("message.cannotOption1", "message.tiptitle");
        } else if (this.stauts == 2) {
            DisplayMessage.showErrorDialog("message.cannotOption2", "message.tiptitle");
        } else if (this.stauts == 3) {
            DisplayMessage.showErrorDialog("message.cannotOption3", "message.tiptitle");
        }
    }

    public void copyFile(File inFile, File outFile) throws Exception {
        int size = 0;
        FileOutputStream fos = null;
        FileInputStream fis = null;
        byte[] buf = new byte[1024];
        try {
            fis = new FileInputStream(inFile);
            fos = new FileOutputStream(outFile);
            while ((size = fis.read(buf)) != -1) {
                fos.write(buf, 0, size);
                fos.flush();
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        outFile.setLastModified(inFile.lastModified());
    }

    public boolean backupFiles(List<File> files, PropertiesIni ini) {
        this.stauts = 1;
        boolean isOK = true;
        float sizesum = 0.0f;
        this.dialog.progress.setValue(0);
        this.dialog.note.setText("message.backup");
        for (File file : files) {
            try {
                if (!file.getName().equals("update.ini")) {
                    String s = ini.getString(file.getName());
                    String[] fileStr = s.split(";");
                    File ifile = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + fileStr[0]);
                    if (ifile.exists()) {
                        try {
                            File ofile;
                            String dir = String.valueOf(UpgradeConstants.BACKUPSTR) + fileStr[0];
                            File backFile = null;
                            backFile = UpgradeConstants.IS_OS_WINDOWS ? new File(dir.substring(0, dir.lastIndexOf("\\"))) : new File(dir.substring(0, dir.lastIndexOf("/")));
                            if (!backFile.exists()) {
                                backFile.mkdirs();
                            }
                            if (!(ofile = new File(String.valueOf(UpgradeConstants.BACKUPSTR) + fileStr[0])).exists()) {
                                ofile.createNewFile();
                            }
                            this.copyFile(ifile, ofile);
                        }
                        catch (Exception e) {
                            isOK = false;
                        }
                    }
                }
                float len = (sizesum += 1.0f) / (float)files.size() * 100.0f;
                this.dialog.progress.setValue(Math.round(len));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isOK;
    }

    public boolean replaceFiles(List<File> files, PropertiesIni ini) {
        this.stauts = 2;
        float sizesum = 0.0f;
        boolean isOK = true;
        this.dialog.progress.setValue(0);
        this.dialog.note.setText("message.upgrading");
        for (File file : files) {
            block9: {
                if (!file.getName().equals("update.ini")) {
                    String s = ini.getString(file.getName());
                    String[] fileStr = s.split(";");
                    if (GenerateCheckSum.isVaildFile(file.getPath(), fileStr[1])) {
                        try {
                            File ofile;
                            File odir = null;
                            if (UpgradeConstants.IS_OS_WINDOWS) {
                                odir = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + fileStr[0].substring(0, fileStr[0].lastIndexOf("\\")));
                            } else {
                                String path = String.valueOf(System.getProperty("user.dir")) + File.separator + fileStr[0].substring(0, fileStr[0].lastIndexOf("/"));
                                odir = new File(path);
                            }
                            if (!odir.exists()) {
                                odir.mkdirs();
                            }
                            if (!(ofile = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + fileStr[0])).exists()) {
                                ofile.createNewFile();
                            }
                            this.copyFile(file, ofile);
                        }
                        catch (Exception ex) {
                            if (file.getName().equalsIgnoreCase("Thumbs.db")) break block9;
                            isOK = false;
                        }
                    }
                }
            }
            float len = (sizesum += 1.0f) / (float)files.size() * 100.0f;
            this.dialog.progress.setValue(Math.round(len));
        }
        return isOK;
    }

    public boolean restoreFiles(List<File> files) {
        this.stauts = 3;
        float sizesum = 0.0f;
        boolean isOK = true;
        String backup = "BackupFiles";
        this.dialog.progress.setValue(0);
        this.dialog.note.setText("message.restore");
        for (File file : files) {
            try {
                String ofileStr = String.valueOf(System.getProperty("user.dir")) + File.separator + file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(backup) + File.separator.length());
                File ofile = new File(ofileStr);
                this.copyFile(file, ofile);
            }
            catch (Exception e) {
                isOK = false;
            }
            float len = (sizesum += 1.0f) / (float)files.size() * 100.0f;
            this.dialog.progress.setValue(Math.round(len));
        }
        return isOK;
    }

    public void runUpgrade() {
        boolean issuccessful = true;
        if (System.getProperty("java.version").startsWith("1.6")) {
            this.dialog = new InstallDialog16();
        } else {
            this.dialog = new InstallDialog15();
            this.dialog.setSize(380, 120);
        }
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setTitle("Upgrade");
        this.isOver = false;
        this.dialog.setVisible(true);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!InstallUpgrade.this.isOver) {
                    InstallUpgrade.this.colseTip();
                } else {
                    InstallUpgrade.this.dialog.dispose();
                }
            }
        });
        this.dialog.progress.setValue(0);
        String zipToFile = String.valueOf(System.getProperty("user.dir")) + File.separator + "temp";
        File zipTempFile = new File(zipToFile);
        if (!zipTempFile.exists()) {
            zipTempFile.mkdirs();
        }
        try {
            this.deleteFile(zipTempFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dialog.note.setText("message.decofiles");
        this.stauts = 0;
        boolean result = false;
        if (this.fromFile != null && !"".equals(this.fromFile)) {
            GZip gzipFile;
            ZipToFile zipFile;
            if (UpgradeConstants.IS_OS_WINDOWS) {
                zipFile = new ZipToFile(this.dialog.progress);
                result = zipFile.unZip(String.valueOf(this.fromFile) + File.separator + this.fileName, String.valueOf(zipToFile) + File.separator + this.fileName.substring(0, this.fileName.lastIndexOf(".")));
            } else if (UpgradeConstants.IS_OS_LINUX) {
                gzipFile = new GZip(this.dialog.progress);
                result = gzipFile.unTargzFile(String.valueOf(this.fromFile) + File.separator + this.fileName, zipToFile);
            } else if (UpgradeConstants.IS_OS_SOLARIS) {
                gzipFile = new GZip(this.dialog.progress);
                result = gzipFile.unTargzFile(String.valueOf(this.fromFile) + File.separator + this.fileName, zipToFile);
            } else if (UpgradeConstants.IS_OS_MAC || UpgradeConstants.IS_OS_MAC_OSX) {
                zipFile = new ZipToFile(this.dialog.progress);
                result = zipFile.unZip(String.valueOf(this.fromFile) + File.separator + this.fileName, zipToFile);
            }
        }
        if (result) {
            this.dialog.note.setText("message.decoover");
            String fileStr = "";
            if (UpgradeConstants.IS_OS_WINDOWS) {
                fileStr = this.fileName.substring(0, this.fileName.lastIndexOf("."));
            } else if (UpgradeConstants.IS_OS_LINUX) {
                fileStr = this.fileName.substring(0, this.fileName.length() - 7);
            } else if (UpgradeConstants.IS_OS_SOLARIS) {
                fileStr = this.fileName.substring(0, this.fileName.length() - 7);
            } else if (UpgradeConstants.IS_OS_MAC || UpgradeConstants.IS_OS_MAC_OSX) {
                fileStr = this.fileName.substring(0, this.fileName.lastIndexOf("."));
            }
            File baseDir = new File(String.valueOf(zipToFile) + File.separator + fileStr);
            List<File> files = this.getSubFiles(baseDir);
            String iniPath = String.valueOf(zipToFile) + File.separator + fileStr + File.separator + "update.ini";
            PropertiesIni ini = new PropertiesIni(iniPath);
            String newVersion = "";
            String oldVersion = "";
            try {
                newVersion = ini.getString("version").trim();
                oldVersion = ReadDatFile.getString("version").trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            issuccessful = this.backupFiles(files, ini);
            if (issuccessful) {
                issuccessful = !newVersion.equals(oldVersion) ? this.replaceFiles(files, ini) : true;
                if (issuccessful) {
                    try {
                        String tempFileName = ReadTempDatFile.getString("fileName").trim();
                        String tempFileSize = ReadTempDatFile.getString("fileSize").trim();
                        String tempFileDate = ReadTempDatFile.getString("lastModified").trim();
                        ReadDatFile.updateProperty("fileName", tempFileName);
                        ReadDatFile.updateProperty("fileSize", tempFileSize);
                        ReadDatFile.updateProperty("lastModified", tempFileDate);
                        ReadDatFile.updateProperty("version", newVersion);
                        this.dialog.note.setText("message.upgradeover");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    DisplayMessage.showErrorDialog("message.upgradefailure", "message.tiptitle");
                    List<File> backfiles = this.getSubFiles(new File(UpgradeConstants.BACKUPSTR));
                    issuccessful = this.restoreFiles(backfiles);
                }
                this.deleteFile(new File(zipToFile));
                this.deleteFile(new File(UpgradeConstants.BACKUPSTR));
                this.dialog.dispose();
                this.upgradeOver();
            } else {
                this.dialog.note.setText("message.backupfailure");
                this.upgradeOver();
            }
        } else {
            this.dialog.note.setText("message.decofailure");
            this.upgradeOver();
        }
    }

    @Override
    public void run() {
        this.runUpgrade();
    }

    public void upgradeOver() {
        this.isOver = true;
        try {
            if (UpgradeConstants.IS_OS_WINDOWS) {
                String cmd = "cmd /c start \" \" /D \"" + System.getProperty("user.dir") + "\" " + "restart.bat";
                Runtime.getRuntime().exec(cmd);
            } else if (UpgradeConstants.IS_OS_LINUX) {
                String cmd1 = "chmod 777 " + System.getProperty("user.dir") + File.separator + "restart.sh";
                String cmd2 = String.valueOf(System.getProperty("user.dir")) + File.separator + "restart.sh";
                Runtime.getRuntime().exec(cmd1);
                Runtime.getRuntime().exec(cmd2);
            } else if (UpgradeConstants.IS_OS_SOLARIS) {
                Runtime.getRuntime().exec("chmod 777 " + System.getProperty("user.dir") + File.separator + "Restart.sh");
                Runtime.getRuntime().exec("sh " + System.getProperty("user.dir") + File.separator + "Restart.sh");
            } else if (UpgradeConstants.IS_OS_MAC || UpgradeConstants.IS_OS_MAC_OSX) {
                Runtime.getRuntime().exec("chmod 777 " + System.getProperty("user.dir") + File.separator + "restart.sh");
                Runtime.getRuntime().exec(String.valueOf(System.getProperty("user.dir")) + File.separator + File.separator + "restart.sh");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        System.exit(0);
    }

    private void deleteFile(File file) {
        try {
            if (file.exists()) {
                if (file.isFile()) {
                    file.delete();
                } else if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    int i = 0;
                    while (i < files.length) {
                        this.deleteFile(files[i]);
                        ++i;
                    }
                }
                file.delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private List<File> getSubFiles(File baseDir) {
        ArrayList<File> ret = new ArrayList<File>();
        File[] tmp = baseDir.listFiles();
        int i = 0;
        while (i < tmp.length) {
            if (tmp[i].isFile()) {
                ret.add(tmp[i]);
            }
            if (tmp[i].isDirectory()) {
                ret.addAll(this.getSubFiles(tmp[i]));
            }
            ++i;
        }
        return ret;
    }

    public void changeLanguage(String currentLanguage) {
        if (currentLanguage.equals("en_US")) {
            I18NBundle.changeUS();
        } else if (currentLanguage.equals("fr_FR")) {
            I18NBundle.changeFR();
        } else if (currentLanguage.equals("de_DE")) {
            I18NBundle.changeDE();
        } else if (currentLanguage.equals("it_IT")) {
            I18NBundle.changeIT();
        } else if (currentLanguage.equals("pl_PL")) {
            I18NBundle.changePL();
        } else if (currentLanguage.equals("pt_PT")) {
            I18NBundle.changePT();
        } else if (currentLanguage.equals("ru_RU")) {
            I18NBundle.changeRUS();
        } else if (currentLanguage.equals("es_ES")) {
            I18NBundle.changeSP();
        } else if (currentLanguage.equals("uk_UK")) {
            I18NBundle.changeUKR();
        } else if (currentLanguage.equals("tr_TR")) {
            I18NBundle.changeTUR();
        } else if (currentLanguage.equals("zh_CN")) {
            I18NBundle.changeCN();
        } else if (currentLanguage.equals("cs_CS")) {
            I18NBundle.changeCS();
        } else if (currentLanguage.equals("zh_TW")) {
            I18NBundle.changeTW();
        } else {
            I18NBundle.changeUS();
        }
    }

    public void initFace() {
        try {
            Properties props = new Properties();
            props.put("foregroundColor", "255 255 255");
            props.put("frameColor", "130 130 130");
            props.put("gridColor", "210 210 210");
            props.put("tooltipBackgroundColor", "102 102 102");
            props.put("tooltipForegroundColor", "255 255 255");
            props.put("selectionBackgroundColor", "230 230 230");
            props.put("menuSelectionForegroundColor", "0 0 0");
            props.put("menuSelectionBackgroundColor", "230 230 230");
            props.put("menuSelectionBackgroundColorLight", "255 255 255");
            props.put("menuSelectionBackgroundColorDark", "230 230 230");
            props.put("menuBackgroundColor", "90 90 90");
            props.put("menuColorLight", "69 69 69");
            props.put("menuColorDark", "102 102 102");
            props.put("menuForegroundColor", "255 255 255");
            props.put("controlColor", "102 102 102");
            props.put("controlColorLight", "102 102 102");
            props.put("controlColorDark", "69 69 69");
            props.put("buttonForegroundColor", "255 255 255");
            props.put("buttonColor", "102 102 102");
            props.put("buttonBackgroundColor", "102 102 102");
            props.put("buttonColorLight", "230 230 230");
            props.put("buttonColorDark", "102 102 102");
            props.put("rolloverColor", "102 102 102");
            props.put("rolloverColorLight", "102 102 102");
            props.put("rolloverColorDark", "69 69 69");
            props.put("windowTitleForegroundColor", "0 0 0");
            props.put("windowTitleBackgroundColor", "69 69 69");
            props.put("windowTitleColorLight", "197 197 197");
            props.put("windowTitleColorDark", "69 69 69");
            props.put("windowBorderColor", "10 10 10");
            props.put("tabAreaBackgroundColor", "102 102 102");
            props.put("inputForegroundColor", "255 255 255");
            props.put("inputBackgroundColor", "102 102 102");
            props.put("focusColor", "255 255 255");
            props.put("focusCellColor", "255 255 255");
            props.put("backgroundColor", "102 102 102");
            props.put("backgroundColorLight", "255 255 255");
            props.put("backgroundColorDark", "102 102 102");
            SmartLookAndFeel.setCurrentTheme(props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.smart.SmartLookAndFeel");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String fromZipPath = "";
        String path = "";
        String fileName = "";
        try {
            fromZipPath = Config.getString("InstallPath");
            path = new File(fromZipPath).getParent();
            fileName = new File(fromZipPath).getName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("fromZipPath:" + fromZipPath);
        InstallUpgrade install = new InstallUpgrade(path, fileName);
        install.start();
    }
}

