/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.EventDetails;
import org.apache.log4j.chainsaw.MyTableModel;

class DetailPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger LOG = Logger.getLogger(class$org$apache$log4j$chainsaw$DetailPanel == null ? (class$org$apache$log4j$chainsaw$DetailPanel = DetailPanel.class$("org.apache.log4j.chainsaw.DetailPanel")) : class$org$apache$log4j$chainsaw$DetailPanel);
    private static final MessageFormat FORMATTER = new MessageFormat("<b>Time:</b> <code>{0,time,medium}</code>&nbsp;&nbsp;<b>Priority:</b> <code>{1}</code>&nbsp;&nbsp;<b>Thread:</b> <code>{2}</code>&nbsp;&nbsp;<b>NDC:</b> <code>{3}</code><br><b>Logger:</b> <code>{4}</code><br><b>Location:</b> <code>{5}</code><br><b>Message:</b><pre>{6}</pre><b>Throwable:</b><pre>{7}</pre>");
    private final MyTableModel mModel;
    private final JEditorPane mDetails;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$DetailPanel;

    DetailPanel(JTable jTable, MyTableModel myTableModel) {
        this.mModel = myTableModel;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Details: "));
        this.mDetails = new JEditorPane();
        this.mDetails.setEditable(false);
        this.mDetails.setContentType("text/html");
        this.add((Component)new JScrollPane(this.mDetails), "Center");
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty()) {
            this.mDetails.setText("Nothing selected");
        } else {
            int n = listSelectionModel.getMinSelectionIndex();
            EventDetails eventDetails = this.mModel.getEventDetails(n);
            Object[] objectArray = new Object[]{new Date(eventDetails.getTimeStamp()), eventDetails.getPriority(), this.escape(eventDetails.getThreadName()), this.escape(eventDetails.getNDC()), this.escape(eventDetails.getCategoryName()), this.escape(eventDetails.getLocationDetails()), this.escape(eventDetails.getMessage()), this.escape(DetailPanel.getThrowableStrRep(eventDetails))};
            this.mDetails.setText(FORMATTER.format(objectArray));
            this.mDetails.setCaretPosition(0);
        }
    }

    private static String getThrowableStrRep(EventDetails eventDetails) {
        String[] stringArray = eventDetails.getThrowableStrRep();
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]).append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

