/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ClassUtils;

public class LocalVariableTableParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static Log logger = LogFactory.getLog((Class)(class$org$springframework$core$LocalVariableTableParameterNameDiscoverer == null ? (class$org$springframework$core$LocalVariableTableParameterNameDiscoverer = LocalVariableTableParameterNameDiscoverer.class$("org.springframework.core.LocalVariableTableParameterNameDiscoverer")) : class$org$springframework$core$LocalVariableTableParameterNameDiscoverer));
    static /* synthetic */ Class class$org$springframework$core$LocalVariableTableParameterNameDiscoverer;

    public String[] getParameterNames(Method method) {
        block3: {
            ParameterNameDiscoveringVisitor parameterNameDiscoveringVisitor = null;
            try {
                parameterNameDiscoveringVisitor = this.visitMethod(method);
                if (parameterNameDiscoveringVisitor.foundTargetMember()) {
                    return parameterNameDiscoveringVisitor.getParameterNames();
                }
            }
            catch (IOException iOException) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("IOException whilst attempting to read '.class' file for class [" + method.getDeclaringClass().getName() + "] - unable to determine parameter names for method: " + method), (Throwable)iOException);
            }
        }
        return null;
    }

    public String[] getParameterNames(Constructor constructor) {
        block3: {
            ParameterNameDiscoveringVisitor parameterNameDiscoveringVisitor = null;
            try {
                parameterNameDiscoveringVisitor = this.visitConstructor(constructor);
                if (parameterNameDiscoveringVisitor.foundTargetMember()) {
                    return parameterNameDiscoveringVisitor.getParameterNames();
                }
            }
            catch (IOException iOException) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("IOException whilst attempting to read '.class' file for class [" + constructor.getDeclaringClass().getName() + "] - unable to determine parameter names for constructor: " + constructor), (Throwable)iOException);
            }
        }
        return null;
    }

    private ParameterNameDiscoveringVisitor visitMethod(Method method) throws IOException {
        ClassReader classReader = this.createClassReader(method.getDeclaringClass());
        FindMethodParameterNamesClassVisitor findMethodParameterNamesClassVisitor = new FindMethodParameterNamesClassVisitor(method);
        classReader.accept((ClassVisitor)findMethodParameterNamesClassVisitor, false);
        return findMethodParameterNamesClassVisitor;
    }

    private ParameterNameDiscoveringVisitor visitConstructor(Constructor constructor) throws IOException {
        ClassReader classReader = this.createClassReader(constructor.getDeclaringClass());
        FindConstructorParameterNamesClassVisitor findConstructorParameterNamesClassVisitor = new FindConstructorParameterNamesClassVisitor(constructor);
        classReader.accept((ClassVisitor)findConstructorParameterNamesClassVisitor, false);
        return findConstructorParameterNamesClassVisitor;
    }

    private ClassReader createClassReader(Class clazz) throws IOException {
        return new ClassReader(clazz.getResourceAsStream(ClassUtils.getClassFileName(clazz)));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FindConstructorParameterNamesClassVisitor
    extends ParameterNameDiscoveringVisitor {
        public FindConstructorParameterNamesClassVisitor(Constructor constructor) {
            super("<init>", false, constructor.getParameterTypes());
            Type[] typeArray = new Type[constructor.getParameterTypes().length];
            for (int i = 0; i < typeArray.length; ++i) {
                typeArray[i] = Type.getType(constructor.getParameterTypes()[i]);
            }
            this.setDescriptorToMatch(Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])typeArray));
        }
    }

    private static class FindMethodParameterNamesClassVisitor
    extends ParameterNameDiscoveringVisitor {
        public FindMethodParameterNamesClassVisitor(Method method) {
            super(method.getName(), Modifier.isStatic(method.getModifiers()), method.getParameterTypes());
            this.setDescriptorToMatch(Type.getMethodDescriptor((Method)method));
        }
    }

    private static class LocalVariableTableVisitor
    extends EmptyVisitor {
        private boolean isStatic;
        private ParameterNameDiscoveringVisitor memberVisitor;
        private int numParameters;
        private int[] lvtSlotIndices;
        private String[] parameterNames;
        private boolean hasLVTInfo = false;

        public LocalVariableTableVisitor(boolean bl, ParameterNameDiscoveringVisitor parameterNameDiscoveringVisitor, int n, int[] nArray) {
            this.isStatic = bl;
            this.numParameters = n;
            this.parameterNames = new String[this.numParameters];
            this.memberVisitor = parameterNameDiscoveringVisitor;
            this.lvtSlotIndices = nArray;
        }

        public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
            this.hasLVTInfo = true;
            if (this.isMethodArgumentSlot(n)) {
                this.parameterNames[this.parameterNameIndexForSlot((int)n)] = string;
            }
        }

        public void visitEnd() {
            if (this.hasLVTInfo || this.isStatic && this.numParameters == 0) {
                this.memberVisitor.setParameterNames(this.parameterNames);
            }
        }

        private boolean isMethodArgumentSlot(int n) {
            for (int i = 0; i < this.lvtSlotIndices.length; ++i) {
                if (this.lvtSlotIndices[i] != n) continue;
                return true;
            }
            return false;
        }

        private int parameterNameIndexForSlot(int n) {
            for (int i = 0; i < this.lvtSlotIndices.length; ++i) {
                if (this.lvtSlotIndices[i] != n) continue;
                return i;
            }
            throw new IllegalStateException("Asked for index for a slot which failed the isMethodArgumentSlot test: " + n);
        }
    }

    private static abstract class ParameterNameDiscoveringVisitor
    extends EmptyVisitor {
        private String methodNameToMatch;
        private String descriptorToMatch;
        private int numParamsExpected;
        private int[] lvtSlotIndex;
        private boolean foundTargetMember = false;
        private String[] parameterNames;

        public ParameterNameDiscoveringVisitor(String string, boolean bl, Class[] classArray) {
            this.methodNameToMatch = string;
            this.numParamsExpected = classArray.length;
            this.computeLVTSlotIndices(bl, classArray);
        }

        public void setDescriptorToMatch(String string) {
            this.descriptorToMatch = string;
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (string.equals(this.methodNameToMatch) && string2.equals(this.descriptorToMatch)) {
                this.foundTargetMember = true;
                return new LocalVariableTableVisitor(this.isStatic(n), this, this.numParamsExpected, this.lvtSlotIndex);
            }
            return null;
        }

        private boolean isStatic(int n) {
            return (n & 8) > 0;
        }

        public boolean foundTargetMember() {
            return this.foundTargetMember;
        }

        public String[] getParameterNames() {
            if (!this.foundTargetMember()) {
                throw new IllegalStateException("Can't ask for parameter names when target member has not been found");
            }
            return this.parameterNames;
        }

        public void setParameterNames(String[] stringArray) {
            this.parameterNames = stringArray;
        }

        private void computeLVTSlotIndices(boolean bl, Class[] classArray) {
            this.lvtSlotIndex = new int[classArray.length];
            int n = bl ? 0 : 1;
            for (int i = 0; i < classArray.length; ++i) {
                this.lvtSlotIndex[i] = n++;
                if (!this.isWideType(classArray[i])) continue;
                n += 2;
            }
        }

        private boolean isWideType(Class clazz) {
            return clazz == Long.TYPE || clazz == Double.TYPE;
        }
    }
}

