/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;

public class StopWatch {
    private final String id;
    private boolean keepTaskList = true;
    private final List taskList = new LinkedList();
    private long startTimeMillis;
    private boolean running;
    private String currentTaskName;
    private TaskInfo lastTaskInfo;
    private int taskCount;
    private long totalTimeMillis;

    public StopWatch() {
        this.id = "";
    }

    public StopWatch(String string) {
        this.id = string;
    }

    public void setKeepTaskList(boolean bl) {
        this.keepTaskList = bl;
    }

    public void start() throws IllegalStateException {
        this.start("");
    }

    public void start(String string) throws IllegalStateException {
        if (this.running) {
            throw new IllegalStateException("Can't start StopWatch: it's already running");
        }
        this.startTimeMillis = System.currentTimeMillis();
        this.running = true;
        this.currentTaskName = string;
    }

    public void stop() throws IllegalStateException {
        if (!this.running) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        long l = System.currentTimeMillis() - this.startTimeMillis;
        this.totalTimeMillis += l;
        this.lastTaskInfo = new TaskInfo(this.currentTaskName, l);
        if (this.keepTaskList) {
            this.taskList.add(this.lastTaskInfo);
        }
        ++this.taskCount;
        this.running = false;
        this.currentTaskName = null;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getLastTaskTimeMillis() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tests run: can't get last interval");
        }
        return this.lastTaskInfo.getTimeMillis();
    }

    public long getTotalTimeMillis() {
        return this.totalTimeMillis;
    }

    public double getTotalTimeSeconds() {
        return (double)this.totalTimeMillis / 1000.0;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public TaskInfo[] getTaskInfo() {
        if (!this.keepTaskList) {
            throw new UnsupportedOperationException("Task info is not being kept!");
        }
        return this.taskList.toArray(new TaskInfo[this.taskList.size()]);
    }

    public String shortSummary() {
        return "StopWatch '" + this.id + "': running time (millis) = " + this.getTotalTimeMillis();
    }

    public String prettyPrint() {
        StringBuffer stringBuffer = new StringBuffer(this.shortSummary());
        stringBuffer.append('\n');
        if (!this.keepTaskList) {
            stringBuffer.append("No task info kept");
        } else {
            TaskInfo[] taskInfoArray = this.getTaskInfo();
            stringBuffer.append("-----------------------------------------\n");
            stringBuffer.append("ms     %     Task name\n");
            stringBuffer.append("-----------------------------------------\n");
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumIntegerDigits(5);
            numberFormat.setGroupingUsed(false);
            NumberFormat numberFormat2 = NumberFormat.getPercentInstance();
            numberFormat2.setMinimumIntegerDigits(3);
            numberFormat2.setGroupingUsed(false);
            for (int i = 0; i < taskInfoArray.length; ++i) {
                stringBuffer.append(numberFormat.format(taskInfoArray[i].getTimeMillis()) + "  ");
                stringBuffer.append(numberFormat2.format(taskInfoArray[i].getTimeSeconds() / this.getTotalTimeSeconds()) + "  ");
                stringBuffer.append(taskInfoArray[i].getTaskName() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.shortSummary());
        if (this.keepTaskList) {
            TaskInfo[] taskInfoArray = this.getTaskInfo();
            for (int i = 0; i < taskInfoArray.length; ++i) {
                stringBuffer.append("; [" + taskInfoArray[i].getTaskName() + "] took " + taskInfoArray[i].getTimeMillis());
                long l = Math.round(100.0 * taskInfoArray[i].getTimeSeconds() / this.getTotalTimeSeconds());
                stringBuffer.append(" = " + l + "%");
            }
        } else {
            stringBuffer.append("; no task info kept");
        }
        return stringBuffer.toString();
    }

    public static class TaskInfo {
        private final String taskName;
        private final long timeMillis;

        private TaskInfo(String string, long l) {
            this.taskName = string;
            this.timeMillis = l;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getTimeMillis() {
            return this.timeMillis;
        }

        public double getTimeSeconds() {
            return (double)this.timeMillis / 1000.0;
        }
    }
}

