/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.StringUtils;

public class ServiceLocatorFactoryBean
implements FactoryBean,
BeanFactoryAware,
InitializingBean {
    private Class serviceLocatorInterface;
    private Constructor serviceLocatorExceptionConstructor;
    private Properties serviceMappings;
    private ListableBeanFactory beanFactory;
    private Object proxy;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Object;

    public void setServiceLocatorInterface(Class clazz) {
        this.serviceLocatorInterface = clazz;
    }

    public void setServiceLocatorExceptionClass(Class clazz) {
        if (clazz != null && !(class$java$lang$Exception == null ? (class$java$lang$Exception = ServiceLocatorFactoryBean.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("serviceLocatorException [" + clazz.getName() + "] is not a subclass of Exception");
        }
        this.serviceLocatorExceptionConstructor = this.determineServiceLocatorExceptionConstructor(clazz);
    }

    public void setServiceMappings(Properties properties) {
        this.serviceMappings = properties;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new FatalBeanException("ServiceLocatorFactoryBean needs to run in a BeanFactory that is a ListableBeanFactory");
        }
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() {
        if (this.serviceLocatorInterface == null) {
            throw new IllegalArgumentException("serviceLocatorInterface is required");
        }
        this.proxy = Proxy.newProxyInstance(this.serviceLocatorInterface.getClassLoader(), new Class[]{this.serviceLocatorInterface}, (InvocationHandler)new ServiceLocatorInvocationHandler());
    }

    protected Constructor determineServiceLocatorExceptionConstructor(Class clazz) {
        try {
            return clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ServiceLocatorFactoryBean.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = ServiceLocatorFactoryBean.class$("java.lang.Throwable")) : class$java$lang$Throwable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return clazz.getConstructor(class$java$lang$Throwable == null ? (class$java$lang$Throwable = ServiceLocatorFactoryBean.class$("java.lang.Throwable")) : class$java$lang$Throwable);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    return clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ServiceLocatorFactoryBean.class$("java.lang.String")) : class$java$lang$String);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    throw new IllegalArgumentException("serviceLocatorException [" + clazz.getName() + "] neither has a (String, Throwable) constructor nor a (String) constructor");
                }
            }
        }
    }

    protected Exception createServiceLocatorException(Constructor constructor, BeansException beansException) {
        Class<?>[] classArray = constructor.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].equals(class$java$lang$String == null ? ServiceLocatorFactoryBean.class$("java.lang.String") : class$java$lang$String)) {
                objectArray[i] = beansException.getMessage();
                continue;
            }
            if (!classArray[i].isInstance((Object)beansException)) continue;
            objectArray[i] = beansException;
        }
        return (Exception)BeanUtils.instantiateClass(constructor, objectArray);
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        return this.serviceLocatorInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ServiceLocatorInvocationHandler
    implements InvocationHandler {
        private ServiceLocatorInvocationHandler() {
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Object object2 = (class$java$lang$Object == null ? (class$java$lang$Object = ServiceLocatorFactoryBean.class$("java.lang.Object")) : class$java$lang$Object).equals(method.getDeclaringClass()) ? this.invokeStandardObjectMethod(method, objectArray) : this.invokeServiceLocatorMethod(method, objectArray);
            return object2;
        }

        public String toString() {
            return "Service locator: " + ServiceLocatorFactoryBean.this.serviceLocatorInterface.getName();
        }

        private Object invokeServiceLocatorMethod(Method method, Object[] objectArray) throws Exception {
            Class clazz = this.getServiceLocatorMethodReturnType(method);
            try {
                String string = this.tryGetBeanName(objectArray);
                if (StringUtils.hasLength((String)string)) {
                    return ServiceLocatorFactoryBean.this.beanFactory.getBean(string, clazz);
                }
                return BeanFactoryUtils.beanOfTypeIncludingAncestors(ServiceLocatorFactoryBean.this.beanFactory, clazz);
            }
            catch (BeansException beansException) {
                if (ServiceLocatorFactoryBean.this.serviceLocatorExceptionConstructor != null) {
                    throw ServiceLocatorFactoryBean.this.createServiceLocatorException(ServiceLocatorFactoryBean.this.serviceLocatorExceptionConstructor, beansException);
                }
                throw beansException;
            }
        }

        private String tryGetBeanName(Object[] objectArray) {
            String string;
            String string2 = "";
            if (objectArray != null && objectArray.length == 1 && objectArray[0] != null) {
                string2 = objectArray[0].toString();
            }
            if (ServiceLocatorFactoryBean.this.serviceMappings != null && (string = ServiceLocatorFactoryBean.this.serviceMappings.getProperty(string2)) != null) {
                string2 = string;
            }
            return string2;
        }

        private Class getServiceLocatorMethodReturnType(Method method) throws NoSuchMethodException {
            Class<?>[] classArray = method.getParameterTypes();
            Method method2 = ServiceLocatorFactoryBean.this.serviceLocatorInterface.getMethod(method.getName(), classArray);
            Class<?> clazz = method2.getReturnType();
            if (classArray.length > 1 || Void.TYPE.equals(clazz)) {
                throw new UnsupportedOperationException("May only call methods with signature '<type> xxx()' or '<type> xxx(<idtype> id)' on factory interface, but tried to call: " + method2);
            }
            return clazz;
        }

        private Object invokeStandardObjectMethod(Method method, Object[] objectArray) throws Throwable {
            try {
                return method.invoke((Object)this, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
    }
}

