/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.P16ComUSBProcessor;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.exception.FaultHandler;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class P20ComUSBProcessor
extends P16ComUSBProcessor {
    private Logger logger = Logger.getLogger(P20ComUSBProcessor.class);

    public P20ComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public boolean pollQueryStatus() {
        if (this.currenttime == null) {
            return false;
        }
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            String qpifs;
            String qpiws;
            workinfo.setProdid(this.getProtocol().getProtocolID());
            workinfo.setSerialno(this.getProtocol().getSerialNo());
            if (this.currenttime != null) {
                workinfo.setCurrentTime(this.currenttime.getTime());
            }
            if (!"".equals(qpiws = handler.excuteCommand("QPIWS", true)) && !qpiws.equals("(NAK")) {
                String qpiwsStr = qpiws.substring(1);
                this.hasFault = qpiwsStr.charAt(0) == '1';
                if (qpiwsStr.charAt(1) == '1') {
                    if (!workinfo.getWarnings().contains("2001")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2001");
                        workinfo.addWarning("2001");
                    }
                } else if (workinfo.getWarnings().contains("2001")) {
                    workinfo.getWarnings().remove("2001");
                }
                if (qpiwsStr.charAt(2) == '1') {
                    if (!workinfo.getWarnings().contains("2002")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2002");
                        workinfo.addWarning("2002");
                    }
                } else if (workinfo.getWarnings().contains("2002")) {
                    workinfo.getWarnings().remove("2002");
                }
                if (qpiwsStr.charAt(3) == '1') {
                    if (!workinfo.getWarnings().contains("2003")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2003");
                        workinfo.addWarning("2003");
                    }
                } else if (workinfo.getWarnings().contains("2003")) {
                    workinfo.getWarnings().remove("2003");
                }
                if (qpiwsStr.charAt(4) == '1') {
                    if (!workinfo.getWarnings().contains("2004")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2004");
                        workinfo.addWarning("2004");
                    }
                } else if (workinfo.getWarnings().contains("2004")) {
                    workinfo.getWarnings().remove("2004");
                }
                if (qpiwsStr.charAt(5) == '1') {
                    if (!workinfo.getWarnings().contains("2005")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2005");
                        workinfo.addWarning("2005");
                    }
                } else if (workinfo.getWarnings().contains("2005")) {
                    workinfo.getWarnings().remove("2005");
                }
                if (qpiwsStr.charAt(6) == '1') {
                    if (!workinfo.getWarnings().contains("2006")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2006");
                        workinfo.addWarning("2006");
                    }
                } else if (workinfo.getWarnings().contains("2006")) {
                    workinfo.getWarnings().remove("2006");
                }
                if (qpiwsStr.charAt(7) == '1') {
                    if (!workinfo.getWarnings().contains("2007")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2007");
                        workinfo.addWarning("2007");
                    }
                } else if (workinfo.getWarnings().contains("2007")) {
                    workinfo.getWarnings().remove("2007");
                }
                if (qpiwsStr.charAt(8) == '1') {
                    if (!workinfo.getWarnings().contains("2008")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2008");
                        workinfo.addWarning("2008");
                    }
                } else if ((qpiwsStr.charAt(10) == '1' || qpiwsStr.charAt(9) == '1' || qpiwsStr.charAt(8) == '1' || qpiwsStr.charAt(7) == '1') && workinfo.getWarnings().contains("2008")) {
                    workinfo.getWarnings().remove("2008");
                }
                if (qpiwsStr.charAt(9) == '1') {
                    if (!workinfo.getWarnings().contains("2009")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2009");
                        workinfo.addWarning("2009");
                    }
                } else if (workinfo.getWarnings().contains("2009")) {
                    workinfo.getWarnings().remove("2009");
                }
                if (qpiwsStr.charAt(10) == '1') {
                    if (!workinfo.getWarnings().contains("2010")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2010");
                        workinfo.addWarning("2010");
                    }
                } else if ((qpiwsStr.charAt(10) == '1' || qpiwsStr.charAt(9) == '1' || qpiwsStr.charAt(8) == '1' || qpiwsStr.charAt(7) == '1') && workinfo.getWarnings().contains("2010")) {
                    workinfo.getWarnings().remove("2010");
                }
                if (qpiwsStr.charAt(11) == '1') {
                    if (!workinfo.getWarnings().contains("2011")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2011");
                        workinfo.addWarning("2011");
                    }
                } else if (workinfo.getWarnings().contains("2011")) {
                    workinfo.getWarnings().remove("2011");
                }
                if (qpiwsStr.charAt(12) == '1') {
                    if (!workinfo.getWarnings().contains("2012")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2012");
                        workinfo.addWarning("2012");
                    }
                } else if (workinfo.getWarnings().contains("2012")) {
                    workinfo.getWarnings().remove("2012");
                }
                if (qpiwsStr.charAt(13) == '1') {
                    if (!workinfo.getWarnings().contains("2013")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2013");
                        workinfo.addWarning("2013");
                    }
                } else if (workinfo.getWarnings().contains("2013")) {
                    workinfo.removeWarning("2013");
                }
                if (qpiwsStr.charAt(24) == '1') {
                    if (!workinfo.getWarnings().contains("2024")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2024");
                        workinfo.addWarning("2024");
                    }
                } else if (workinfo.getWarnings().contains("2024")) {
                    workinfo.removeWarning("2024");
                }
                if (qpiwsStr.charAt(10) != '1' && qpiwsStr.charAt(9) != '1' && qpiwsStr.charAt(8) != '1' && qpiwsStr.charAt(7) != '1') {
                    try {
                        if (qpiwsStr.charAt(25) == '1') {
                            if (!workinfo.getWarnings().contains("2008")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2008");
                                workinfo.addWarning("2008");
                            }
                        } else if (workinfo.getWarnings().contains("2008")) {
                            workinfo.getWarnings().remove("2008");
                        }
                        if (qpiwsStr.charAt(26) == '1') {
                            if (!workinfo.getWarnings().contains("2010")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2010");
                                workinfo.addWarning("2010");
                            }
                        } else if (workinfo.getWarnings().contains("2010")) {
                            workinfo.getWarnings().remove("2010");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (qpiwsStr.charAt(11) == '1' || qpiwsStr.charAt(10) == '1' || qpiwsStr.charAt(9) == '1' || qpiwsStr.charAt(8) == '1' || qpiwsStr.charAt(7) == '1') {
                    workinfo.setLineLoss(true);
                } else {
                    workinfo.setLineLoss(false);
                }
                if (qpiwsStr.charAt(3) == '1') {
                    workinfo.setPvLoss(true);
                } else {
                    workinfo.setPvLoss(false);
                }
                if (qpiwsStr.charAt(16) == '1') {
                    workinfo.setNoBattery(true);
                } else {
                    workinfo.setNoBattery(false);
                }
                if (qpiwsStr.charAt(18) == '1') {
                    workinfo.setOverLoad(true);
                } else {
                    workinfo.setOverLoad(false);
                }
            }
            Calendar machineTime = Calendar.getInstance();
            machineTime.setTime(workinfo.getCurrentTime());
            Calendar serverTime = Calendar.getInstance(usLocale);
            if (Math.abs(machineTime.getTimeInMillis() - serverTime.getTimeInMillis()) > (long)(GlobalVariables.globalConfig.getShowWarningForDatetime() * 60 * 1000)) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "3003");
            }
            if (this.getFWVersion() >= 0.3f) {
                String qpicf = handler.excuteCommand("QPICF", true);
                if (!"".equals(qpicf) && !qpicf.equals("(NAK")) {
                    String[] qpicfArr = qpicf.split(" ");
                    String faultStatus = qpicfArr[0].substring(1);
                    String faultID = qpicfArr[1];
                    if (faultStatus.equals("00")) {
                        String qpihf;
                        if (!(faultID.equals(this._faultID) || "".equals(qpihf = handler.excuteCommand("QPIHF" + faultID, true)) || qpihf.equals("(NAK") || qpihf.startsWith("(00"))) {
                            this._faultID = faultID;
                            String[] qpifsArr = qpihf.split(" ");
                            String faultstr = qpifsArr[0].substring(1);
                            int kind = VolUtil.parseInt(faultstr);
                            if (kind > 0 && kind < 32) {
                                DataBeforeFault data = new DataBeforeFault();
                                String timeStr = qpifsArr[1];
                                data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                                data.setProdid(this.getProtocol().getProtocolID());
                                data.setSerialno(this.getProtocol().getSerialNo());
                                data.setPvinputvoltage1(VolUtil.parseDouble(qpifsArr[2]));
                                data.setPvinputcurrent1(VolUtil.parseDouble(qpifsArr[3]));
                                data.setPvinputvoltage2(VolUtil.parseDouble(qpifsArr[4]));
                                data.setPvinputcurrent2(VolUtil.parseDouble(qpifsArr[5]));
                                data.setPvinputvoltage3(VolUtil.parseDouble(qpifsArr[6]));
                                data.setPvinputcurrent3(VolUtil.parseDouble(qpifsArr[7]));
                                data.setInverterVoltage(VolUtil.parseDouble(qpifsArr[8]));
                                data.setInverterCurrent(VolUtil.parseDouble(qpifsArr[9]));
                                data.setGridVoltage(VolUtil.parseDouble(qpifsArr[10]));
                                data.setGridFrequency(VolUtil.parseDouble(qpifsArr[11]));
                                data.setGridCurrent(VolUtil.parseDouble(qpifsArr[12]));
                                data.setOutputLoadPercent(VolUtil.parseInt(qpifsArr[13]));
                                data.setOutputLoadCurrent(VolUtil.parseDouble(qpifsArr[14]));
                                data.setOutputLoadVoltage(VolUtil.parseDouble(qpifsArr[15]));
                                data.setOutputLoadFrequency(VolUtil.parseDouble(qpifsArr[16]));
                                data.setBatteryVoltage(VolUtil.parseDouble(qpifsArr[17]));
                                data.setMaxTemperature(VolUtil.parseDouble(qpifsArr[18]));
                                String runStatus = new String(qpifsArr[19]);
                                data.setRunStatus(runStatus);
                                FaultHandler.doFaultEvent(faultstr, workinfo.getProdid(), workinfo.getSerialno(), data);
                            }
                            workinfo.setFaultInfo(faultstr);
                        }
                    } else {
                        String qpihf = handler.excuteCommand("QPIHF" + faultID, true);
                        if (!("".equals(qpihf) || qpihf.equals("(NAK") || qpihf.startsWith("(00"))) {
                            this._faultID = faultID;
                            String[] qpifsArr = qpihf.split(" ");
                            String faultstr = qpifsArr[0].substring(1);
                            int kind = VolUtil.parseInt(faultstr);
                            if (kind > 0 && kind < 32) {
                                DataBeforeFault data = new DataBeforeFault();
                                String timeStr = qpifsArr[1];
                                data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                                data.setProdid(this.getProtocol().getProtocolID());
                                data.setSerialno(this.getProtocol().getSerialNo());
                                data.setPvinputvoltage1(VolUtil.parseDouble(qpifsArr[2]));
                                data.setPvinputcurrent1(VolUtil.parseDouble(qpifsArr[3]));
                                data.setPvinputvoltage2(VolUtil.parseDouble(qpifsArr[4]));
                                data.setPvinputcurrent2(VolUtil.parseDouble(qpifsArr[5]));
                                data.setPvinputvoltage3(VolUtil.parseDouble(qpifsArr[6]));
                                data.setPvinputcurrent3(VolUtil.parseDouble(qpifsArr[7]));
                                data.setInverterVoltage(VolUtil.parseDouble(qpifsArr[8]));
                                data.setInverterCurrent(VolUtil.parseDouble(qpifsArr[9]));
                                data.setGridVoltage(VolUtil.parseDouble(qpifsArr[10]));
                                data.setGridFrequency(VolUtil.parseDouble(qpifsArr[11]));
                                data.setGridCurrent(VolUtil.parseDouble(qpifsArr[12]));
                                data.setOutputLoadPercent(VolUtil.parseInt(qpifsArr[13]));
                                data.setOutputLoadCurrent(VolUtil.parseDouble(qpifsArr[14]));
                                data.setOutputLoadVoltage(VolUtil.parseDouble(qpifsArr[15]));
                                data.setOutputLoadFrequency(VolUtil.parseDouble(qpifsArr[16]));
                                data.setBatteryVoltage(VolUtil.parseDouble(qpifsArr[17]));
                                data.setMaxTemperature(VolUtil.parseDouble(qpifsArr[18]));
                                String runStatus = new String(qpifsArr[19]);
                                data.setRunStatus(runStatus);
                                FaultHandler.doFaultEvent(faultstr, workinfo.getProdid(), workinfo.getSerialno(), data);
                            }
                            workinfo.setFaultInfo(faultstr);
                        }
                    }
                }
            } else if (this.hasFault && !"".equals(qpifs = handler.excuteCommand("QPIFS", true)) && !qpifs.equals("(NAK") && !qpifs.equals("(OK")) {
                String[] qpifsArr = qpifs.split(" ");
                String faultstr = qpifsArr[0].substring(1);
                int kind = VolUtil.parseInt(faultstr);
                if (kind > 0 && kind < 28) {
                    DataBeforeFault data = new DataBeforeFault();
                    String timeStr = qpifsArr[1];
                    data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                    data.setProdid(this.getProtocol().getProtocolID());
                    data.setSerialno(this.getProtocol().getSerialNo());
                    data.setPvinputvoltage1(VolUtil.parseDouble(qpifsArr[2]));
                    data.setPvinputcurrent1(VolUtil.parseDouble(qpifsArr[3]));
                    data.setPvinputvoltage2(VolUtil.parseDouble(qpifsArr[4]));
                    data.setPvinputcurrent2(VolUtil.parseDouble(qpifsArr[5]));
                    data.setPvinputvoltage3(VolUtil.parseDouble(qpifsArr[6]));
                    data.setPvinputcurrent3(VolUtil.parseDouble(qpifsArr[7]));
                    data.setInverterVoltage(VolUtil.parseDouble(qpifsArr[8]));
                    data.setInverterCurrent(VolUtil.parseDouble(qpifsArr[9]));
                    data.setGridVoltage(VolUtil.parseDouble(qpifsArr[10]));
                    data.setGridFrequency(VolUtil.parseDouble(qpifsArr[11]));
                    data.setGridCurrent(VolUtil.parseDouble(qpifsArr[12]));
                    data.setOutputLoadPercent(VolUtil.parseInt(qpifsArr[13]));
                    data.setOutputLoadCurrent(VolUtil.parseDouble(qpifsArr[14]));
                    data.setOutputLoadVoltage(VolUtil.parseDouble(qpifsArr[15]));
                    data.setOutputLoadFrequency(VolUtil.parseDouble(qpifsArr[16]));
                    data.setBatteryVoltage(VolUtil.parseDouble(qpifsArr[17]));
                    data.setMaxTemperature(VolUtil.parseDouble(qpifsArr[18]));
                    String runStatus = new String(qpifsArr[19]);
                    data.setRunStatus(runStatus);
                    FaultHandler.doFaultEvent(faultstr, workinfo.getProdid(), workinfo.getSerialno(), data);
                } else {
                    this.logger.info((Object)("Fault:" + kind));
                }
                workinfo.setFaultInfo(faultstr);
            }
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            workinfo.clear();
            ++this.reconnectTimes;
        }
        return result;
    }
}

