/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.upgrade;

import cn.com.voltronic.solar.configure.ConfigureTools;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.socket.SystemTrayUDPClient;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.upgrade.DownloadDialog;
import cn.com.voltronic.solar.upgrade.DownloadDialog15;
import cn.com.voltronic.solar.upgrade.DownloadDialog16;
import cn.com.voltronic.solar.upgrade.StartUpgrade;
import cn.com.voltronic.solar.upgrade.UpgradeUtil;
import cn.com.voltronic.solar.util.MyMD5;
import cn.com.voltronic.solar.util.ReadDatFile;
import cn.com.voltronic.solar.util.ReadTempDatFile;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Download
extends Thread {
    private Logger logger = Logger.getLogger(Download.class);
    private static int BUFFER_SIZE = 8192;
    private String fromDir;
    private String toDir;
    private DownloadDialog downloadDialog = null;
    public volatile boolean isStop = false;
    public volatile boolean waitting = false;
    private HttpURLConnection httpUrl = null;
    private InputStream inputStream = null;
    private FileOutputStream fos = null;
    private BufferedInputStream bis = null;
    private String fileName = "";
    private float length;
    private long time;

    public Download(String fromDir, String toDir) {
        this.fromDir = fromDir;
        this.toDir = toDir;
    }

    private boolean openURL() {
        boolean result = true;
        URL url = null;
        try {
            url = new URL(this.fromDir);
            boolean useProxy = GlobalVariables.upgradeConfig.isUseProxy();
            String proxyIP = GlobalVariables.upgradeConfig.getProxyIp();
            String proxyPort = GlobalVariables.upgradeConfig.getProxyPort();
            if (useProxy) {
                Properties systemProperties = System.getProperties();
                systemProperties.setProperty("http.proxyHost", proxyIP);
                systemProperties.setProperty("http.proxyPort", proxyPort);
            }
            this.httpUrl = (HttpURLConnection)url.openConnection();
            boolean useAuth = GlobalVariables.upgradeConfig.isUseAuth();
            if (useProxy && useAuth) {
                String username = GlobalVariables.upgradeConfig.getAuthName();
                String pwd = MyMD5.restore(GlobalVariables.upgradeConfig.getAuthPassword());
                String password = String.valueOf(username) + ":" + pwd;
                String encoded = Base64.encode(password.getBytes());
                this.httpUrl.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
            }
            this.httpUrl.setConnectTimeout(20000);
            this.httpUrl.connect();
            this.inputStream = this.httpUrl.getInputStream();
        }
        catch (FileNotFoundException xx) {
            DisplayMessage.showInfoDialog("message.alreadyUpgrade");
            UpgradeUtil.refreshStatus(true, true);
            result = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DisplayMessage.showErrorDialog("message.notcommunicate");
            UpgradeUtil.refreshStatus(true, true);
            result = false;
        }
        return result;
    }

    private boolean isNewUpdatePacket() {
        try {
            this.fromDir = this.fromDir.trim().replace("\\", "/");
            this.fileName = this.fromDir.substring(this.fromDir.lastIndexOf("/") + 1);
            this.length = this.httpUrl.getContentLength();
            this.time = this.httpUrl.getLastModified();
        }
        catch (Exception ex) {
            this.logger.info((Object)("------getMessage----------" + ex.getMessage()));
            ex.printStackTrace();
        }
        String oldFileName = "";
        float oldLength = 0.0f;
        long oldTime = 0L;
        try {
            oldFileName = ReadDatFile.getString("fileName");
            oldLength = Float.parseFloat(ReadDatFile.getString("fileSize"));
            oldTime = Long.parseLong(ReadDatFile.getString("lastModified"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.fileName.equals(oldFileName) && this.length == oldLength && this.time == oldTime;
    }

    private void createdownloaddlg() {
        if (System.getProperty("java.version").startsWith("1.6")) {
            this.downloadDialog = new DownloadDialog16();
        } else {
            this.downloadDialog = new DownloadDialog15();
            this.downloadDialog.setSize(380, 120);
        }
        this.downloadDialog.setLocationRelativeTo(null);
        this.downloadDialog.setTitle("Download");
        this.downloadDialog.setVisible(true);
        this.downloadDialog.setDefaultCloseOperation(0);
        this.downloadDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Download.this.waitting = true;
                int re = DisplayMessage.showConfirmDialog("message.stopnow", "message.confirm");
                if (re == 0) {
                    Download.this.isStop = true;
                    DisplayMessage.showWarningDialog("message.interruptUpgrade");
                    UpgradeUtil.refreshStatus(true, true);
                }
                Download.this.waitting = false;
            }
        });
    }

    private boolean download() {
        File newFile;
        boolean result;
        block24: {
            result = true;
            newFile = null;
            try {
                try {
                    int size = 0;
                    byte[] buf = new byte[BUFFER_SIZE];
                    File f = new File(this.toDir);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    newFile = new File(String.valueOf(this.toDir) + File.separator + this.fileName);
                    this.bis = new BufferedInputStream(this.inputStream);
                    this.fos = new FileOutputStream(newFile);
                    float readLength = 0.0f;
                    this.downloadDialog.note.setText("message.startdownload");
                    while (!this.isStop) {
                        if (this.waitting) {
                            Thread.sleep(100L);
                            continue;
                        }
                        size = this.bis.read(buf);
                        if (size != -1) {
                            this.downloadDialog.note.setText("message.download");
                            this.fos.write(buf, 0, size);
                            float downloadLen = (readLength += (float)size) / this.length * 100.0f;
                            System.out.println("message.downloadof" + Math.round(downloadLen) + "%");
                            this.downloadDialog.progress.setValue(Math.round(downloadLen));
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    result = false;
                    try {
                        if (this.fos != null) {
                            this.fos.close();
                        }
                        if (this.bis != null) {
                            this.bis.close();
                        }
                        if (this.httpUrl != null) {
                            this.httpUrl.disconnect();
                        }
                        break block24;
                    }
                    catch (Exception e) {
                        result = false;
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.fos != null) {
                        this.fos.close();
                    }
                    if (this.bis != null) {
                        this.bis.close();
                    }
                    if (this.httpUrl != null) {
                        this.httpUrl.disconnect();
                    }
                }
                catch (Exception e) {
                    result = false;
                }
                throw throwable;
            }
            try {
                if (this.fos != null) {
                    this.fos.close();
                }
                if (this.bis != null) {
                    this.bis.close();
                }
                if (this.httpUrl != null) {
                    this.httpUrl.disconnect();
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        newFile.setLastModified(this.time);
        return result;
    }

    private boolean isTruethURL() {
        if (this.fromDir == null || "".equals(this.fromDir)) {
            DisplayMessage.showErrorDialog("message.connectionfailure");
            UpgradeUtil.refreshStatus(true, true);
            return false;
        }
        if (Constants.IS_OS_WINDOWS) {
            if (!this.fromDir.endsWith(".zip")) {
                DisplayMessage.showErrorDialog("message.notzipfile");
                UpgradeUtil.refreshStatus(true, true);
                return false;
            }
        } else if (Constants.IS_OS_LINUX) {
            if (!this.fromDir.endsWith(".tar.gz")) {
                DisplayMessage.showErrorDialog("message.notzipfile");
                UpgradeUtil.refreshStatus(true, true);
                return false;
            }
        } else if (Constants.IS_OS_SOLARIS) {
            if (!this.fromDir.endsWith(".tar.gz")) {
                DisplayMessage.showErrorDialog("message.notzipfile");
                UpgradeUtil.refreshStatus(true, true);
                return false;
            }
        } else if ((Constants.IS_OS_MAC || Constants.IS_OS_MAC_OSX) && !this.fromDir.endsWith(".zip")) {
            DisplayMessage.showErrorDialog("message.notzipfile");
            UpgradeUtil.refreshStatus(true, true);
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        if (this.isTruethURL() && this.openURL()) {
            if (!this.isNewUpdatePacket()) {
                this.createdownloaddlg();
                if (this.download()) {
                    if (!this.isStop) {
                        this.downloadDialog.note.setText("message.downloadfinish");
                        String fromZipPath = String.valueOf(this.toDir) + File.separator + this.fileName;
                        try {
                            ReadTempDatFile.updateProperty("fileName", this.fileName.trim());
                            ReadTempDatFile.updateProperty("fileSize", String.valueOf(this.length));
                            ReadTempDatFile.updateProperty("lastModified", String.valueOf(this.time));
                            GlobalVariables.upgradeConfig.setInstallPath(fromZipPath.trim());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        try {
                            ConfigureTools.updateProperties(GlobalVariables.upgradeConfig);
                            ConfigureTools.wrapProperties(GlobalVariables.upgradeConfig);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        String exitMask = "(exit:upgrade";
                        int port = VolUtil.parseInt("38694");
                        try {
                            port = VolUtil.parseInt(GlobalVariables.globalConfig.getUdpPort());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            SystemTrayUDPClient client = new SystemTrayUDPClient("localhost", port);
                            client.send(exitMask.getBytes());
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            StartUpgrade.runUpgrade();
                            System.exit(0);
                        }
                    }
                } else {
                    DisplayMessage.showErrorDialog("message.downloadfailure");
                    this.downloadDialog.dispose();
                    UpgradeUtil.refreshStatus(true, true);
                }
            } else {
                DisplayMessage.showInfoDialog("message.alreadyUpgrade");
                UpgradeUtil.refreshStatus(true, true);
            }
        }
    }

    public static void main(String[] args) {
        String fromdir = "http://192.168.107.222:18080/examples/windows/updateViewPower.zip";
        String todir = "D:/temp";
        Download downLoad = new Download(fromdir, todir);
        downLoad.fileName = fromdir.trim().substring(fromdir.lastIndexOf("/") + 1);
        if (downLoad.openURL()) {
            downLoad.length = downLoad.httpUrl.getContentLength();
            downLoad.createdownloaddlg();
            downLoad.download();
        }
    }
}

