/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import com.sun.imageio.stream.StreamCloser;
import com.sun.imageio.stream.StreamFinalizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.stream.ImageInputStreamImpl;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public class FileCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private static final int BUFFER_LENGTH = 1024;
    private byte[] buf = new byte[1024];
    private long length = 0L;
    private boolean foundEOF = false;
    private final Object disposerReferent;
    private final DisposerRecord disposerRecord;
    private final StreamCloser.CloseAction closeAction;

    public FileCacheImageInputStream(InputStream inputStream, File file) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory!");
        }
        this.stream = inputStream;
        this.cacheFile = file == null ? Files.createTempFile("imageio", ".tmp", new FileAttribute[0]).toFile() : Files.createTempFile(file.toPath(), "imageio", ".tmp", new FileAttribute[0]).toFile();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
        this.closeAction = StreamCloser.createCloseAction(this);
        StreamCloser.addToQueue(this.closeAction);
        this.disposerRecord = new StreamDisposerRecord(this.cacheFile, this.cache);
        if (this.getClass() == FileCacheImageInputStream.class) {
            this.disposerReferent = new Object();
            Disposer.addRecord(this.disposerReferent, this.disposerRecord);
        } else {
            this.disposerReferent = new StreamFinalizer(this);
        }
    }

    private long readUntil(long l) throws IOException {
        if (l < this.length) {
            return l;
        }
        if (this.foundEOF) {
            return this.length;
        }
        long l2 = l - this.length;
        this.cache.seek(this.length);
        while (l2 > 0L) {
            int n = this.stream.read(this.buf, 0, (int)Math.min(l2, 1024L));
            if (n == -1) {
                this.foundEOF = true;
                return this.length;
            }
            this.cache.write(this.buf, 0, n);
            l2 -= (long)n;
            this.length += (long)n;
        }
        return l;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        long l = this.streamPos + 1L;
        long l2 = this.readUntil(l);
        if (l2 >= l) {
            this.cache.seek(this.streamPos++);
            return this.cache.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off+len > b.length || off+len < 0!");
        }
        this.bitOffset = 0;
        if (n2 == 0) {
            return 0;
        }
        long l = this.readUntil(this.streamPos + (long)n2);
        if ((n2 = (int)Math.min((long)n2, l - this.streamPos)) > 0) {
            this.cache.seek(this.streamPos);
            this.cache.readFully(byArray, n, n2);
            this.streamPos += (long)n2;
            return n2;
        }
        return -1;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return false;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.disposerRecord.dispose();
        this.stream = null;
        this.cache = null;
        this.cacheFile = null;
        StreamCloser.removeFromQueue(this.closeAction);
    }

    @Override
    protected void finalize() throws Throwable {
    }

    private static class StreamDisposerRecord
    implements DisposerRecord {
        private File cacheFile;
        private RandomAccessFile cache;

        public StreamDisposerRecord(File file, RandomAccessFile randomAccessFile) {
            this.cacheFile = file;
            this.cache = randomAccessFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void dispose() {
            if (this.cache != null) {
                try {
                    this.cache.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.cache = null;
                }
            }
            if (this.cacheFile != null) {
                this.cacheFile.delete();
                this.cacheFile = null;
            }
        }
    }
}

