/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.support.MutableSortDefinition;
import org.springframework.beans.support.SortDefinition;
import org.springframework.util.StringUtils;

public class PropertyComparator
implements Comparator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final SortDefinition sortDefinition;
    private final BeanWrapperImpl beanWrapper = new BeanWrapperImpl(false);

    public PropertyComparator(SortDefinition sortDefinition) {
        this.sortDefinition = sortDefinition;
    }

    public PropertyComparator(String string, boolean bl, boolean bl2) {
        this.sortDefinition = new MutableSortDefinition(string, bl, bl2);
    }

    public final SortDefinition getSortDefinition() {
        return this.sortDefinition;
    }

    public int compare(Object object, Object object2) {
        int n;
        Object object3 = this.getPropertyValue(object);
        Object object4 = this.getPropertyValue(object2);
        if (this.sortDefinition.isIgnoreCase() && object3 instanceof String && object4 instanceof String) {
            object3 = ((String)object3).toLowerCase();
            object4 = ((String)object4).toLowerCase();
        }
        try {
            n = object3 != null ? (object4 != null ? ((Comparable)object3).compareTo(object4) : -1) : (object4 != null ? 1 : 0);
        }
        catch (RuntimeException runtimeException) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Could not sort objects [" + object + "] and [" + object2 + "]"), (Throwable)runtimeException);
            }
            return 0;
        }
        return this.sortDefinition.isAscending() ? n : -n;
    }

    private Object getPropertyValue(Object object) {
        try {
            this.beanWrapper.setWrappedInstance(object);
            return this.beanWrapper.getPropertyValue(this.sortDefinition.getProperty());
        }
        catch (BeansException beansException) {
            this.logger.info((Object)"PropertyComparator could not access property - treating as null for sorting", (Throwable)((Object)beansException));
            return null;
        }
    }

    public static void sort(List list, SortDefinition sortDefinition) throws BeansException {
        if (StringUtils.hasText((String)sortDefinition.getProperty())) {
            Collections.sort(list, new PropertyComparator(sortDefinition));
        }
    }

    public static void sort(Object[] objectArray, SortDefinition sortDefinition) throws BeansException {
        if (StringUtils.hasText((String)sortDefinition.getProperty())) {
            Arrays.sort(objectArray, new PropertyComparator(sortDefinition));
        }
    }
}

