/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.control;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.control.AbstractControlModule;
import cn.com.voltronic.solar.control.IP18ControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;

public class P18ComUSBControlModule
extends AbstractControlModule
implements IP18ControlModule {
    public P18ComUSBControlModule(Object handler, ConfigData config, Capability capability) {
        super(handler, config, capability);
    }

    private boolean excuteSetCommand(String command, String parmeter) throws Exception {
        IComUSBHandler _handler = (IComUSBHandler)this.getHandler();
        boolean result = false;
        String re = "(NAK";
        if (_handler != null) {
            re = parmeter == null || "".equals(parmeter) ? _handler.excuteSetCommand(command, true) : _handler.excuteSetCommand(String.valueOf(command) + parmeter, true);
        }
        result = re.equals("(ACK");
        return result;
    }

    @Override
    public boolean setPF() {
        boolean result = false;
        try {
            result = this.excuteSetCommand("PF", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setCapability(String x, boolean isEnable) {
        boolean result = false;
        try {
            result = x.equals("A") ? this.excuteSetCommand(isEnable ? "PD" : "PE", x) : this.excuteSetCommand(isEnable ? "PE" : "PD", x);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMCHGV(double cvVoltage, double floatVoltage) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("MCHGV", String.format("%03d,%03d", (int)(cvVoltage * 10.0), (int)(floatVoltage * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPSDV(double cutoffVoltage) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("PSDV", String.format("%03d", (int)(cutoffVoltage * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setBUCD(double chargedV, double dischargedV) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("BUCD", String.format("%03d,%03d", (int)(chargedV * 10.0), (int)(dischargedV * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setF(double value) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("F", String.valueOf((int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMCHGC(int parallkey, double value) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("MCHGC", String.valueOf(parallkey) + "," + String.format("%03d", (int)value));
            System.out.println("---MCHGC---MCHGC" + parallkey + "," + String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMUCHGC(int parallkey, double value) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("MUCHGC", String.valueOf(parallkey) + "," + String.format("%03d", (int)value));
            System.out.println("---setMUCHGC---MUCHGC" + parallkey + "," + String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPBT(int value) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("PBT", String.valueOf(value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPSP(int value) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("PSP", String.valueOf(value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPCP(int parallkey, int value) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("PCP", String.valueOf(parallkey) + "," + value);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPGR(int value) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("PGR", String.valueOf(value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPOP(int value) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("POP", String.valueOf(value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPOPM(int parallkey, int value) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("POPM", String.valueOf(parallkey) + "," + value);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setV(double value) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("V", String.format("%04d", (int)(value * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setCurrentTime(String time) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("DAT", time);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setACCT(String time1, String time2) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("ACCT", String.valueOf(time1) + "," + time2);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setACLT(String time1, String time2) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("ACLT", String.valueOf(time1) + "," + time2);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setCLE() {
        boolean result = false;
        try {
            result = this.excuteSetCommand("CLE", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setRS(String value) {
        boolean result = false;
        try {
            result = this.excuteSetCommand("RS", value);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

