/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;

public class NumberUtils {
    public static final Long LONG_ZERO = new Long(0L);
    public static final Long LONG_ONE = new Long(1L);
    public static final Long LONG_MINUS_ONE = new Long(-1L);
    public static final Integer INTEGER_ZERO = new Integer(0);
    public static final Integer INTEGER_ONE = new Integer(1);
    public static final Integer INTEGER_MINUS_ONE = new Integer(-1);
    public static final Short SHORT_ZERO = new Short(0);
    public static final Short SHORT_ONE = new Short(1);
    public static final Short SHORT_MINUS_ONE = new Short(-1);
    public static final Byte BYTE_ZERO = new Byte(0);
    public static final Byte BYTE_ONE = new Byte(1);
    public static final Byte BYTE_MINUS_ONE = new Byte(-1);
    public static final Double DOUBLE_ZERO = new Double(0.0);
    public static final Double DOUBLE_ONE = new Double(1.0);
    public static final Double DOUBLE_MINUS_ONE = new Double(-1.0);
    public static final Float FLOAT_ZERO = new Float(0.0f);
    public static final Float FLOAT_ONE = new Float(1.0f);
    public static final Float FLOAT_MINUS_ONE = new Float(-1.0f);

    public static int stringToInt(String string) {
        return NumberUtils.toInt(string);
    }

    public static int toInt(String string) {
        return NumberUtils.toInt(string, 0);
    }

    public static int stringToInt(String string, int n) {
        return NumberUtils.toInt(string, n);
    }

    public static int toInt(String string, int n) {
        if (string == null) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static long toLong(String string) {
        return NumberUtils.toLong(string, 0L);
    }

    public static long toLong(String string, long l) {
        if (string == null) {
            return l;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public static float toFloat(String string) {
        return NumberUtils.toFloat(string, 0.0f);
    }

    public static float toFloat(String string, float f) {
        if (string == null) {
            return f;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public static double toDouble(String string) {
        return NumberUtils.toDouble(string, 0.0);
    }

    public static double toDouble(String string, double d) {
        if (string == null) {
            return d;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static Number createNumber(String string) throws NumberFormatException {
        Number number;
        String string2;
        String string3;
        if (string == null) {
            return null;
        }
        if (StringUtils.isBlank(string)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (string.startsWith("--")) {
            return null;
        }
        if (string.startsWith("0x") || string.startsWith("-0x")) {
            return NumberUtils.createInteger(string);
        }
        char c = string.charAt(string.length() - 1);
        int n = string.indexOf(46);
        int n2 = string.indexOf(101) + string.indexOf(69) + 1;
        if (n > -1) {
            if (n2 > -1) {
                if (n2 < n) {
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                string3 = string.substring(n + 1, n2);
            } else {
                string3 = string.substring(n + 1);
            }
            string2 = string.substring(0, n);
        } else {
            string2 = n2 > -1 ? string.substring(0, n2) : string;
            string3 = null;
        }
        if (!Character.isDigit(c)) {
            String string4 = n2 > -1 && n2 < string.length() - 1 ? string.substring(n2 + 1, string.length() - 1) : null;
            String string5 = string.substring(0, string.length() - 1);
            boolean bl = NumberUtils.isAllZeros(string2) && NumberUtils.isAllZeros(string4);
            switch (c) {
                case 'L': 
                case 'l': {
                    if (string3 == null && string4 == null && NumberUtils.isDigits(string5.substring(1)) && (string5.charAt(0) == '-' || Character.isDigit(string5.charAt(0)))) {
                        try {
                            return NumberUtils.createLong(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(string5);
                        }
                    }
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    Number number2;
                    try {
                        number2 = NumberUtils.createFloat(string5);
                        if (!((Float)number2).isInfinite() && (((Float)number2).floatValue() != 0.0f || bl)) {
                            return number2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    Number number2;
                    try {
                        number2 = NumberUtils.createDouble(string5);
                        if (!((Double)number2).isInfinite() && ((double)((Double)number2).floatValue() != 0.0 || bl)) {
                            return number2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(string + " is not a valid number.");
        }
        String string6 = n2 > -1 && n2 < string.length() - 1 ? string.substring(n2 + 1, string.length()) : null;
        if (string3 == null && string6 == null) {
            try {
                return NumberUtils.createInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return NumberUtils.createLong(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    return NumberUtils.createBigInteger(string);
                }
            }
        }
        boolean bl = NumberUtils.isAllZeros(string2) && NumberUtils.isAllZeros(string6);
        try {
            number = NumberUtils.createFloat(string);
            if (!((Float)number).isInfinite() && (((Float)number).floatValue() != 0.0f || bl)) {
                return number;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            number = NumberUtils.createDouble(string);
            if (!((Double)number).isInfinite() && ((Double)number != 0.0 || bl)) {
                return number;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NumberUtils.createBigDecimal(string);
    }

    private static boolean isAllZeros(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) != '0') {
                return false;
            }
            --n;
        }
        return string.length() > 0;
    }

    public static Float createFloat(String string) {
        if (string == null) {
            return null;
        }
        return Float.valueOf(string);
    }

    public static Double createDouble(String string) {
        if (string == null) {
            return null;
        }
        return Double.valueOf(string);
    }

    public static Integer createInteger(String string) {
        if (string == null) {
            return null;
        }
        return Integer.decode(string);
    }

    public static Long createLong(String string) {
        if (string == null) {
            return null;
        }
        return Long.valueOf(string);
    }

    public static BigInteger createBigInteger(String string) {
        if (string == null) {
            return null;
        }
        return new BigInteger(string);
    }

    public static BigDecimal createBigDecimal(String string) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isBlank(string)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        return new BigDecimal(string);
    }

    public static long min(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (lArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long l = lArray[0];
        int n = 1;
        while (n < lArray.length) {
            if (lArray[n] < l) {
                l = lArray[n];
            }
            ++n;
        }
        return l;
    }

    public static int min(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int n = nArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            if (nArray[n2] < n) {
                n = nArray[n2];
            }
            ++n2;
        }
        return n;
    }

    public static short min(short[] sArray) {
        if (sArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (sArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        short s = sArray[0];
        int n = 1;
        while (n < sArray.length) {
            if (sArray[n] < s) {
                s = sArray[n];
            }
            ++n;
        }
        return s;
    }

    public static double min(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (dArray[n] < d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static float min(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float f = fArray[0];
        int n = 1;
        while (n < fArray.length) {
            if (fArray[n] < f) {
                f = fArray[n];
            }
            ++n;
        }
        return f;
    }

    public static long max(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (lArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long l = lArray[0];
        int n = 1;
        while (n < lArray.length) {
            if (lArray[n] > l) {
                l = lArray[n];
            }
            ++n;
        }
        return l;
    }

    public static int max(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int n = nArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            if (nArray[n2] > n) {
                n = nArray[n2];
            }
            ++n2;
        }
        return n;
    }

    public static short max(short[] sArray) {
        if (sArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (sArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        short s = sArray[0];
        int n = 1;
        while (n < sArray.length) {
            if (sArray[n] > s) {
                s = sArray[n];
            }
            ++n;
        }
        return s;
    }

    public static double max(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (dArray[n] > d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static float max(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float f = fArray[0];
        int n = 1;
        while (n < fArray.length) {
            if (fArray[n] > f) {
                f = fArray[n];
            }
            ++n;
        }
        return f;
    }

    public static long min(long l, long l2, long l3) {
        if (l2 < l) {
            l = l2;
        }
        if (l3 < l) {
            l = l3;
        }
        return l;
    }

    public static int min(int n, int n2, int n3) {
        if (n2 < n) {
            n = n2;
        }
        if (n3 < n) {
            n = n3;
        }
        return n;
    }

    public static short min(short s, short s2, short s3) {
        if (s2 < s) {
            s = s2;
        }
        if (s3 < s) {
            s = s3;
        }
        return s;
    }

    public static byte min(byte by, byte by2, byte by3) {
        if (by2 < by) {
            by = by2;
        }
        if (by3 < by) {
            by = by3;
        }
        return by;
    }

    public static double min(double d, double d2, double d3) {
        return Math.min(Math.min(d, d2), d3);
    }

    public static float min(float f, float f2, float f3) {
        return Math.min(Math.min(f, f2), f3);
    }

    public static long max(long l, long l2, long l3) {
        if (l2 > l) {
            l = l2;
        }
        if (l3 > l) {
            l = l3;
        }
        return l;
    }

    public static int max(int n, int n2, int n3) {
        if (n2 > n) {
            n = n2;
        }
        if (n3 > n) {
            n = n3;
        }
        return n;
    }

    public static short max(short s, short s2, short s3) {
        if (s2 > s) {
            s = s2;
        }
        if (s3 > s) {
            s = s3;
        }
        return s;
    }

    public static byte max(byte by, byte by2, byte by3) {
        if (by2 > by) {
            by = by2;
        }
        if (by3 > by) {
            by = by3;
        }
        return by;
    }

    public static double max(double d, double d2, double d3) {
        return Math.max(Math.max(d, d2), d3);
    }

    public static float max(float f, float f2, float f3) {
        return Math.max(Math.max(f, f2), f3);
    }

    public static int compare(double d, double d2) {
        long l;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        long l2 = Double.doubleToLongBits(d);
        if (l2 == (l = Double.doubleToLongBits(d2))) {
            return 0;
        }
        if (l2 < l) {
            return -1;
        }
        return 1;
    }

    public static int compare(float f, float f2) {
        int n;
        if (f < f2) {
            return -1;
        }
        if (f > f2) {
            return 1;
        }
        int n2 = Float.floatToIntBits(f);
        if (n2 == (n = Float.floatToIntBits(f2))) {
            return 0;
        }
        if (n2 < n) {
            return -1;
        }
        return 1;
    }

    public static boolean isDigits(String string) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isDigit(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isNumber(String var0) {
        block21: {
            if (StringUtils.isEmpty(var0)) {
                return false;
            }
            var1_1 = var0.toCharArray();
            var2_2 = var1_1.length;
            var3_3 = false;
            var4_4 = false;
            var5_5 = false;
            var6_6 = false;
            v0 = var7_7 = var1_1[0] == '-' ? 1 : 0;
            if (var2_2 <= var7_7 + 1 || var1_1[var7_7] != '0' || var1_1[var7_7 + 1] != 'x') break block21;
            var8_8 = var7_7 + 2;
            if (var8_8 != var2_2) ** GOTO lbl17
            return false;
lbl-1000:
            // 1 sources

            {
                if (!(var1_1[var8_8] >= '0' && var1_1[var8_8] <= '9' || var1_1[var8_8] >= 'a' && var1_1[var8_8] <= 'f' || var1_1[var8_8] >= 'A' && var1_1[var8_8] <= 'F')) {
                    return false;
                }
                ++var8_8;
lbl17:
                // 2 sources

                ** while (var8_8 < var1_1.length)
            }
lbl18:
            // 1 sources

            return true;
        }
        --var2_2;
        var8_9 = var7_7;
        while (var8_9 < var2_2 || var8_9 < var2_2 + 1 && var5_5 && !var6_6) {
            if (var1_1[var8_9] >= '0' && var1_1[var8_9] <= '9') {
                var6_6 = true;
                var5_5 = false;
            } else if (var1_1[var8_9] == '.') {
                if (var4_4 || var3_3) {
                    return false;
                }
                var4_4 = true;
            } else if (var1_1[var8_9] == 'e' || var1_1[var8_9] == 'E') {
                if (var3_3) {
                    return false;
                }
                if (!var6_6) {
                    return false;
                }
                var3_3 = true;
                var5_5 = true;
            } else if (var1_1[var8_9] == '+' || var1_1[var8_9] == '-') {
                if (!var5_5) {
                    return false;
                }
                var5_5 = false;
                var6_6 = false;
            } else {
                return false;
            }
            ++var8_9;
        }
        if (var8_9 < var1_1.length) {
            if (var1_1[var8_9] >= '0' && var1_1[var8_9] <= '9') {
                return true;
            }
            if (var1_1[var8_9] == 'e' || var1_1[var8_9] == 'E') {
                return false;
            }
            if (!(var5_5 || var1_1[var8_9] != 'd' && var1_1[var8_9] != 'D' && var1_1[var8_9] != 'f' && var1_1[var8_9] != 'F')) {
                return var6_6;
            }
            if (var1_1[var8_9] == 'l' || var1_1[var8_9] == 'L') {
                return var6_6 != false && var3_3 == false;
            }
            return false;
        }
        return var5_5 == false && var6_6 != false;
    }
}

