/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.util.Assert;

public class PropertyBatchUpdateException
extends BeansException {
    private PropertyAccessException[] propertyAccessExceptions;

    public PropertyBatchUpdateException(PropertyAccessException[] propertyAccessExceptionArray) {
        super(null);
        Assert.notEmpty((Object[])propertyAccessExceptionArray, (String)"At least 1 PropertyAccessException required");
        this.propertyAccessExceptions = propertyAccessExceptionArray;
    }

    public final int getExceptionCount() {
        return this.propertyAccessExceptions.length;
    }

    public final PropertyAccessException[] getPropertyAccessExceptions() {
        return this.propertyAccessExceptions;
    }

    public PropertyAccessException getPropertyAccessException(String string) {
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            PropertyAccessException propertyAccessException = this.propertyAccessExceptions[i];
            if (!string.equals(propertyAccessException.getPropertyChangeEvent().getPropertyName())) continue;
            return propertyAccessException;
        }
        return null;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer("Failed properties: ");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            stringBuffer.append(this.propertyAccessExceptions[i].getMessage());
            if (i >= this.propertyAccessExceptions.length - 1) continue;
            stringBuffer.append("; ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(((Object)((Object)this)).getClass().getName()).append("; nested PropertyAccessExceptions (");
        stringBuffer.append(this.getExceptionCount()).append(") are:");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            stringBuffer.append('\n').append("PropertyAccessException ").append(i + 1).append(": ");
            stringBuffer.append((Object)this.propertyAccessExceptions[i]);
        }
        return stringBuffer.toString();
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.println(((Object)((Object)this)).getClass().getName() + "; nested PropertyAccessException details (" + this.getExceptionCount() + ") are:");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            printStream.println("PropertyAccessException " + (i + 1) + ":");
            this.propertyAccessExceptions[i].printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println(((Object)((Object)this)).getClass().getName() + "; nested PropertyAccessException details (" + this.getExceptionCount() + ") are:");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            printWriter.println("PropertyAccessException " + (i + 1) + ":");
            this.propertyAccessExceptions[i].printStackTrace(printWriter);
        }
    }

    public boolean contains(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isInstance((Object)this)) {
            return true;
        }
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            PropertyAccessException propertyAccessException = this.propertyAccessExceptions[i];
            if (!propertyAccessException.contains(clazz)) continue;
            return true;
        }
        return false;
    }
}

