/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.util.ObjectUtils;

public abstract class BeanDefinitionVisitor {
    public void visitBeanDefinition(BeanDefinition beanDefinition) {
        this.visitBeanClassName(beanDefinition);
        this.visitScope(beanDefinition);
        this.visitPropertyValues(beanDefinition.getPropertyValues());
        ConstructorArgumentValues constructorArgumentValues = beanDefinition.getConstructorArgumentValues();
        this.visitIndexedArgumentValues(constructorArgumentValues.getIndexedArgumentValues());
        this.visitGenericArgumentValues(constructorArgumentValues.getGenericArgumentValues());
    }

    protected void visitBeanClassName(BeanDefinition beanDefinition) {
        String string;
        String string2 = beanDefinition.getBeanClassName();
        if (string2 != null && !string2.equals(string = this.resolveStringValue(string2))) {
            beanDefinition.setBeanClassName(string);
        }
    }

    protected void visitScope(BeanDefinition beanDefinition) {
        String string;
        String string2 = beanDefinition.getScope();
        if (string2 != null && !string2.equals(string = this.resolveStringValue(string2))) {
            beanDefinition.setScope(string);
        }
    }

    protected void visitPropertyValues(MutablePropertyValues mutablePropertyValues) {
        PropertyValue[] propertyValueArray = mutablePropertyValues.getPropertyValues();
        for (int i = 0; i < propertyValueArray.length; ++i) {
            PropertyValue propertyValue = propertyValueArray[i];
            Object object = this.resolveValue(propertyValue.getValue());
            if (ObjectUtils.nullSafeEquals((Object)object, (Object)propertyValue.getValue())) continue;
            mutablePropertyValues.addPropertyValue(propertyValue.getName(), object);
        }
    }

    protected void visitIndexedArgumentValues(Map map) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)iterator.next();
            Object object = this.resolveValue(valueHolder.getValue());
            if (ObjectUtils.nullSafeEquals((Object)object, (Object)valueHolder.getValue())) continue;
            valueHolder.setValue(object);
        }
    }

    protected void visitGenericArgumentValues(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)iterator.next();
            Object object = this.resolveValue(valueHolder.getValue());
            if (ObjectUtils.nullSafeEquals((Object)object, (Object)valueHolder.getValue())) continue;
            valueHolder.setValue(object);
        }
    }

    protected Object resolveValue(Object object) {
        if (object instanceof BeanDefinition) {
            this.visitBeanDefinition((BeanDefinition)object);
        } else if (object instanceof BeanDefinitionHolder) {
            this.visitBeanDefinition(((BeanDefinitionHolder)object).getBeanDefinition());
        } else if (object instanceof RuntimeBeanReference) {
            RuntimeBeanReference runtimeBeanReference = (RuntimeBeanReference)object;
            String string = this.resolveStringValue(runtimeBeanReference.getBeanName());
            if (!string.equals(runtimeBeanReference.getBeanName())) {
                return new RuntimeBeanReference(string);
            }
        } else if (object instanceof List) {
            this.visitList((List)object);
        } else if (object instanceof Set) {
            this.visitSet((Set)object);
        } else if (object instanceof Map) {
            this.visitMap((Map)object);
        } else if (object instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)object;
            String string = typedStringValue.getValue();
            if (string != null) {
                String string2 = this.resolveStringValue(string);
                typedStringValue.setValue(string2);
            }
        } else if (object instanceof String) {
            return this.resolveStringValue((String)object);
        }
        return object;
    }

    protected void visitList(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            Object object = this.resolveValue(e);
            if (ObjectUtils.nullSafeEquals((Object)object, e)) continue;
            list.set(i, object);
        }
    }

    protected void visitSet(Set set) {
        Iterator iterator = new HashSet(set).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object = this.resolveValue(e);
            if (ObjectUtils.nullSafeEquals((Object)object, e)) continue;
            set.remove(e);
            set.add(object);
        }
    }

    protected void visitMap(Map map) {
        Iterator iterator = new HashMap(map).entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            boolean bl = !ObjectUtils.nullSafeEquals(k, (Object)(object = this.resolveValue(k)));
            Object v = entry.getValue();
            Object object2 = this.resolveValue(v);
            if (bl) {
                map.remove(k);
            }
            if (!bl && ObjectUtils.nullSafeEquals((Object)object2, v)) continue;
            map.put(object, object2);
        }
    }

    protected abstract String resolveStringValue(String var1);
}

