/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.tool.communicate;

import cn.com.voltronic.tool.communicate.CommunicateHandler;
import cn.com.voltronic.tool.communicate.SerialPortHandler;
import cn.com.voltronic.tool.communicate.USBHandler;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import usb.IUSBComm;
import usb.USBComm;

public class CommConnector {
    private static CommConnector connector = null;
    private CommunicateHandler _handler = null;
    private IUSBComm usbComm = new USBComm();

    private CommConnector() {
    }

    public CommunicateHandler getHandler() {
        return this._handler;
    }

    public static CommConnector getInstance() {
        if (connector == null) {
            connector = new CommConnector();
        }
        return connector;
    }

    public List<String> autoSearchLocalcomms() {
        ArrayList<String> deviceList = new ArrayList<String>();
        Enumeration portEn = CommPortIdentifier.getPortIdentifiers();
        while (portEn.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portEn.nextElement();
            if (portId.getPortType() != 1) continue;
            deviceList.add(portId.getName());
        }
        String usbDevices = this.usbComm.findUSBDevices();
        String[] devices = usbDevices.split("#");
        if (devices != null && devices.length > 0) {
            String[] stringArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                String usbId = stringArray[n2];
                if (usbId != null && !"".equals(usbId)) {
                    deviceList.add("USB" + usbId);
                }
                ++n2;
            }
        }
        return deviceList;
    }

    public CommunicateHandler connDeviceByName(String portName, String baudRate) {
        block9: {
            if (portName.startsWith("USB")) {
                try {
                    String usbDevices = this.usbComm.findUSBDevices();
                    String[] devices = usbDevices.split("#");
                    if (devices == null || devices.length <= 0) break block9;
                    String[] stringArray = devices;
                    int n = devices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String usbId = stringArray[n2];
                        if (usbId != null && !"".equals(usbId) && usbId.equalsIgnoreCase(portName.substring(3))) {
                            this.openUSB(usbId);
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    Enumeration portEn = CommPortIdentifier.getPortIdentifiers();
                    while (portEn.hasMoreElements()) {
                        CommPortIdentifier portId = (CommPortIdentifier)portEn.nextElement();
                        if (portId.getPortType() != 1 || !portName.equalsIgnoreCase(portId.getName())) continue;
                        this.openSerialPort(portId, baudRate);
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this._handler;
    }

    private CommunicateHandler openSerialPort(CommPortIdentifier portId, String baudRate) {
        block4: {
            int baudRateInt = 2400;
            try {
                baudRateInt = Integer.parseInt(baudRate);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            SerialPort serialPort = null;
            try {
                serialPort = (SerialPort)portId.open("Arista", baudRateInt);
                serialPort.setSerialPortParams(baudRateInt, 8, 1, 0);
                this._handler = new SerialPortHandler(portId, serialPort);
            }
            catch (Exception e) {
                if (serialPort == null) break block4;
                serialPort.close();
            }
        }
        return this._handler;
    }

    public CommunicateHandler openUSB(String usbId) {
        this._handler = new USBHandler(this.usbComm, usbId);
        return this._handler;
    }

    public void close() {
        if (this._handler != null) {
            this._handler.close();
        }
    }
}

