/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.dns;

import com.sun.jndi.url.dns.dnsURLContext;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;

public class dnsURLContextFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        if (object == null) {
            return new dnsURLContext(hashtable);
        }
        if (object instanceof String) {
            return dnsURLContextFactory.getUsingURL((String)object, hashtable);
        }
        if (object instanceof String[]) {
            return dnsURLContextFactory.getUsingURLs((String[])object, hashtable);
        }
        throw new ConfigurationException("dnsURLContextFactory.getObjectInstance: argument must be a DNS URL String or an array of them");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getUsingURL(String string, Hashtable hashtable) throws NamingException {
        try (dnsURLContext dnsURLContext2 = new dnsURLContext(hashtable);){
            Object object = dnsURLContext2.lookup(string);
            return object;
        }
    }

    private static Object getUsingURLs(String[] stringArray, Hashtable hashtable) throws NamingException {
        if (stringArray.length == 0) {
            throw new ConfigurationException("dnsURLContextFactory: empty URL array");
        }
        try (dnsURLContext dnsURLContext2 = new dnsURLContext(hashtable);){
            NamingException namingException = null;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    Object object = dnsURLContext2.lookup(stringArray[i]);
                    return object;
                }
                catch (NamingException namingException2) {
                    namingException = namingException2;
                    continue;
                }
            }
            throw namingException;
        }
    }
}

