/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.tools;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class TransformInputOutput {
    private static URI currentJavaWorkingDirectory = new File(System.getProperty("user.dir")).toURI();

    public void parse(String[] stringArray) throws Exception {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        if (stringArray.length == 0) {
            bufferedInputStream = new BufferedInputStream(System.in);
            bufferedOutputStream = new BufferedOutputStream(System.out);
        } else if (stringArray.length == 1) {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(stringArray[0]));
            bufferedOutputStream = new BufferedOutputStream(System.out);
        } else if (stringArray.length == 2) {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(stringArray[0]));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(stringArray[1]));
        } else {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.optinalFileNotSpecified"));
        }
        this.parse(bufferedInputStream, bufferedOutputStream);
    }

    public abstract void parse(InputStream var1, OutputStream var2) throws Exception;

    public void parse(InputStream inputStream, OutputStream outputStream, String string) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected static EntityResolver createRelativePathResolver(final String string) {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String string3, String string2) throws SAXException, IOException {
                if (string2 != null && string2.startsWith("file:/")) {
                    URI uRI = new File(string).toURI();
                    try {
                        URI uRI2 = TransformInputOutput.convertToNewWorkingDirectory(currentJavaWorkingDirectory, uRI, new File(new URI(string2)).toURI());
                        return new InputSource(uRI2.toString());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                return null;
            }
        };
    }

    private static URI convertToNewWorkingDirectory(URI uRI, URI uRI2, URI uRI3) throws IOException, URISyntaxException {
        int n;
        int n2;
        String string = uRI.toString();
        String string2 = uRI2.toString();
        String string3 = uRI3.toString();
        String string4 = null;
        if (string3.startsWith(string) && (string4 = string3.substring(string.length())).indexOf(47) == -1) {
            return new URI(string2 + '/' + string4);
        }
        String[] stringArray = string.split("/");
        String[] stringArray2 = string2.split("/");
        String[] stringArray3 = string3.split("/");
        int n3 = 0;
        while (n3 < stringArray.length & n3 < stringArray3.length && stringArray[n3].equals(stringArray3[n3])) {
            ++n3;
        }
        for (n2 = 0; n2 < stringArray2.length && n2 < stringArray3.length && stringArray2[n2].equals(stringArray3[n2]); ++n2) {
        }
        if (n2 > n3) {
            return uRI3;
        }
        int n4 = stringArray.length - n3;
        StringBuffer stringBuffer = new StringBuffer(100);
        for (n = 0; n < stringArray2.length - n4; ++n) {
            stringBuffer.append(stringArray2[n]);
            stringBuffer.append('/');
        }
        for (n = n3; n < stringArray3.length; ++n) {
            stringBuffer.append(stringArray3[n]);
            if (n >= stringArray3.length - 1) continue;
            stringBuffer.append('/');
        }
        return new URI(stringBuffer.toString());
    }
}

