/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.internal.ws.developer.HttpConfigFeature;
import javax.xml.ws.WebServiceFeature;

public final class DeferredTransportPipe
extends AbstractTubeImpl {
    private Tube transport;
    private EndpointAddress address;
    private final ClassLoader classLoader;
    private final ClientTubeAssemblerContext context;

    public DeferredTransportPipe(ClassLoader classLoader, ClientTubeAssemblerContext clientTubeAssemblerContext) {
        this.classLoader = classLoader;
        this.context = clientTubeAssemblerContext;
        if (clientTubeAssemblerContext.getBinding().getFeature(HttpConfigFeature.class) == null) {
            clientTubeAssemblerContext.getBinding().getFeatures().mergeFeatures(new WebServiceFeature[]{new HttpConfigFeature()}, false);
        }
        try {
            this.transport = TransportTubeFactory.create(classLoader, clientTubeAssemblerContext);
            this.address = clientTubeAssemblerContext.getAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeferredTransportPipe(DeferredTransportPipe deferredTransportPipe, TubeCloner tubeCloner) {
        super(deferredTransportPipe, tubeCloner);
        this.classLoader = deferredTransportPipe.classLoader;
        this.context = deferredTransportPipe.context;
        if (deferredTransportPipe.transport != null) {
            this.transport = tubeCloner.copy(deferredTransportPipe.transport);
            this.address = deferredTransportPipe.address;
        }
    }

    @Override
    public NextAction processException(@NotNull Throwable throwable) {
        return this.transport.processException(throwable);
    }

    @Override
    public NextAction processRequest(@NotNull Packet packet) {
        if (packet.endpointAddress == this.address) {
            return this.transport.processRequest(packet);
        }
        if (this.transport != null) {
            this.transport.preDestroy();
            this.transport = null;
            this.address = null;
        }
        ClientTubeAssemblerContext clientTubeAssemblerContext = new ClientTubeAssemblerContext(packet.endpointAddress, this.context.getWsdlModel(), this.context.getBindingProvider(), this.context.getBinding(), this.context.getContainer(), this.context.getCodec().copy(), this.context.getSEIModel());
        this.address = packet.endpointAddress;
        this.transport = TransportTubeFactory.create(this.classLoader, clientTubeAssemblerContext);
        assert (this.transport != null);
        return this.transport.processRequest(packet);
    }

    @Override
    public NextAction processResponse(@NotNull Packet packet) {
        return this.transport.processResponse(packet);
    }

    @Override
    public void preDestroy() {
        if (this.transport != null) {
            this.transport.preDestroy();
            this.transport = null;
            this.address = null;
        }
    }

    @Override
    public DeferredTransportPipe copy(TubeCloner tubeCloner) {
        return new DeferredTransportPipe(this, tubeCloner);
    }
}

