/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class Conventions {
    private static final String PLURAL_SUFFIX = "List";
    private static final Set ignoredInterfaces = new HashSet();
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$lang$Cloneable;
    static /* synthetic */ Class class$java$lang$Comparable;

    public static String getVariableName(Object object) {
        Object object2;
        Assert.notNull(object, "Value must not be null");
        Class clazz = null;
        boolean bl = false;
        if (object.getClass().isArray()) {
            clazz = object.getClass().getComponentType();
            bl = true;
        } else if (object instanceof Collection) {
            object2 = (Collection)object;
            if (object2.isEmpty()) {
                throw new IllegalArgumentException("Cannot generate variable name for an empty Collection");
            }
            Object object3 = Conventions.peekAhead((Collection)object2);
            clazz = Conventions.getClassForValue(object3);
            bl = true;
        } else {
            clazz = Conventions.getClassForValue(object);
        }
        object2 = StringUtils.uncapitalize(Conventions.getShortName(clazz));
        return bl ? Conventions.pluralize((String)object2) : object2;
    }

    public static String attributeNameToPropertyName(String string) {
        Assert.notNull(string, "'attributeName' must not be null");
        if (string.indexOf("-") == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length - 1];
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '-') {
                bl = true;
                continue;
            }
            if (bl) {
                cArray2[n++] = Character.toUpperCase(c);
                bl = false;
                continue;
            }
            cArray2[n++] = c;
        }
        return new String(cArray2, 0, n);
    }

    private static Class getClassForValue(Object object) {
        if (Proxy.isProxyClass(object.getClass())) {
            Class<?>[] classArray = object.getClass().getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz = classArray[i];
                if (ignoredInterfaces.contains(clazz)) continue;
                return clazz;
            }
        }
        return object.getClass();
    }

    private static String getShortName(Class clazz) {
        String string = ClassUtils.getShortName(clazz);
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(n + 1) : string;
    }

    private static String pluralize(String string) {
        return string + PLURAL_SUFFIX;
    }

    private static Object peekAhead(Collection collection) {
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - no element found");
        }
        Object e = iterator.next();
        if (e == null) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - only null element found");
        }
        return e;
    }

    public static String getQualifiedAttributeName(Class clazz, String string) {
        Assert.notNull(clazz, "'enclosingClass' must not be null");
        Assert.notNull(string, "'attributeName' must not be null");
        return clazz.getName() + "." + string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ignoredInterfaces.add(class$java$io$Serializable == null ? (class$java$io$Serializable = Conventions.class$("java.io.Serializable")) : class$java$io$Serializable);
        ignoredInterfaces.add(class$java$io$Externalizable == null ? (class$java$io$Externalizable = Conventions.class$("java.io.Externalizable")) : class$java$io$Externalizable);
        ignoredInterfaces.add(class$java$lang$Cloneable == null ? (class$java$lang$Cloneable = Conventions.class$("java.lang.Cloneable")) : class$java$lang$Cloneable);
        ignoredInterfaces.add(class$java$lang$Comparable == null ? (class$java$lang$Comparable = Conventions.class$("java.lang.Comparable")) : class$java$lang$Comparable);
    }
}

