/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.bernstein;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;

public class BernsteinUtils {
    private static final Icon BG_IMAGE = new LazyImageIcon("bernstein/icons/background.jpg");
    private static final int IMAGE_WIDTH = BG_IMAGE.getIconWidth();
    private static final int IMAGE_HEIGHT = BG_IMAGE.getIconHeight();

    private BernsteinUtils() {
    }

    public static void fillComponent(Graphics graphics, Component component) {
        if (AbstractLookAndFeel.getTheme().isBackgroundPatternOn()) {
            int n = component.getWidth();
            int n2 = component.getHeight();
            Point point = JTattooUtilities.getRelLocation(component);
            for (int i = -point.y; i < n2; i += IMAGE_HEIGHT) {
                for (int j = -point.x; j < n; j += IMAGE_WIDTH) {
                    BG_IMAGE.paintIcon(component, graphics, j, i);
                }
            }
        } else {
            graphics.setColor(AbstractLookAndFeel.getBackgroundColor());
            graphics.fillRect(0, 0, component.getWidth(), component.getHeight());
        }
    }
}

