/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.beanbag.P17BeanBag;
import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.AbstractComUSBProcessor;
import cn.com.voltronic.solar.control.P17ComUSBControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.data.bean.DefaultData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProtocolInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.exception.FaultHandler;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.webservice.WebServices;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class P17ComUSBProcessor
extends AbstractComUSBProcessor {
    private static final Logger LOGGER = Logger.getLogger(P17ComUSBProcessor.class);
    protected final int TEN = 10;
    protected final int HUNDRED = 100;
    private Object query_hour = new Integer(0);
    private Object query_day = new Integer(1);
    private Object query_month = new Integer(2);
    private Object query_year = new Integer(3);
    private Object query_tatal = new Integer(4);
    private String pollFaultID = null;
    protected static final int TENK = 10000;
    protected static final int FIVEK = 5000;
    protected static final int FOURK = 4000;
    protected static final int THREEK = 3000;
    protected static final int outputA = 0;

    public P17ComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    protected void initBeanBag() {
        this._beanbag = new P17BeanBag();
    }

    @Override
    protected void initControlModule() {
        this._control = new P17ComUSBControlModule(this.getHandler(), (ConfigData)this._beanbag.getBean("configdata"), (Capability)this._beanbag.getBean("capability"));
    }

    @Override
    public void initProtocol() {
        ProtocolInfo info = (ProtocolInfo)this.getBeanBag().getBean("protocolinfo");
        info.setProdid(this._protocol.getProtocolID());
        info.setBaseInfo(this._protocol.getBaseInfo());
        info.setProductInfo(this._protocol.getProductInfo());
        info.setRatingInfo(this._protocol.getRatingInfo());
        try {
            info.setSerialno(this._protocol.getSerialNo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        info.setMoreInfo(this._protocol.getMoreInfo());
        info.setMpptTrackNumber(this._protocol.getMpptTrackNumber());
    }

    @Override
    public P17BeanBag getBeanBag() {
        return (P17BeanBag)this._beanbag;
    }

    @Override
    public boolean pollQueryStatus() {
        if (!super.pollQueryStatus()) {
            ++this.reconnectTimes;
            return false;
        }
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            String qpicf;
            String qpiws;
            workinfo.setProdid(this._protocol.getProtocolID());
            workinfo.setSerialno(this.getProtocol().getSerialNo());
            if (this.currenttime != null) {
                workinfo.setCurrentTime(this.currenttime.getTime());
            }
            if ("".equals(qpiws = handler.excuteCommand("WS", true)) || qpiws.equals("(NAK")) {
                return result;
            }
            String[] ws = qpiws.split(",");
            if (ws.length != 0) {
                if (this._protocol.getProtocolID().equals("P17P1S1")) {
                    this.handlerEventP17P1S1(ws, workinfo);
                } else {
                    this.handlerEvent(ws, workinfo);
                }
                if (ws[9].equals("1") || ws[10].equals("1") || ws[11].equals("1") || ws[12].equals("1") || ws[13].equals("1")) {
                    workinfo.setLineLoss(true);
                } else {
                    workinfo.setLineLoss(false);
                }
                if (ws[6].equals("1")) {
                    workinfo.setNoBattery(true);
                } else {
                    workinfo.setNoBattery(false);
                }
                if (ws[19].equals("1")) {
                    workinfo.setOverLoad(true);
                } else {
                    workinfo.setOverLoad(false);
                }
            }
            Calendar machineTime = Calendar.getInstance();
            machineTime.setTime(workinfo.getCurrentTime());
            Calendar serverTime = Calendar.getInstance(usLocale);
            if (Math.abs(machineTime.getTimeInMillis() - serverTime.getTimeInMillis()) > (long)(GlobalVariables.globalConfig.getShowWarningForDatetime() * 60 * 1000)) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "3003");
            }
            if (!"".equals(qpicf = handler.excuteCommand("CFS", true)) && !qpicf.equals("(NAK")) {
                String[] qpicfArr = qpicf.split(",");
                String faultID = qpicfArr[1];
                if (this.pollFaultID != null && this.pollFaultID.equals(faultID)) {
                    return result;
                }
                this.pollFaultID = faultID;
                int i = 0;
                while (i < 9) {
                    String qhfs = handler.excuteCommand("HFS" + faultID, true);
                    if (!"".equals(qhfs) && !qhfs.equals("(NAK")) {
                        String[] qhfsArr = qhfs.split(",");
                        String faultstr = qhfsArr[1];
                        if (faultstr.equals("00")) break;
                        DataBeforeFault data = new DataBeforeFault();
                        String timeStr = qhfsArr[2];
                        data.setTrandate(DateUtils.parseDate(timeStr, "yyMMddHHmmss"));
                        data.setProdid(this._protocol.getProtocolID());
                        data.setSerialno(this.getProtocol().getSerialNo());
                        data.setWorkMode(qhfsArr[3]);
                        data.setPvinputvoltage1(VolUtil.parseDouble(qhfsArr[4]) / 10.0);
                        data.setPvinputvoltage2(VolUtil.parseDouble(qhfsArr[5]) / 10.0);
                        data.setPvinputpower1(VolUtil.parseDouble(qhfsArr[6]));
                        data.setPvinputpower2(VolUtil.parseDouble(qhfsArr[7]));
                        data.setAcinputvoltager(VolUtil.parseDouble(qhfsArr[8]) / 10.0);
                        data.setAcinputvoltages(VolUtil.parseDouble(qhfsArr[9]) / 10.0);
                        data.setAcinputvoltaget(VolUtil.parseDouble(qhfsArr[10]) / 10.0);
                        data.setGridFrequency(VolUtil.parseDouble(qhfsArr[11]) / 100.0);
                        data.setBatteryVoltage(VolUtil.parseDouble(qhfsArr[12]) / 10.0);
                        String batCurrent = qhfsArr[13];
                        if (batCurrent.startsWith("+")) {
                            data.setBatteryCurrent(VolUtil.parseDouble(qhfsArr[13].substring(1)) / 10.0);
                        } else {
                            data.setBatteryCurrent(-VolUtil.parseDouble(qhfsArr[13].substring(1)) / 10.0);
                        }
                        data.setAcoutputvoltager(VolUtil.parseDouble(qhfsArr[14]) / 10.0);
                        data.setAcoutputvoltages(VolUtil.parseDouble(qhfsArr[15]) / 10.0);
                        data.setAcoutputvoltaget(VolUtil.parseDouble(qhfsArr[16]) / 10.0);
                        data.setOutputLoadFrequency(VolUtil.parseDouble(qhfsArr[17]) / 100.0);
                        data.setAcoutputapperentpowerr(VolUtil.parseDouble(qhfsArr[18]));
                        data.setAcoutputapperentpowers(VolUtil.parseDouble(qhfsArr[19]));
                        data.setAcoutputapperentpowert(VolUtil.parseDouble(qhfsArr[20]));
                        data.setOutputLoadPercent(VolUtil.parseInt(qhfsArr[21]));
                        data.setInnertemperature(VolUtil.parseInt(qhfsArr[22]));
                        data.setComponenttemperature(VolUtil.parseInt(qhfsArr[23]));
                        if (qhfsArr.length == 24) {
                            data.setExternalbatterytemperature(0.0);
                        } else {
                            data.setExternalbatterytemperature(VolUtil.parseInt(qhfsArr[24]));
                        }
                        FaultHandler.doFaultEvent(faultstr, workinfo.getProdid(), workinfo.getSerialno(), data);
                    }
                    int newFaultID = Integer.valueOf(faultID);
                    if (--newFaultID < 0) {
                        newFaultID += 9;
                    }
                    faultID = "0" + newFaultID;
                    if (this.pollFaultID != null && faultID.equals(this.pollFaultID)) break;
                    ++i;
                }
            }
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            LOGGER.error((Object)e.getMessage());
            workinfo.clear();
            ++this.reconnectTimes;
        }
        return result;
    }

    protected void handlerEvent(String[] ws, WorkInfo workinfo) {
        this.warnsHandler(ws[0], "2001", workinfo);
        this.warnsHandler(ws[1], "2002", workinfo);
        this.warnsHandler(ws[2], "2003", workinfo);
        this.warnsHandler(ws[3], "2004", workinfo);
        this.warnsHandler(ws[4], "2005", workinfo);
        this.warnsHandler(ws[5], "2006", workinfo);
        this.warnsHandler(ws[6], "2007", workinfo);
        this.warnsHandler(ws[7], "2008", workinfo);
        this.warnsHandler(ws[8], "2009", workinfo);
        this.warnsHandler(ws[9], "2010", workinfo);
        this.warnsHandler(ws[10], "2011", workinfo);
        this.warnsHandler(ws[11], "2012", workinfo);
        this.warnsHandler(ws[12], "2013", workinfo);
        this.warnsHandler(ws[13], "2014", workinfo);
        this.warnsHandler(ws[14], "2015", workinfo);
        this.warnsHandler(ws[15], "2016", workinfo);
        this.warnsHandler(ws[16], "2017", workinfo);
        this.warnsHandler(ws[17], "2018", workinfo);
        this.warnsHandler(ws[18], "2019", workinfo);
        this.warnsHandler(ws[19], "2020", workinfo);
        this.warnsHandler(ws[20], "2021", workinfo);
        this.warnsHandler(ws[21], "2022", workinfo);
    }

    private void handlerEventP17P1S1(String[] ws, WorkInfo workinfo) {
        this.warnsHandler(ws[0], "2001", workinfo);
        this.warnsHandler(ws[2], "2003", workinfo);
        this.warnsHandler(ws[4], "2005", workinfo);
        this.warnsHandler(ws[5], "2006", workinfo);
        this.warnsHandler(ws[6], "2007", workinfo);
        this.warnsHandler(ws[7], "2008", workinfo);
        this.warnsHandler(ws[8], "2009", workinfo);
        this.warnsHandler(ws[9], "2010", workinfo);
        this.warnsHandler(ws[10], "2011", workinfo);
        this.warnsHandler(ws[11], "2012", workinfo);
        this.warnsHandler(ws[12], "2013", workinfo);
        this.warnsHandler(ws[13], "2014", workinfo);
        this.warnsHandler(ws[14], "2015", workinfo);
        this.warnsHandler(ws[15], "2016", workinfo);
        this.warnsHandler(ws[16], "2017", workinfo);
        this.warnsHandler(ws[17], "2018", workinfo);
        this.warnsHandler(ws[18], "2019", workinfo);
        this.warnsHandler(ws[19], "2020", workinfo);
        this.warnsHandler(ws[20], "2021", workinfo);
        this.warnsHandler(ws[21], "2022", workinfo);
    }

    @Override
    public boolean pollQuery() {
        if (!super.pollQuery()) {
            ++this.reconnectTimes;
            return false;
        }
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        try {
            String qmodStrs;
            String qpsStr;
            WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
            workInfo.setProdid(this._protocol.getProtocolID());
            workInfo.setSerialno(handler.getSerialNo());
            if (this.currenttime != null) {
                workInfo.setCurrentTime(this.currenttime.getTime());
            }
            int mpptTrackNumber = 2;
            String qpiriStr = handler.excuteCommand("PIRI", true);
            if (qpiriStr != null && !"".equals(qpiriStr) && !qpiriStr.equals("PIRI")) {
                String[] arr = qpiriStr.split(",");
                mpptTrackNumber = VolUtil.parseInt(arr[7]);
            }
            this.getProtocol().setMpptTrackNumber(mpptTrackNumber);
            String qpigsStr = handler.excuteCommand("GS", true);
            if (!"".equals(qpigsStr) && !qpigsStr.equals("(NAK")) {
                String[] qpigsArr = qpigsStr.split(",");
                double gridVoltageR = VolUtil.parseDouble(qpigsArr[7]) / 10.0;
                workInfo.setRGridVoltage(gridVoltageR);
                double gridVoltageS = VolUtil.parseDouble(qpigsArr[8]) / 10.0;
                workInfo.setSGridVoltage(gridVoltageS);
                double gridVoltageT = VolUtil.parseDouble(qpigsArr[9]) / 10.0;
                workInfo.setTGridVoltage(gridVoltageT);
                double gridFrequency = VolUtil.parseDouble(qpigsArr[10]) / 100.0;
                workInfo.setGridFrequency(gridFrequency);
                double gridCurrentR = VolUtil.parseDouble(qpigsArr[11]) / 10.0;
                workInfo.setGridCurrentR(gridCurrentR);
                double acOutputVoltageR = VolUtil.parseDouble(qpigsArr[14]) / 10.0;
                workInfo.setAcOutputVoltageR(acOutputVoltageR);
                double acOutputFrequency = VolUtil.parseDouble(qpigsArr[17]) / 100.0;
                workInfo.setAcOutputFrequency(acOutputFrequency);
                double acOutputCurrentR = VolUtil.parseDouble(qpigsArr[18]) / 10.0;
                workInfo.setAcOutputCurrentR(acOutputCurrentR);
                double pBatteryVoltage = VolUtil.parseDouble(qpigsArr[4]) / 10.0;
                pBatteryVoltage = pBatteryVoltage < 30.0 ? 0.0 : pBatteryVoltage;
                workInfo.setPBatteryVoltage(pBatteryVoltage);
                int batteryCapacity = VolUtil.parseInt(qpigsArr[5]);
                int n = batteryCapacity = batteryCapacity < 30 ? 0 : batteryCapacity;
                if (pBatteryVoltage == 0.0) {
                    batteryCapacity = 0;
                }
                workInfo.setBatteryCapacity(batteryCapacity);
                double pvInputVoltage1 = VolUtil.parseDouble(qpigsArr[0]) / 10.0;
                workInfo.setPvInputVoltage1(pvInputVoltage1);
                double pvInputVoltage2 = VolUtil.parseDouble(qpigsArr[1]) / 10.0;
                workInfo.setPvInputVoltage2(pvInputVoltage2);
                double innerTemperature = VolUtil.parseDouble(qpigsArr[21]);
                double maxTemperature = VolUtil.parseDouble(qpigsArr[22]);
                int ExternalBatteryTemperature = VolUtil.parseInt(qpigsArr[23]);
                workInfo.setInnerTemperature(innerTemperature);
                workInfo.setMaxTemperature(maxTemperature);
                workInfo.setExternalBatteryTemperature(ExternalBatteryTemperature);
                String chargingCurrentStr = qpigsArr[6];
                double chargingCurrent = 0.0;
                chargingCurrent = chargingCurrentStr.length() == 0 ? 0.0 : (chargingCurrentStr.charAt(0) == '+' ? VolUtil.parseDouble(chargingCurrentStr.substring(1)) / 10.0 : -VolUtil.parseDouble(chargingCurrentStr.substring(1)) / 10.0);
                workInfo.setChargingCurrent(chargingCurrent);
                try {
                    String settingChangeBit = qpigsArr[24];
                    if (settingChangeBit.equals("1")) {
                        this.queryCapability();
                        this.queryConfigData();
                        this.queryMachineInfo();
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage());
                }
            }
            if (!"".equals(qpsStr = handler.excuteCommand("PS", true)) && !qpsStr.equals("(NAK")) {
                String[] qpsArr = qpsStr.split(",");
                int pvInputPower1 = VolUtil.parseInt(qpsArr[0]);
                workInfo.setPvInputPower1(pvInputPower1);
                int pvInputPower2 = VolUtil.parseInt(qpsArr[1]);
                workInfo.setPvInputPower2(pvInputPower2);
                int outputLoadPercent = VolUtil.parseInt(qpsArr[15]);
                workInfo.setOutputLoadPercent(outputLoadPercent);
                if (qpsArr[16].equals("1")) {
                    workInfo.setHasLoad(true);
                } else {
                    workInfo.setHasLoad(false);
                }
                workInfo.setPv1WorkStatus(qpsArr[17]);
                workInfo.setPv2WorkStatus(qpsArr[18]);
                if (workInfo.getPv1WorkStatus().equals("0") && workInfo.getPv2WorkStatus().equals("0")) {
                    workInfo.setPvLoss(true);
                } else {
                    workInfo.setPvLoss(false);
                }
                String batteryStatus = "";
                if (qpsArr[19].equals("0")) {
                    batteryStatus = "00";
                } else if (qpsArr[19].equals("1")) {
                    batteryStatus = "01";
                } else if (qpsArr[19].equals("2")) {
                    batteryStatus = "10";
                }
                workInfo.setBatteryStatus(batteryStatus);
                workInfo.setInvDirection(qpsArr[20]);
                String lineDirection = qpsArr[21];
                if (lineDirection.equals("0")) {
                    workInfo.setLineDirection("00");
                } else if (lineDirection.equals("1")) {
                    workInfo.setLineDirection("01");
                } else if (lineDirection.equals("2")) {
                    workInfo.setLineDirection("10");
                }
                workInfo.setAcOutputActivePowerR(VolUtil.parseInt(qpsArr[7]));
                workInfo.setAcOutputActivePowerS(VolUtil.parseInt(qpsArr[8]));
                workInfo.setAcOutputActivePowerT(VolUtil.parseInt(qpsArr[9]));
                workInfo.setWholeGridOutputPower(VolUtil.parseInt(qpsArr[10]));
                workInfo.setAcOutputApperentPowerR(VolUtil.parseInt(qpsArr[11]));
                workInfo.setAcOutputApperentPowerS(VolUtil.parseInt(qpsArr[12]));
                workInfo.setAcOutputApperentPowerT(VolUtil.parseInt(qpsArr[13]));
                workInfo.setWholeGridOutputApperentPower(VolUtil.parseInt(qpsArr[14]));
            }
            if (!"".equals(qmodStrs = handler.excuteCommand("MOD", true)) && !qmodStrs.equals("(NAK")) {
                String workMode = "Standby";
                workInfo.setFault(false);
                String modeType = this.getProtocol().getModelType();
                if (modeType.equals("00")) {
                    if (qmodStrs.equals("00")) {
                        workMode = "Power On";
                    } else if (qmodStrs.equals("01")) {
                        workMode = "Standby";
                    } else if (qmodStrs.equals("02")) {
                        workMode = "Bypass";
                    } else if (qmodStrs.equals("03")) {
                        workMode = "Battery";
                    } else if (qmodStrs.equals("04")) {
                        workMode = "Fault";
                    } else if (qmodStrs.equals("05")) {
                        workMode = "Hybrid";
                    } else if (qmodStrs.equals("06")) {
                        workMode = "Charging";
                    }
                } else {
                    boolean hasLoad = workInfo.isHasLoad();
                    boolean isLineLoss = workInfo.isLineLoss();
                    boolean isPvLoss = workInfo.isPvLoss();
                    if (qmodStrs.equals("00")) {
                        workMode = "Power On";
                    } else if (qmodStrs.equals("01")) {
                        workMode = "Standby without charging";
                    } else if (qmodStrs.equals("02")) {
                        workMode = "Bypass without charging";
                    } else if (qmodStrs.equals("03")) {
                        workMode = "Inverter";
                    } else if (qmodStrs.equals("04")) {
                        workInfo.setFault(true);
                        workMode = !isLineLoss && hasLoad ? (!isPvLoss && workInfo.getBatteryStatus().equals("01") ? "Bypass with PV charging" : "Bypass without charging") : (!isPvLoss && workInfo.getBatteryStatus().equals("01") ? "Standby with PV charging" : "Standby without charging");
                    } else if (qmodStrs.equals("05")) {
                        String inv = workInfo.getInvDirection();
                        boolean load = workInfo.isHasLoad();
                        String bat = workInfo.getBatteryStatus();
                        String grid = workInfo.getLineDirection();
                        if (inv.equals("0") && load && bat.equals("01") && grid.equals("01") && !isPvLoss) {
                            workMode = "Bypass with PV charging";
                        } else if (inv.equals("1") && load && bat.equals("01") && grid.equals("01") && isPvLoss) {
                            workMode = "Bypass with AC charging";
                        } else if (inv.equals("0") && !load && bat.equals("01") && !isPvLoss) {
                            workMode = "Standby with PV charging";
                        } else if (inv.equals("1") && !load && bat.equals("01") && grid.equals("01") && isPvLoss) {
                            workMode = "Standby with AC charging";
                        } else if (inv.equals("0") && load && !bat.equals("01") && grid.equals("01") && isPvLoss) {
                            workMode = "Bypass without charging";
                        } else if (inv.equals("0") && !load && bat.equals("00")) {
                            workMode = "Standby without charging";
                        } else {
                            int check_pvfeedgrid = 1;
                            String retString = handler.excuteCommand("HECS", true);
                            if (!"".equals(retString) && !retString.equals("(NAK")) {
                                String[] retAtt = retString.split(",");
                                check_pvfeedgrid = VolUtil.parseInt(retAtt[3]);
                            }
                            workMode = this._protocol.getModelType().equals("01") || check_pvfeedgrid == 0 ? "Off-Grid with backup" : "Grid-tie with backup";
                        }
                    } else if (qmodStrs.equals("06")) {
                        workMode = !isLineLoss && workInfo.getBatteryStatus().equals("01") && hasLoad ? "Bypass with PV charging" : "Standby with PV charging";
                    }
                }
                workInfo.setWorkMode(workMode);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean queryMachineInfo() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        boolean result = true;
        MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        try {
            Date date;
            String qpiriStr;
            String qmdStr;
            String slaveFirmwareVersion;
            String mainFirmwareVersion = handler.excuteCommand("VFW", true);
            if (!"".equals(mainFirmwareVersion) && !mainFirmwareVersion.equals("(NAK")) {
                String[] version = mainFirmwareVersion.split(":");
                machineInfo.setMainFirmwareVersion(version[1]);
            }
            if (!"".equals(slaveFirmwareVersion = handler.excuteCommand("VFW2", true)) && !slaveFirmwareVersion.equals("(NAK")) {
                String[] version = slaveFirmwareVersion.split(":");
                machineInfo.setSlaveFirmwareVersion(version[1]);
            }
            if (!"".equals(qmdStr = handler.excuteCommand("MD", true)) && !qmdStr.equals("(NAK")) {
                String[] deviceMode = qmdStr.split(",");
                machineInfo.setMachineNumber(deviceMode[0]);
                machineInfo.setOutputRateVA(VolUtil.parseInt(deviceMode[1]));
                machineInfo.setOutputPowerFactor(VolUtil.parseInt(deviceMode[2]));
                machineInfo.setIoPhase(String.valueOf(deviceMode[3]) + "/" + deviceMode[4]);
                machineInfo.setNominalOutputVoltage(VolUtil.parseDouble(deviceMode[5]) / 10.0);
                machineInfo.setNominalInputVoltage(VolUtil.parseDouble(deviceMode[6]) / 10.0);
                machineInfo.setBatteryPieceNumber(VolUtil.parseInt(deviceMode[7]));
                double perUnit = VolUtil.parseDouble(deviceMode[8]) / 10.0;
                machineInfo.setBatteryStandVoltage((double)machineInfo.getBatteryPieceNumber() * perUnit);
            }
            if (!"".equals(qpiriStr = handler.excuteCommand("PIRI", true)) && !qpiriStr.equals("(NAK")) {
                String[] ratingInfo = qpiriStr.split(",");
                double acInputRatingVoltage = VolUtil.parseDouble(ratingInfo[0]) / 10.0;
                double acInputRatingFrequency = VolUtil.parseDouble(ratingInfo[1]) / 10.0;
                double acInputRatingCurrent = VolUtil.parseDouble(ratingInfo[2]) / 10.0;
                double acOutputRatingVoltage = VolUtil.parseDouble(ratingInfo[3]) / 10.0;
                double acOutputRatingCurrent = VolUtil.parseDouble(ratingInfo[4]) / 10.0;
                double perMPPTRatingCurrent = VolUtil.parseDouble(ratingInfo[5]) / 10.0;
                double batteryRatingVoltage = VolUtil.parseDouble(ratingInfo[6]) / 10.0;
                int mpptTrackNumber = VolUtil.parseInt(ratingInfo[7]);
                String machineTypeStr = ratingInfo[8];
                String topologyStr = ratingInfo[9];
                machineInfo.setGridRatingVoltage(acInputRatingVoltage);
                machineInfo.setGridRatingFrequency(acInputRatingFrequency);
                machineInfo.setGridRatingCurrent(acInputRatingCurrent);
                machineInfo.setAcOutputRatingVoltage(acOutputRatingVoltage);
                machineInfo.setAcOutputRatingCurrent(acOutputRatingCurrent);
                machineInfo.setPerMPPTRatingCurrent(perMPPTRatingCurrent);
                machineInfo.setBatteryRatingVoltage(batteryRatingVoltage);
                machineInfo.setMpptTrackNumber(mpptTrackNumber);
                String machineType = "";
                if (machineTypeStr.equals("00")) {
                    machineType = "Grid-Tie";
                } else if (machineTypeStr.equals("01")) {
                    machineType = "Off-Grid";
                } else if (machineTypeStr.equals("10")) {
                    machineType = "Hybrid";
                }
                machineInfo.setMachineType(machineType);
                this.getProtocol().setModelType(machineTypeStr);
                String topology = "";
                if (topologyStr.equals("0")) {
                    topology = "transformerless";
                } else if (topologyStr.equals("1")) {
                    topology = "transformer";
                }
                machineInfo.setTopology(topology);
            }
            if (machineInfo.getAcOutputRatingVoltage() > 180.0) {
                machineInfo.setMinACInputLowV(170.0);
                machineInfo.setMaxACInputHighV(280.0);
                if (machineInfo.getGridRatingFrequency() == 50.0) {
                    machineInfo.setMinACInputLowF(40.0);
                    machineInfo.setMaxACInputHighF(55.0);
                } else {
                    machineInfo.setMinACInputLowF(55.0);
                    machineInfo.setMaxACInputHighF(65.0);
                }
            } else {
                if (machineInfo.getAcOutputRatingVoltage() < 120.0) {
                    machineInfo.setMinACInputLowV(80.0);
                    machineInfo.setMaxACInputHighV(130.0);
                } else {
                    machineInfo.setMinACInputLowV(80.0);
                    machineInfo.setMaxACInputHighV(150.0);
                }
                if (machineInfo.getGridRatingFrequency() == 50.0) {
                    machineInfo.setMinACInputLowF(40.0);
                    machineInfo.setMaxACInputHighF(55.0);
                } else {
                    machineInfo.setMinACInputLowF(55.0);
                    machineInfo.setMaxACInputHighF(65.0);
                }
            }
            String qfetStr = handler.excuteCommand("FET", true);
            if (!"".equals(qfetStr) && !qfetStr.equals("(NAK") && (date = DateUtils.parseDate(qfetStr, "yyyyMMddHH")) != null) {
                this.enerystarttime = Calendar.getInstance();
                this.enerystarttime.setTime(date);
                WebServices web = new WebServices();
                if (!web.doEnergyBeginDate(this.getProtocol().getProtocolID(), this.getProtocol().getSerialNo(), this.enerystarttime)) {
                    result = false;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = false;
        }
        return result;
    }

    @Override
    public boolean queryCapability() {
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        Capability capability = (Capability)this.getBeanBag().getBean("capability");
        try {
            String retString;
            String qryPIRI;
            String qflagStr = handler.excuteCommand("FLAG", true);
            if (!"".equals(qflagStr) && !qflagStr.equals("(NAK")) {
                String[] flag = qflagStr.split(",");
                if (flag[0].equals("1")) {
                    capability.setCapableA(true);
                } else {
                    capability.setCapableA(false);
                }
                if (flag[1].equals("1")) {
                    capability.setCapableB(true);
                } else {
                    capability.setCapableB(false);
                }
                if (flag[2].equals("1")) {
                    capability.setCapableC(true);
                } else {
                    capability.setCapableC(false);
                }
                if (flag[3].equals("1")) {
                    capability.setCapableD(true);
                } else {
                    capability.setCapableD(false);
                }
                if (flag[4].equals("1")) {
                    capability.setCapableE(true);
                } else {
                    capability.setCapableE(false);
                }
                if (flag[5].equals("1")) {
                    capability.setCapableF(true);
                } else {
                    capability.setCapableF(false);
                }
                if (flag[6].equals("1")) {
                    capability.setCapableG(true);
                } else {
                    capability.setCapableG(false);
                }
                if (flag[7].equals("1")) {
                    capability.setCapableH(true);
                } else {
                    capability.setCapableH(false);
                }
            }
            if (this.notEmpty(qryPIRI = handler.excuteCommand("PIRI", true))) {
                String[] piri = qryPIRI.split(",");
                if (piri[10].equals("1")) {
                    capability.setParallelOutput(true);
                } else {
                    capability.setParallelOutput(false);
                }
            }
            if (!"".equals(retString = handler.excuteCommand("HECS", true)) && !retString.equals("(NAK")) {
                String[] retAtt = retString.split(",");
                if (retAtt[8].equals("1")) {
                    capability.setCheck_reactivePowerAutoControl(true);
                } else {
                    capability.setCheck_reactivePowerAutoControl(false);
                }
            }
        }
        catch (Exception e) {
            result = false;
            LOGGER.error((Object)e.getMessage());
        }
        return result;
    }

    @Override
    public Calendar queryCurrentTime() {
        String timeStr;
        Calendar ca;
        block7: {
            block6: {
                IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
                if (handler == null) {
                    return null;
                }
                try {
                    ca = null;
                    timeStr = handler.excuteCommand("T", true);
                    if (!"".equals(timeStr) && !timeStr.equals("(NAK")) break block6;
                    return null;
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage());
                    return null;
                }
            }
            if (timeStr.trim().length() == 14) break block7;
            return null;
        }
        Date date = DateUtils.parseDate(timeStr, "yyyyMMddHHmmss");
        if (date != null) {
            ca = Calendar.getInstance();
            ca.setTime(date);
        }
        return ca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyDay(Calendar trandate) throws Exception {
        Object object = this.query_day;
        synchronized (object) {
            double energyDay = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            Calendar calendar = (Calendar)trandate.clone();
            String value = DateUtils.getFormatDate(calendar.getTime(), "yyyyMMdd");
            String validate = this.getValidate("^P014ED" + value);
            String qedStr = handler.excuteCommand("ED" + value + validate, true);
            if (qedStr == null || "".equals(qedStr) || qedStr.equals("(NAK")) {
                throw new Exception("query day energy error");
            }
            energyDay = this.parseDoubleV(qedStr);
            return energyDay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyHour(Calendar trandate, int hour) throws Exception {
        Object object = this.query_hour;
        synchronized (object) {
            double energyHour = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            Calendar calendar = (Calendar)trandate.clone();
            String hourStr = String.valueOf(hour).length() < 2 ? "0" + hour : String.valueOf(hour);
            String value = String.valueOf(DateUtils.getFormatDate(calendar.getTime(), "yyyyMMdd")) + hourStr;
            String validate = this.getValidate("^P016EH" + value);
            String qehStr = handler.excuteCommand("EH" + value + validate, true);
            if (qehStr == null || "".equals(qehStr) || qehStr.equals("(NAK")) {
                throw new Exception("query hour energy error");
            }
            energyHour = this.parseDoubleV(qehStr);
            return energyHour;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyMonth(int year, int month) throws Exception {
        Object object = this.query_month;
        synchronized (object) {
            double energyMonth = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String monthStr = String.valueOf(month).length() < 2 ? "0" + month : String.valueOf(month);
            String value = year + monthStr;
            String validate = this.getValidate("^P012EM" + value);
            String qemStr = handler.excuteCommand("EM" + value + validate, true);
            if (qemStr == null || "".equals(qemStr) || qemStr.equals("(NAK")) {
                throw new Exception("query month energy error");
            }
            energyMonth = this.parseDoubleV(qemStr);
            return energyMonth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyYear(int year) throws Exception {
        Object object = this.query_year;
        synchronized (object) {
            double energyYear = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String value = "" + year;
            String validate = this.getValidate("^P010EY" + value);
            String qeyStr = handler.excuteCommand("EY" + value + validate, true);
            if (qeyStr == null || "".equals(qeyStr) || qeyStr.equals("(NAK")) {
                throw new Exception("query year energy error");
            }
            energyYear = this.parseDoubleV(qeyStr);
            return energyYear;
        }
    }

    @Override
    public boolean queryConfigData() {
        boolean result = true;
        try {
            String btnum;
            String aapf;
            String qfppf;
            String qdmStr;
            String qgpmp;
            String queryQPIRI;
            String qmpptv;
            String qgltv;
            String qlstStr;
            String qpvipv;
            String qopmpStr;
            String qmd;
            String qftStr;
            String qgof;
            String qgov;
            String fpra;
            String qchgsStr;
            String qbyf;
            String qbyv;
            WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
            ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String qvftrStr = handler.excuteCommand("MAR", true);
            if (!"".equals(qvftrStr) && !qvftrStr.equals("(NAK")) {
                String[] queryQvftrStr = qvftrStr.split(",");
                double maxGridOutputHighV = VolUtil.parseDouble(queryQvftrStr[0]) / 10.0;
                double minGridOutputHighV = VolUtil.parseDouble(queryQvftrStr[1]) / 10.0;
                double maxGridOutputLowV = VolUtil.parseDouble(queryQvftrStr[2]) / 10.0;
                double minGridOutputLowV = VolUtil.parseDouble(queryQvftrStr[3]) / 10.0;
                configdata.setMaxGridoutputhighV(maxGridOutputHighV);
                configdata.setMinGridoutputhighV(minGridOutputHighV);
                configdata.setMaxGridoutputlowV(maxGridOutputLowV);
                configdata.setMinGridoutputlowV(minGridOutputLowV);
                configdata.setMaxGridInputHighV(maxGridOutputHighV);
                configdata.setMinGridInputHighV(minGridOutputHighV);
                configdata.setMaxGridInputLowV(maxGridOutputLowV);
                configdata.setMinGridInputLowV(minGridOutputLowV);
                double maxGridOutputHighF = VolUtil.parseDouble(queryQvftrStr[4]) / 100.0;
                double minGridOutputHighF = VolUtil.parseDouble(queryQvftrStr[5]) / 100.0;
                double maxGridOutputLowF = VolUtil.parseDouble(queryQvftrStr[6]) / 100.0;
                double minGridOutputLowF = VolUtil.parseDouble(queryQvftrStr[7]) / 100.0;
                configdata.setMaxGridoutputhighF(maxGridOutputHighF);
                configdata.setMinGridoutputhighF(minGridOutputHighF);
                configdata.setMaxGridoutputlowF(maxGridOutputLowF);
                configdata.setMinGridoutputlowF(minGridOutputLowF);
                configdata.setMaxGridInputHighF(maxGridOutputHighF);
                configdata.setMinGridInputHighF(minGridOutputHighF);
                configdata.setMaxGridInputLowF(maxGridOutputLowF);
                configdata.setMinGridInputLowF(minGridOutputLowF);
                int maxWaittime = VolUtil.parseInt(queryQvftrStr[8]);
                int minWaittime = VolUtil.parseInt(queryQvftrStr[9]);
                configdata.setMaxGridWaittime(maxWaittime);
                configdata.setMinGridWaittime(minWaittime);
                int maxPvInputHighV = Integer.parseInt(queryQvftrStr[10]) / 10;
                int minPvInputHighV = Integer.parseInt(queryQvftrStr[11]) / 10;
                int maxPvInputLowV = Integer.parseInt(queryQvftrStr[12]) / 10;
                int minPvInputLowV = Integer.parseInt(queryQvftrStr[13]) / 10;
                int maxMpptHighV = Integer.parseInt(queryQvftrStr[14]) / 10;
                int minMpptHighV = Integer.parseInt(queryQvftrStr[15]) / 10;
                int maxMpptLowV = Integer.parseInt(queryQvftrStr[16]) / 10;
                int minMpptLowV = Integer.parseInt(queryQvftrStr[17]) / 10;
                double maxMaxChargingV = VolUtil.parseDouble(queryQvftrStr[18]) / 10.0;
                double minMaxChargingV = VolUtil.parseDouble(queryQvftrStr[19]) / 10.0;
                double maxMaxChargingCurrent = Double.parseDouble(queryQvftrStr[20]) / 10.0;
                double minMaxChargingCurrent = Double.parseDouble(queryQvftrStr[21]) / 10.0;
                configdata.setMaxMaxChargingCurrent(maxMaxChargingCurrent);
                configdata.setMinMaxChargingCurrent(minMaxChargingCurrent);
                configdata.setMaxPvInputHighV(maxPvInputHighV);
                configdata.setMinPvInputHighV(minPvInputHighV);
                configdata.setMaxPvInputLowV(maxPvInputLowV);
                configdata.setMinPvInputLowV(minPvInputLowV);
                configdata.setMaxMpptHighV(maxMpptHighV);
                configdata.setMinMpptHighV(minMpptHighV);
                configdata.setMaxMpptLowV(maxMpptLowV);
                configdata.setMinMpptLowV(minMpptLowV);
                configdata.setMaxMaxChargingVoltage(maxMaxChargingV);
                configdata.setMinMaxChargingVoltage(minMaxChargingV);
                configdata.setMaxFloatingVoltage(maxMaxChargingV);
                configdata.setMinFloatingVoltage(minMaxChargingV);
                int maxPowerFeedGrid = Integer.valueOf(queryQvftrStr[22]);
                int minPowerFeedGrid = Integer.valueOf(queryQvftrStr[23]);
                configdata.setMinPowerFeedGrid(minPowerFeedGrid);
                configdata.setMaxPowerFeedGrid(maxPowerFeedGrid);
            }
            if (!"".equals(qbyv = handler.excuteCommand("GOV", true)) && !qbyv.equals("(NAK")) {
                String[] qbyvArr = qbyv.split(",");
                double gridInputHighV = VolUtil.parseDouble(qbyvArr[0]) / 10.0;
                double gridInputLowV = VolUtil.parseDouble(qbyvArr[1]) / 10.0;
                configdata.setGridInputHighV(gridInputHighV);
                configdata.setGridInputLowV(gridInputLowV);
            }
            if (!"".equals(qbyf = handler.excuteCommand("GOF", true)) && !qbyf.equals("(NAK")) {
                String[] qbyfArr = qbyf.split(",");
                double gridInputHighF = VolUtil.parseDouble(qbyfArr[0]) / 100.0;
                double gridInputLowF = VolUtil.parseDouble(qbyfArr[1]) / 100.0;
                configdata.setGridInputHighF(gridInputHighF);
                configdata.setGridInputLowF(gridInputLowF);
            }
            if (!"".equals(qchgsStr = handler.excuteCommand("BATS", true)) && !qchgsStr.equals("(NAK")) {
                try {
                    String[] qchgsArr = qchgsStr.split(",");
                    double maxChargingCurrent = VolUtil.parseDouble(qchgsArr[0]) / 10.0;
                    double maxChargingVoltage = VolUtil.parseDouble(qchgsArr[1]) / 10.0;
                    double floatVoltage = VolUtil.parseDouble(qchgsArr[2]) / 10.0;
                    configdata.setFloatingVoltage(floatVoltage);
                    configdata.setMaxChargingCurrent(maxChargingCurrent);
                    configdata.setMaxChargingVoltage(maxChargingVoltage);
                    configdata.setLiFloatChargingCurrent(VolUtil.parseDouble(qchgsArr[3]) / 10.0);
                    configdata.setLimaxFloatChargingCurrent(50.0);
                    configdata.setLiminFloatChargingCurrent(0.0);
                    configdata.setMinMaxChargingCurrent(configdata.getLiFloatChargingCurrent());
                    configdata.setLiRemainingtime(VolUtil.parseInt(qchgsArr[4]));
                    configdata.setLimaxRemainingtime(999.0);
                    configdata.setLiminRemainingtime(0.0);
                    configdata.setLiRecoverVoltage(VolUtil.parseDouble(qchgsArr[5]) / 10.0);
                    configdata.setLimaxrecoverVoltage(60.0);
                    configdata.setLiminRecoverVoltage(40.0);
                    double cutoffVoltageGridLoss = VolUtil.parseDouble(qchgsArr[6]) / 10.0;
                    double recoverVoltageGridLoss = VolUtil.parseDouble(qchgsArr[7]) / 10.0;
                    double cutoffVoltage = VolUtil.parseDouble(qchgsArr[8]) / 10.0;
                    double recoverVoltage = VolUtil.parseDouble(qchgsArr[9]) / 10.0;
                    configdata.setCutoffVoltageGridLoss(cutoffVoltageGridLoss);
                    configdata.setMinCutoffVoltageGridLoss(40.0);
                    configdata.setMaxCutoffVoltageGridLoss(recoverVoltageGridLoss);
                    configdata.setRecoverVoltageGridLoss(recoverVoltageGridLoss);
                    configdata.setMinRecoverVoltageGridLoss(configdata.getCutoffVoltageGridLoss());
                    configdata.setMaxRecoverVoltageGridLoss(configdata.getFloatingVoltage());
                    configdata.setCutoffVoltage(cutoffVoltage);
                    configdata.setMinCutoffVoltage(42.0);
                    configdata.setMaxCutoffVoltage(recoverVoltage);
                    configdata.setRecoverVoltage(recoverVoltage);
                    configdata.setMinRecoverVoltage(configdata.getCutoffVoltage());
                    configdata.setMaxRecoverVoltage(configdata.getFloatingVoltage());
                    int batteryType = VolUtil.parseInt(qchgsArr[10]);
                    if (batteryType == 0) {
                        configdata.setLiFeBattery(false);
                    } else if (batteryType == 1) {
                        configdata.setLiFeBattery(true);
                    }
                    configdata.setCheck_gridChargingLowestBatVol(Integer.parseInt(qchgsArr[13]));
                    configdata.setGridChargingLowestBatVol(VolUtil.parseDouble(qchgsArr[14]) / 10.0);
                    double batTptCompensate = VolUtil.parseDouble(qchgsArr[15]) / 10.0;
                    if (batTptCompensate > 0.0 && configdata.isBatTptCompensateFirstQry()) {
                        workInfo.setNeedToReresh(true);
                        configdata.setBatTptCompensateFirstQry(false);
                        workInfo.setHaveRefreshed(true);
                    } else if (batTptCompensate <= 0.0 && workInfo.isHaveRefreshed()) {
                        workInfo.setNeedToReresh(true);
                        configdata.setBatTptCompensateFirstQry(true);
                        workInfo.setHaveRefreshed(false);
                    }
                    configdata.setBatTptCompensate(batTptCompensate);
                    configdata.setMinBatTptCompensate(0.0);
                    configdata.setMaxBatTptCompensate(10.0);
                    configdata.setMaxAcChargingCurrent(VolUtil.parseDouble(qchgsArr[16]) / 10.0);
                    configdata.setBatDischargeMaxCurrentInHybridMode(VolUtil.parseInt(qchgsArr[17]));
                    configdata.setMinBatDischargeMaxCurrentInHybridMode(10);
                    configdata.setMaxBatDischargeMaxCurrentInHybridMode(300);
                    try {
                        if (qchgsArr.length >= 21) {
                            configdata.setEnabledEPS(qchgsArr[18].equals("1"));
                            double batCutOffMainOutputVol = VolUtil.parseDouble(qchgsArr[19]) / 10.0;
                            configdata.setBatCutOffMainOutputVol(batCutOffMainOutputVol);
                            configdata.setMinBatCutOffMainOutputVol(40.0);
                            configdata.setMaxBatCutOffMainOutputVol(60.0);
                            double batReConnectedMainOutputVol = VolUtil.parseDouble(qchgsArr[20]) / 10.0;
                            configdata.setBatReConnectedMainOutputVol(batReConnectedMainOutputVol);
                            configdata.setMinBatReConnectedMainOutputVol(40.0);
                            configdata.setMaxBatReConnectedMainOutputVol(60.0);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage());
                }
            }
            if (this.getProtocol().getMCUVersion().compareTo("170711123000") >= 0 && !"".equals(fpra = handler.excuteCommand("FPRA", true)) && !fpra.equals("(NAK")) {
                MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                double feefInReactivePower = 0.0;
                if (machineInfo.getOutputRateVA() == 4000.0) {
                    feefInReactivePower = VolUtil.parseDouble(fpra);
                    configdata.setFeefInReactivePower(feefInReactivePower);
                    configdata.setMinfeefInReactivePower(-2000.0);
                    configdata.setMaxfeefInReactivePower(2000.0);
                } else if (machineInfo.getOutputRateVA() == 5000.0) {
                    feefInReactivePower = VolUtil.parseDouble(fpra);
                    configdata.setFeefInReactivePower(feefInReactivePower);
                    configdata.setMinfeefInReactivePower(-2500.0);
                    configdata.setMaxfeefInReactivePower(2500.0);
                } else if (machineInfo.getOutputRateVA() == 10000.0) {
                    feefInReactivePower = VolUtil.parseDouble(fpra);
                    configdata.setFeefInReactivePower(feefInReactivePower);
                    configdata.setMinfeefInReactivePower(-5000.0);
                    configdata.setMaxfeefInReactivePower(5000.0);
                }
            }
            if (!"".equals(qgov = handler.excuteCommand("GOV", true)) && !qgov.equals("(NAK")) {
                String[] qgovStr = qgov.split(",");
                double gridOutputHighV = VolUtil.parseDouble(qgovStr[0]) / 10.0;
                double gridOutputLowV = VolUtil.parseDouble(qgovStr[1]) / 10.0;
                configdata.setGridoutputhighV(gridOutputHighV);
                configdata.setGridoutputlowV(gridOutputLowV);
            }
            if (!"".equals(qgof = handler.excuteCommand("GOF", true)) && !qgof.equals("(NAK")) {
                String[] qgofStr = qgof.split(",");
                double gridOutputHighF = VolUtil.parseDouble(qgofStr[0]) / 100.0;
                double gridOutputLowF = VolUtil.parseDouble(qgofStr[1]) / 100.0;
                configdata.setGridoutputhighF(gridOutputHighF);
                configdata.setGridoutputlowF(gridOutputLowF);
            }
            if (!"".equals(qftStr = handler.excuteCommand("FT", true)) && !qftStr.equals("(NAK")) {
                int waitingTime = VolUtil.parseInt(qftStr);
                configdata.setGridwaittime(waitingTime);
            }
            if (!"".equals(qmd = handler.excuteCommand("MD", true)) && !qmd.equals("(NAK")) {
                String[] qmdAttr = qmd.split(",");
                String outputVAStr = qmdAttr[1];
                int outputRateVA = VolUtil.parseInt(outputVAStr);
                configdata.setMinMaxoutputPower(0);
                configdata.setMaxMaxoutputPower(outputRateVA);
            }
            if (!"".equals(qopmpStr = handler.excuteCommand("OPMP", true)) && !qopmpStr.equals("(NAK")) {
                int maxOutputPower = VolUtil.parseInt(qopmpStr);
                configdata.setMaxoutputPower(maxOutputPower);
            }
            if (!"".equals(qpvipv = handler.excuteCommand("SV", true)) && !qpvipv.equals("(NAK")) {
                String[] qpvipvStr = qpvipv.split(",");
                int upperLimitInputV = VolUtil.parseInt(qpvipvStr[0]) / 10;
                int lowestLimtInputV = VolUtil.parseInt(qpvipvStr[1]) / 10;
                configdata.setPvInputLowV(lowestLimtInputV);
                configdata.setPvInputHighV(upperLimitInputV);
            }
            if (!"".equals(qlstStr = handler.excuteCommand("LST", true)) && !qlstStr.equals("(NAK")) {
                configdata.setLcdSleepTime(qlstStr);
            }
            if (!"".equals(qgltv = handler.excuteCommand("GLTHV", true)) && !qgltv.equals("(NAK")) {
                int gridInputAverageHighV = VolUtil.parseInt(qgltv) / 10;
                configdata.setGridAvgHighV(gridInputAverageHighV);
                configdata.setMaxGridAvgHighV(265);
                configdata.setMinGridAvgHighV(235);
            }
            if (!"".equals(qmpptv = handler.excuteCommand("MPPTV", true)) && !qmpptv.equals("(NAK")) {
                String[] qmpptvStr = qmpptv.split(",");
                int highVoltage = VolUtil.parseInt(qmpptvStr[0]) / 10;
                int lowVoltage = VolUtil.parseInt(qmpptvStr[1]) / 10;
                configdata.setMpptHighV(highVoltage);
                configdata.setMpptLowV(lowVoltage);
            }
            if (!"".equals(queryQPIRI = handler.excuteCommand("PIRI", true)) && !queryQPIRI.equals("(NAK")) {
                String[] queryQPIRIStr = queryQPIRI.split(",");
                double gridRatingVoltage = VolUtil.parseDouble(queryQPIRIStr[0]) / 10.0;
                double gridRatingFrequency = VolUtil.parseDouble(queryQPIRIStr[1]) / 10.0;
                double gridRatingCurrent = VolUtil.parseDouble(queryQPIRIStr[2]) / 10.0;
                configdata.setNominalVoltage(gridRatingVoltage);
                configdata.setNominalFreq(gridRatingFrequency);
                int queryPVN = VolUtil.parseInt(queryQPIRIStr[7]);
                configdata.setPvnNumber(queryPVN);
                MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                machineInfo.setGridRatingCurrent(gridRatingCurrent);
                machineInfo.setGridRatingVoltage(gridRatingVoltage);
                machineInfo.setGridRatingFrequency(gridRatingFrequency);
                String machineTypeStr = queryQPIRIStr[8];
                if (machineTypeStr.equals("00")) {
                    machineInfo.setMachineType("Grid-Tie");
                } else if (machineTypeStr.equals("01")) {
                    machineInfo.setMachineType("Off-Grid");
                } else if (machineTypeStr.equals("10")) {
                    machineInfo.setMachineType("Hybrid");
                } else if (machineTypeStr.equals("11")) {
                    machineInfo.setMachineType("Self-Use");
                }
                this.getProtocol().setModelType(machineTypeStr);
            }
            if (!"".equals(qgpmp = handler.excuteCommand("GPMP", true)) && !qgpmp.equals("(NAK")) {
                int maxfeedgrid = VolUtil.parseInt(qgpmp);
                configdata.setMinMaxoutputPower(maxfeedgrid);
                configdata.setPowerfeedGrid(maxfeedgrid);
            }
            if (!"".equals(qdmStr = handler.excuteCommand("DM", true)) && !qdmStr.equals("(NAK")) {
                int modeid = VolUtil.parseInt(qdmStr);
                String retString = handler.excuteCommand("HECS", true);
                if (!"".equals(retString) && !retString.equals("(NAK")) {
                    try {
                        String[] retAtt = retString.split(",");
                        if (modeid == 151) {
                            configdata.setPlanID("02");
                        } else if (modeid == 150) {
                            if (retAtt[0].equals("00")) {
                                configdata.setPlanID("01");
                            } else if (retAtt[0].equals("01")) {
                                configdata.setPlanID("00");
                            }
                        } else {
                            configdata.setPlanID(retAtt[0]);
                        }
                        configdata.setCheck_charge(VolUtil.parseInt(retAtt[1]));
                        configdata.setCheck_accharge(VolUtil.parseInt(retAtt[2]));
                        configdata.setCheck_pvfeedgrid(VolUtil.parseInt(retAtt[3]));
                        configdata.setCheck_batdispvon(VolUtil.parseInt(retAtt[4]));
                        configdata.setCheck_batdispvloss(VolUtil.parseInt(retAtt[5]));
                        configdata.setCheck_batfeedpvon(VolUtil.parseInt(retAtt[6]));
                        configdata.setCheck_batfeedpvloss(VolUtil.parseInt(retAtt[7]));
                        configdata.setCheck_reactivePowerAutoControl(VolUtil.parseInt(retAtt[8]));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e.getMessage());
                    }
                }
                if (!"".equals(retString = handler.excuteCommand("ACCT", true)) && !retString.equals("(NAK")) {
                    String[] attr = retString.split(",");
                    configdata.setAcChargeStarttime(attr[0]);
                    configdata.setAcChargeEndtime(attr[1]);
                    try {
                        configdata.setAcctParams(attr.length);
                        configdata.setAcChargeStarttime2(attr[2]);
                        configdata.setAcChargeEndtime2(attr[3]);
                    }
                    catch (Exception gridRatingCurrent) {
                        // empty catch block
                    }
                }
                if (!"".equals(retString = handler.excuteCommand("ACLT", true)) && !retString.equals("(NAK")) {
                    String[] splitArray = retString.split(",");
                    configdata.setAcoutputStarttime(splitArray[0]);
                    configdata.setAcoutputEndtime(splitArray[1]);
                }
            }
            configdata.setMinFloatingVoltage(Math.max(Math.max(configdata.getRecoverVoltage(), configdata.getRecoverVoltageGridLoss()), configdata.getLiRecoverVoltage()));
            String qfpadj = handler.excuteCommand("FPADJ", true);
            if (!"".equals(qfpadj) && !qfpadj.equals("(NAK")) {
                String[] qfpadjAttr = qfpadj.split(",");
                if (qfpadjAttr[0].equals("0")) {
                    configdata.setGridPowerDeviation(-VolUtil.parseInt(qfpadjAttr[1]));
                } else if (qfpadjAttr[0].equals("1")) {
                    configdata.setGridPowerDeviation(VolUtil.parseInt(qfpadjAttr[1]));
                }
                configdata.setMaxGridPowerDeviation(1000);
                configdata.setMinGridPowerDeviation(-1000);
                if (qfpadjAttr[2].equals("0")) {
                    configdata.setFeedingGridCalibrationPowerR(-VolUtil.parseInt(qfpadjAttr[3]));
                } else if (qfpadjAttr[2].equals("1")) {
                    configdata.setFeedingGridCalibrationPowerR(VolUtil.parseInt(qfpadjAttr[3]));
                }
                configdata.setMinFeedingGridCalibrationPowerR(-1000);
                configdata.setMaxFeedingGridCalibrationPowerR(1000);
                if (qfpadjAttr[4].equals("0")) {
                    configdata.setFeedingGridCalibrationPowerS(-VolUtil.parseInt(qfpadjAttr[5]));
                } else if (qfpadjAttr[4].equals("1")) {
                    configdata.setFeedingGridCalibrationPowerS(VolUtil.parseInt(qfpadjAttr[5]));
                }
                configdata.setMinFeedingGridCalibrationPowerS(-1000);
                configdata.setMaxFeedingGridCalibrationPowerS(1000);
                if (qfpadjAttr[6].equals("0")) {
                    configdata.setFeedingGridCalibrationPowerT(-VolUtil.parseInt(qfpadjAttr[7]));
                } else if (qfpadjAttr[6].equals("1")) {
                    configdata.setFeedingGridCalibrationPowerT(VolUtil.parseInt(qfpadjAttr[7]));
                }
                configdata.setMinFeedingGridCalibrationPowerT(-1000);
                configdata.setMaxFeedingGridCalibrationPowerT(1000);
            }
            if (!"".equals(qfppf = handler.excuteCommand("FPPF", true)) && !qfppf.equals("(NAK")) {
                int fppf = VolUtil.parseInt(qfppf);
                if (fppf > 100) {
                    configdata.setFeedinPowerFactor((double)(-(fppf -= 100)) / 100.0);
                } else {
                    configdata.setFeedinPowerFactor((double)fppf / 100.0);
                }
                if (configdata.getFeefInReactivePower() == 0.0) {
                    configdata.setMinFeedinPowerFactor(-0.99);
                    configdata.setMaxFeedinPowerFactor(1.0);
                }
            }
            if (!"".equals(aapf = handler.excuteCommand("AAPF", true)) && !aapf.equals("(NAK")) {
                String[] aapfAttr = aapf.split(",");
                configdata.setEnabledAAPF(aapfAttr[0].equals("1"));
                int startPowerPercentage = VolUtil.parseInt(aapfAttr[1]);
                configdata.setStartPowerPercentage(startPowerPercentage);
                configdata.setMinStartPowerPercentage(10);
                configdata.setMaxStartPowerPercentage(90);
                double minmumPFValue = VolUtil.parseDouble(aapfAttr[2]);
                if (minmumPFValue >= 190.0) {
                    minmumPFValue = (minmumPFValue - 100.0) / 100.0;
                    configdata.setMinmumPFValue(-minmumPFValue);
                    configdata.setMinMinmumPFValue(-0.99);
                    configdata.setMaxMinmumPFValue(-0.9);
                }
            }
            String ple = handler.excuteCommand("PLE", true);
            if (!"".equals(aapf) && !aapf.equals("(NAK")) {
                if (ple.equals("1")) {
                    configdata.setAllowSTPhaseLoss(true);
                } else {
                    configdata.setAllowSTPhaseLoss(false);
                }
            }
            if (!"".equals(btnum = handler.excuteCommand("BTNUM", true)) && !btnum.equals("(NAK")) {
                int batnum = VolUtil.parseInt(btnum);
                if (batnum >= 29 && batnum <= 32) {
                    configdata.setBatteryNumber(batnum);
                }
                configdata.setMinBatteryNumber(29);
                configdata.setMaxBatteryNumber(32);
            }
        }
        catch (Exception e) {
            result = false;
            LOGGER.error((Object)e.getMessage());
        }
        return result;
    }

    @Override
    public void queryEnergyBeginDate() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return;
        }
        try {
            Date date;
            String queryTime = handler.excuteCommand("FET", true);
            if (!"".equals(queryTime) && !queryTime.equals("(NAK") && queryTime.trim().length() == 10 && (date = DateUtils.parseDate(queryTime, "yyyyMMddHH")) != null) {
                this.enerystarttime = Calendar.getInstance();
                this.enerystarttime.setTime(date);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
    }

    @Override
    public void querySelfTestResult() {
    }

    @Override
    public boolean queryDefaultData() {
        DefaultData defaultData = (DefaultData)this.getBeanBag().getBean("defaultdata");
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        boolean result = true;
        try {
            String qdiStr = handler.excuteCommand("DI", true);
            if (!"".equals(qdiStr) && !qdiStr.equals("(NAK")) {
                String[] qdiArr = qdiStr.split(",");
                double acInputHighestV = VolUtil.parseDouble(qdiArr[0]) / 10.0;
                double acInputLowestV = VolUtil.parseDouble(qdiArr[1]) / 10.0;
                double acInputHightestF = VolUtil.parseDouble(qdiArr[2]) / 100.0;
                double acInputLowestF = VolUtil.parseDouble(qdiArr[3]) / 100.0;
                int solarMpptInputHighV = VolUtil.parseInt(qdiArr[4]) / 10;
                int solarMpptInputLowV = VolUtil.parseInt(qdiArr[5]) / 10;
                int solarInputHighestV = VolUtil.parseInt(qdiArr[6]) / 10;
                int solarInputLowestV = VolUtil.parseInt(qdiArr[7]) / 10;
                int acInputLTHighestAvgV = VolUtil.parseInt(qdiArr[8]) / 10;
                double batteryMaxinumChargeCurrent = VolUtil.parseDouble(qdiArr[10]) / 10.0;
                double batteryConstantChargeVoltage = VolUtil.parseDouble(qdiArr[11]) / 10.0;
                double batteryFloatChargeVoltage = VolUtil.parseDouble(qdiArr[12]) / 10.0;
                defaultData.setHighGridV(acInputHighestV);
                defaultData.setLowGridV(acInputLowestV);
                defaultData.setHighGridF(acInputHightestF);
                defaultData.setLowGridF(acInputLowestF);
                defaultData.setGridAvgHighV(acInputLTHighestAvgV);
                defaultData.setPvInputHighV(solarInputHighestV);
                defaultData.setPvInputLowV(solarInputLowestV);
                defaultData.setMppHighV(solarMpptInputHighV);
                defaultData.setMppLowV(solarMpptInputLowV);
                int lcdSleepTime = VolUtil.parseInt(qdiArr[9]) * 30;
                defaultData.setLcdSleepTime(String.valueOf(lcdSleepTime));
                defaultData.setMaxChargingCurrent(batteryMaxinumChargeCurrent);
                defaultData.setFloatingVoltage(batteryFloatChargeVoltage);
                defaultData.setMaxChargingVoltage(batteryConstantChargeVoltage);
                defaultData.setGridwaittime(VolUtil.parseInt(qdiArr[13]));
                double batteryUnderVoltage = VolUtil.parseDouble(qdiArr[18]) / 10.0;
                double batteryUnderBackVoltage = VolUtil.parseDouble(qdiArr[19]) / 10.0;
                double batteryWeakVoltage = VolUtil.parseDouble(qdiArr[20]) / 10.0;
                double batteryWeakBackVoltage = VolUtil.parseDouble(qdiArr[21]) / 10.0;
                defaultData.setBatteryUnderVoltage(batteryUnderVoltage);
                defaultData.setBatteryUnderBackVoltage(batteryUnderBackVoltage);
                defaultData.setBatteryWeakVoltage(batteryWeakVoltage);
                defaultData.setBatteryWeakBackVoltage(batteryWeakBackVoltage);
                double batteryStopChargerCurrentLevel = VolUtil.parseDouble(qdiArr[22]) / 10.0;
                String batteryChargerTime = qdiArr[23];
                double batteryVoltageOfRecover = VolUtil.parseDouble(qdiArr[24]) / 10.0;
                defaultData.setBatteryCurrentLevel(batteryStopChargerCurrentLevel);
                defaultData.setBatteryChargerTime(batteryChargerTime);
                defaultData.setBatteryRecoverVoltage(batteryVoltageOfRecover);
            }
        }
        catch (Exception e) {
            result = false;
            LOGGER.error((Object)e.getMessage());
        }
        return result;
    }

    @Override
    public boolean supportSelfTest() {
        return false;
    }

    @Override
    public float getFWVersion() {
        return this._fwVersion;
    }

    @Override
    public float queryFWVersion() {
        return 0.0f;
    }

    @Override
    public String getDeviceMode() {
        return this._deviceModel;
    }

    @Override
    public boolean queryDeviceModel() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        try {
            String qdmStr = handler.excuteCommand("DM", true);
            if (!"".equals(qdmStr) && !qdmStr.equals("(NAK")) {
                this._deviceModel = qdmStr;
                this.getProtocol().setDeviceModel(this._deviceModel);
                ConfigData bean = (ConfigData)this.getBeanBag().getBean("configdata");
                bean.setModelID(this._deviceModel);
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getMessage());
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyTotal() {
        Object object = this.query_tatal;
        synchronized (object) {
            double energyTotal = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                return energyTotal;
            }
            String qetStr = handler.excuteCommand("ET", true);
            energyTotal = !this.isEmpty(qetStr) ? VolUtil.parseDouble(qetStr) : 0.0;
            return energyTotal;
        }
    }
}

