/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.upgrade;

import cn.com.voltronic.solar.configure.ConfigureTools;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.socket.SystemTrayUDPClient;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.upgrade.StartUpgrade;
import cn.com.voltronic.solar.upgrade.UpgradeUtil;
import cn.com.voltronic.solar.util.ReadDatFile;
import cn.com.voltronic.solar.util.ReadTempDatFile;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.AAPanel;
import cn.com.voltronic.solar.view.component.AATextField;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public abstract class UpByUserDialog
extends JFrame {
    private static final long serialVersionUID = 2002701722574427113L;
    protected AAButton browser;
    protected AAButton update;
    protected AALabel selectFile;
    protected AALabel note;
    protected AAPanel jPanel1;
    protected AATextField filepath;
    protected JFileChooser fDialog;
    protected String filepathStr;

    public abstract void initComponents();

    protected void updateAction() {
        String oldFileName = "";
        float oldLength = 0.0f;
        long oldTime = 0L;
        try {
            oldFileName = ReadDatFile.getString("fileName");
            oldLength = Float.parseFloat(ReadDatFile.getString("fileSize"));
            oldTime = Long.parseLong(ReadDatFile.getString("lastModified"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file = new File(this.filepathStr);
        String fileName = file.getName();
        long length = file.length();
        long time = file.lastModified();
        if (fileName.equals(oldFileName) && (float)length == oldLength && time == oldTime) {
            DisplayMessage.showInfoDialog("message.alreadyUpgrade");
            UpgradeUtil.refreshStatus(true, true);
            return;
        }
        String fromZipPath = this.filepathStr.trim();
        try {
            ReadTempDatFile.updateProperty("fileName", fileName.trim());
            ReadTempDatFile.updateProperty("fileSize", String.valueOf(length));
            ReadTempDatFile.updateProperty("lastModified", String.valueOf(time));
            GlobalVariables.upgradeConfig.setInstallPath(fromZipPath.trim());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ConfigureTools.updateProperties(GlobalVariables.upgradeConfig);
            ConfigureTools.wrapProperties(GlobalVariables.upgradeConfig);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String exitMask = "(exit:upgrade";
        int port = VolUtil.parseInt("38694");
        try {
            port = VolUtil.parseInt(GlobalVariables.globalConfig.getUdpPort());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SystemTrayUDPClient client = new SystemTrayUDPClient("localhost", port);
            client.send(exitMask.getBytes());
        }
        catch (IOException e1) {
            e1.printStackTrace();
            StartUpgrade.runUpgrade();
            System.exit(0);
        }
        this.dispose();
    }

    protected int getFileDialog() {
        this.fDialog = new JFileChooser();
        this.fDialog.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return Constants.IS_OS_WINDOWS ? f.getName().endsWith(".zip") || f.isDirectory() : (Constants.IS_OS_LINUX || Constants.IS_OS_SOLARIS ? f.getName().endsWith(".tar.gz") || f.isDirectory() : f.getName().endsWith(".zip") || f.isDirectory());
            }

            @Override
            public String getDescription() {
                if (Constants.IS_OS_WINDOWS) {
                    return "*.zip";
                }
                if (Constants.IS_OS_LINUX || Constants.IS_OS_SOLARIS) {
                    return "*.tar.gz";
                }
                return "*.zip";
            }
        });
        int result = this.fDialog.showOpenDialog(this);
        return result;
    }
}

