/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.communicate;

import cn.com.voltronic.solar.communicate.FairLock;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.dao.ModbusDao;
import cn.com.voltronic.solar.data.bean.ModbusSet;
import gnu.io.CommPortIdentifier;
import java.util.ArrayList;
import java.util.List;
import net.wimpi.modbus.facade.ModbusSerialMaster;
import net.wimpi.modbus.util.SerialParameters;

public class ModbusHandlerMaster {
    private volatile ModbusSerialMaster _modbus;
    private CommPortIdentifier _portId;
    private ModbusSet _config;
    private List<ModbusHandler> _handlers;
    private static ModbusDao dao = new ModbusDao();
    private volatile int _handlersize = 0;
    private static final String WRITE_FAIL = "I/O failed to write";
    private static final String READ_FAIL = "Error reading response";
    private static final int MAX_WRITE_FAIL = 3;
    private static final int MAX_READ_FAIL = 6;
    public static final int TIME_OUT = 150;
    private FairLock lock = new FairLock();
    private int readfailcount = 0;
    private int writefailcount = 0;
    private int short_delay = 5;
    private int normal_delay = 20;
    private int long_delay = 50;

    public void lock() throws Exception {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public int getShort_delay() {
        return this.short_delay;
    }

    public void setShort_delay(int short_delay) {
        this.short_delay = short_delay;
    }

    public int getNormal_delay() {
        return this.normal_delay;
    }

    public void setNormal_delay(int normal_delay) {
        this.normal_delay = normal_delay;
    }

    public int getLong_delay() {
        return this.long_delay;
    }

    public void setLong_delay(int long_delay) {
        this.long_delay = long_delay;
    }

    public boolean maybeLost() {
        return this.readfailcount >= 6;
    }

    public int getActiveHandlesSize() {
        int activehandlers = 0;
        for (ModbusHandler handler : this._handlers) {
            if (handler == null || !handler.isActive()) continue;
            ++activehandlers;
        }
        return activehandlers;
    }

    public void processError(boolean isActiveHandler, String errMessage) {
        if (errMessage.equalsIgnoreCase(READ_FAIL)) {
            if (isActiveHandler) {
                ++this.readfailcount;
                if (this.readfailcount >= 6) {
                    this._modbus.setRetries(1);
                }
            }
        } else if (errMessage.equalsIgnoreCase(WRITE_FAIL)) {
            ++this.writefailcount;
            if (this.writefailcount >= 3) {
                this._modbus.setRetries(1);
                for (ModbusHandler handler : this._handlers) {
                    handler.setMustClose();
                }
            }
        } else {
            this.resetError();
        }
    }

    public void resetError() {
        this.readfailcount = 0;
        this.writefailcount = 0;
        this._modbus.setRetries(2);
    }

    public static boolean isUseCom(CommPortIdentifier portId) {
        ModbusSet deviceList = dao.queryModbusSetByPort(portId.getName());
        return deviceList != null && !"".equals(deviceList.getDeviceIds());
    }

    public ModbusHandlerMaster(CommPortIdentifier portId) throws Exception {
        this._portId = portId;
        this._config = dao.queryModbusSetByPort(portId.getName());
        if (this._config == null) {
            this._config = this.getDefaultConfig(portId.getName());
        }
        SerialParameters params = new SerialParameters(portId.getName(), this._config.getBaudrate(), 0, 0, this._config.getDataBit(), this._config.getStopBit(), this._config.getParity(), false, 150);
        params.setEncoding("rtu");
        this._modbus = new ModbusSerialMaster(params);
        this._modbus.connect();
        this._modbus.setTransDelayMS(10);
        this._handlers = new ArrayList<ModbusHandler>();
    }

    private ModbusSet getDefaultConfig(String portname) {
        ModbusSet set = new ModbusSet();
        set.setPortName(portname);
        set.setBaudrate(2400);
        set.setDataBit(8);
        set.setStopBit(2);
        set.setParity(0);
        set.setDeviceIds("0");
        return set;
    }

    public ModbusHandler getTestHandler() {
        return new ModbusHandler(this, this._modbus, 0);
    }

    public void generateHandlers() {
        int lastindex = 0;
        ModbusSet modbusSet = dao.queryModbusSetByPort(this._portId.getName());
        if (modbusSet != null) {
            String[] deviceList = modbusSet.getDeviceIds().split(",");
            while (this._handlers.contains(null)) {
                this._handlers.remove(null);
            }
            int i = 0;
            while (i < deviceList.length) {
                int id = Integer.parseInt(deviceList[i]);
                while (lastindex < this._handlers.size() && this._handlers.get(lastindex).getMachineID() < id) {
                    ++lastindex;
                }
                if (lastindex < this._handlers.size()) {
                    if (this._handlers.get(lastindex).getMachineID() != id) {
                        this._handlers.add(lastindex, new ModbusHandler(this, this._modbus, id));
                    }
                } else {
                    this._handlers.add(new ModbusHandler(this, this._modbus, id));
                }
                ++i;
            }
            this._handlersize = this._handlers.size();
        }
    }

    public List<ModbusHandler> getHandlers() {
        return this._handlers;
    }

    public void close(int machineID) {
        int index = 0;
        while (index < this._handlers.size()) {
            ModbusHandler handler = this._handlers.get(index);
            if (handler != null && handler.getMachineID() == machineID) {
                --this._handlersize;
                this._handlers.set(index, null);
                break;
            }
            ++index;
        }
        if (this._handlersize <= 0) {
            try {
                this._handlers.clear();
                if (this._modbus != null) {
                    this._modbus.disconnect();
                    this._modbus = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getDeviceName() {
        String portName = this._portId.getName();
        int index = portName.lastIndexOf("/");
        if (index > 0) {
            portName = portName.substring(index + 1, portName.length());
        }
        return portName;
    }

    public static void main(String[] args) {
    }
}

