/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.beanbag.P15BeanBag;
import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.AbstractComUSBProcessor;
import cn.com.voltronic.solar.control.P15ComUSBControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.data.bean.DefaultData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProtocolInfo;
import cn.com.voltronic.solar.data.bean.SelfTestResult;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.exception.FaultHandler;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.GridTestResultDialog;
import cn.com.voltronic.solar.view.RealControlJDialog15;
import cn.com.voltronic.solar.webservice.WebServices;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class P15ComUSBProcessor
extends AbstractComUSBProcessor {
    public Logger logger = Logger.getLogger(P15ComUSBProcessor.class);
    private Object query_hour = new Integer(0);
    private Object query_day = new Integer(1);
    private Object query_month = new Integer(2);
    private Object query_year = new Integer(3);

    public P15ComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    protected void initBeanBag() {
        this._beanbag = new P15BeanBag();
    }

    @Override
    protected void initControlModule() {
        this._control = new P15ComUSBControlModule(this.getHandler(), (ConfigData)this._beanbag.getBean("configdata"), (Capability)this._beanbag.getBean("capability"));
    }

    @Override
    public void initProtocol() {
        ProtocolInfo info = (ProtocolInfo)this.getBeanBag().getBean("protocolinfo");
        info.setProdid(this._protocol.getProtocolID());
        info.setBaseInfo(this._protocol.getBaseInfo());
        info.setProductInfo(this._protocol.getProductInfo());
        info.setRatingInfo(this._protocol.getRatingInfo());
        try {
            info.setSerialno(this._protocol.getSerialNo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        info.setMoreInfo(this._protocol.getMoreInfo());
        info.setMpptTrackNumber(this._protocol.getMpptTrackNumber());
    }

    @Override
    public P15BeanBag getBeanBag() {
        return (P15BeanBag)this._beanbag;
    }

    @Override
    public boolean pollQueryStatus() {
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workinfo.setProdid("P15");
        if (!super.pollQueryStatus()) {
            ++this.reconnectTimes;
            return false;
        }
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        try {
            String qpifs;
            String qpiws;
            workinfo.setSerialno(this.getProtocol().getSerialNo());
            if (this.currenttime != null) {
                workinfo.setCurrentTime(this.currenttime.getTime());
            }
            if (!"".equals(qpiws = handler.excuteCommand("QPIWS", true)) && !qpiws.equals("(NAK")) {
                String qpiwsStr = qpiws.substring(1);
                this.hasFault = qpiwsStr.charAt(0) == '1';
                if (qpiwsStr.charAt(1) == '1') {
                    if (!workinfo.getWarnings().contains("2001")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2001");
                        workinfo.addWarning("2001");
                    }
                } else if (workinfo.getWarnings().contains("2001")) {
                    workinfo.getWarnings().remove("2001");
                }
                if (qpiwsStr.charAt(2) == '1') {
                    if (!workinfo.getWarnings().contains("2002")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2002");
                        workinfo.addWarning("2002");
                    }
                } else if (workinfo.getWarnings().contains("2002")) {
                    workinfo.getWarnings().remove("2002");
                }
                if (qpiwsStr.charAt(3) == '1') {
                    if (!workinfo.getWarnings().contains("2003")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2003");
                        workinfo.addWarning("2003");
                    }
                } else if (workinfo.getWarnings().contains("2003")) {
                    workinfo.getWarnings().remove("2003");
                }
                if (qpiwsStr.charAt(4) == '1') {
                    if (!workinfo.getWarnings().contains("2004")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2004");
                        workinfo.addWarning("2004");
                    }
                } else if (workinfo.getWarnings().contains("2004")) {
                    workinfo.getWarnings().remove("2004");
                }
                if (qpiwsStr.charAt(5) == '1') {
                    if (!workinfo.getWarnings().contains("2005")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2005");
                        workinfo.addWarning("2005");
                    }
                } else if (workinfo.getWarnings().contains("2005")) {
                    workinfo.getWarnings().remove("2005");
                }
                if (qpiwsStr.charAt(6) == '1') {
                    if (!workinfo.getWarnings().contains("2006")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2006");
                        workinfo.addWarning("2006");
                    }
                } else if (workinfo.getWarnings().contains("2006")) {
                    workinfo.getWarnings().remove("2006");
                }
                if (qpiwsStr.charAt(7) == '1') {
                    if (!workinfo.getWarnings().contains("2007")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2007");
                        workinfo.addWarning("2007");
                    }
                } else if (workinfo.getWarnings().contains("2007")) {
                    workinfo.getWarnings().remove("2007");
                }
                if (qpiwsStr.charAt(8) == '1') {
                    if (!workinfo.getWarnings().contains("2008")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2008");
                        workinfo.addWarning("2008");
                    }
                } else if (workinfo.getWarnings().contains("2008")) {
                    workinfo.getWarnings().remove("2008");
                }
                if (qpiwsStr.charAt(9) == '1') {
                    if (!workinfo.getWarnings().contains("2009")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2009");
                        workinfo.addWarning("2009");
                    }
                } else if (workinfo.getWarnings().contains("2009")) {
                    workinfo.getWarnings().remove("2009");
                }
                if (qpiwsStr.charAt(10) == '1') {
                    if (!workinfo.getWarnings().contains("2010")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2010");
                        workinfo.addWarning("2010");
                    }
                } else if (workinfo.getWarnings().contains("2010")) {
                    workinfo.getWarnings().remove("2010");
                }
                if (qpiwsStr.charAt(11) == '1') {
                    if (!workinfo.getWarnings().contains("2011")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2011");
                        workinfo.addWarning("2011");
                    }
                } else if (workinfo.getWarnings().contains("2011")) {
                    workinfo.getWarnings().remove("2011");
                }
                if (qpiwsStr.charAt(12) == '1') {
                    if (!workinfo.getWarnings().contains("2012")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2012");
                        workinfo.addWarning("2012");
                    }
                } else if (workinfo.getWarnings().contains("2012")) {
                    workinfo.getWarnings().remove("2012");
                }
                if (qpiwsStr.charAt(13) == '1') {
                    if (!workinfo.getWarnings().contains("2013")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2013");
                        workinfo.addWarning("2013");
                    }
                } else if (workinfo.getWarnings().contains("2013")) {
                    workinfo.removeWarning("2013");
                }
                if (qpiwsStr.charAt(24) == '1') {
                    if (!workinfo.getWarnings().contains("2024")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2024");
                        workinfo.addWarning("2024");
                    }
                } else if (workinfo.getWarnings().contains("2024")) {
                    workinfo.removeWarning("2024");
                }
                if (qpiwsStr.charAt(11) == '1' || qpiwsStr.charAt(10) == '1' || qpiwsStr.charAt(9) == '1' || qpiwsStr.charAt(8) == '1' || qpiwsStr.charAt(7) == '1') {
                    workinfo.setLineLoss(true);
                } else {
                    workinfo.setLineLoss(false);
                }
            }
            Calendar machineTime = Calendar.getInstance();
            machineTime.setTime(workinfo.getCurrentTime());
            Calendar serverTime = Calendar.getInstance(usLocale);
            if (Math.abs(machineTime.getTimeInMillis() - serverTime.getTimeInMillis()) > (long)(GlobalVariables.globalConfig.getShowWarningForDatetime() * 60 * 1000)) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "3003");
            }
            if (this.getFWVersion() >= 0.9f) {
                String qpicf = handler.excuteCommand("QPICF", true);
                if (!"".equals(qpicf) && !qpicf.equals("(NAK")) {
                    String[] qpicfArr = qpicf.split(" ");
                    String faultStatus = qpicfArr[0].substring(1);
                    String faultID = qpicfArr[1];
                    if (faultStatus.equals("00")) {
                        String qpihf;
                        if (!(faultID.equals(this._faultID) || "".equals(qpihf = handler.excuteCommand("QPIHF" + faultID, true)) || qpihf.equals("(NAK") || qpihf.startsWith("(00"))) {
                            this._faultID = faultID;
                            String[] qpifsArr = qpihf.split(" ");
                            String faultstr = qpifsArr[0].substring(1);
                            int kind = VolUtil.parseInt(faultstr);
                            if (kind > 0 && kind < 21) {
                                DataBeforeFault data = new DataBeforeFault();
                                String timeStr = qpifsArr[1];
                                data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                                data.setProdid("P15");
                                data.setSerialno(this.getProtocol().getSerialNo());
                                data.setPvinputvoltage1(VolUtil.parseDouble(qpifsArr[2]));
                                data.setPvinputcurrent1(VolUtil.parseDouble(qpifsArr[3]));
                                data.setPvinputvoltage2(VolUtil.parseDouble(qpifsArr[4]));
                                data.setPvinputcurrent2(VolUtil.parseDouble(qpifsArr[5]));
                                data.setPvinputvoltage3(VolUtil.parseDouble(qpifsArr[6]));
                                data.setPvinputcurrent3(VolUtil.parseDouble(qpifsArr[7]));
                                data.setInverterVoltage(VolUtil.parseDouble(qpifsArr[8]));
                                data.setInverterCurrent(VolUtil.parseDouble(qpifsArr[9]));
                                data.setGridVoltage(VolUtil.parseDouble(qpifsArr[10]));
                                data.setGridFrequency(VolUtil.parseDouble(qpifsArr[11]));
                                data.setGridCurrent(VolUtil.parseDouble(qpifsArr[12]));
                                data.setOutputLoadPercent(VolUtil.parseInt(qpifsArr[13]));
                                data.setOutputLoadCurrent(VolUtil.parseDouble(qpifsArr[14]));
                                data.setOutputLoadVoltage(VolUtil.parseDouble(qpifsArr[15]));
                                data.setOutputLoadFrequency(VolUtil.parseDouble(qpifsArr[16]));
                                data.setBatteryVoltage(VolUtil.parseDouble(qpifsArr[17]));
                                data.setMaxTemperature(VolUtil.parseDouble(qpifsArr[18]));
                                String runStatus = new String(qpifsArr[19]);
                                data.setRunStatus(runStatus);
                                FaultHandler.doFaultEvent(faultstr, data.getProdid(), data.getSerialno(), data);
                            }
                            workinfo.setFaultInfo(faultstr);
                        }
                    } else {
                        String qpihf = handler.excuteCommand("QPIHF" + faultID, true);
                        if (!("".equals(qpihf) || qpihf.equals("(NAK") || qpihf.startsWith("(00"))) {
                            this._faultID = faultID;
                            String[] qpifsArr = qpihf.split(" ");
                            String faultstr = qpifsArr[0].substring(1);
                            int kind = VolUtil.parseInt(faultstr);
                            if (kind > 0 && kind < 21) {
                                DataBeforeFault data = new DataBeforeFault();
                                String timeStr = qpifsArr[1];
                                data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                                data.setProdid("P15");
                                data.setSerialno(this.getProtocol().getSerialNo());
                                data.setPvinputvoltage1(VolUtil.parseDouble(qpifsArr[2]));
                                data.setPvinputcurrent1(VolUtil.parseDouble(qpifsArr[3]));
                                data.setPvinputvoltage2(VolUtil.parseDouble(qpifsArr[4]));
                                data.setPvinputcurrent2(VolUtil.parseDouble(qpifsArr[5]));
                                data.setPvinputvoltage3(VolUtil.parseDouble(qpifsArr[6]));
                                data.setPvinputcurrent3(VolUtil.parseDouble(qpifsArr[7]));
                                data.setInverterVoltage(VolUtil.parseDouble(qpifsArr[8]));
                                data.setInverterCurrent(VolUtil.parseDouble(qpifsArr[9]));
                                data.setGridVoltage(VolUtil.parseDouble(qpifsArr[10]));
                                data.setGridFrequency(VolUtil.parseDouble(qpifsArr[11]));
                                data.setGridCurrent(VolUtil.parseDouble(qpifsArr[12]));
                                data.setOutputLoadPercent(VolUtil.parseInt(qpifsArr[13]));
                                data.setOutputLoadCurrent(VolUtil.parseDouble(qpifsArr[14]));
                                data.setOutputLoadVoltage(VolUtil.parseDouble(qpifsArr[15]));
                                data.setOutputLoadFrequency(VolUtil.parseDouble(qpifsArr[16]));
                                data.setBatteryVoltage(VolUtil.parseDouble(qpifsArr[17]));
                                data.setMaxTemperature(VolUtil.parseDouble(qpifsArr[18]));
                                String runStatus = new String(qpifsArr[19]);
                                data.setRunStatus(runStatus);
                                FaultHandler.doFaultEvent(faultstr, data.getProdid(), data.getSerialno(), data);
                            } else {
                                this.logger.info((Object)("Fault:" + kind));
                            }
                            workinfo.setFaultInfo(faultstr);
                        }
                    }
                }
            } else if (this.hasFault && !"".equals(qpifs = handler.excuteCommand("QPIFS", true)) && !qpifs.equals("(NAK") && !qpifs.equals("(OK")) {
                String[] qpifsArr = qpifs.split(" ");
                String faultstr = qpifsArr[0].substring(1);
                int kind = VolUtil.parseInt(faultstr);
                if (kind > 0 && kind < 21) {
                    DataBeforeFault data = new DataBeforeFault();
                    String timeStr = qpifsArr[1];
                    data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                    data.setProdid("P15");
                    data.setSerialno(this.getProtocol().getSerialNo());
                    data.setPvinputvoltage1(VolUtil.parseDouble(qpifsArr[2]));
                    data.setPvinputcurrent1(VolUtil.parseDouble(qpifsArr[3]));
                    data.setPvinputvoltage2(VolUtil.parseDouble(qpifsArr[4]));
                    data.setPvinputcurrent2(VolUtil.parseDouble(qpifsArr[5]));
                    data.setPvinputvoltage3(VolUtil.parseDouble(qpifsArr[6]));
                    data.setPvinputcurrent3(VolUtil.parseDouble(qpifsArr[7]));
                    data.setInverterVoltage(VolUtil.parseDouble(qpifsArr[8]));
                    data.setInverterCurrent(VolUtil.parseDouble(qpifsArr[9]));
                    data.setGridVoltage(VolUtil.parseDouble(qpifsArr[10]));
                    data.setGridFrequency(VolUtil.parseDouble(qpifsArr[11]));
                    data.setGridCurrent(VolUtil.parseDouble(qpifsArr[12]));
                    data.setOutputLoadPercent(VolUtil.parseInt(qpifsArr[13]));
                    data.setOutputLoadCurrent(VolUtil.parseDouble(qpifsArr[14]));
                    data.setOutputLoadVoltage(VolUtil.parseDouble(qpifsArr[15]));
                    data.setOutputLoadFrequency(VolUtil.parseDouble(qpifsArr[16]));
                    data.setBatteryVoltage(VolUtil.parseDouble(qpifsArr[17]));
                    data.setMaxTemperature(VolUtil.parseDouble(qpifsArr[18]));
                    String runStatus = new String(qpifsArr[19]);
                    data.setRunStatus(runStatus);
                    FaultHandler.doFaultEvent(faultstr, workinfo.getProdid(), workinfo.getSerialno(), data);
                } else {
                    this.logger.info((Object)("Fault:" + kind));
                }
                workinfo.setFaultInfo(faultstr);
            }
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            workinfo.clear();
            ++this.reconnectTimes;
        }
        return result;
    }

    @Override
    public boolean pollQuery() {
        if (!super.pollQuery()) {
            ++this.reconnectTimes;
            return false;
        }
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            String qpvipv;
            String qpigsStr;
            workInfo.setProdid("P15");
            workInfo.setSerialno(handler.getSerialNo());
            if (this.currenttime != null) {
                workInfo.setCurrentTime(this.currenttime.getTime());
            }
            int mpptTrackNumber = 2;
            String qpiriStr = handler.excuteCommand("QPIRI", true);
            if (qpiriStr != null && !"".equals(qpiriStr) && !qpiriStr.equals("QPIRI")) {
                String[] arr = qpiriStr.split(" ");
                mpptTrackNumber = Integer.parseInt(arr[7]);
            }
            this.getProtocol().setMpptTrackNumber(mpptTrackNumber);
            String qmodStrs = handler.excuteCommand("QMOD", true);
            if (!"".equals(qmodStrs) && !qmodStrs.equals("(NAK")) {
                String qmodStr = qmodStrs.substring(1);
                String workMode = "Standby";
                if (qmodStr.equals("P")) {
                    workMode = "Power On";
                } else if (qmodStr.equals("S")) {
                    workMode = "Standby";
                } else if (qmodStr.equals("Y")) {
                    workMode = "Bypass";
                } else if (qmodStr.equals("L")) {
                    workMode = "Line";
                } else if (!qmodStr.equals("B") && !qmodStr.equals("T")) {
                    if (qmodStr.equals("F")) {
                        workMode = "Fault";
                    } else if (qmodStr.equals("D")) {
                        workMode = "Shutdown";
                    } else if (qmodStr.equals("G")) {
                        workMode = "Grid";
                    } else {
                        qmodStr.equals("C");
                    }
                }
                workInfo.setWorkMode(workMode);
            }
            if (!"".equals(qpigsStr = handler.excuteCommand("QPIGS", true)) && !qpigsStr.equals("(NAK")) {
                String[] qpigsArr = qpigsStr.split(" ");
                double gridVoltageR = VolUtil.parseDouble(qpigsArr[0].substring(1));
                workInfo.setGridVoltageR(gridVoltageR);
                String gridPowerRStr = qpigsArr[1];
                double gridPowerR = 0.0;
                gridPowerR = gridPowerRStr.charAt(0) == '0' ? VolUtil.parseDouble(gridPowerRStr.substring(1)) : -VolUtil.parseDouble(gridPowerRStr.substring(1));
                workInfo.setGridPowerR(gridPowerR);
                double gridFrequency = VolUtil.parseDouble(qpigsArr[2]);
                workInfo.setGridFrequency(gridFrequency);
                String gridCurrentRStr = qpigsArr[3];
                double gridCurrentR = 0.0;
                gridCurrentR = gridCurrentRStr.charAt(0) == '0' ? VolUtil.parseDouble(gridCurrentRStr.substring(1)) : -VolUtil.parseDouble(gridCurrentRStr.substring(1));
                workInfo.setGridCurrentR(gridCurrentR);
                int pvInputPower1 = VolUtil.parseInt(qpigsArr[14]);
                workInfo.setPvInputPower1(pvInputPower1);
                int pvInputPower2 = VolUtil.parseInt(qpigsArr[15]);
                workInfo.setPvInputPower2(pvInputPower2);
                int pvInputPower3 = VolUtil.parseInt(qpigsArr[16]);
                workInfo.setPvInputPower3(pvInputPower3);
                double pvInputVoltage1 = VolUtil.parseDouble(qpigsArr[17]);
                workInfo.setPvInputVoltage1(pvInputVoltage1);
                double pvInputVoltage2 = VolUtil.parseDouble(qpigsArr[18]);
                workInfo.setPvInputVoltage2(pvInputVoltage2);
                double pvInputVoltage3 = VolUtil.parseDouble(qpigsArr[19]);
                workInfo.setPvInputVoltage3(pvInputVoltage3);
                double maxTemperature = VolUtil.parseDouble(qpigsArr[20]);
                workInfo.setMaxTemperature(maxTemperature);
            }
            if (!"".equals(qpvipv = handler.excuteCommand("QPVIPV", true)) && !qpvipv.equals("(NAK")) {
                String[] qpvipvStr = qpvipv.split(" ");
                int lowestLimtInputV = VolUtil.parseInt(qpvipvStr[1]);
                workInfo.setLowestLimtInputV(lowestLimtInputV);
            }
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean queryMachineInfo() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        boolean result = true;
        MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        try {
            Date date;
            String qfetStr;
            String qpiriStr;
            String qmdStr;
            String slaveFirmwareVersion;
            String mainFirmwareVersion = handler.excuteCommand("QVFW", true);
            if (!"".equals(mainFirmwareVersion) && !mainFirmwareVersion.equals("(NAK")) {
                machineInfo.setMainFirmwareVersion(mainFirmwareVersion.substring(7));
            }
            if (!"".equals(slaveFirmwareVersion = handler.excuteCommand("QVFW2", true)) && !slaveFirmwareVersion.equals("(NAK")) {
                machineInfo.setSlaveFirmwareVersion(slaveFirmwareVersion.substring(8));
            }
            if (!"".equals(qmdStr = handler.excuteCommand("QMD", true)) && !qmdStr.equals("(NAK")) {
                String[] deviceMode = qmdStr.split(" ");
                String outputVAStr = deviceMode[1];
                if (outputVAStr.indexOf("#") != -1) {
                    outputVAStr = outputVAStr.substring(outputVAStr.lastIndexOf("#") + 1);
                }
                double outputRateVA = VolUtil.parseDouble(outputVAStr);
                double outputPowerFactor = VolUtil.parseDouble(deviceMode[2]);
                String ioPhase = deviceMode[3];
                double nominalInputVoltage = VolUtil.parseDouble(deviceMode[4]);
                double nominalOutputVoltage = VolUtil.parseDouble(deviceMode[5]);
                machineInfo.setOutputRateVA(outputRateVA);
                machineInfo.setOutputPowerFactor(outputPowerFactor);
                machineInfo.setIoPhase(ioPhase);
                machineInfo.setNominalInputVoltage(nominalInputVoltage);
                machineInfo.setNominalOutputVoltage(nominalOutputVoltage);
            }
            if (!"".equals(qpiriStr = handler.excuteCommand("QPIRI", true)) && !qpiriStr.equals("(NAK")) {
                String[] ratingInfo = qpiriStr.split(" ");
                double gridRatingVoltage = VolUtil.parseDouble(ratingInfo[0].substring(1));
                double gridRatingFrequency = VolUtil.parseDouble(ratingInfo[1]);
                double gridRatingCurrent = VolUtil.parseDouble(ratingInfo[2]);
                double perMPPTRatingCurrent = VolUtil.parseDouble(ratingInfo[5]);
                int mpptTrackNumber = VolUtil.parseInt(ratingInfo[7]);
                String machineTypeStr = ratingInfo[8];
                String topologyStr = ratingInfo[9];
                machineInfo.setGridRatingVoltage(gridRatingVoltage);
                machineInfo.setGridRatingFrequency(gridRatingFrequency);
                machineInfo.setGridRatingCurrent(gridRatingCurrent);
                machineInfo.setPerMPPTRatingCurrent(perMPPTRatingCurrent);
                machineInfo.setMpptTrackNumber(mpptTrackNumber);
                String machineType = "";
                if (machineTypeStr.equals("00")) {
                    machineType = "Grid tie";
                } else if (machineTypeStr.equals("01")) {
                    machineType = "Stand alone";
                } else if (machineTypeStr.equals("10")) {
                    machineType = "Hybrid";
                }
                machineInfo.setMachineType(machineType);
                this.getProtocol().setModelType(machineTypeStr);
                String topology = "";
                if (topologyStr.equals("0")) {
                    topology = "transformerless";
                } else if (topologyStr.equals("1")) {
                    topology = "transformer";
                }
                machineInfo.setTopology(topology);
            }
            if (!"".equals(qfetStr = handler.excuteCommand("QFET", true)) && !qfetStr.equals("(NAK") && (date = DateUtils.parseDate(qfetStr.substring(1), "yyyyMMddHH")) != null) {
                this.enerystarttime = Calendar.getInstance();
                this.enerystarttime.setTime(date);
                WebServices web = new WebServices();
                if (!web.doEnergyBeginDate(this.getProtocol().getProtocolID(), this.getProtocol().getSerialNo(), this.enerystarttime)) {
                    result = false;
                }
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean queryCapability() {
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        Capability capability = (Capability)this.getBeanBag().getBean("capability");
        try {
            String qflagStr = handler.excuteCommand("QFLAG", true);
            System.out.println("qflagStr=" + qflagStr);
            if (!"".equals(qflagStr) && !qflagStr.equals("(NAK")) {
                String before = qflagStr.substring(qflagStr.indexOf("E"), qflagStr.indexOf("D"));
                if (before.indexOf(97) != -1) {
                    capability.setCapableA(true);
                } else {
                    capability.setCapableA(false);
                }
                if (before.indexOf(112) != -1) {
                    capability.setCapableP(true);
                } else {
                    capability.setCapableP(false);
                }
            }
        }
        catch (Exception e) {
            result = false;
            System.err.println(e.getMessage());
        }
        try {
            String qpdgStr = handler.excuteCommand("QPDG", true);
            if (!"".equals(qpdgStr) && !qpdgStr.equals("(NAK")) {
                String capabelePDG = qpdgStr.substring(1).trim();
                if (capabelePDG.equals("1")) {
                    capability.setCapabelePDG(true);
                } else {
                    capability.setCapabelePDG(false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Calendar queryCurrentTime() {
        String timeStr;
        Calendar ca;
        block7: {
            block6: {
                IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
                if (handler == null) {
                    return null;
                }
                try {
                    ca = null;
                    timeStr = handler.excuteCommand("QT", true);
                    if (!"".equals(timeStr) && !timeStr.equals("(NAK")) break block6;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (timeStr.trim().length() == 15) break block7;
            return null;
        }
        Date date = DateUtils.parseDate(timeStr.substring(1), "yyyyMMddHHmmss");
        if (date != null) {
            ca = Calendar.getInstance();
            ca.setTime(date);
        }
        return ca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyDay(Calendar trandate) throws Exception {
        Object object = this.query_day;
        synchronized (object) {
            double energyDay = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            Calendar calendar = (Calendar)trandate.clone();
            String value = DateUtils.getFormatDate(calendar.getTime(), "yyyyMMdd");
            String validate = this.getValidate("QED" + value);
            String qedStr = handler.excuteCommand("QED" + value + validate, true);
            if (qedStr == null || "".equals(qedStr) || qedStr.equals("(NAK") || qedStr.length() != 7) {
                throw new Exception("query day energy error");
            }
            String qedValue = qedStr.substring(1);
            energyDay = this.parseDoubleV(qedValue);
            return energyDay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyHour(Calendar trandate, int hour) throws Exception {
        Object object = this.query_hour;
        synchronized (object) {
            double energyHour = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            Calendar calendar = (Calendar)trandate.clone();
            String hourStr = String.valueOf(hour).length() < 2 ? "0" + hour : String.valueOf(hour);
            String value = String.valueOf(DateUtils.getFormatDate(calendar.getTime(), "yyyyMMdd")) + hourStr;
            String validate = this.getValidate("QEH" + value);
            String qehStr = handler.excuteCommand("QEH" + value + validate, true);
            if (qehStr == null || "".equals(qehStr) || qehStr.equals("(NAK") || qehStr.length() != 6) {
                throw new Exception("query hour energy error");
            }
            String qehValue = qehStr.substring(1);
            energyHour = this.parseDoubleV(qehValue);
            return energyHour;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyMonth(int year, int month) throws Exception {
        Object object = this.query_month;
        synchronized (object) {
            double energyMonth = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String monthStr = String.valueOf(month).length() < 2 ? "0" + month : String.valueOf(month);
            String value = year + monthStr;
            String validate = this.getValidate("QEM" + value);
            String qemStr = handler.excuteCommand("QEM" + value + validate, true);
            if (qemStr == null || "".equals(qemStr) || qemStr.equals("(NAK") || qemStr.length() != 8) {
                throw new Exception("query month energy error");
            }
            String qemValue = qemStr.substring(1);
            energyMonth = this.parseDoubleV(qemValue);
            return energyMonth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyYear(int year) throws Exception {
        Object object = this.query_year;
        synchronized (object) {
            double energyYear = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String value = "" + year;
            String validate = this.getValidate("QEY" + value);
            String qeyStr = handler.excuteCommand("QEY" + value + validate, true);
            if (qeyStr == null || "".equals(qeyStr) || qeyStr.equals("(NAK") || qeyStr.length() != 9) {
                throw new Exception("query year energy error");
            }
            String qeyValue = qeyStr.substring(1);
            energyYear = this.parseDoubleV(qeyValue);
            return energyYear;
        }
    }

    @Override
    public boolean queryConfigData() {
        boolean result = true;
        try {
            String queryQPIRI;
            String qmpptv;
            String qlstStr;
            String qpvipv;
            String qopmpStr;
            String qmd;
            String qftStr;
            String qgof;
            String qgov;
            ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            if (this.getFWVersion() >= 0.9f) {
                String qvftrStr = handler.excuteCommand("QVFTR", true);
                if (!"".equals(qvftrStr) && !qvftrStr.equals("(NAK")) {
                    String[] queryQvftrStr = qvftrStr.split(" ");
                    double maxGridOutputHighV = VolUtil.parseDouble(queryQvftrStr[0].substring(1));
                    double minGridOutputHighV = VolUtil.parseDouble(queryQvftrStr[1]);
                    double maxGridOutputLowV = VolUtil.parseDouble(queryQvftrStr[2]);
                    double minGridOutputLowV = VolUtil.parseDouble(queryQvftrStr[3]);
                    configdata.setMaxGridoutputhighV(maxGridOutputHighV);
                    configdata.setMinGridoutputhighV(minGridOutputHighV);
                    configdata.setMaxGridoutputlowV(maxGridOutputLowV);
                    configdata.setMinGridoutputlowV(minGridOutputLowV);
                    double maxGridOutputHighF = VolUtil.parseDouble(queryQvftrStr[4]);
                    double minGridOutputHighF = VolUtil.parseDouble(queryQvftrStr[5]);
                    double maxGridOutputLowF = VolUtil.parseDouble(queryQvftrStr[6]);
                    double minGridOutputLowF = VolUtil.parseDouble(queryQvftrStr[7]);
                    configdata.setMaxGridoutputhighF(maxGridOutputHighF);
                    configdata.setMinGridoutputhighF(minGridOutputHighF);
                    configdata.setMaxGridoutputlowF(maxGridOutputLowF);
                    configdata.setMinGridoutputlowF(minGridOutputLowF);
                    int maxWaittime = VolUtil.parseInt(queryQvftrStr[8]);
                    int minWaittime = VolUtil.parseInt(queryQvftrStr[9]);
                    configdata.setMaxGridWaittime(maxWaittime);
                    configdata.setMinGridWaittime(minWaittime);
                    try {
                        int maxPvInputHighV = Integer.parseInt(queryQvftrStr[14]);
                        int minPvInputHighV = Integer.parseInt(queryQvftrStr[15]);
                        int maxPvInputLowV = Integer.parseInt(queryQvftrStr[16]);
                        int minPvInputLowV = Integer.parseInt(queryQvftrStr[17]);
                        int maxMpptHighV = Integer.parseInt(queryQvftrStr[18]);
                        int minMpptHighV = Integer.parseInt(queryQvftrStr[19]);
                        int maxMpptLowV = Integer.parseInt(queryQvftrStr[20]);
                        int minMpptLowV = Integer.parseInt(queryQvftrStr[21]);
                        configdata.setMaxPvInputHighV(maxPvInputHighV);
                        configdata.setMinPvInputHighV(minPvInputHighV);
                        configdata.setMaxPvInputLowV(maxPvInputLowV);
                        configdata.setMinPvInputLowV(minPvInputLowV);
                        configdata.setMaxMpptHighV(maxMpptHighV);
                        configdata.setMinMpptHighV(minMpptHighV);
                        configdata.setMaxMpptLowV(maxMpptLowV);
                        configdata.setMinMpptLowV(minMpptLowV);
                    }
                    catch (Exception ex) {
                        configdata.setMaxPvInputHighV(550);
                        configdata.setMinPvInputHighV(450);
                        configdata.setMaxPvInputLowV(200);
                        configdata.setMinPvInputLowV(90);
                        configdata.setMaxMpptHighV(450);
                        configdata.setMinMpptHighV(400);
                        configdata.setMaxMpptLowV(200);
                        configdata.setMinMpptLowV(110);
                    }
                }
            } else {
                String queryFrequency = handler.excuteCommand("QPIRI", true);
                if (!"".equals(queryFrequency) && !queryFrequency.equals("(NAK")) {
                    String[] queryFrequencyStr = queryFrequency.split(" ");
                    double frequency = VolUtil.parseDouble(queryFrequencyStr[1]);
                    if (frequency == 50.0) {
                        configdata.setMinGridoutputlowF(45.0);
                        configdata.setMaxGridoutputlowF(49.8);
                        configdata.setMinGridoutputhighF(50.2);
                        configdata.setMaxGridoutputhighF(54.8);
                    } else if (frequency == 60.0) {
                        configdata.setMinGridoutputlowF(55.0);
                        configdata.setMaxGridoutputlowF(59.8);
                        configdata.setMinGridoutputhighF(60.2);
                        configdata.setMaxGridoutputhighF(64.8);
                    }
                }
                configdata.setMinGridWaittime(5);
                configdata.setMaxGridWaittime(999);
                configdata.setMinGridoutputlowV(176.0);
                configdata.setMaxGridoutputlowV(220.0);
                configdata.setMinGridoutputhighV(240.0);
                configdata.setMaxGridoutputhighV(276.0);
                configdata.setMaxPvInputHighV(550);
                configdata.setMinPvInputHighV(450);
                configdata.setMaxPvInputLowV(200);
                configdata.setMinPvInputLowV(90);
                configdata.setMaxMpptHighV(450);
                configdata.setMinMpptHighV(400);
                configdata.setMaxMpptLowV(200);
                configdata.setMinMpptLowV(110);
            }
            if (!"".equals(qgov = handler.excuteCommand("QGOV", true)) && !qgov.equals("(NAK")) {
                String[] qgovStr = qgov.split(" ");
                double gridOutputHighV = VolUtil.parseDouble(qgovStr[0].substring(1));
                double gridOutputLowV = VolUtil.parseDouble(qgovStr[1]);
                configdata.setGridoutputhighV(gridOutputHighV);
                configdata.setGridoutputlowV(gridOutputLowV);
            }
            if (!"".equals(qgof = handler.excuteCommand("QGOF", true)) && !qgof.equals("(NAK")) {
                String[] qgofStr = qgof.split(" ");
                double gridOutputHighF = VolUtil.parseDouble(qgofStr[0].substring(1));
                double gridOutputLowF = VolUtil.parseDouble(qgofStr[1]);
                configdata.setGridoutputhighF(gridOutputHighF);
                configdata.setGridoutputlowF(gridOutputLowF);
            }
            if (!"".equals(qftStr = handler.excuteCommand("QFT", true)) && !qftStr.equals("(NAK")) {
                int waitingTime = VolUtil.parseInt(qftStr.substring(1));
                configdata.setGridwaittime(waitingTime);
            }
            if (!"".equals(qmd = handler.excuteCommand("QMD", true)) && !qmd.equals("(NAK")) {
                String[] deviceMode = qmd.split(" ");
                String outputVAStr = deviceMode[1];
                if (outputVAStr.indexOf("#") != -1) {
                    outputVAStr = outputVAStr.substring(outputVAStr.lastIndexOf("#") + 1);
                }
                int outputRateVA = VolUtil.parseInt(outputVAStr);
                configdata.setMinMaxoutputPower(0);
                if (outputRateVA == 4600) {
                    outputRateVA = 5000;
                }
                configdata.setMaxMaxoutputPower(outputRateVA);
            }
            if (!"".equals(qopmpStr = handler.excuteCommand("QOPMP", true)) && !qopmpStr.equals("(NAK")) {
                int maxOutputPower = VolUtil.parseInt(qopmpStr.substring(1));
                configdata.setMaxoutputPower(maxOutputPower);
            }
            if (!"".equals(qpvipv = handler.excuteCommand("QPVIPV", true)) && !qpvipv.equals("(NAK")) {
                String[] qpvipvStr = qpvipv.split(" ");
                int upperLimitInputV = VolUtil.parseInt(qpvipvStr[0].substring(1));
                int lowestLimtInputV = VolUtil.parseInt(qpvipvStr[1]);
                configdata.setPvInputLowV(lowestLimtInputV);
                configdata.setPvInputHighV(upperLimitInputV);
            }
            if (!"".equals(qlstStr = handler.excuteCommand("QLST", true)) && !qlstStr.equals("(NAK")) {
                String lcdSleepTime = qlstStr.substring(1);
                configdata.setLcdSleepTime(lcdSleepTime);
            }
            configdata.setMaxGridAvgHighV(265);
            configdata.setMinGridAvgHighV(235);
            String qgltv = handler.excuteCommand("QGLTV", true);
            if (!"".equals(qgltv) && !qgltv.equals("(NAK")) {
                String[] qgltvStr = qgltv.split(" ");
                int gridInputAverageHighV = VolUtil.parseInt(qgltvStr[0].substring(1));
                int gridInputAverageLowV = VolUtil.parseInt(qgltvStr[1]);
                configdata.setGridAvgHighV(gridInputAverageHighV);
                configdata.setGridAvgLowV(gridInputAverageLowV);
            }
            if (!"".equals(qmpptv = handler.excuteCommand("QMPPTV", true)) && !qmpptv.equals("(NAK")) {
                String[] qmpptvStr = qmpptv.split(" ");
                int highVoltage = VolUtil.parseInt(qmpptvStr[0].substring(1));
                int lowVoltage = VolUtil.parseInt(qmpptvStr[1]);
                configdata.setMpptHighV(highVoltage);
                configdata.setMpptLowV(lowVoltage);
            }
            if (!"".equals(queryQPIRI = handler.excuteCommand("QPIRI", true)) && !queryQPIRI.equals("(NAK")) {
                String[] queryQPIRIStr = queryQPIRI.split(" ");
                int queryPVN = VolUtil.parseInt(queryQPIRIStr[7]);
                configdata.setPvnNumber(queryPVN);
            }
            try {
                String queryQOPF = handler.excuteCommand("QOPF", true);
                int powerFactor = 0;
                powerFactor = VolUtil.parseInt(queryQOPF.substring(1));
                if (powerFactor > 100) {
                    powerFactor = -(powerFactor - 100);
                }
                configdata.setPowerFactor(powerFactor);
                configdata.setMinPowerFactor(-99);
                configdata.setMaxPowerFactor(100);
                String queryQPPS = handler.excuteCommand("QPPS", true);
                configdata.setPowerPercent(VolUtil.parseInt(queryQPPS.substring(1)));
                configdata.setMinPowerPercent(10);
                configdata.setMaxPowerPercent(100);
                String queryQPPD = handler.excuteCommand("QPPD", true);
                configdata.setPowerPFPercent(VolUtil.parseInt(queryQPPD.substring(1)));
                configdata.setMinPowerPFPercent(50);
                configdata.setMaxPowerPFPercent(100);
                String queryQPFL = handler.excuteCommand("QPFL", true);
                int powerQPFL = 0;
                powerQPFL = VolUtil.parseInt(queryQPFL.substring(1));
                if (powerQPFL > 100) {
                    powerQPFL = -(powerQPFL - 100);
                }
                configdata.setPowerPFcurve(powerQPFL);
                configdata.setMinPowerPFcurve(-99);
                configdata.setMaxPowerPFcurve(-90);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void queryEnergyBeginDate() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return;
        }
        try {
            Date date;
            String queryTime = handler.excuteCommand("QFET", true);
            if (!"".equals(queryTime) && !queryTime.equals("(NAK") && queryTime.trim().length() == 10 && (date = DateUtils.parseDate(queryTime, "yyyyMMddHH")) != null) {
                this.enerystarttime = Calendar.getInstance();
                this.enerystarttime.setTime(date);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void querySelfTestResult() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return;
        }
        try {
            String qsts = handler.excuteCommand("QSTS", true);
            if (!"".equals(qsts) && !qsts.equals("(NAK")) {
                String[] qstsStr = qsts.substring(1).split(" ");
                int resultValue = VolUtil.parseInt(qstsStr[0]);
                WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
                if (resultValue != 0) {
                    SelfTestResult result = (SelfTestResult)this.getBeanBag().getBean("selftestresult");
                    if (resultValue == 1) {
                        result.setResult("PASS");
                    } else {
                        result.setResult("FAIL");
                    }
                    MachineInfo machineinfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                    result.setModelName("Solar inverter");
                    result.setFwVersion(String.valueOf(machineinfo.getMainFirmwareVersion()) + "/" + machineinfo.getSlaveFirmwareVersion());
                    result.setHighVoltage(VolUtil.parseDouble(qstsStr[1]));
                    result.setLowVoltage(VolUtil.parseDouble(qstsStr[2]));
                    result.setHighFrequency(VolUtil.parseDouble(qstsStr[3]));
                    result.setLowFrequency(VolUtil.parseDouble(qstsStr[4]));
                    result.setHighVoltageT(VolUtil.parseDouble(qstsStr[5]));
                    result.setLowVoltageT(VolUtil.parseDouble(qstsStr[6]));
                    result.setHighFrequencyT(VolUtil.parseDouble(qstsStr[7]));
                    result.setLowFrequencyT(VolUtil.parseDouble(qstsStr[8]));
                    result.setDateStr(DateUtils.getFormatDate(this.getCurrentTime().getTime(), DateUtils.getDateFormat(true)));
                    result.setTimeStr(DateUtils.getFormatDate(this.getCurrentTime().getTime(), "HH:mm"));
                    EventsHandler.handleEvent(this.getProtocol().getProtocolID(), this.getProtocol().getSerialNo(), this.getCurrentTime().getTime(), "3009");
                    this.showResultDialog();
                    this.setStartQuerySelfTestResult(false);
                    workinfo.setSelfTesting(false);
                } else {
                    workinfo.setSelfTesting(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showResultDialog() {
        new GridTestResultDialog(null, true);
        if (RealControlJDialog15.startButton != null) {
            RealControlJDialog15.startButton.setEnabled(true);
        }
    }

    @Override
    public boolean queryDefaultData() {
        boolean result;
        block8: {
            DefaultData defaultData = (DefaultData)this.getBeanBag().getBean("defaultdata");
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                return false;
            }
            result = true;
            try {
                String qdiStr = handler.excuteCommand("QDI", true);
                if (!"".equals(qdiStr) && !qdiStr.equals("(NAK")) {
                    String[] qdiArr = qdiStr.split(" ");
                    double gridOutputHighV = VolUtil.parseDouble(qdiArr[0].substring(1));
                    double gridOutputLowV = VolUtil.parseDouble(qdiArr[1]);
                    double gridOutputHighF = VolUtil.parseDouble(qdiArr[2]);
                    double gridOutputLowF = VolUtil.parseDouble(qdiArr[3]);
                    int upperLimitInputV = VolUtil.parseInt(qdiArr[8]);
                    int lowestLimitInputV = VolUtil.parseInt(qdiArr[9]);
                    int mpptInputHighV = VolUtil.parseInt(qdiArr[10]);
                    int mpptInputLowV = VolUtil.parseInt(qdiArr[11]);
                    int maxoutputPower = VolUtil.parseInt(qdiArr[12]);
                    int timeGridAverageHighV = VolUtil.parseInt(qdiArr[13]);
                    int lcdSleepTime = VolUtil.parseInt(qdiArr[14]);
                    defaultData.setHighGridV(gridOutputHighV);
                    defaultData.setLowGridV(gridOutputLowV);
                    defaultData.setHighGridF(gridOutputHighF);
                    defaultData.setLowGridF(gridOutputLowF);
                    defaultData.setPvInputHighV(upperLimitInputV);
                    defaultData.setPvInputLowV(lowestLimitInputV);
                    defaultData.setMppHighV(mpptInputHighV);
                    defaultData.setMppLowV(mpptInputLowV);
                    defaultData.setMaxoutputPower(maxoutputPower);
                    defaultData.setGridAvgHighV(timeGridAverageHighV);
                    defaultData.setLcdSleepTime(String.valueOf(lcdSleepTime * 30));
                }
                if (this.getFWVersion() >= 0.9f) {
                    String qdi2Str = handler.excuteCommand("QDI2", true);
                    if (!"".equals(qdi2Str) && !qdi2Str.equals("(NAK")) {
                        String[] qdi2Arr = qdi2Str.split(" ");
                        int gridwaittime = VolUtil.parseInt(qdi2Arr[2]);
                        defaultData.setGridwaittime(gridwaittime);
                    }
                    break block8;
                }
                String qftStr = handler.excuteCommand("QFT", true);
                if ("".equals(qftStr) || qftStr.equals("(NAK")) break block8;
                int gridwaittime = 0;
                try {
                    gridwaittime = Integer.parseInt(qftStr.substring(1));
                }
                catch (Exception ex) {
                    gridwaittime = 5;
                }
                defaultData.setGridwaittime(gridwaittime);
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public boolean supportSelfTest() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        try {
            String qdmStr = handler.excuteCommand("QDM", true);
            return !"".equals(qdmStr) && !qdmStr.equals("(NAK") && (qdmStr = qdmStr.substring(1)).equals("002");
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public float getFWVersion() {
        return this._fwVersion;
    }

    @Override
    public float queryFWVersion() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return 0.0f;
        }
        String qsvfw2tr = handler.excuteCommand("QSVFW2", true);
        if (!"".equals(qsvfw2tr) && !qsvfw2tr.equals("(NAK")) {
            this._fwVersion = VolUtil.parseFloat(qsvfw2tr.substring(9));
            return this._fwVersion;
        }
        return 0.0f;
    }

    @Override
    public String getDeviceMode() {
        return this._deviceModel;
    }

    @Override
    public boolean queryDeviceModel() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        try {
            String qdmStr = handler.excuteCommand("QDM", true);
            if (!"".equals(qdmStr) && !qdmStr.equals("(NAK")) {
                this._deviceModel = qdmStr = qdmStr.substring(1);
                this.getProtocol().setDeviceModel(this._deviceModel);
                ConfigData bean = (ConfigData)this.getBeanBag().getBean("configdata");
                bean.setModelID(this._deviceModel);
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    @Override
    public double queryEnergyTotal() {
        return 0.0;
    }
}

