/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.handler;

import cn.com.voltronic.solar.data.bean.CommandParameter;
import cn.com.voltronic.solar.data.bean.CommandParameterMap;
import cn.com.voltronic.solar.data.bean.ControlRelation;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.component.AARadioButton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ParameterActionHandler {
    private static Map<String, JSpinner> spinner = new HashMap<String, JSpinner>();
    private static Map<String, Double> spinnerValue = new HashMap<String, Double>();

    public static boolean pollExecuteCommand(List<String> controlNameList) {
        boolean result = false;
        for (String controlName : controlNameList) {
            String item = controlName.substring(0, controlName.indexOf("+"));
            result = ParameterActionHandler.executeCommand(item, spinner.get(controlName));
            if (!result) break;
        }
        return result;
    }

    public static boolean executeCommand(String command0, JComponent control) {
        boolean result = false;
        AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
        if (currentProcessor != null) {
            List<ControlRelation> relaList;
            String command = VolUtil.splitCommandName(command0);
            CommandParameter para = currentProcessor.getProtocol().getCommandMap().getCommandParameter(command);
            if (para != null && (result = currentProcessor.executeControl(command, para.getValues())) && (relaList = currentProcessor.getProtocol().getRelationList()) != null && relaList.size() > 0) {
                for (ControlRelation relaObj : relaList) {
                    SpinnerNumberModel model;
                    if (!relaObj.getCommandAndIndex().equalsIgnoreCase(command0)) continue;
                    double value = ParameterActionHandler.getValueFromMainControl(relaList, currentProcessor.getProtocol().getCommandMap(), relaObj.getRelacommandAndIndex(), relaObj.getRelationtype());
                    if (relaObj.getRelationtype() == ControlRelation.RELATION_MIN) {
                        model = (SpinnerNumberModel)((JSpinner)relaObj.getRelationControl()).getModel();
                        model.setMinimum(Double.valueOf(value));
                        if (!((Double)model.getValue() < value)) continue;
                        model.setValue(value);
                        continue;
                    }
                    if (relaObj.getRelationtype() != ControlRelation.RELATION_MAX) continue;
                    model = (SpinnerNumberModel)((JSpinner)relaObj.getRelationControl()).getModel();
                    model.setMaximum(Double.valueOf(value));
                    if (!((Double)model.getValue() > value)) continue;
                    model.setValue(value);
                }
            }
        }
        return result;
    }

    public static boolean executeCommand(String command0, JComponent control, boolean isCheck) {
        boolean result = false;
        AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
        if (currentProcessor != null) {
            String command = VolUtil.splitCommandName(command0);
            CommandParameter para = currentProcessor.getProtocol().getCommandMap().getCommandParameter(command);
            if (para != null) {
                List<ControlRelation> relaList;
                Object[] paras = para.getValues();
                int length = paras.length + 1;
                Object[] newParas = new Object[length];
                int i = 0;
                while (i < paras.length) {
                    newParas[i] = paras[i];
                    ++i;
                }
                newParas[paras.length] = isCheck;
                result = currentProcessor.executeControl(command, newParas);
                if (result && (relaList = currentProcessor.getProtocol().getRelationList()) != null && relaList.size() > 0) {
                    for (ControlRelation relaObj : relaList) {
                        SpinnerNumberModel model;
                        if (!relaObj.getCommandAndIndex().equalsIgnoreCase(command0)) continue;
                        double value = ParameterActionHandler.getValueFromMainControl(relaList, currentProcessor.getProtocol().getCommandMap(), relaObj.getRelacommandAndIndex(), relaObj.getRelationtype());
                        if (relaObj.getRelationtype() == ControlRelation.RELATION_MIN) {
                            model = (SpinnerNumberModel)((JSpinner)relaObj.getRelationControl()).getModel();
                            model.setMinimum(Double.valueOf(value));
                            if (!((Double)model.getValue() < value)) continue;
                            model.setValue(value);
                            continue;
                        }
                        if (relaObj.getRelationtype() != ControlRelation.RELATION_MAX) continue;
                        model = (SpinnerNumberModel)((JSpinner)relaObj.getRelationControl()).getModel();
                        model.setMaximum(Double.valueOf(value));
                        if (!((Double)model.getValue() > value)) continue;
                        model.setValue(value);
                    }
                }
            }
        }
        return result;
    }

    public static boolean executeCommand(AARadioButton radioA, AARadioButton radioB, JSpinner spinnerA, JSpinner spinnerB, String executefunc) {
        boolean result = false;
        AbstractProcessor currentProcessor = GlobalProcessors.getCurrentProcessor();
        if (currentProcessor != null) {
            int isEnabled = 0;
            if (radioA.isSelected()) {
                isEnabled = 1;
            } else if (radioB.isSelected()) {
                isEnabled = 0;
            }
            String valueA = spinnerA.getValue().toString();
            String valueB = spinnerB.getValue().toString();
            result = currentProcessor.executeControl(executefunc, new Object[]{isEnabled, VolUtil.parseDouble(valueA), VolUtil.parseDouble(valueB)});
        }
        return result;
    }

    public static double getValueFromMainControl(List<ControlRelation> relaList, CommandParameterMap map, String relaCommandIndex, int relaType) {
        double dbvalue = 0.0;
        boolean bfirsttime = true;
        for (ControlRelation relaObj : relaList) {
            String command;
            CommandParameter para;
            if (!relaObj.getRelacommandAndIndex().equalsIgnoreCase(relaCommandIndex) || relaObj.getRelationtype() != relaType || (para = map.getCommandParameter(command = VolUtil.splitCommandName(relaObj.getCommandAndIndex()))) == null) continue;
            double dbtemp = para.getDoubleValue(relaObj.getMainControl());
            if (bfirsttime) {
                dbvalue = dbtemp;
                bfirsttime = false;
                continue;
            }
            if (relaType == ControlRelation.RELATION_MAX) {
                dbvalue = Math.min(dbvalue, dbtemp);
                continue;
            }
            if (relaType != ControlRelation.RELATION_MIN) continue;
            dbvalue = Math.max(dbvalue, dbtemp);
        }
        return dbvalue;
    }

    public static boolean executeCommandRadio(String name, AARadioButton valueLabel1, AARadioButton valueLabel2, AbstractProcessor currentProcessor) {
        boolean result = false;
        if (name.equals("CapableA")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"A", true});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"A", false});
            }
        } else if (name.equals("CapableB")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"B", true});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"B", false});
            }
        } else if (name.equals("CapableC")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"C", true});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"C", false});
            }
        } else if (name.equals("CapableD")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"D", true});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"D", false});
            }
        } else if (name.equals("CapableE")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"E", true});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"E", false});
            }
        } else if (name.equals("CapableF")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"F", true});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"F", false});
            }
        } else if (name.equals("CapableP")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"P", true});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"P", false});
            }
        } else if (name.equals("CapableG")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"G", true});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"G", false});
            }
        } else if (name.equals("CapableH")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"H", true});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"H", false});
            }
        } else if (name.equals("CapableI")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"I", true});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setCapability", new Object[]{"I", false});
            }
        } else if (name.equals("CapabelePDG")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setPowerFactorLine", new Object[]{1});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setPowerFactorLine", new Object[]{0});
            }
        } else if (name.equalsIgnoreCase("GNTM")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setGNTM", new Object[]{1});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setGNTM", new Object[]{0});
            }
        } else if (name.equalsIgnoreCase("LBF")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setLBF", new Object[]{1});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setLBF", new Object[]{0});
            }
        } else if (name.equalsIgnoreCase("ParallelFO")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setPALE", new Object[]{1});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setPALE", new Object[]{0});
            }
        } else if (name.equalsIgnoreCase("PLE")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("setPLE", new Object[]{1});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("setPLE", new Object[]{0});
            }
        } else if (name.equalsIgnoreCase("ENFH")) {
            if (valueLabel1.isSelected()) {
                result = currentProcessor.executeControl("excuteSetCommand", new Object[]{"EDH", "1"});
            } else if (valueLabel2.isSelected()) {
                result = currentProcessor.executeControl("excuteSetCommand", new Object[]{"EDH", "0"});
            }
        }
        return result;
    }

    public static boolean executeCommandCombox(String name, String value, JComponent control, AbstractProcessor currentProcessor) {
        boolean result = false;
        if (name.equals("setPCP")) {
            if (value.equals("Solar first")) {
                result = currentProcessor.executeControl("setPCP", new Object[]{currentProcessor.getParallKey(), 0});
            } else if (value.equals("Solar and Utility")) {
                result = currentProcessor.executeControl("setPCP", new Object[]{currentProcessor.getParallKey(), 1});
            } else if (value.equals("Solar only")) {
                result = currentProcessor.executeControl("setPCP", new Object[]{currentProcessor.getParallKey(), 2});
            }
        } else if (name.equals("setPOP")) {
            if (value.equals("Solar-Utility-Battery")) {
                result = currentProcessor.executeControl("setPOP", new Object[]{0});
            } else if (value.equals("Solar-Battery-Utility")) {
                result = currentProcessor.executeControl("setPOP", new Object[]{1});
            }
        } else if (name.equals("setPGR")) {
            if (value.equals("Appliance")) {
                result = currentProcessor.executeControl("setPGR", new Object[]{0});
            } else if (value.equals("UPS")) {
                result = currentProcessor.executeControl("setPGR", new Object[]{1});
            }
        } else if (name.equals("setPBT")) {
            if (value.equals("AGM")) {
                result = currentProcessor.executeControl("setPBT", new Object[]{0});
            } else if (value.equals("Flooded")) {
                result = currentProcessor.executeControl("setPBT", new Object[]{1});
            } else if (value.equals("User")) {
                result = currentProcessor.executeControl("setPBT", new Object[]{2});
            }
        } else if (name.equals("setPOPM")) {
            if (value.equals("Single")) {
                result = currentProcessor.executeControl("setPOPM", new Object[]{currentProcessor.getParallKey(), 0});
            } else if (value.equals("Parallel output")) {
                result = currentProcessor.executeControl("setPOPM", new Object[]{currentProcessor.getParallKey(), 1});
            } else if (value.equals("Phase R of 3 phase output")) {
                result = currentProcessor.executeControl("setPOPM", new Object[]{currentProcessor.getParallKey(), 2});
            } else if (value.equals("Phase S of 3 phase output")) {
                result = currentProcessor.executeControl("setPOPM", new Object[]{currentProcessor.getParallKey(), 3});
            } else if (value.equals("Phase T of 3 phase output")) {
                result = currentProcessor.executeControl("setPOPM", new Object[]{currentProcessor.getParallKey(), 4});
            } else if (value.equals("Phase 1 of 2 phase output")) {
                result = currentProcessor.executeControl("setPOPM", new Object[]{currentProcessor.getParallKey(), 5});
            } else if (value.equals("Phase 2 of 2 phase output")) {
                result = currentProcessor.executeControl("setPOPM", new Object[]{currentProcessor.getParallKey(), 6});
            }
        } else if (name.equals("setF")) {
            result = currentProcessor.executeControl("setF", new Object[]{VolUtil.parseDouble(value)});
        } else if (name.equals("setV")) {
            result = currentProcessor.executeControl("setV", new Object[]{VolUtil.parseDouble(value)});
        } else if (name.startsWith("setBUCD")) {
            String command0 = name;
            String command = VolUtil.splitCommandName(command0);
            CommandParameter para = currentProcessor.getProtocol().getCommandMap().getCommandParameter(command);
            if (para != null) {
                Object[] params = para.getValues();
                int i = 0;
                while (i < params.length) {
                    params[i] = VolUtil.parseDouble(params[i].toString());
                    ++i;
                }
                result = currentProcessor.executeControl(command, params);
            }
        } else if (name.equals("setMCHGC")) {
            result = currentProcessor.executeControl("setMCHGC", new Object[]{currentProcessor.getParallKey(), VolUtil.parseDouble(value)});
        } else if (name.equals("setMUCHGC")) {
            result = currentProcessor.executeControl("setMUCHGC", new Object[]{currentProcessor.getParallKey(), VolUtil.parseDouble(value)});
        } else if (name.equals("setPSP")) {
            if (value.equals("Battery-Load-Utility")) {
                result = currentProcessor.executeControl("setPSP", new Object[]{0});
            } else if (value.equals("Load-Battery-Utility")) {
                result = currentProcessor.executeControl("setPSP", new Object[]{1});
            }
        } else if (name.equals("setRS")) {
            if (value.equals("India")) {
                result = currentProcessor.executeControl("setRS", new Object[]{"00"});
            } else if (value.equals("Germany")) {
                result = currentProcessor.executeControl("setRS", new Object[]{"01"});
            } else if (value.equals("South America")) {
                result = currentProcessor.executeControl("setRS", new Object[]{"02"});
            }
        }
        return result;
    }

    public static Map spinner() {
        return spinner;
    }

    public static void setSpinner(String controlName, JSpinner jspinner) {
        spinner.put(controlName, jspinner);
        spinnerValue.put(controlName, (Double)jspinner.getValue());
    }

    public static Map spinnerVlaue() {
        return spinnerValue;
    }
}

